/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Defaults;
import com.sun.slp.SLPHeaderV1;
import com.sun.slp.SSrvMsg;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationAttributeV1;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.SrvLocMsg;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

class SLPV1SSrvMsg
extends SSrvMsg {
    static final char SPACE = ' ';
    static final char COMMA = ',';
    static final char OR_OP = '|';
    static final char AND_OP = '&';
    static final char HASH = '#';
    static final char EQUAL_OP = '=';
    static final char NOT_OP = '!';
    static final char LESS_OP = '<';
    static final char GREATER_OP = '>';
    static final char GEQUAL_OP = 'g';
    static final char LEQUAL_OP = 'l';
    static final char OPEN_PAREN = '(';
    static final char CLOSE_PAREN = ')';
    static final char PRESENT = '*';
    static final String WILDCARD = "*";
    String charCode = "UTF8";

    protected SLPV1SSrvMsg() {
    }

    SLPV1SSrvMsg(SrvLocHeader srvLocHeader, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        super(srvLocHeader, dataInputStream);
    }

    void convertQuery() throws ServiceLocationException {
        this.query = this.query.trim();
        if (this.query.length() <= 0) {
            return;
        }
        if (!this.query.startsWith("(") || !this.query.endsWith(")")) {
            this.query = this.rewriteQueryJoin(this.query);
        }
        this.query = this.rewriteQuery(this.query);
    }

    private int eatWhite(StreamTokenizer streamTokenizer) throws IOException {
        int n = streamTokenizer.nextToken();
        while (n == 32) {
            n = streamTokenizer.nextToken();
        }
        return n;
    }

    void initialize(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        SLPHeaderV1 sLPHeaderV1 = (SLPHeaderV1)this.getHeader();
        StringBuffer stringBuffer = new StringBuffer();
        sLPHeaderV1.parsePreviousRespondersIn(dataInputStream);
        sLPHeaderV1.getString(stringBuffer, dataInputStream);
        String string = stringBuffer.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
        try {
            String string2 = "service:" + stringTokenizer.nextToken().trim().toLowerCase() + ":";
            this.serviceType = SLPHeaderV1.checkServiceType(string2);
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken().trim().toLowerCase();
            if (string3.equals("/")) {
                string3 = "";
            } else {
                stringTokenizer.nextToken();
                if (string3.length() > 0) {
                    SLPHeaderV1.validateScope(string3);
                }
            }
            sLPHeaderV1.scopes = new Vector();
            if (string3.length() <= 0) {
                string3 = "default";
            }
            sLPHeaderV1.scopes.addElement(string3.toLowerCase().trim());
            String string4 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string4 = String.valueOf(string4) + stringTokenizer.nextToken();
            }
            if (!string4.endsWith("/")) {
                throw new ServiceLocationException(2, "v1_query_error", new Object[]{string});
            }
            this.query = string4.substring(0, string4.length() - 1);
            this.charCode = sLPHeaderV1.charCode;
            this.convertQuery();
            if (this.serviceType.equals(Defaults.DA_SERVICE_TYPE.toString())) {
                sLPHeaderV1.mcast = true;
            }
            sLPHeaderV1.constructDescription("SrvRqst", "        service type=``" + this.serviceType + "''\n" + "        query=``" + this.query + "''");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ServiceLocationException(2, "v1_query_error", new Object[]{string});
        }
    }

    static SrvLocMsg makeEmptyReply(SLPHeaderV1 sLPHeaderV1) throws ServiceLocationException {
        SLPV1SSrvMsg sLPV1SSrvMsg = new SLPV1SSrvMsg();
        sLPV1SSrvMsg.hdr = sLPHeaderV1;
        sLPV1SSrvMsg.makeReply(new Hashtable(), null);
        return sLPV1SSrvMsg;
    }

    SrvLocMsg makeReply(Hashtable hashtable, Hashtable hashtable2) throws ServiceLocationException {
        Serializable serializable;
        SLPHeaderV1 sLPHeaderV1 = ((SLPHeaderV1)this.getHeader()).makeReplyHeader();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Enumeration<Object> enumeration = hashtable.keys();
        Vector<ServiceURL> vector = new Vector<ServiceURL>();
        while (enumeration.hasMoreElements()) {
            ServiceURL serviceURL = (ServiceURL)enumeration.nextElement();
            serializable = serviceURL.getServiceType();
            if (serializable.isAbstractType() || !serializable.isServiceURL()) continue;
            vector.addElement(serviceURL);
        }
        sLPHeaderV1.iNumReplies = vector.size();
        int n = vector.size();
        sLPHeaderV1.putInt(n, byteArrayOutputStream);
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            serializable = (ServiceURL)enumeration.nextElement();
            sLPHeaderV1.parseServiceURLOut((ServiceURL)serializable, true, byteArrayOutputStream);
        }
        sLPHeaderV1.payload = byteArrayOutputStream.toByteArray();
        sLPHeaderV1.constructDescription("SrvRply", "        service URLs=``" + vector + "''\n");
        return sLPHeaderV1;
    }

    private void parse(StreamTokenizer streamTokenizer, StringBuffer stringBuffer, boolean bl) throws ServiceLocationException, IOException {
        String string = "";
        int n = 0;
        n = this.eatWhite(streamTokenizer);
        if (n != -3) {
            throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
        }
        string = this.parseTag(streamTokenizer, bl);
        if (string.length() <= 0) {
            throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
        }
        string = ServiceLocationAttributeV1.unescapeAttributeString(string, this.charCode);
        string = ServiceLocationAttribute.escapeAttributeString(string, true);
        char c = this.parseOperator(streamTokenizer);
        if (c == '*') {
            stringBuffer.append('(');
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append('*');
            stringBuffer.append(')');
            return;
        }
        String string2 = this.parseValue(streamTokenizer);
        if (c == '!') {
            try {
                int n2 = Integer.parseInt(string2);
                if (n2 < Integer.MAX_VALUE) {
                    stringBuffer.append('(');
                    stringBuffer.append(string);
                    stringBuffer.append('>');
                    stringBuffer.append('=');
                    stringBuffer.append(n2 + 1);
                    stringBuffer.append(')');
                }
                if (n2 > Integer.MIN_VALUE) {
                    stringBuffer.append('(');
                    stringBuffer.append(string);
                    stringBuffer.append('<');
                    stringBuffer.append('=');
                    stringBuffer.append(n2 - 1);
                    stringBuffer.append(')');
                }
                if (n2 < Integer.MAX_VALUE && n2 > Integer.MIN_VALUE) {
                    stringBuffer.insert(0, '|');
                    stringBuffer.insert(0, '(');
                    stringBuffer.append(')');
                }
            }
            catch (NumberFormatException numberFormatException) {
                stringBuffer.append('(');
                stringBuffer.append('&');
                stringBuffer.append('(');
                stringBuffer.append(string);
                stringBuffer.append('=');
                stringBuffer.append('*');
                stringBuffer.append(')');
                stringBuffer.append('(');
                stringBuffer.append('!');
                stringBuffer.append('(');
                stringBuffer.append(string);
                stringBuffer.append('=');
                stringBuffer.append(string2);
                stringBuffer.append(')');
                stringBuffer.append(')');
                stringBuffer.append(')');
            }
        } else if (c == '<' || c == '>') {
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
            }
            if (n3 == Integer.MAX_VALUE || n3 == Integer.MIN_VALUE) {
                throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
            }
            stringBuffer.append('(');
            stringBuffer.append(string);
            if (c == '<') {
                stringBuffer.append('<');
                stringBuffer.append('=');
                stringBuffer.append(n3 - 1);
            } else {
                stringBuffer.append('>');
                stringBuffer.append('=');
                stringBuffer.append(n3 + 1);
            }
            stringBuffer.append(')');
        } else {
            stringBuffer.append('(');
            stringBuffer.append(string);
            if (c == 'l') {
                stringBuffer.append('<');
                stringBuffer.append('=');
            } else if (c == 'g') {
                stringBuffer.append('>');
                stringBuffer.append('=');
            } else {
                stringBuffer.append(c);
            }
            stringBuffer.append(string2);
            stringBuffer.append(')');
        }
    }

    private void parseInternal(StreamTokenizer streamTokenizer, StringBuffer stringBuffer, boolean bl) throws ServiceLocationException, IOException {
        int n = 0;
        boolean bl2 = true;
        n = this.eatWhite(streamTokenizer);
        if (n == 40) {
            n = this.eatWhite(streamTokenizer);
            int n2 = n;
            if (n2 == 38) {
                n = streamTokenizer.nextToken();
                String string = streamTokenizer.sval;
                streamTokenizer.pushBack();
                if (n == -3) {
                    if (string.charAt(0) != '#') {
                        this.parseLogicalExpression(n2, streamTokenizer, stringBuffer);
                    } else {
                        this.parse(streamTokenizer, stringBuffer, true);
                    }
                } else {
                    this.parseLogicalExpression(n2, streamTokenizer, stringBuffer);
                }
            } else if (n2 == 124) {
                this.parseLogicalExpression(n2, streamTokenizer, stringBuffer);
            } else {
                streamTokenizer.pushBack();
                this.parse(streamTokenizer, stringBuffer, false);
            }
        } else {
            throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
        }
        if (bl && (n = this.eatWhite(streamTokenizer)) != -1) {
            throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
        }
    }

    private void parseLogicalExpression(int n, StreamTokenizer streamTokenizer, StringBuffer stringBuffer) throws ServiceLocationException, IOException {
        stringBuffer.append('(');
        stringBuffer.append((char)n);
        int n2 = 0;
        do {
            if ((n2 = this.eatWhite(streamTokenizer)) != 40) {
                if (n2 == 41) {
                    stringBuffer.append((char)n2);
                    return;
                }
                throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
            }
            streamTokenizer.pushBack();
            this.parseInternal(streamTokenizer, stringBuffer, false);
        } while (n2 != -1);
        throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
    }

    private char parseOperator(StreamTokenizer streamTokenizer) throws ServiceLocationException, IOException {
        int n = streamTokenizer.ttype;
        if ((char)n == ')') {
            return '*';
        }
        if (n != 61 && n != 33 && n != 60 && n != 62) {
            throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
        }
        int n2 = n;
        n = streamTokenizer.nextToken();
        if ((char)n == '=') {
            if (n2 != 60 && n2 != 62 && n2 != 61 && n2 != 33) {
                throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
            }
            if (n2 == 60) {
                n2 = 108;
            } else if (n2 == 62) {
                n2 = 103;
            }
        } else {
            if (n2 != 60 && n2 != 62) {
                throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
            }
            streamTokenizer.pushBack();
        }
        return (char)n2;
    }

    private String parseTag(StreamTokenizer streamTokenizer, boolean bl) throws ServiceLocationException, IOException {
        String string = "";
        if (bl) {
            string = String.valueOf(string) + "&";
            bl = false;
        }
        while (true) {
            if (streamTokenizer.ttype == -3) {
                string = String.valueOf(string) + streamTokenizer.sval;
            } else if ((char)streamTokenizer.ttype == ' ') {
                string = String.valueOf(string) + " ";
            } else {
                if ((char)streamTokenizer.ttype != '&') break;
                string = String.valueOf(string) + "&";
            }
            streamTokenizer.nextToken();
        }
        return string.trim();
    }

    private String parseValue(StreamTokenizer streamTokenizer) throws ServiceLocationException, IOException {
        Object object;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        n = this.eatWhite(streamTokenizer);
        if ((char)n == '(') {
            block14: {
                stringBuffer.append("(");
                while (true) {
                    if ((char)(n = streamTokenizer.nextToken()) == ')') break block14;
                    if ((char)n == '=') {
                        stringBuffer.append("=");
                        continue;
                    }
                    if (n != -3) break;
                    stringBuffer.append(streamTokenizer.sval);
                }
                throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
            }
            stringBuffer.append(")");
            n = this.eatWhite(streamTokenizer);
            if ((char)n != ')') {
                throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
            }
        } else {
            if (n == 41) {
                throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
            }
            do {
                if (n == -3) {
                    stringBuffer.append(streamTokenizer.sval);
                    continue;
                }
                if (n == -1 || n == 10 || n == 41) continue;
                stringBuffer.append((char)n);
            } while ((n = streamTokenizer.nextToken()) != 41);
        }
        String string = stringBuffer.toString().trim();
        boolean bl = false;
        boolean bl2 = false;
        if (string.startsWith(WILDCARD)) {
            bl = true;
            string = string.substring(1, string.length());
        }
        if (string.endsWith(WILDCARD)) {
            bl2 = true;
            string = string.substring(0, string.length() - 1);
        }
        if ((object = ServiceLocationAttributeV1.evaluate(string, this.charCode)) instanceof String) {
            string = ServiceLocationAttribute.escapeAttributeString(object.toString(), false);
            if (bl) {
                string = WILDCARD + string;
            }
            if (bl2) {
                string = String.valueOf(string) + WILDCARD;
            }
        } else {
            string = object.toString();
        }
        return string;
    }

    private String rewriteQuery(String string) throws ServiceLocationException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 31);
        streamTokenizer.ordinaryChar(32);
        streamTokenizer.wordChars(33, 37);
        streamTokenizer.ordinaryChar(38);
        streamTokenizer.wordChars(39, 39);
        streamTokenizer.ordinaryChar(40);
        streamTokenizer.ordinaryChar(41);
        streamTokenizer.wordChars(42, 123);
        streamTokenizer.ordinaryChar(124);
        streamTokenizer.wordChars(125, 126);
        streamTokenizer.ordinaryChar(61);
        streamTokenizer.ordinaryChar(33);
        streamTokenizer.ordinaryChar(60);
        streamTokenizer.ordinaryChar(62);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.parseInternal(streamTokenizer, stringBuffer, true);
        }
        catch (IOException iOException) {
            throw new ServiceLocationException(2, "v1_query_error", new Object[]{this.query});
        }
        return stringBuffer.toString();
    }

    private String rewriteQueryJoin(String string) throws ServiceLocationException {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        boolean bl = true;
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals(",")) {
                if (bl) {
                    throw new ServiceLocationException(2, "v1_query_error", new Object[]{string});
                }
                bl = true;
                continue;
            }
            bl = false;
            if (string2.length() <= 0) {
                throw new ServiceLocationException(2, "v1_query_error", new Object[]{string});
            }
            stringBuffer.append("(");
            stringBuffer.append(string2);
            stringBuffer.append(")");
            ++n;
        }
        if (bl || n == 0) {
            throw new ServiceLocationException(2, "v1_query_error", new Object[]{string});
        }
        if (n > 1) {
            stringBuffer.insert(0, "(&");
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

