/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.DAAdvertiser;
import com.sun.slp.Listener;
import com.sun.slp.SDAAdvert;
import com.sun.slp.SLPConfig;
import com.sun.slp.SLPHeaderV1;
import com.sun.slp.ServerDATable;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceStore;
import com.sun.slp.ServiceTable;
import com.sun.slp.SrvLocHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Vector;

abstract class SLPV1Manager {
    static final String V1_HEADER_CLASS = "com.sun.slp.SLPHeaderV1";
    static final String sGeneralSLPMCAddress = "224.0.1.22";
    static final String sDADiscSLPMCAddress = "224.0.1.35";
    static InetAddress v1SLPGSAddr = null;
    static InetAddress v1SLPDAAddr = null;

    static {
        SrvLocHeader.addHeaderClass(V1_HEADER_CLASS, SLPHeaderV1.VERSION);
    }

    SLPV1Manager() {
    }

    public static void start(SLPConfig sLPConfig, ServerDATable serverDATable, ServiceTable serviceTable) {
        if (sLPConfig.getHasSecurity()) {
            if (sLPConfig.regTest() || sLPConfig.traceMsg() || sLPConfig.traceDrop() || sLPConfig.traceDATraffic()) {
                sLPConfig.writeLog("v1_security_enabled", new Object[0]);
            }
            return;
        }
        Vector vector = sLPConfig.getInterfaces();
        int n = 0;
        int n2 = vector.size();
        Vector<SLPV1Advertiser> vector2 = new Vector<SLPV1Advertiser>();
        try {
            InetAddress inetAddress = null;
            inetAddress = InetAddress.getByName(sDADiscSLPMCAddress);
            v1SLPGSAddr = InetAddress.getByName(sGeneralSLPMCAddress);
            n = 0;
            while (n < n2) {
                InetAddress inetAddress2 = (InetAddress)vector.elementAt(n);
                Listener.addListenerToMulticastGroup(inetAddress2, inetAddress);
                SLPV1Advertiser sLPV1Advertiser = new SLPV1Advertiser(inetAddress2, v1SLPGSAddr, serviceTable);
                sLPV1Advertiser.start();
                vector2.addElement(sLPV1Advertiser);
                ++n;
            }
            if (sLPConfig.regTest() || sLPConfig.traceMsg() || sLPConfig.traceDrop() || sLPConfig.traceDATraffic()) {
                sLPConfig.writeLog("v1_hello", new Object[]{sLPConfig.getSAConfiguredScopes()});
            }
            return;
        }
        catch (ServiceLocationException serviceLocationException) {
            sLPConfig.writeLog("v1_init_error", new Object[]{serviceLocationException.getMessage()});
        }
        catch (UnknownHostException unknownHostException) {
            sLPConfig.writeLog("v1_init_error", new Object[]{unknownHostException.getMessage()});
        }
        int n3 = 0;
        while (n3 < n) {
            InetAddress inetAddress = (InetAddress)vector.elementAt(n);
            DatagramSocket datagramSocket = Listener.returnListenerSocketOnInterface(inetAddress);
            if (datagramSocket instanceof MulticastSocket) {
                MulticastSocket multicastSocket = (MulticastSocket)datagramSocket;
                try {
                    multicastSocket.leaveGroup(v1SLPDAAddr);
                }
                catch (IOException iOException) {}
                DAAdvertiser dAAdvertiser = (DAAdvertiser)vector2.elementAt(n3);
                dAAdvertiser.stopThread();
            }
            ++n;
        }
    }

    static class SLPV1Advertiser
    extends DAAdvertiser {
        private short xid = 0;
        private static final short STATEFUL_XID = 256;
        private static final long STATEFUL_TIME_BOUND = 300L;
        private ServiceTable table = null;
        Vector useScopes = new Vector();

        SLPV1Advertiser(InetAddress inetAddress, InetAddress inetAddress2, ServiceTable serviceTable) throws ServiceLocationException {
            this.table = serviceTable;
            this.initialize();
            this.initializeNetworking(inetAddress, inetAddress2);
        }

        private void bumpXid() {
            int n = this.xid + 1;
            this.xid = n > Short.MAX_VALUE ? (short)256 : (short)n;
        }

        protected byte[] getOutbuf() {
            SDAAdvert sDAAdvert = null;
            try {
                SLPHeaderV1 sLPHeaderV1 = new SLPHeaderV1();
                sLPHeaderV1.functionCode = 8;
                sLPHeaderV1.locale = SLPConfig.getLocale();
                sDAAdvert = (SDAAdvert)this.table.makeDAAdvert(sLPHeaderV1, this.interfac, this.xid, this.useScopes, DAAdvertiser.config);
                sLPHeaderV1 = (SLPHeaderV1)sDAAdvert.getHeader();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sLPHeaderV1.externalize(byteArrayOutputStream, true, false);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.bumpXid();
                return byArray;
            }
            catch (ServiceLocationException serviceLocationException) {
                Assert.assert(false, "v1_advert_error", new Object[0]);
                return null;
            }
        }

        private void initialize() throws ServiceLocationException {
            ServiceStore serviceStore = ServiceTable.getServiceTable().store;
            long l = serviceStore.getStateTimestamp();
            long l2 = SLPConfig.currentSLPTime();
            if (l2 - l > 300L) {
                this.xid = (short)256;
            }
            this.useScopes = DAAdvertiser.config.getSAConfiguredScopes();
        }
    }
}

