/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.CDAAdvert;
import com.sun.slp.CSAAdvert;
import com.sun.slp.DATable;
import com.sun.slp.SAttrMsg;
import com.sun.slp.SDAAdvert;
import com.sun.slp.SLPConfig;
import com.sun.slp.SLPHeaderV2;
import com.sun.slp.SSrvDereg;
import com.sun.slp.SSrvMsg;
import com.sun.slp.SSrvReg;
import com.sun.slp.SSrvTypeMsg;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.SrvLocMsg;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;

class SLPServerHeaderV2
extends SLPHeaderV2
implements Cloneable {
    int replyFunctionCode = 5;
    String des = "";

    SLPServerHeaderV2() {
    }

    SLPServerHeaderV2(int n, boolean bl, Locale locale) throws ServiceLocationException {
        super(n, bl, locale);
    }

    protected void constructDescription(String string, String string2) {
        this.des = String.valueOf(string) + ":version=``" + this.version + "''\n" + "       functionCode=``" + this.functionCode + "''\n" + "       length=``" + this.length + "''" + "''\n" + "       overflow=``" + this.overflow + "''\n" + "       mcast = ``" + this.mcast + "''\n" + "       fresh=``" + this.fresh + "''\n" + "       locale = ``" + this.locale + "''\n" + "       xid=``0x" + Integer.toHexString(this.xid) + "''\n" + "       errCode=``" + this.errCode + "''\n" + "       previousResponders=``" + this.previousResponders + "''\n" + "       scopes=``" + this.scopes + "''\n" + string2;
    }

    SDAAdvert getDAAdvert(short s, long l, ServiceURL serviceURL, Vector vector, Vector vector2) throws ServiceLocationException {
        if (vector.size() <= 0) {
            vector = SLPConfig.getSLPConfig().getSAConfiguredScopes();
        }
        return new SDAAdvert(this, s, l, serviceURL, vector, vector2);
    }

    SrvLocMsg makeErrorReply(Exception exception) {
        SrvLocHeader srvLocHeader = null;
        try {
            srvLocHeader = (SrvLocHeader)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        srvLocHeader.fresh = false;
        srvLocHeader.overflow = false;
        srvLocHeader.functionCode = this.replyFunctionCode;
        Assert.assert(exception != null, "null_parameter", new Object[]{exception});
        if (exception instanceof ServiceLocationException) {
            srvLocHeader.errCode = ((ServiceLocationException)exception).getErrorCode();
            if (!ServiceLocationException.validWireErrorCode(srvLocHeader.errCode)) {
                srvLocHeader.errCode = (short)10;
            }
        } else {
            srvLocHeader.errCode = exception instanceof IllegalArgumentException || exception instanceof IOException ? (short)2 : (short)10;
        }
        this.constructDescription("SrvLocMsg", "");
        return srvLocHeader;
    }

    SLPServerHeaderV2 makeReplyHeader() {
        SLPServerHeaderV2 sLPServerHeaderV2 = null;
        try {
            sLPServerHeaderV2 = (SLPServerHeaderV2)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        sLPServerHeaderV2.functionCode = this.replyFunctionCode;
        sLPServerHeaderV2.length = 0;
        sLPServerHeaderV2.previousResponders = null;
        sLPServerHeaderV2.scopes = null;
        sLPServerHeaderV2.overflow = false;
        sLPServerHeaderV2.fresh = false;
        sLPServerHeaderV2.mcast = false;
        return sLPServerHeaderV2;
    }

    void parseHeader(int n, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        switch (n) {
            case 1: {
                this.replyFunctionCode = 2;
                break;
            }
            case 6: {
                this.replyFunctionCode = 7;
                break;
            }
            case 9: {
                this.replyFunctionCode = 10;
                break;
            }
            case 3: 
            case 4: {
                this.replyFunctionCode = 5;
                break;
            }
            case 8: {
                this.replyFunctionCode = 8;
                break;
            }
        }
        super.parseHeader(n, dataInputStream);
    }

    SrvLocMsg parseMsg(DataInputStream dataInputStream) throws ServiceLocationException, IOException, IllegalArgumentException {
        SrvLocMsg srvLocMsg = null;
        if (this.functionCode == 8) {
            this.errCode = (short)this.getInt(dataInputStream);
        }
        switch (this.functionCode) {
            case 3: {
                srvLocMsg = new SSrvReg((SrvLocHeader)this, dataInputStream);
                break;
            }
            case 4: {
                srvLocMsg = new SSrvDereg((SrvLocHeader)this, dataInputStream);
                break;
            }
            case 1: {
                srvLocMsg = new SSrvMsg((SrvLocHeader)this, dataInputStream);
                break;
            }
            case 6: {
                srvLocMsg = new SAttrMsg((SrvLocHeader)this, dataInputStream);
                break;
            }
            case 5: {
                srvLocMsg = this;
                this.iNumReplies = 1;
                break;
            }
            case 9: {
                srvLocMsg = new SSrvTypeMsg((SrvLocHeader)this, dataInputStream);
                break;
            }
            case 8: {
                srvLocMsg = new CDAAdvert((SrvLocHeader)this, dataInputStream);
                break;
            }
            case 11: {
                srvLocMsg = new CSAAdvert(this, dataInputStream);
                break;
            }
            default: {
                throw new ServiceLocationException(2, "function_code_error", new Object[]{new Integer(this.functionCode)});
            }
        }
        if (this.nbytes > this.length) {
            throw new ServiceLocationException(2, "length_overflow", new Object[]{new Integer(this.nbytes), new Integer(this.length)});
        }
        return srvLocMsg;
    }

    void parsePreviousRespondersIn(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.getString(stringBuffer, dataInputStream);
        this.previousResponders = SrvLocHeader.parseCommaSeparatedListIn(stringBuffer.toString(), true);
    }

    void parseScopesIn(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.getString(stringBuffer, dataInputStream);
        this.scopes = SrvLocHeader.parseCommaSeparatedListIn(stringBuffer.toString(), true);
        SLPHeaderV2.unescapeScopeStrings(this.scopes);
        DATable.validateScopes(this.scopes, this.locale);
    }

    public String toString() {
        return this.des;
    }
}

