/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.IANACharCode;
import com.sun.slp.SDAAdvert;
import com.sun.slp.SLPConfig;
import com.sun.slp.SLPV1CDAAdvert;
import com.sun.slp.SLPV1SAttrMsg;
import com.sun.slp.SLPV1SDAAdvert;
import com.sun.slp.SLPV1SSrvDereg;
import com.sun.slp.SLPV1SSrvMsg;
import com.sun.slp.SLPV1SSrvReg;
import com.sun.slp.SLPV1SSrvTypeMsg;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationAttributeV1;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceType;
import com.sun.slp.ServiceURL;
import com.sun.slp.ServiceURLV1;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.SrvLocMsg;
import com.sun.slp.SrvLocMsgImpl;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

class SLPHeaderV1
extends SrvLocHeader
implements Cloneable {
    static int VERSION = 1;
    int replyFunctionCode = 5;
    String des = "";
    protected static final int NOFLAG = 0;
    protected static final int OVERFLOW = 128;
    protected static final int MONOLING = 64;
    protected static final int URLSIG = 32;
    protected static final int ATTRSIG = 16;
    protected static final int FRESH = 8;
    protected static int LANG_CODE_BYTES = 2;
    protected static int HEADER_BYTES = SrvLocHeader.VERSION_FUNCTION_BYTES + LANG_CODE_BYTES + 8;
    private static final String UNESCAPABLE_CHARS = ",=!></*()";
    private static final String ESCAPABLE_CHARS = ",=!></*()&#;";
    String charCode = "UTF8";
    boolean monolingual = false;

    SLPHeaderV1() {
        this.version = VERSION;
    }

    static String checkServiceType(String string) throws ServiceLocationException {
        if (!string.endsWith(":")) {
            throw new ServiceLocationException(2, "v1_service_type_format", new Object[]{string});
        }
        String string2 = string.substring(0, string.length() - 1);
        ServiceType serviceType = new ServiceType(string2 = SLPHeaderV1.removeIANA(string2));
        if (serviceType.isAbstractType()) {
            throw new ServiceLocationException(2, "v1_abstract_type", new Object[0]);
        }
        if (!serviceType.isServiceURL()) {
            throw new ServiceLocationException(2, "v1_not_surl", new Object[0]);
        }
        return string2;
    }

    public Object clone() throws CloneNotSupportedException {
        SLPHeaderV1 sLPHeaderV1 = (SLPHeaderV1)super.clone();
        sLPHeaderV1.nbytes = HEADER_BYTES + 2;
        return sLPHeaderV1;
    }

    protected void constructDescription(String string, String string2) {
        this.des = String.valueOf(string) + ":version=``" + this.version + "''\n" + "       functionCode=``" + this.functionCode + "''\n" + "       length=``" + this.length + "''\n" + "       overflow=``" + this.overflow + "''\n" + "       mcast = ``" + this.mcast + "''\n" + "       fresh=``" + this.fresh + "''\n" + "       monolingual=``" + this.monolingual + "''\n" + "       charCode=``" + this.charCode + "''\n" + "       locale = ``" + this.locale + "''\n" + "       xid=``0x" + Integer.toHexString(this.xid) + "''\n" + "       errCode=``" + this.errCode + "''\n" + "       previousResponders=``" + this.previousResponders + "''\n" + "       scopes=``" + this.scopes + "''\n" + string2;
    }

    public void externalize(ByteArrayOutputStream byteArrayOutputStream, boolean bl, boolean bl2) throws ServiceLocationException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        if (this.functionCode == 5 || this.functionCode == 10 || this.functionCode == 2 || this.functionCode == 7 || this.functionCode == 8) {
            this.putInt(this.errCode, byteArrayOutputStream2);
        } else if (this.previousResponders != null) {
            this.parseCommaSeparatedListOut(this.previousResponders, byteArrayOutputStream2);
        }
        if (this.payload != null && this.errCode == 0) {
            byteArrayOutputStream2.write(this.payload, 0, this.payload.length);
        }
        if ((byArray = byteArrayOutputStream2.toByteArray()).length + 12 > SLPConfig.getSLPConfig().getMTU() && !bl2) {
            this.overflow = true;
        }
        byteArrayOutputStream.write((byte)(0xFF & this.version));
        ++this.nbytes;
        byteArrayOutputStream.write((byte)(0xFF & this.functionCode));
        ++this.nbytes;
        this.length = byArray.length + 12;
        this.putInt(this.length, byteArrayOutputStream);
        int n = 0;
        n = this.overflow ? (int)((byte)(n | 0x80)) : (int)((byte)(n & 0xFFFFFF7F));
        n = this.monolingual ? (int)((byte)(n | 0x40)) : (int)((byte)(n & 0xFFFFFFBF));
        n = this.fresh ? (int)((byte)((n | 8) & 0xFF)) : (int)((byte)(n & 0xFFFFFFF7 & 0xFF));
        byteArrayOutputStream.write((byte)(0xFF & n));
        ++this.nbytes;
        byteArrayOutputStream.write(0);
        ++this.nbytes;
        String string = this.locale.getLanguage();
        byteArrayOutputStream.write((byte)(0xFF & string.charAt(0)));
        byteArrayOutputStream.write((byte)(0xFF & string.charAt(1)));
        this.nbytes += 2;
        int n2 = 0;
        try {
            n2 = IANACharCode.encodeCharacterEncoding(this.charCode);
        }
        catch (ServiceLocationException serviceLocationException) {
            Assert.assert(false, "v1_unsupported_encoding", new Object[]{this.charCode});
        }
        this.putInt(n2, byteArrayOutputStream);
        this.putInt(this.xid, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        this.nbytes += byArray.length;
    }

    SDAAdvert getDAAdvert(short s, long l, ServiceURL serviceURL, Vector vector, Vector vector2) throws ServiceLocationException {
        if (vector.size() <= 0) {
            vector = SLPConfig.getSLPConfig().getSAConfiguredScopes();
        }
        return new SLPV1SDAAdvert(this, s, l, serviceURL, vector, vector2);
    }

    byte[] getString(StringBuffer stringBuffer, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        String string;
        int n = 0;
        n = SrvLocHeader.getInteger(dataInputStream);
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray, 0, n);
        if (this.charCode == "Unicode") {
            this.charCode = IANACharCode.getUnicodeEndianess(byArray);
        }
        if ((string = this.charCode) == "Unicode") {
            string = "UnicodeBig";
            byArray = IANACharCode.addBigEndianFlag(byArray);
        }
        stringBuffer.setLength(0);
        stringBuffer.append(SrvLocHeader.getBytesString(byArray, string));
        return byArray;
    }

    SrvLocMsg makeErrorReply(Exception exception) {
        if (this.functionCode == 8) {
            return null;
        }
        SLPHeaderV1 sLPHeaderV1 = null;
        try {
            sLPHeaderV1 = (SLPHeaderV1)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        sLPHeaderV1.fresh = false;
        sLPHeaderV1.overflow = false;
        sLPHeaderV1.mcast = false;
        sLPHeaderV1.functionCode = this.replyFunctionCode;
        Assert.assert(exception != null, "null_parameter", new Object[]{exception});
        if (exception instanceof ServiceLocationException) {
            sLPHeaderV1.errCode = ((ServiceLocationException)exception).getErrorCode();
            if (sLPHeaderV1.errCode == 1) {
                try {
                    if (!sLPHeaderV1.monolingual) {
                        if (sLPHeaderV1.functionCode == 1) {
                            return SLPV1SSrvMsg.makeEmptyReply(sLPHeaderV1);
                        }
                        if (sLPHeaderV1.functionCode == 6) {
                            return SLPV1SAttrMsg.makeEmptyReply(sLPHeaderV1);
                        }
                    }
                }
                catch (ServiceLocationException serviceLocationException) {
                    sLPHeaderV1.monolingual = true;
                    sLPHeaderV1.makeErrorReply(serviceLocationException);
                }
            }
            if (sLPHeaderV1.errCode > 7) {
                sLPHeaderV1.errCode = (short)2;
            }
        } else {
            sLPHeaderV1.errCode = exception instanceof IllegalArgumentException || exception instanceof IOException ? (short)2 : (short)2;
        }
        sLPHeaderV1.constructDescription("SrvLocMsg", "");
        return sLPHeaderV1;
    }

    SLPHeaderV1 makeReplyHeader() {
        SLPHeaderV1 sLPHeaderV1 = null;
        try {
            sLPHeaderV1 = (SLPHeaderV1)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        sLPHeaderV1.functionCode = this.replyFunctionCode;
        sLPHeaderV1.length = 0;
        sLPHeaderV1.previousResponders = null;
        sLPHeaderV1.scopes = null;
        sLPHeaderV1.overflow = false;
        sLPHeaderV1.fresh = false;
        sLPHeaderV1.mcast = false;
        sLPHeaderV1.nbytes = 0;
        return sLPHeaderV1;
    }

    protected Vector parseAttributeVectorIn(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.getString(stringBuffer, dataInputStream);
        SLPConfig sLPConfig = SLPConfig.getSLPConfig();
        Vector vector = SrvLocHeader.parseCommaSeparatedListIn(stringBuffer.toString(), false);
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2);
            vector.setElementAt(new ServiceLocationAttributeV1(string, this.charCode, false), n2);
            ++n2;
        }
        return vector;
    }

    void parseAttributeVectorOut(Vector vector, ByteArrayOutputStream byteArrayOutputStream) throws ServiceLocationException {
        Enumeration enumeration = vector.elements();
        Vector<String> vector2 = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            ServiceLocationAttribute serviceLocationAttribute = (ServiceLocationAttribute)enumeration.nextElement();
            ServiceLocationAttributeV1 serviceLocationAttributeV1 = new ServiceLocationAttributeV1(serviceLocationAttribute);
            serviceLocationAttributeV1.charCode = this.charCode;
            String string = serviceLocationAttributeV1.externalize();
            vector2.addElement(string);
        }
        this.parseCommaSeparatedListOut(vector2, byteArrayOutputStream);
    }

    void parseHeader(int n, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        boolean bl;
        this.functionCode = n;
        switch (n) {
            case 1: {
                this.replyFunctionCode = 2;
                break;
            }
            case 6: {
                this.replyFunctionCode = 7;
                break;
            }
            case 9: {
                this.replyFunctionCode = 10;
                break;
            }
        }
        this.length = this.getInt(dataInputStream);
        byte by = (byte)((char)dataInputStream.read() & 0xFF);
        ++this.nbytes;
        this.overflow = (by & 0x80) != 0;
        this.fresh = false;
        this.monolingual = (by & 0x40) != 0;
        boolean bl2 = (by & 0x20) != 0;
        boolean bl3 = bl = (by & 0x10) != 0;
        if (bl2 || bl) {
            throw new ServiceLocationException(7, "v1_no_security", new Object[0]);
        }
        int n2 = (char)dataInputStream.read() & 0xFF;
        ++this.nbytes;
        if (n2 != 0) {
            throw new ServiceLocationException(2, "v1_nonzero_dialect", new Object[0]);
        }
        byte[] byArray = new byte[LANG_CODE_BYTES];
        byArray[0] = (byte)dataInputStream.read();
        byArray[1] = (byte)dataInputStream.read();
        this.nbytes += 2;
        try {
            this.locale = new Locale(new String(byArray, "Default"), "");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        int n3 = this.getInt(dataInputStream);
        this.charCode = IANACharCode.decodeCharacterEncoding(n3);
        this.xid = (short)this.getInt(dataInputStream);
        this.errCode = 0;
    }

    SrvLocMsg parseMsg(DataInputStream dataInputStream) throws ServiceLocationException, IOException, IllegalArgumentException {
        SrvLocMsgImpl srvLocMsgImpl = null;
        if (this.mcast && this.functionCode != 8) {
            return null;
        }
        switch (this.functionCode) {
            case 1: {
                srvLocMsgImpl = new SLPV1SSrvMsg((SrvLocHeader)this, dataInputStream);
                break;
            }
            case 3: {
                srvLocMsgImpl = new SLPV1SSrvReg((SrvLocHeader)this, dataInputStream);
                break;
            }
            case 4: {
                srvLocMsgImpl = new SLPV1SSrvDereg((SrvLocHeader)this, dataInputStream);
                break;
            }
            case 6: {
                srvLocMsgImpl = new SLPV1SAttrMsg((SrvLocHeader)this, dataInputStream);
                break;
            }
            case 9: {
                srvLocMsgImpl = new SLPV1SSrvTypeMsg((SrvLocHeader)this, dataInputStream);
                break;
            }
            case 8: {
                srvLocMsgImpl = new SLPV1CDAAdvert(this, dataInputStream);
                break;
            }
            default: {
                throw new ServiceLocationException(2, "function_code_error", new Object[]{new Integer(this.functionCode)});
            }
        }
        if (this.nbytes > this.length) {
            throw new ServiceLocationException(2, "length_overflow", new Object[]{new Integer(this.nbytes), new Integer(this.length)});
        }
        return srvLocMsgImpl;
    }

    void parsePreviousRespondersIn(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.getString(stringBuffer, dataInputStream);
        this.previousResponders = SrvLocHeader.parseCommaSeparatedListIn(stringBuffer.toString(), true);
    }

    protected ServiceURL parseServiceURLIn(DataInputStream dataInputStream, boolean bl, short s) throws ServiceLocationException, IOException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            n = this.getInt(dataInputStream);
        }
        this.getString(stringBuffer, dataInputStream);
        ServiceURLV1 serviceURLV1 = null;
        try {
            serviceURLV1 = new ServiceURLV1(stringBuffer.toString(), n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ServiceLocationException(s, "malformed_url", new Object[]{illegalArgumentException});
        }
        return serviceURLV1;
    }

    void parseServiceURLOut(ServiceURL serviceURL, boolean bl, ByteArrayOutputStream byteArrayOutputStream) throws ServiceLocationException {
        String string = serviceURL.toString();
        if (bl) {
            this.putInt(serviceURL.getLifetime(), byteArrayOutputStream);
        }
        this.putString(string, byteArrayOutputStream);
    }

    byte[] putString(String string, ByteArrayOutputStream byteArrayOutputStream) {
        if (this.charCode == "Unicode") {
            this.charCode = "UnicodeBig";
        }
        byte[] byArray = SrvLocHeader.putStringField(string, byteArrayOutputStream, this.charCode);
        this.nbytes += byArray.length;
        return byArray;
    }

    void putStringVector(Vector vector, ByteArrayOutputStream byteArrayOutputStream) {
        int n = vector.size();
        this.putInt(n, byteArrayOutputStream);
        int n2 = 0;
        while (n2 < n) {
            this.putString((String)vector.elementAt(n2), byteArrayOutputStream);
            ++n2;
        }
    }

    static String removeIANA(String string) {
        int n = 0;
        n = (string = string.toLowerCase()).indexOf(".iana");
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public String toString() {
        return this.des;
    }

    static void validateScope(String string) throws ServiceLocationException {
        if (string.indexOf(47) != -1 || string.indexOf(44) != -1 || string.indexOf(58) != -1) {
            throw new ServiceLocationException(2, "v1_scope_char_res", new Object[]{string});
        }
        if (string.equalsIgnoreCase("local") || string.equalsIgnoreCase("remote")) {
            throw new ServiceLocationException(2, "v1_scope_name_res", new Object[]{string});
        }
    }
}

