/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.AuthBlock;
import com.sun.slp.SLPServerHeaderV2;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceType;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.SrvLocMsg;
import com.sun.slp.SrvLocMsgImpl;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

class SAttrMsg
extends SrvLocMsgImpl {
    ServiceURL URL = null;
    String serviceType = null;
    Vector tags = new Vector();
    String spi = "";

    protected SAttrMsg() {
    }

    SAttrMsg(SrvLocHeader srvLocHeader, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        super(srvLocHeader, 6);
        this.initialize(dataInputStream);
    }

    void initialize(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        SLPServerHeaderV2 sLPServerHeaderV2 = (SLPServerHeaderV2)this.getHeader();
        StringBuffer stringBuffer = new StringBuffer();
        sLPServerHeaderV2.parsePreviousRespondersIn(dataInputStream);
        sLPServerHeaderV2.getString(stringBuffer, dataInputStream);
        String string = stringBuffer.toString();
        try {
            this.URL = new ServiceURL(string, 0);
            this.serviceType = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ServiceType serviceType = new ServiceType(string);
            this.serviceType = serviceType.toString();
            this.URL = null;
        }
        sLPServerHeaderV2.parseScopesIn(dataInputStream);
        sLPServerHeaderV2.getString(stringBuffer, dataInputStream);
        this.tags = SrvLocHeader.parseCommaSeparatedListIn(stringBuffer.toString(), true);
        sLPServerHeaderV2.unescapeTags(this.tags);
        sLPServerHeaderV2.getString(stringBuffer, dataInputStream);
        this.spi = stringBuffer.toString();
        sLPServerHeaderV2.constructDescription("AttrRqst", "         " + (this.URL != null ? "URL=``" + this.URL : "service type=``" + this.serviceType) + "''\n" + "         tags=``" + this.tags + "''\n" + "         spi=``" + this.spi + "''\n");
    }

    SrvLocMsg makeReply(Vector vector, Hashtable hashtable) throws ServiceLocationException {
        Object object;
        SLPServerHeaderV2 sLPServerHeaderV2 = ((SLPServerHeaderV2)this.getHeader()).makeReplyHeader();
        sLPServerHeaderV2.iNumReplies = vector.size();
        if (hashtable != null) {
            object = AuthBlock.getEquivalentAuth(this.spi, hashtable);
            hashtable = null;
            if (object != null) {
                hashtable = new Hashtable<String, Object>();
                hashtable.put(this.spi, object);
            }
        }
        object = new ByteArrayOutputStream();
        sLPServerHeaderV2.parseAttributeVectorOut(vector, 0, hashtable != null, hashtable, (ByteArrayOutputStream)object, true);
        sLPServerHeaderV2.payload = ((ByteArrayOutputStream)object).toByteArray();
        sLPServerHeaderV2.constructDescription("AttrRply", "        attributes=``" + vector + "''\n" + "        auth block=" + AuthBlock.desc(hashtable) + "\n");
        return sLPServerHeaderV2;
    }
}

