/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.CDAAdvert;
import com.sun.slp.CSAAdvert;
import com.sun.slp.DATable;
import com.sun.slp.Defaults;
import com.sun.slp.SAttrMsg;
import com.sun.slp.SLPConfig;
import com.sun.slp.SSrvDereg;
import com.sun.slp.SSrvMsg;
import com.sun.slp.SSrvReg;
import com.sun.slp.SSrvTypeMsg;
import com.sun.slp.ServerDATable;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceTable;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.SrvLocMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class RequestHandler
extends Thread {
    private SLPConfig config;
    private ServerDATable daTable;
    private InetAddress interfac = null;
    private Socket sock = null;
    private DatagramPacket packet = null;
    private InetAddress clientAddr = null;
    private int port = 0;
    private ServiceTable serviceTable = null;
    private SrvLocMsg toForward = null;
    private InputStream inStream = null;
    private OutputStream outStream = null;
    private static Hashtable inProgress = new Hashtable();

    static {
        SrvLocHeader.addHeaderClass("com.sun.slp.SLPServerHeaderV2", 2);
    }

    RequestHandler(InputStream inputStream, OutputStream outputStream, SLPConfig sLPConfig) {
        this.config = sLPConfig;
        this.sock = null;
        this.inStream = inputStream;
        this.outStream = outputStream;
        this.clientAddr = this.config.getLoopback();
        this.port = 427;
        this.interfac = this.clientAddr;
        try {
            this.serviceTable = ServiceTable.getServiceTable();
        }
        catch (ServiceLocationException serviceLocationException) {}
    }

    RequestHandler(DatagramPacket datagramPacket, InetAddress inetAddress, SLPConfig sLPConfig) {
        Assert.assert(datagramPacket != null, "rh_null_packy", new Object[0]);
        Assert.assert(sLPConfig != null, "ls_null_config", new Object[0]);
        this.config = sLPConfig;
        this.packet = datagramPacket;
        this.clientAddr = this.packet.getAddress();
        this.port = this.packet.getPort();
        this.interfac = inetAddress;
        try {
            this.serviceTable = ServiceTable.getServiceTable();
            this.daTable = ServerDATable.getServerDATable();
        }
        catch (ServiceLocationException serviceLocationException) {}
    }

    RequestHandler(Socket socket, InetAddress inetAddress, SLPConfig sLPConfig) {
        Assert.assert(socket != null, "rh_null_sock", new Object[0]);
        Assert.assert(sLPConfig != null, "ls_null_config", new Object[0]);
        this.config = sLPConfig;
        this.sock = socket;
        this.clientAddr = this.sock.getInetAddress();
        this.port = this.sock.getPort();
        this.interfac = inetAddress;
        try {
            this.serviceTable = ServiceTable.getServiceTable();
        }
        catch (ServiceLocationException serviceLocationException) {}
    }

    SrvLocMsg dispatch(SrvLocMsg srvLocMsg) {
        SrvLocHeader srvLocHeader = srvLocMsg.getHeader();
        boolean bl = srvLocHeader.mcast;
        if (srvLocMsg instanceof CDAAdvert) {
            CDAAdvert cDAAdvert = (CDAAdvert)srvLocMsg;
            cDAAdvert.setIsUnsolicited(true);
            if (!this.config.passiveDADetection() && cDAAdvert.isUnsolicited() && !cDAAdvert.isGoingDown()) {
                if (this.config.traceDrop()) {
                    this.config.writeLog("rh_passive_drop", new Object[]{cDAAdvert.URL, srvLocHeader.scopes});
                }
            } else if (cDAAdvert.isGoingDown() && cDAAdvert.isUnsolicited() && this.isLocalHostURL(cDAAdvert.URL) && this.config.isDA()) {
                Vector vector = (Vector)srvLocHeader.scopes.clone();
                DATable.filterScopes(vector, this.config.getSAConfiguredScopes(), true);
                if (vector.size() > 0) {
                    this.daTable.handleAdvertIn(cDAAdvert);
                } else {
                    Vector vector2 = new Vector();
                    try {
                        vector2 = this.daTable.findScopes();
                    }
                    catch (ServiceLocationException serviceLocationException) {}
                    Vector vector3 = this.config.getSAConfiguredScopes();
                    Vector vector4 = this.config.getInterfaces();
                    Vector vector5 = this.config.getDAAttributes();
                    if (this.config.traceAll() || this.config.traceMsg() || this.config.traceDrop() || this.config.traceDATraffic()) {
                        this.config.writeLog("goodby_da", new Object[]{vector4, vector3, vector2, vector5});
                    }
                    System.exit(0);
                }
            } else {
                this.daTable.handleAdvertIn(cDAAdvert);
            }
            return null;
        }
        if (srvLocMsg instanceof CSAAdvert) {
            CSAAdvert cSAAdvert = (CSAAdvert)srvLocMsg;
            if (srvLocHeader.xid == 0 && this.isLocalHostURL(cSAAdvert.URL) && !this.config.isDA()) {
                Vector vector = (Vector)srvLocHeader.scopes.clone();
                DATable.filterScopes(vector, this.config.getSAConfiguredScopes(), true);
                if (vector.size() <= 0) {
                    Vector vector6 = new Vector();
                    try {
                        vector6 = this.daTable.findScopes();
                    }
                    catch (ServiceLocationException serviceLocationException) {}
                    Vector vector7 = this.config.getSAConfiguredScopes();
                    Vector vector8 = this.config.getInterfaces();
                    Vector vector9 = this.config.getSAAttributes();
                    if (this.config.traceAll() || this.config.traceMsg() || this.config.traceDrop() || this.config.traceDATraffic()) {
                        this.config.writeLog("goodby", new Object[]{vector8, vector7, vector6, vector9});
                    }
                    System.exit(0);
                }
            }
            if (this.config.traceDrop()) {
                this.config.writeLog("rh_client_sa_advert_drop", new Object[]{Integer.toHexString(srvLocHeader.xid), this.clientAddr, new Integer(this.port), this.interfac});
            }
            return null;
        }
        if (srvLocMsg instanceof SSrvReg) {
            return this.dispatchReg((SSrvReg)srvLocMsg, this.serviceTable);
        }
        if (srvLocMsg instanceof SSrvDereg) {
            return this.dispatchDereg((SSrvDereg)srvLocMsg, this.serviceTable);
        }
        if (this.isPreviousResponder(srvLocHeader)) {
            if (this.config.traceDrop()) {
                this.config.writeLog("rh_prev_resp", new Object[]{Integer.toHexString(srvLocHeader.xid), this.clientAddr, new Integer(this.port), this.interfac});
            }
            return null;
        }
        if (srvLocMsg instanceof SSrvTypeMsg) {
            return this.dispatchSrvType((SSrvTypeMsg)srvLocMsg, this.serviceTable);
        }
        if (srvLocMsg instanceof SAttrMsg) {
            return this.dispatchAttr((SAttrMsg)srvLocMsg, this.serviceTable);
        }
        if (srvLocMsg instanceof SSrvMsg) {
            return this.dispatchSrv((SSrvMsg)srvLocMsg, this.serviceTable);
        }
        Assert.assert(false, "rh_rqst_type_err", new Object[]{srvLocMsg});
        return null;
    }

    private SrvLocMsg dispatchAttr(SAttrMsg sAttrMsg, ServiceTable serviceTable) {
        SrvLocHeader srvLocHeader = sAttrMsg.getHeader();
        boolean bl = srvLocHeader.mcast;
        if (bl && this.config.isDA()) {
            if (this.config.traceDrop()) {
                this.config.writeLog("rh_drop_da_multi", new Object[]{"AttrRqst", Integer.toHexString(srvLocHeader.xid), this.clientAddr, new Integer(this.port), this.interfac});
            }
            return null;
        }
        SrvLocMsg srvLocMsg = serviceTable.findAttributes(sAttrMsg);
        srvLocHeader = srvLocMsg.getHeader();
        if (bl && (srvLocHeader.errCode != 0 || srvLocHeader.getNumReplies() == 0)) {
            if (this.config.traceDrop()) {
                this.config.writeLog("rh_multi_error", new Object[]{"AttrRqst", Integer.toHexString(srvLocHeader.xid), this.clientAddr, new Integer(this.port), this.interfac});
            }
            return null;
        }
        return srvLocMsg;
    }

    private SrvLocMsg dispatchDereg(SSrvDereg sSrvDereg, ServiceTable serviceTable) {
        SrvLocHeader srvLocHeader = sSrvDereg.getHeader();
        if (srvLocHeader.mcast && this.config.traceDrop()) {
            if (this.config.traceDrop()) {
                this.config.writeLog("rh_no_multi", new Object[]{"SrvDereg", Integer.toHexString(srvLocHeader.xid), this.clientAddr, new Integer(this.port), this.interfac});
            }
            return null;
        }
        SrvLocMsg srvLocMsg = serviceTable.deregister(sSrvDereg);
        if (srvLocMsg != null) {
            srvLocHeader = srvLocMsg.getHeader();
            if (srvLocHeader.errCode == 0) {
                this.toForward = sSrvDereg;
            }
        }
        return srvLocMsg;
    }

    private SrvLocMsg dispatchReg(SSrvReg sSrvReg, ServiceTable serviceTable) {
        SrvLocHeader srvLocHeader = sSrvReg.getHeader();
        if (srvLocHeader.mcast && this.config.traceDrop()) {
            if (this.config.traceDrop()) {
                this.config.writeLog("rh_no_multi", new Object[]{"SrvReg", Integer.toHexString(srvLocHeader.xid), this.clientAddr, new Integer(this.port), this.interfac});
            }
            return null;
        }
        SrvLocMsg srvLocMsg = serviceTable.register(sSrvReg);
        if (srvLocMsg != null) {
            srvLocHeader = srvLocMsg.getHeader();
            if (srvLocHeader.errCode == 0) {
                this.toForward = sSrvReg;
            }
        }
        return srvLocMsg;
    }

    private SrvLocMsg dispatchSrv(SSrvMsg sSrvMsg, ServiceTable serviceTable) {
        SrvLocHeader srvLocHeader = sSrvMsg.getHeader();
        boolean bl = srvLocHeader.mcast;
        String string = sSrvMsg.serviceType;
        SrvLocMsg srvLocMsg = null;
        if (string.equals(Defaults.DA_SERVICE_TYPE.toString())) {
            if (this.config.isDA()) {
                srvLocMsg = serviceTable.makeDAAdvert(sSrvMsg, this.interfac, this.config);
                srvLocHeader = srvLocMsg.getHeader();
                if (srvLocHeader.errCode != 0 && this.config.traceMsg()) {
                    this.config.writeLog("rh_advert_error", new Object[]{new Integer(srvLocHeader.errCode), "DAAdvert", ""});
                }
            }
            if (srvLocHeader.errCode != 0 && bl) {
                if (this.config.traceDrop()) {
                    this.config.writeLog("rh_drop_srv", new Object[]{"DA SrvRqst", Integer.toHexString(srvLocHeader.xid), this.clientAddr, new Integer(this.port), this.interfac});
                }
                return null;
            }
            return srvLocMsg;
        }
        if (string.equals(Defaults.SA_SERVICE_TYPE.toString())) {
            if (!bl) {
                if (this.config.traceDrop()) {
                    this.config.writeLog("rh_no_srv_uni", new Object[]{"SA SrvRqst", Integer.toHexString(srvLocHeader.xid), this.clientAddr, new Integer(this.port), this.interfac});
                }
                return null;
            }
            try {
                srvLocMsg = serviceTable.makeSAAdvert(sSrvMsg, this.interfac, this.config);
            }
            catch (ServiceLocationException serviceLocationException) {
                this.config.writeLog("rh_advert_error", new Object[]{new Integer(serviceLocationException.getErrorCode()), "SAAdvert", serviceLocationException.getMessage()});
            }
            if (srvLocMsg == null && this.config.traceDrop()) {
                this.config.writeLog("rh_drop_srv", new Object[]{"SA SrvRqst", Integer.toHexString(srvLocHeader.xid), this.clientAddr, new Integer(this.port), this.interfac});
            }
            return srvLocMsg;
        }
        if (bl && this.config.isDA()) {
            if (this.config.traceDrop()) {
                this.config.writeLog("rh_drop_da_multi", new Object[]{"SrvRqst", Integer.toHexString(srvLocHeader.xid), this.clientAddr, new Integer(this.port), this.interfac});
            }
            return null;
        }
        SrvLocMsg srvLocMsg2 = serviceTable.findServices(sSrvMsg);
        srvLocHeader = srvLocMsg2.getHeader();
        if (bl && (srvLocHeader.errCode != 0 || srvLocHeader.getNumReplies() == 0)) {
            if (this.config.traceDrop()) {
                this.config.writeLog("rh_multi_error", new Object[]{"SrvRqst", Integer.toHexString(srvLocHeader.xid), this.clientAddr, new Integer(this.port), this.interfac});
            }
            return null;
        }
        return srvLocMsg2;
    }

    private SrvLocMsg dispatchSrvType(SSrvTypeMsg sSrvTypeMsg, ServiceTable serviceTable) {
        SrvLocHeader srvLocHeader = sSrvTypeMsg.getHeader();
        boolean bl = srvLocHeader.mcast;
        if (bl && this.config.isDA()) {
            if (this.config.traceDrop()) {
                this.config.writeLog("rh_drop_da_multi", new Object[]{"SrvTypeRqst", Integer.toHexString(srvLocHeader.xid), this.clientAddr, new Integer(this.port), this.interfac});
            }
            return null;
        }
        SrvLocMsg srvLocMsg = serviceTable.findServiceTypes(sSrvTypeMsg);
        srvLocHeader = srvLocMsg.getHeader();
        if (bl && (srvLocHeader.errCode != 0 || srvLocHeader.getNumReplies() == 0)) {
            if (this.config.traceDrop()) {
                this.config.writeLog("rh_multi_error", new Object[]{"SrvTypeRqst", Integer.toHexString(srvLocHeader.xid), this.clientAddr, new Integer(this.port), this.interfac});
            }
            return null;
        }
        return srvLocMsg;
    }

    protected void finalize() throws IOException {
        if (this.sock != null) {
            this.sock.close();
        }
    }

    private boolean handleRequest(DataInputStream dataInputStream, ByteArrayOutputStream byteArrayOutputStream, boolean bl) throws IOException {
        Object object;
        SrvLocMsg srvLocMsg;
        boolean bl2 = false;
        SrvLocMsg srvLocMsg2 = srvLocMsg = this.internalize(dataInputStream, bl);
        if (srvLocMsg != null) {
            object = srvLocMsg.getHeader();
            if (((SrvLocHeader)object).errCode == 0) {
                if (this.config.traceMsg()) {
                    this.config.writeLog("rh_rqst_in", new Object[]{Integer.toHexString(((SrvLocHeader)object).xid), this.clientAddr, new Integer(this.port), this.interfac, srvLocMsg.getHeader()});
                }
                if ((srvLocMsg2 = this.dispatch(srvLocMsg)) == null) {
                    if (this.config.traceMsg()) {
                        this.config.writeLog("rh_rply_null", new Object[]{Integer.toHexString(((SrvLocHeader)object).xid), this.clientAddr, new Integer(this.port), this.interfac});
                    }
                    return bl2;
                }
            } else if (srvLocMsg.getHeader().mcast) {
                srvLocMsg2 = null;
                if (this.config.traceDrop()) {
                    this.config.writeLog("rh_multi_error", new Object[]{srvLocMsg.getClass().getName(), Integer.toHexString(((SrvLocHeader)object).xid), this.clientAddr, new Integer(this.port), this.interfac});
                }
            } else if (bl) {
                bl2 = true;
            }
        }
        if (srvLocMsg2 != null) {
            object = srvLocMsg2.getHeader();
            if (this.config.traceMsg()) {
                this.config.writeLog("rh_rply_out", new Object[]{Integer.toHexString(((SrvLocHeader)object).xid), this.clientAddr, new Integer(this.port), this.interfac, srvLocMsg2.getHeader()});
            }
            try {
                ((SrvLocHeader)object).externalize(byteArrayOutputStream, false, bl);
            }
            catch (ServiceLocationException serviceLocationException) {
                byteArrayOutputStream.reset();
                srvLocMsg2 = ((SrvLocHeader)object).makeErrorReply(serviceLocationException);
                Assert.assert(srvLocMsg != null, "rh_header_class_error", new Object[]{serviceLocationException.getMessage()});
                object = srvLocMsg2.getHeader();
                try {
                    ((SrvLocHeader)object).externalize(byteArrayOutputStream, false, bl);
                }
                catch (ServiceLocationException serviceLocationException2) {}
            }
        } else if (this.config.traceMsg()) {
            object = "<null message>";
            if (srvLocMsg != null) {
                SrvLocHeader srvLocHeader = srvLocMsg.getHeader();
                object = Integer.toHexString(srvLocHeader.xid);
            }
            this.config.writeLog("rh_rply_null", new Object[]{object, this.clientAddr, new Integer(this.port), this.interfac});
        }
        return bl2;
    }

    private void handleStream() {
        block9: {
            try {
                boolean bl;
                DataInputStream dataInputStream = null;
                DataOutputStream dataOutputStream = null;
                if (this.inStream != null) {
                    dataInputStream = new DataInputStream(this.inStream);
                    dataOutputStream = new DataOutputStream(this.outStream);
                } else {
                    dataInputStream = new DataInputStream(this.sock.getInputStream());
                    dataOutputStream = new DataOutputStream(this.sock.getOutputStream());
                }
                do {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bl = this.handleRequest(dataInputStream, byteArrayOutputStream, true);
                    dataOutputStream.write(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                    if (this.toForward == null) continue;
                    try {
                        this.daTable.forwardSAMessage(this.toForward, this.clientAddr);
                        this.toForward = null;
                    }
                    catch (ServiceLocationException serviceLocationException) {
                        this.config.writeLog("sa_forwarding_exception", new Object[]{new Short(serviceLocationException.getErrorCode()), Integer.toHexString(this.toForward.getHeader().xid), serviceLocationException.getMessage()});
                    }
                } while (!bl || !this.config.traceMsg());
                this.config.writeLog("rh_tcp_error", new Object[]{this.clientAddr, new Integer(this.port), this.interfac});
            }
            catch (EOFException eOFException) {
                if (this.config.traceMsg()) {
                    this.config.writeLog("rh_socket_closed", new Object[]{this.clientAddr, new Integer(this.port), this.interfac});
                }
            }
            catch (IOException iOException) {
                if (!this.config.traceDrop()) break block9;
                this.config.writeLog("ioexception_server_stream", new Object[]{this.clientAddr, new Integer(this.port), this.interfac, iOException.getMessage()});
            }
        }
    }

    private SrvLocMsg internalize(DataInputStream dataInputStream, boolean bl) throws IOException {
        Object object;
        block9: {
            int n = 0;
            int n2 = 0;
            Assert.assert(dataInputStream != null, "rh_null_bais", new Object[0]);
            try {
                object = new byte[2];
                dataInputStream.readFully((byte[])object, 0, 2);
                n = (char)object[0] & 0xFF;
                n2 = (char)object[1] & 0xFF;
            }
            catch (IOException iOException) {
                if (!(iOException instanceof EOFException)) {
                    this.printInternalizeErrorMessage(n, n2, iOException);
                }
                throw iOException;
            }
            object = null;
            SrvLocHeader srvLocHeader = null;
            try {
                srvLocHeader = SrvLocHeader.newInstance(n);
                if (srvLocHeader == null) {
                    if (n > 2 || this.config.isV1Supported() && this.config.isDA()) {
                        throw new ServiceLocationException(9, "rh_version_number_error", new Object[]{new Integer(n), this.clientAddr, new Integer(this.port), this.interfac});
                    }
                    return null;
                }
                if (bl) {
                    srvLocHeader.setPacketLength(Integer.MAX_VALUE);
                }
                srvLocHeader.parseHeader(n2, dataInputStream);
                SrvLocMsg srvLocMsg = srvLocHeader.parseMsg(dataInputStream);
                object = srvLocMsg;
                if (srvLocMsg != null) {
                    srvLocHeader.parseOptions(dataInputStream);
                }
            }
            catch (Exception exception) {
                this.printInternalizeErrorMessage(n, n2, exception);
                object = null;
                if (n2 == 8 || n2 == 11 || srvLocHeader == null) break block9;
                object = srvLocHeader.makeErrorReply(exception);
            }
        }
        return object;
    }

    boolean isLocalHostURL(ServiceURL serviceURL) {
        String string = serviceURL.getHost();
        Vector vector = this.config.getInterfaces();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return vector.contains(inetAddress);
    }

    public boolean isPreviousResponder(SrvLocHeader srvLocHeader) {
        if (srvLocHeader.previousResponders == null || !srvLocHeader.mcast) {
            return false;
        }
        Vector vector = srvLocHeader.previousResponders;
        Enumeration enumeration = null;
        Vector vector2 = this.config.getInterfaces();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                InetAddress inetAddress = InetAddress.getByName(string);
                if (!vector2.contains(inetAddress)) continue;
                return true;
            }
            catch (UnknownHostException unknownHostException) {}
        }
        return false;
    }

    private void printInternalizeErrorMessage(int n, int n2, Exception exception) {
        if (this.config.traceDrop()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            int n3 = 20;
            if (exception instanceof ServiceLocationException) {
                n3 = ((ServiceLocationException)exception).getErrorCode();
            } else if (exception instanceof IllegalArgumentException) {
                n3 = 2;
            }
            String string = "(" + n3 + "):" + exception.getMessage();
            this.config.writeLog("rh_unparse_exception", new Object[]{this.clientAddr, new Integer(this.port), this.interfac, new Integer(n), new Integer(n2), string, stringWriter.toString()});
        }
    }

    public void run() {
        if (this.sock != null || this.inStream != null) {
            this.setName("Stream Request Handler " + this.clientAddr + ":" + this.port);
            if (this.sock != null) {
                try {
                    this.sock.setSoTimeout(0);
                }
                catch (SocketException socketException) {}
            }
            try {
                this.daTable = ServerDATable.getServerDATable();
            }
            catch (ServiceLocationException serviceLocationException) {}
            this.handleStream();
            if (this.sock != null) {
                try {
                    this.sock.close();
                    this.sock = null;
                }
                catch (IOException iOException) {}
            }
        } else {
            Object object;
            String string;
            block23: {
                this.setName("Datagram Request Handler " + this.clientAddr + ":" + this.port);
                byte[] byArray = this.packet.getData();
                byte[] byArray2 = new byte[2];
                System.arraycopy(byArray, 10, byArray2, 0, 2);
                int n = 0;
                n = ((char)byArray2[0] & 0xFF) << 8;
                string = String.valueOf(new Integer(n += (char)byArray2[1] & 0xFF).toString()) + this.clientAddr.getHostAddress();
                boolean bl = false;
                Object object2 = inProgress;
                synchronized (object2) {
                    boolean bl2 = bl = inProgress.get(string) != null;
                    if (!bl) {
                        inProgress.put(string, this);
                    }
                }
                if (bl) {
                    if (this.config.traceDrop()) {
                        this.config.writeLog("rh_rqst_in_progress", new Object[]{this.clientAddr, new Integer(this.port), this.interfac});
                    }
                    return;
                }
                object2 = new DataInputStream(new ByteArrayInputStream(byArray));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    this.handleRequest((DataInputStream)object2, byteArrayOutputStream, false);
                    object = byteArrayOutputStream.toByteArray();
                    if (object != null && ((Object)object).length > 0) {
                        this.sendDatagramReply((byte[])object);
                    }
                }
                catch (IOException iOException) {
                    if (!this.config.traceDrop()) break block23;
                    this.config.writeLog("rh_datagram_ioe", new Object[]{this.clientAddr, new Integer(this.port), this.interfac, iOException.getMessage()});
                }
            }
            object = inProgress;
            synchronized (object) {
                RequestHandler requestHandler = (RequestHandler)inProgress.get(string);
                if (requestHandler == this) {
                    inProgress.remove(string);
                }
            }
        }
    }

    private void sendDatagramReply(byte[] byArray) {
        DatagramSocket datagramSocket = null;
        try {
            block11: {
                try {
                    datagramSocket = new DatagramSocket();
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.clientAddr, this.port);
                    datagramSocket.send(datagramPacket);
                    if (this.toForward != null) {
                        try {
                            this.daTable.forwardSAMessage(this.toForward, this.clientAddr);
                            this.toForward = null;
                        }
                        catch (ServiceLocationException serviceLocationException) {
                            this.config.writeLog("sle_forward_error", new Object[]{new Integer(serviceLocationException.getErrorCode()), Integer.toHexString(this.toForward.getHeader().xid), serviceLocationException.getMessage()});
                        }
                    }
                }
                catch (SocketException socketException) {
                    if (this.config.traceDrop()) {
                        this.config.writeLog("rh_socket_error", new Object[]{this.clientAddr, new Integer(this.port), this.interfac, socketException.getMessage()});
                    }
                }
                catch (IOException iOException) {
                    if (!this.config.traceDrop()) break block11;
                    this.config.writeLog("rh_ioexception_reply", new Object[]{this.clientAddr, new Integer(this.port), this.interfac, iOException.getMessage()});
                }
            }
            Object var4_7 = null;
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            throw throwable;
        }
    }

    static String stringifyBuffer(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            if (by >= 33 && by < 126) {
                stringBuffer.append((char)by);
            } else {
                stringBuffer.append("\\" + Integer.toHexString(by & 0xFF));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

