/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.AttributePattern;
import com.sun.slp.AttributeString;
import com.sun.slp.Opaque;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

abstract class Parser {
    private static final char NONASCII_LOWER = '\u0080';
    private static final char NONASCII_UPPER = '\uffff';
    static final char EQUAL = '=';
    static final char LESS = '<';
    static final char GREATER = '>';
    private static final char STAR = '*';
    static final char PRESENT = '*';
    private static final char OPAREN = '(';
    private static final char CPAREN = ')';
    private static final char APPROX = '~';
    private static final char NOT = '!';
    private static final char AND = '&';
    private static final char OR = '|';
    private static final char SPACE = ' ';

    Parser() {
    }

    private static boolean mergeQueryReturns(ParserRecord parserRecord, ParserRecord parserRecord2, char c) {
        Hashtable hashtable = parserRecord.services;
        Hashtable hashtable2 = parserRecord2.services;
        boolean bl = c == '&' ? Parser.mergeTablesWithAnd(hashtable, hashtable2) : Parser.mergeTablesWithOr(hashtable, hashtable2);
        Hashtable hashtable3 = parserRecord.signatures;
        Hashtable hashtable4 = parserRecord2.signatures;
        if (c == '&') {
            Parser.mergeTablesWithAnd(hashtable3, hashtable4);
        } else {
            Parser.mergeTablesWithOr(hashtable3, hashtable4);
        }
        return bl;
    }

    private static boolean mergeTablesWithAnd(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (hashtable2.get(k) != null) continue;
            hashtable.remove(k);
        }
        return hashtable.size() > 0;
    }

    private static boolean mergeTablesWithOr(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashtable.put(k, hashtable2.get(k));
        }
        return true;
    }

    static void parseAndEvaluateQuery(String string, QueryEvaluator queryEvaluator, Locale locale, ParserRecord parserRecord) throws ServiceLocationException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(127, 127);
        streamTokenizer.wordChars(0, 32);
        streamTokenizer.ordinaryChar(33);
        streamTokenizer.wordChars(34, 37);
        streamTokenizer.ordinaryChar(38);
        streamTokenizer.wordChars(39, 39);
        streamTokenizer.ordinaryChar(40);
        streamTokenizer.ordinaryChar(41);
        streamTokenizer.ordinaryChar(42);
        streamTokenizer.wordChars(43, 123);
        streamTokenizer.ordinaryChar(124);
        streamTokenizer.wordChars(125, 126);
        streamTokenizer.ordinaryChar(61);
        streamTokenizer.ordinaryChar(60);
        streamTokenizer.ordinaryChar(62);
        streamTokenizer.ordinaryChar(126);
        try {
            ParserRecord parserRecord2 = Parser.parseFilter(streamTokenizer, queryEvaluator, locale, false, true);
            if (streamTokenizer.nextToken() != -1) {
                throw new ServiceLocationException(2, "par_char_closing", new Object[]{string});
            }
            Parser.mergeQueryReturns(parserRecord, parserRecord2, '|');
        }
        catch (IOException iOException) {
            throw new ServiceLocationException(2, "par_syn_err", new Object[]{string});
        }
    }

    private static AttributeString parseAttr(StreamTokenizer streamTokenizer, Locale locale) throws ServiceLocationException, IOException {
        String string = Parser.parsePotentialNonASCII(streamTokenizer);
        string = ServiceLocationAttribute.unescapeAttributeString(string, true);
        return new AttributeString(string, locale);
    }

    private static ParserRecord parseFilter(StreamTokenizer streamTokenizer, QueryEvaluator queryEvaluator, Locale locale, boolean bl, boolean bl2) throws ServiceLocationException, IOException {
        ParserRecord parserRecord = null;
        int n = streamTokenizer.nextToken();
        if (n != 40) {
            throw new ServiceLocationException(2, "par_init_par", new Object[0]);
        }
        n = streamTokenizer.nextToken();
        if (n == 38 || n == 124) {
            parserRecord = Parser.parseFilterlist(streamTokenizer, queryEvaluator, locale, (char)n, bl, bl2);
        } else if (n == 33) {
            parserRecord = Parser.parseFilter(streamTokenizer, queryEvaluator, locale, bl ^ true, bl2);
        } else if (n == -3) {
            streamTokenizer.pushBack();
            parserRecord = Parser.parseItem(streamTokenizer, queryEvaluator, locale, bl, bl2);
        } else {
            streamTokenizer.pushBack();
            parserRecord = Parser.parseItem(streamTokenizer, queryEvaluator, locale, bl, bl2);
        }
        n = streamTokenizer.nextToken();
        if (n != 41) {
            throw new ServiceLocationException(2, "par_final_par", new Object[0]);
        }
        return parserRecord;
    }

    private static ParserRecord parseFilterlist(StreamTokenizer streamTokenizer, QueryEvaluator queryEvaluator, Locale locale, char c, boolean bl, boolean bl2) throws ServiceLocationException, IOException {
        int n;
        ParserRecord parserRecord = null;
        do {
            ParserRecord parserRecord2 = null;
            parserRecord2 = c == '&' ? Parser.parseFilter(streamTokenizer, queryEvaluator, locale, bl, bl2) : Parser.parseFilter(streamTokenizer, queryEvaluator, locale, bl, bl2);
            if (parserRecord == null) {
                parserRecord = parserRecord2;
            } else {
                bl2 = Parser.mergeQueryReturns(parserRecord, parserRecord2, c);
            }
            n = streamTokenizer.nextToken();
            streamTokenizer.pushBack();
        } while (n != 41);
        return parserRecord;
    }

    private static ParserRecord parseItem(StreamTokenizer streamTokenizer, QueryEvaluator queryEvaluator, Locale locale, boolean bl, boolean bl2) throws ServiceLocationException, IOException {
        ParserRecord parserRecord = new ParserRecord();
        AttributeString attributeString = Parser.parseAttr(streamTokenizer, locale);
        char c = Parser.parseOp(streamTokenizer);
        Object object = null;
        if (c == '*') {
            int n = streamTokenizer.nextToken();
            streamTokenizer.pushBack();
            if ((char)n != ')') {
                c = '=';
                object = Parser.parseValue(streamTokenizer, locale);
                object = new AttributePattern(String.valueOf('*') + object.toString(), locale);
            }
        } else {
            object = Parser.parseValue(streamTokenizer, locale);
        }
        if (object instanceof AttributePattern && ((AttributePattern)object).isWildcarded() && c != '=') {
            throw new ServiceLocationException(2, "par_wild_op", new Object[]{new Character(c)});
        }
        if ((object instanceof Boolean || object instanceof Opaque) && (c == '>' || c == '<')) {
            throw new ServiceLocationException(2, "par_bool_op", new Object[]{new Character(c)});
        }
        if ((object == null || object.toString().length() <= 0) && c != '*') {
            throw new ServiceLocationException(2, "par_key_op", new Object[]{new Character(c)});
        }
        if (bl2) {
            queryEvaluator.evaluate(attributeString, c, object, bl, parserRecord);
        }
        return parserRecord;
    }

    private static char parseOp(StreamTokenizer streamTokenizer) throws ServiceLocationException, IOException {
        int n = streamTokenizer.nextToken();
        switch (n) {
            case 61: {
                n = streamTokenizer.nextToken();
                if (n == 42) {
                    return '*';
                }
                streamTokenizer.pushBack();
                return '=';
            }
            case 60: 
            case 62: 
            case 126: {
                if (streamTokenizer.nextToken() != 61) break;
                if (n == 126) {
                    n = 61;
                }
                return (char)n;
            }
        }
        throw new ServiceLocationException(2, "par_comp_op", new Object[0]);
    }

    private static String parsePotentialNonASCII(StreamTokenizer streamTokenizer) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = streamTokenizer.nextToken()) == -3) {
                stringBuffer.append(streamTokenizer.sval);
                continue;
            }
            if ((char)n < '\u0080' || (char)n > '\uffff') break;
            stringBuffer.append((char)n);
        }
        streamTokenizer.pushBack();
        return stringBuffer.toString();
    }

    private static Object parseValue(StreamTokenizer streamTokenizer, Locale locale) throws ServiceLocationException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = streamTokenizer.nextToken()) == 41) {
                streamTokenizer.pushBack();
                Object object = ServiceLocationAttribute.evaluate(stringBuffer.toString().trim());
                if (object instanceof String) {
                    object = new AttributePattern((String)object, locale);
                } else if (object instanceof byte[]) {
                    object = new Opaque((byte[])object);
                }
                return object;
            }
            if (n == -1) break;
            if (n == -3) {
                stringBuffer.append(streamTokenizer.sval);
                continue;
            }
            if (n == -2) {
                Assert.assert(false, "par_ntok", new Object[0]);
                continue;
            }
            stringBuffer.append((char)n);
        }
        throw new ServiceLocationException(2, "par_qend", new Object[0]);
    }

    static final class ParserRecord {
        Hashtable services = new Hashtable();
        Hashtable signatures = new Hashtable();

        ParserRecord() {
        }
    }

    static interface QueryEvaluator {
        public boolean evaluate(AttributeString var1, char var2, Object var3, boolean var4, ParserRecord var5) throws ServiceLocationException;
    }
}

