/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.RequestHandler;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.StreamListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Hashtable;
import java.util.Vector;

class Listener
extends Thread {
    private DatagramSocket dss = null;
    private InetAddress interfac = null;
    private int pktsize = 0;
    private Vector groups = new Vector();
    private static SLPConfig config = null;
    private static Hashtable listeners = new Hashtable();

    private Listener(InetAddress inetAddress) throws ServiceLocationException {
        this.pktsize = config.getMTU();
        this.interfac = inetAddress;
        this.dss = config.getMulticastSocketOnInterface(inetAddress, false);
        listeners.put(inetAddress, this);
        Listener.addListenerToMulticastGroup(inetAddress, SLPConfig.getMulticastAddress());
    }

    static void addListenerToMulticastGroup(InetAddress inetAddress, InetAddress inetAddress2) throws ServiceLocationException {
        block3: {
            Listener listener = (Listener)listeners.get(inetAddress);
            if (listener == null) {
                return;
            }
            DatagramSocket datagramSocket = listener.dss;
            if (!(datagramSocket instanceof MulticastSocket)) break block3;
            MulticastSocket multicastSocket = (MulticastSocket)datagramSocket;
            try {
                multicastSocket.joinGroup(inetAddress2);
                listener.groups.addElement(inetAddress2);
            }
            catch (IOException iOException) {
                new ServiceLocationException(17, "socket_initializtion_failure", new Object[]{inetAddress2, iOException.getMessage()});
            }
        }
    }

    static void initializeInterfaceManagers(InetAddress inetAddress) throws ServiceLocationException {
        if (listeners.get(inetAddress) != null) {
            return;
        }
        if (config == null) {
            config = SLPConfig.getSLPConfig();
        }
        Listener listener = new Listener(inetAddress);
        listener.start();
        StreamListener.initializeStreamListenerOnInterface(inetAddress);
    }

    static DatagramSocket refreshSocketOnInterface(InetAddress inetAddress) {
        Listener listener = (Listener)listeners.get(inetAddress);
        if (listener == null) {
            return config.refreshMulticastSocketOnInterface(inetAddress, null);
        }
        listener.dss.close();
        listener.dss = config.refreshMulticastSocketOnInterface(inetAddress, listener.groups);
        return listener.dss;
    }

    static DatagramSocket returnListenerSocketOnInterface(InetAddress inetAddress) {
        Listener listener = (Listener)listeners.get(inetAddress);
        if (listener != null) {
            return listener.dss;
        }
        return null;
    }

    public void run() {
        boolean bl = true;
        String string = "Multicast";
        if (config.isBroadcastOnly()) {
            string = "Broadcast";
        }
        this.setName("SLP " + string + " Datagram Listener:" + this.dss.getLocalAddress() + "/" + this.dss.getLocalPort());
        while (true) {
            byte[] byArray = new byte[this.pktsize];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, this.pktsize);
            try {
                this.dss.receive(datagramPacket);
                if (config.traceMsg()) {
                    config.writeLog("request_in", new Object[]{datagramPacket.getAddress(), this.interfac});
                }
                RequestHandler requestHandler = new RequestHandler(datagramPacket, this.interfac, config);
                requestHandler.start();
                continue;
            }
            catch (IOException iOException) {
                Assert.assert(bl, "datagram_io_error", new Object[]{this.dss.getLocalAddress(), iOException.getMessage()});
                bl = false;
                config.writeLog("datagram_io_error", new Object[]{this.dss.getLocalAddress(), iOException.getMessage()});
                this.dss.close();
                this.dss = config.refreshMulticastSocketOnInterface(this.interfac, this.groups);
                continue;
            }
            break;
        }
    }
}

