/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.ServiceLocationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

abstract class IANACharCode {
    static final String ASCII = "Default";
    static final String LATIN1 = "latin1";
    static final String UTF8 = "UTF8";
    static final String UNICODE = "Unicode";
    static final String UNICODE_LITTLE = "UnicodeLittle";
    static final String UNICODE_BIG = "UnicodeBig";
    static final String UNICODE_BIG_NO_HDR = "UnicodeBigNoHdr";
    static final short CHARSET_NOT_UNDERSTOOD = 5;
    protected static final int CHAR_ASCII = 3;
    protected static final int CHAR_LATIN1 = 4;
    protected static final int CHAR_UTF8 = 6;
    protected static final int CHAR_UNICODE = 1000;
    protected static final byte[] UNICODE_LITTLE_FLAG = new byte[]{-1, -2};
    protected static final byte[] UNICODE_BIG_FLAG = new byte[]{-2, -1};

    IANACharCode() {
    }

    static byte[] addBigEndianFlag(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = UNICODE_BIG_FLAG[0];
        byArray2[1] = UNICODE_BIG_FLAG[1];
        System.arraycopy(byArray2, 2, byArray, 0, byArray.length);
        return byArray2;
    }

    static String decodeCharacterEncoding(int n) throws ServiceLocationException {
        switch (n) {
            case 3: {
                return ASCII;
            }
            case 4: {
                return LATIN1;
            }
            case 6: {
                return UTF8;
            }
            case 1000: {
                return UNICODE;
            }
        }
        throw new ServiceLocationException(5, "v1_unsupported_encoding", new Object[]{Integer.toString(n)});
    }

    static int encodeCharacterEncoding(String string) throws ServiceLocationException {
        if (string.equals(ASCII)) {
            return 3;
        }
        if (string.equals(LATIN1)) {
            return 4;
        }
        if (string.equals(UTF8)) {
            return 6;
        }
        if (string.equals(UNICODE)) {
            return 1000;
        }
        if (string.equals(UNICODE_BIG)) {
            return 1000;
        }
        if (string.equals(UNICODE_LITTLE)) {
            return 1000;
        }
        if (string.equals(UNICODE_BIG_NO_HDR)) {
            return 1000;
        }
        throw new ServiceLocationException(5, "v1_unsupported_encoding", new Object[]{string});
    }

    static String escapeChar(char c, String string) throws ServiceLocationException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string);
            ((OutputStreamWriter)object).write(c);
            ((OutputStreamWriter)object).flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ServiceLocationException(5, "v1_unsupported_encoding", new Object[]{string});
        }
        catch (IOException iOException) {}
        object = byteArrayOutputStream.toByteArray();
        int n = 0;
        if (string.equals(UNICODE) || string.equals(UNICODE_BIG) || string.equals(UNICODE_LITTLE)) {
            n = object[0] & 0xFF;
            n |= (object[1] & 0xFF) << 8;
            n |= (object[2] & 0xFF) << 16;
            n |= (object[3] & 0xFF) << 24;
            if (((Object)object).length <= 4) {
                throw new ServiceLocationException(2, "v1_charcode_error", new Object[]{new Character(c), string});
            }
        } else if (string.equals(ASCII) || string.equals(LATIN1)) {
            n = object[0] & 0xFF;
            if (((Object)object).length > 1) {
                throw new ServiceLocationException(2, "v1_charcode_error", new Object[]{new Character(c), string});
            }
        } else if (string.equals(UTF8)) {
            if (((Object)object).length > 3) {
                throw new ServiceLocationException(2, "v1_charcode_error", new Object[]{new Character(c), string});
            }
            n = object[0] & 0xFF;
            if (((Object)object).length > 1) {
                n |= (object[1] & 0xFF) << 8;
            }
            if (((Object)object).length > 2) {
                n |= (object[2] & 0xFF) << 16;
            }
        }
        return Integer.toString(n);
    }

    static String getUnicodeEndianess(byte[] byArray) {
        if (byArray.length >= 2) {
            if (byArray[0] == UNICODE_LITTLE_FLAG[0] && byArray[1] == UNICODE_LITTLE_FLAG[1]) {
                return UNICODE_LITTLE;
            }
            if (byArray[0] == UNICODE_BIG_FLAG[0] && byArray[1] == UNICODE_BIG_FLAG[1]) {
                return UNICODE_BIG;
            }
        }
        return UNICODE;
    }

    static String unescapeChar(String string, String string2) throws ServiceLocationException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServiceLocationException(2, "v1_stringcode_error", new Object[]{string, string2});
        }
        String string3 = null;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte[] byArray = null;
        by = (byte)(n & 0xFF);
        by2 = (byte)(n >> 8 & 0xFF);
        by3 = (byte)(n >> 16 & 0xFF);
        by4 = (byte)(n >> 24 & 0xFF);
        if (string2.equals(UNICODE_BIG) || string2.equals(UNICODE_LITTLE)) {
            byArray = new byte[]{by, by2, by3, by4};
        } else if (string2.equals(LATIN1) || string2.equals(ASCII)) {
            byArray = new byte[]{by};
            if (by2 != 0 || by3 != 0) {
                throw new ServiceLocationException(2, "v1_stringcode_error", new Object[]{string, string2});
            }
        } else if (string2.equals(UTF8)) {
            if (by4 != 0) {
                throw new ServiceLocationException(2, "v1_stringcode_error", new Object[]{string, string2});
            }
            if (by3 != 0) {
                byArray = new byte[3];
                byArray[2] = by3;
                byArray[1] = by2;
                byArray[0] = by;
            } else if (by2 != 0) {
                byArray = new byte[2];
                byArray[1] = by2;
                byArray[0] = by;
            } else {
                byArray = new byte[]{by};
            }
        }
        try {
            string3 = new String(byArray, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.assert(false, "v1_unsupported_encoding", new Object[]{string2});
        }
        return string3;
    }
}

