/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Listener;
import com.sun.slp.SDAAdvert;
import com.sun.slp.SLPConfig;
import com.sun.slp.SLPServerHeaderV2;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceTable;
import com.sun.slp.SrvLocHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Hashtable;

class DAAdvertiser
extends Thread {
    protected DatagramSocket dss = null;
    protected InetAddress castAddr = null;
    protected InetAddress interfac = null;
    private static byte[] outbuf = null;
    protected static SLPConfig config = null;
    protected static Hashtable daadv = new Hashtable();
    private Boolean done = new Boolean(false);

    DAAdvertiser() {
        if (config == null) {
            config = SLPConfig.getSLPConfig();
        }
    }

    DAAdvertiser(InetAddress inetAddress, SrvLocHeader srvLocHeader) throws ServiceLocationException {
        if (config == null) {
            config = SLPConfig.getSLPConfig();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        srvLocHeader.externalize(byteArrayOutputStream, true, false);
        outbuf = byteArrayOutputStream.toByteArray();
        this.initializeNetworking(inetAddress, SLPConfig.getMulticastAddress());
    }

    protected byte[] getOutbuf() {
        return outbuf;
    }

    static void initializeDAAdvertiserOnInterface(InetAddress inetAddress) throws ServiceLocationException {
        if (daadv.get(inetAddress) != null) {
            return;
        }
        if (config == null) {
            config = SLPConfig.getSLPConfig();
        }
        ServiceTable serviceTable = ServiceTable.getServiceTable();
        SLPServerHeaderV2 sLPServerHeaderV2 = new SLPServerHeaderV2(8, false, SLPConfig.getLocale());
        SDAAdvert sDAAdvert = (SDAAdvert)serviceTable.makeDAAdvert(sLPServerHeaderV2, inetAddress, (short)0, config.getSAConfiguredScopes(), config);
        DAAdvertiser dAAdvertiser = new DAAdvertiser(inetAddress, sDAAdvert.getHeader());
        dAAdvertiser.start();
    }

    protected void initializeNetworking(InetAddress inetAddress, InetAddress inetAddress2) throws ServiceLocationException {
        this.interfac = inetAddress;
        this.castAddr = inetAddress2;
        this.dss = Listener.returnListenerSocketOnInterface(inetAddress);
        if (this.dss == null) {
            this.dss = config.getMulticastSocketOnInterface(inetAddress, true);
        }
    }

    public void run() {
        this.setName("SLP DA Advertisement");
        long l = config.getAdvertHeartbeatTime() * 1000;
        while (true) {
            this.sendAdvert();
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                Boolean bl = this.done;
                synchronized (bl) {
                    if (this.done.booleanValue()) {
                        Object var4_3 = null;
                        return;
                    }
                }
            }
        }
    }

    void sendAdvert() {
        byte[] byArray = this.getOutbuf();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.castAddr, 427);
        try {
            this.dss.send(datagramPacket);
        }
        catch (IOException iOException) {
            config.writeLog("passive_advert_exception", new Object[]{iOException.getMessage()});
            this.dss = Listener.refreshSocketOnInterface(this.interfac);
        }
    }

    void stopThread() {
        Boolean bl = this.done;
        synchronized (bl) {
            this.done = new Boolean(true);
        }
        this.interrupt();
    }
}

