/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.CDAAdvert;
import com.sun.slp.CSrvMsg;
import com.sun.slp.Defaults;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServerDATable;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.SrvLocMsg;
import com.sun.slp.Transact;
import java.net.InetAddress;
import java.util.Vector;

class ActiveDiscoverer
extends Thread {
    private static SLPConfig config = null;
    private CSrvMsg activeMsg = null;
    private int version = 0;
    private ServerDATable table = null;
    private Vector useScopes = null;
    private InetAddress address = null;

    ActiveDiscoverer(int n, ServerDATable serverDATable, Vector vector, InetAddress inetAddress) {
        this.version = n;
        this.table = serverDATable;
        this.useScopes = vector;
        this.address = inetAddress;
        if (config == null) {
            config = SLPConfig.getSLPConfig();
        }
    }

    private synchronized void activeDiscovery() {
        SrvLocHeader srvLocHeader = this.activeMsg.getHeader();
        srvLocHeader.previousResponders.removeAllElements();
        try {
            Transact.transactActiveAdvertRequest(Defaults.DA_SERVICE_TYPE, this.activeMsg, this.table);
        }
        catch (ServiceLocationException serviceLocationException) {
            config.writeLog("ad_multi_error", new Object[]{new Integer(serviceLocationException.getErrorCode()), serviceLocationException.getMessage()});
        }
    }

    private synchronized void addPreconfiguredDAs() {
        Vector vector = config.getPreconfiguredDAs();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            block8: {
                InetAddress inetAddress = (InetAddress)vector.elementAt(n2);
                SrvLocMsg srvLocMsg = null;
                try {
                    srvLocMsg = Transact.transactTCPMsg(inetAddress, this.activeMsg, false);
                }
                catch (ServiceLocationException serviceLocationException) {
                    if (config.traceDrop()) {
                        config.writeLog("ad_trans_error", new Object[]{new Integer(serviceLocationException.getErrorCode()), inetAddress, serviceLocationException.getMessage()});
                    }
                    break block8;
                }
                if (!(srvLocMsg instanceof CDAAdvert)) {
                    if (config.traceDrop()) {
                        config.writeLog("ad_preconfig_not_advert", new Object[]{inetAddress, srvLocMsg});
                    }
                } else {
                    CDAAdvert cDAAdvert = (CDAAdvert)srvLocMsg;
                    SrvLocHeader srvLocHeader = cDAAdvert.getHeader();
                    if (config.getActiveDiscoveryInterval() <= 0) {
                        cDAAdvert.URL = new ServiceURL(cDAAdvert.URL.toString(), 65535);
                    }
                    config.addPreconfiguredDAScopes(srvLocHeader.scopes);
                    this.table.recordNewDA(cDAAdvert.URL, srvLocHeader.scopes, cDAAdvert.timestamp, srvLocHeader.version, cDAAdvert.attrs, cDAAdvert.spis);
                }
            }
            ++n2;
        }
    }

    public void run() {
        Thread.currentThread().setName("SLP Active DA Discovery");
        long l = config.getActiveDiscoveryInterval() * 1000;
        if (l <= 0L) {
            l = 32767000L;
        }
        if (config.isDA()) {
            Vector vector = config.getInterfaces();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                InetAddress inetAddress = (InetAddress)vector.elementAt(n2);
                ServiceURL serviceURL = new ServiceURL(String.valueOf(String.valueOf(Defaults.DA_SERVICE_TYPE)) + "://" + inetAddress.getHostAddress(), 65535);
                Vector vector2 = config.getSAConfiguredScopes();
                long l2 = 0L;
                String string = System.getProperty("sun.net.slp.SPIs");
                string = string == null ? "" : string;
                this.table.recordNewDA(serviceURL, vector2, l2, this.version, config.getDAAttributes(), string);
                ++n2;
            }
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(l);
                    if (config.getActiveDiscoveryInterval() > 0) {
                        this.activeDiscovery();
                        continue;
                    }
                    this.addPreconfiguredDAs();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void start() {
        long l = config.getRandomWait();
        try {
            this.activeMsg = new CSrvMsg(SLPConfig.getLocale(), Defaults.DA_SERVICE_TYPE, this.useScopes, "");
        }
        catch (ServiceLocationException serviceLocationException) {
            Assert.assert(false, "sdat_active_err", new Object[]{new Integer(serviceLocationException.getErrorCode()), serviceLocationException.getMessage()});
        }
        this.addPreconfiguredDAs();
        if (config.getActiveDiscoveryInterval() > 0) {
            try {
                Thread.currentThread();
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
            this.activeDiscovery();
        } else {
            config.writeLog("ad_active_off", new Object[0]);
        }
        super.start();
    }
}

