/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.util.JarFileHandlerFailedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class SunOSJarFileHandler {
    private static final String[] EXECUTABLES = new String[]{"prepatch", "prePatch", "postpatch", "prebackout", "postbackout", "installpatch", "backoutpatch", "download32", "download64", "download", "install", "install_patch", "t3.sh", "t4.sh"};
    private static final String[] NONPRIV_READABLES = new String[]{"checkinstall", "request", "patch_checkinstall"};
    private static final String[] NOT_CONTENT = new String[]{"META-INF/", ".file_attributes.SunOS", ".file_attributes.linux"};
    PatchProLog log;
    Runtime runtime = Runtime.getRuntime();

    public SunOSJarFileHandler() {
        this.log = PatchProLog.getInstance();
    }

    public void extract(String string, String string2, String string3) throws JarFileHandlerFailedException {
        File file = new File(string + "/" + string3);
        if (!file.exists()) {
            throw new JarFileHandlerFailedException("The specified jar file does not exist.");
        }
        File file2 = new File(string2);
        if (!file2.exists()) {
            file2.mkdir();
        }
        this.log.println(this, 7, "Unjar'ing: " + string + "/" + string3);
        byte[] byArray = new byte[8192];
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(string + "/" + string3, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log.printStackTrace(this, 3, fileNotFoundException);
            throw new JarFileHandlerFailedException("The specified jar file does not exist.");
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 3, iOException);
            throw new JarFileHandlerFailedException("The unjar process terminated with an error.");
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        InputStream inputStream = null;
        while (enumeration.hasMoreElements()) {
            File file3;
            File file4;
            JarEntry jarEntry = enumeration.nextElement();
            String string4 = jarEntry.getName();
            if (this.isContent(string4)) {
                String string5 = string2 + "/" + string4;
                try {
                    file4 = new File(string5);
                    file3 = file4.getParentFile();
                    if (file3 != null && !file3.exists()) {
                        this.mkUsableDirs(file3);
                    }
                    if (!file4.exists()) {
                        file4.createNewFile();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(string5);
                    inputStream = jarFile.getInputStream(jarEntry);
                    int n = 0;
                    while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    inputStream.close();
                    fileOutputStream.close();
                    if (this.isExecutable(string4)) {
                        this.setExecutable(string5);
                    }
                    if (this.isNonprivReadable(string4)) {
                        this.setReadable(string5);
                    }
                }
                catch (IOException iOException) {
                    this.log.printStackTrace(this, 3, iOException);
                    throw new JarFileHandlerFailedException("The unjar process terminated with an error.");
                }
            }
            file3 = null;
            file4 = null;
        }
    }

    private boolean isExecutable(String string) {
        boolean bl = false;
        String string2 = this.getFileName(string);
        if (string.indexOf("/") == string.lastIndexOf("/")) {
            int n = 0;
            while (n < EXECUTABLES.length) {
                if (string2.equals(EXECUTABLES[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean isNonprivReadable(String string) {
        boolean bl = false;
        String string2 = this.getFileName(string);
        int n = 0;
        while (n < NONPRIV_READABLES.length) {
            if (string2.equals(NONPRIV_READABLES[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private boolean isContent(String string) {
        boolean bl = true;
        int n = 0;
        while (n < NOT_CONTENT.length) {
            if (string.indexOf(NOT_CONTENT[n]) == 0) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    private void setExecutable(String string) {
        try {
            Process process = this.runtime.exec("/usr/bin/chmod a+x,ug+r " + string);
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            this.log.println(this, 3, "chmod of " + string + " interrupted.");
        }
        catch (IOException iOException) {
            this.log.println(this, 3, "Unable to chmod " + string);
        }
    }

    private void setReadable(String string) {
        try {
            Process process = this.runtime.exec("/usr/bin/chmod a+r " + string);
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            this.log.println(this, 3, "chmod of " + string + " interrupted.");
        }
        catch (IOException iOException) {
            this.log.println(this, 3, "Unable to chmod " + string);
        }
    }

    private String getFileName(String string) {
        int n = string.lastIndexOf("/") + 1;
        return string.substring(n);
    }

    private void mkUsableDirs(File file) {
        File file2 = new File(file.getPath());
        Vector<File> vector = new Vector<File>();
        while (!file2.exists()) {
            vector.add(file2);
            file2 = file2.getParentFile();
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            File file3 = (File)vector.elementAt(n);
            file3.mkdir();
            this.setExecutable(file3.getPath());
            --n;
        }
    }
}

