/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.util.FailedStateEvent;
import com.sun.patchpro.util.FailedStateException;
import com.sun.patchpro.util.FailedStateListener;
import com.sun.patchpro.util.InvalidStartingStateException;
import com.sun.patchpro.util.MalformedStateException;
import com.sun.patchpro.util.NextStateEvent;
import com.sun.patchpro.util.NextStateListener;
import com.sun.patchpro.util.NoProblemException;
import com.sun.patchpro.util.NoResultException;
import com.sun.patchpro.util.NoSuchStateException;
import com.sun.patchpro.util.State;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Stack;

public abstract class StateMachine
implements NextStateListener,
FailedStateListener {
    public PatchProLog log;
    private boolean stateTableIsValid = false;
    private int intermediateEndState = -1;
    private int currentStateNo = -1;
    private Enumeration nextStateEnumeration = null;
    protected int[] nextStateArray;
    protected State[] stateTable = null;
    private Stack nextStateEvents = new Stack();
    private Stack failedStateEvents = new Stack();
    private boolean running = false;

    public StateMachine() {
        this.log = PatchProLog.getInstance();
    }

    protected State[] buildStateTable() throws MalformedStateException {
        State[] stateArray = new State[]{};
        return stateArray;
    }

    public void initialize() throws MalformedStateException {
        if (!this.stateTableIsValid) {
            this.stateTable = this.buildStateTable();
            this.stateTableIsValid = true;
        }
        int n = 0;
        while (n < this.stateTable.length) {
            this.stateTable[n].initialize();
            ++n;
        }
    }

    private synchronized void setRunning() throws InvalidStartingStateException {
        if (this.running) {
            this.log.println(this, 7, "setRunning(): Failed. Already running.");
            new Exception().printStackTrace();
            throw new InvalidStartingStateException("StateMachine.start(): No start is possible. Machine is running.");
        }
        this.running = true;
        this.log.println(this, 7, "setRunning()");
    }

    private synchronized void setDone() {
        this.running = false;
        this.log.println(this, 7, "setDone()");
    }

    public void start() throws InvalidStartingStateException, MalformedStateException, FailedStateException {
        this.setRunning();
        if (!this.stateTableIsValid) {
            this.stateTable = this.buildStateTable();
            this.stateTableIsValid = true;
        }
        this.initialize();
        try {
            this.start(true, 0);
            Object var2_1 = null;
            this.setDone();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.setDone();
            throw throwable;
        }
    }

    public void start(int n, int n2) throws InvalidStartingStateException, MalformedStateException, FailedStateException {
        this.start(false, n, n2);
    }

    private void start(boolean bl, int n, int n2) throws InvalidStartingStateException, MalformedStateException, FailedStateException {
        if (!bl) {
            this.setRunning();
        }
        if (!this.stateTableIsValid) {
            this.stateTable = this.buildStateTable();
            this.stateTableIsValid = true;
        }
        if (n2 >= this.stateTable.length) {
            throw new MalformedStateException("StateMachine.start(): Specified end state is not in the state table.");
        }
        this.intermediateEndState = n2;
        try {
            this.start(true, n);
            Object var5_4 = null;
            this.intermediateEndState = -1;
            this.setDone();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.intermediateEndState = -1;
            this.setDone();
            throw throwable;
        }
    }

    public void start(int n) throws InvalidStartingStateException, MalformedStateException, FailedStateException {
        this.start(false, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void start(boolean bl, int n) throws InvalidStartingStateException, MalformedStateException, FailedStateException {
        try {
            boolean bl2;
            if (!bl) {
                this.setRunning();
            }
            this.log.println(this, 7, "start(...) w/ start state = " + n + " and end state = " + this.intermediateEndState + ".");
            State state = null;
            boolean bl3 = false;
            if (!this.stateTableIsValid) {
                this.stateTable = this.buildStateTable();
                this.stateTableIsValid = true;
            }
            try {
                bl2 = this.stateTable[n].isEntryPoint();
            }
            catch (Exception exception) {
                throw new MalformedStateException("StateMachine.start(): Specified start state is not in the state table.");
            }
            if (!bl2) {
                throw new InvalidStartingStateException("StateMachine.start(): Invalid starting state.");
            }
            this.nextStateArray = new int[]{n};
            try {
                while (true) {
                    Serializable serializable;
                    State state2;
                    Object object;
                    if (bl3) {
                        this.log.println(this, 7, "StateMachine is officially done.");
                        break;
                    }
                    Thread thread = null;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= this.nextStateArray.length) {
                            this.nextStateArray = new int[0];
                            try {
                                Thread.sleep(150L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            break;
                        }
                        this.currentStateNo = this.nextStateArray[n2];
                        State state3 = this.stateTable[this.currentStateNo];
                        this.log.println(this, 7, "Starting " + this.currentStateNo + " with state state " + state3.getStateState());
                        if (state3.reserveState()) {
                            state3.addNextStateListener(this);
                            state3.addFailedStateListener(this);
                            state3.setStateNumber(this.currentStateNo);
                            thread = new Thread(state3);
                            thread.start();
                            this.log.println(this, 7, "StateMachine: Started state " + this.currentStateNo);
                        } else {
                            if (!state3.isSynchronized()) {
                                this.log.println(this, 4, "StateMachine.run: State " + state3.getStateNumber() + " was invoked a second time but it" + " is not synchronized.");
                                throw new FailedStateException("Reentering unsynchronized state " + state3.getStateNumber());
                            }
                            this.log.println(this, 7, "StateMachine.run: State " + state3.getStateNumber() + " is synchronized.");
                        }
                        ++n2;
                    }
                    if (state != null) {
                        state.setNextStateProcessed(true);
                        state = null;
                    }
                    if (!this.failedStateEvents.empty()) {
                        object = (FailedStateEvent)this.failedStateEvents.pop();
                        state2 = (State)((EventObject)object).getSource();
                        try {
                            try {
                                String string;
                                try {
                                    serializable = state2.getException();
                                    string = ((Throwable)serializable).getMessage();
                                    this.log.printStackTrace(this, 4, (Throwable)serializable);
                                }
                                catch (NoProblemException noProblemException) {
                                    string = state2.getError().getMessage();
                                }
                                this.log.println(this, 4, "StateMachine.run: State " + state2.getStateNumber() + " failed throwing " + string);
                            }
                            catch (NoProblemException noProblemException) {
                                this.log.println(this, 4, "StateMachine.run: State " + state2.getStateNumber() + " failed throwing an exception" + " but no exception was found.");
                                Object var15_22 = null;
                                throw new FailedStateException("Problem detected. Refer to the log for detailed information about the problem.");
                            }
                            Object var15_21 = null;
                            throw new FailedStateException("Problem detected. Refer to the log for detailed information about the problem.");
                        }
                        catch (Throwable throwable) {
                            Object var15_23 = null;
                            throw new FailedStateException("Problem detected. Refer to the log for detailed information about the problem.");
                        }
                    }
                    object = this.nextStateArray;
                    synchronized (object) {
                        this.nextStateArray = new int[0];
                        if (!this.nextStateEvents.empty()) {
                            serializable = (NextStateEvent)this.nextStateEvents.pop();
                            state2 = (State)((EventObject)serializable).getSource();
                            if (!bl3) {
                                if (state2.isTerminal() || state2.getStateNumber() == this.intermediateEndState && state2.getStateState() == 2) {
                                    bl3 = true;
                                    this.log.println(this, 7, "reached the end state.");
                                }
                                try {
                                    this.log.println(this, 7, "reading state " + state2.getStateNumber());
                                    if (!state2.isTerminal()) {
                                        this.log.println(this, 7, "State " + state2.getStateNumber() + " is not terminal.");
                                        this.nextStateArray = state2.getNextState();
                                        state = state2;
                                        this.log.println(this, 7, "nextStates = ");
                                        int n3 = 0;
                                        while (n3 < this.nextStateArray.length) {
                                            this.log.println(this, 7, "  " + this.nextStateArray[n3]);
                                            ++n3;
                                        }
                                    } else {
                                        this.log.println(this, 7, "State " + state2.getStateNumber() + " is terminal.");
                                        this.nextStateArray = new int[0];
                                    }
                                }
                                catch (NoSuchStateException noSuchStateException) {
                                    this.log.printStackTrace(this, 4, noSuchStateException);
                                    this.log.println(this, 4, "StateMachine.run: State " + state2.getStateNumber() + " indicated a next state but" + " could not produce one.");
                                    this.nextStateArray = new int[0];
                                }
                            } else {
                                this.log.println(this, 4, "StateMachine.run: State " + state2.getStateNumber() + " indicated a next state but the" + " terminal state has completed.");
                                this.nextStateArray = new int[0];
                            }
                        }
                    }
                }
            }
            catch (Error error) {
                String string = new String("StateMachine.start(): " + error.getMessage());
                this.log.printStackTrace(this, 4, error);
                throw new FailedStateException(string);
            }
            Object var18_25 = null;
            if (bl) return;
            this.setDone();
            return;
        }
        catch (Throwable throwable) {
            Object var18_26 = null;
            if (bl) throw throwable;
            this.setDone();
            throw throwable;
        }
    }

    public Object getActionResult(int n) throws NoSuchStateException, NoResultException {
        if (n > this.stateTable.length) {
            throw new NoSuchStateException("No such state.");
        }
        return this.stateTable[n].getActionResult();
    }

    public boolean isNextStateProcessed(int n) throws NoSuchStateException {
        if (n > this.stateTable.length) {
            throw new NoSuchStateException("No such state.");
        }
        return this.stateTable[n].isNextStateProcessed();
    }

    public synchronized boolean allDone(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            try {
                if (!this.isNextStateProcessed(nArray[n])) {
                    return false;
                }
            }
            catch (NoSuchStateException noSuchStateException) {
                this.log.println(this, 4, "StateMachine.allDone: State " + nArray[n] + " doesn't exist.");
            }
            ++n;
        }
        return true;
    }

    public int getStateResult(int n) throws NoSuchStateException {
        if (n > this.stateTable.length) {
            throw new NoSuchStateException("No such state.");
        }
        return this.stateTable[n].getStateState();
    }

    public synchronized void processNextState(NextStateEvent nextStateEvent) {
        this.nextStateEvents.push(nextStateEvent);
        ((State)nextStateEvent.getSource()).removeFailedStateListener(this);
        ((State)nextStateEvent.getSource()).removeNextStateListener(this);
    }

    public synchronized void processFailedState(FailedStateEvent failedStateEvent) {
        this.failedStateEvents.push(failedStateEvent);
        ((State)failedStateEvent.getSource()).removeFailedStateListener(this);
        ((State)failedStateEvent.getSource()).removeNextStateListener(this);
    }
}

