/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.model.InstallPatchEvent;
import com.sun.patchpro.model.InstallPatchListener;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.util.NoResultException;
import com.sun.patchpro.util.PatchBundleInstaller;
import com.sun.patchpro.util.Percentage;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class GroupPatchBundleInstaller
implements InstallPatchListener {
    public static boolean nowInstalling = false;
    private int hostCount = 1;
    private int hostsRemaining = 1;
    private Percentage progress = new Percentage(0);
    private Vector listeners;
    private PatchProLog log;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private PatchProProperties associateProperties;
    private PatchBundleInstaller patchInstaller;
    private PatchList patchesToInstall;
    private File installDirectory;
    private File backoutDirectory;
    private Enumeration associateHosts;
    private Host primaryHost;
    private Host associateHost;
    private PatchPro model;
    private boolean debug = false;

    public GroupPatchBundleInstaller(PatchPro patchPro) {
        this.log = PatchProLog.getInstance();
        this.listeners = new Vector();
        this.model = patchPro;
        this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
    }

    public void install(Host host) throws InstallFailedException {
        if (nowInstalling) {
            throw new InstallFailedException("Already Running");
        }
        nowInstalling = true;
        this.hostCount = this.hostsRemaining = host.getAssociateCount() + 1;
        try {
            try {
                if (!host.getSessionData().getIgnoreStatus()) {
                    try {
                        this.patchesToInstall = host.getSessionData().getPatchesRequired();
                    }
                    catch (NoResultException noResultException) {
                        this.patchesToInstall = null;
                    }
                    this.installDirectory = new File(this.properties.getProperty("patchpro.patch.install.directory"));
                    this.backoutDirectory = new File(this.properties.getProperty("patchpro.patch.backout.directory"));
                    if (this.debug) {
                        this.log.println(this, 7, "# of patches to Install is " + this.patchesToInstall.size());
                        this.log.println(this, 7, "installDirectory is " + this.installDirectory);
                        this.log.println(this, 7, "backoutDirectory is " + this.backoutDirectory);
                    }
                    this.patchInstaller = new PatchBundleInstaller();
                    this.patchInstaller.addListener(this);
                    this.patchInstaller.initialize(host);
                    this.patchInstaller.install(host, this.patchesToInstall, this.installDirectory, this.backoutDirectory, this.model);
                    this.patchInstaller.removeListener(this);
                }
                this.associateHosts = host.getAssociates();
                while (this.associateHosts.hasMoreElements()) {
                    this.associateHost = (Host)this.associateHosts.nextElement();
                    this.patchesToInstall = null;
                    if (this.associateHost.getSessionData().getIgnoreStatus()) continue;
                    try {
                        this.patchesToInstall = this.associateHost.getSessionData().getPatchesRequired();
                    }
                    catch (NoResultException noResultException) {
                        // empty catch block
                    }
                    this.properties = this.properties.getHostSpecificProperties(this.associateHost);
                    this.installDirectory = new File(this.properties.getProperty("patchpro.patch.install.directory", "/var/spool/pkg/patchpro"));
                    this.backoutDirectory = new File(this.properties.getProperty("patchpro.patch.backout.directory"));
                    this.patchInstaller = new PatchBundleInstaller();
                    this.patchInstaller.addListener(this);
                    this.patchInstaller.initialize(this.associateHost);
                    this.patchInstaller.install(host, this.associateHost, this.patchesToInstall, this.installDirectory, this.backoutDirectory, this.model);
                    this.patchInstaller.removeListener(this);
                }
            }
            catch (Exception exception) {
                this.log.println(this, 2, "GroupPatchBundleInstaller: Internal error. Unknown Error");
                this.log.printStackTrace(this, 2, exception);
                nowInstalling = false;
                throw new InstallFailedException(exception.getMessage());
            }
            Object var4_6 = null;
            this.patchInstaller.removeListener(this);
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.patchInstaller.removeListener(this);
            throw throwable;
        }
        nowInstalling = false;
    }

    public Percentage percentComplete() {
        return this.progress;
    }

    public void addListener(InstallPatchListener installPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(installPatchListener);
        }
    }

    public void removeListener(InstallPatchListener installPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(installPatchListener);
        }
    }

    public void installPatchProgress(InstallPatchEvent installPatchEvent) {
        int n = installPatchEvent == null ? 100 : ((PatchBundleInstaller)installPatchEvent.getSource()).installProgress().getPercentage();
        Percentage percentage = this.progress;
        synchronized (percentage) {
            this.progress = new Percentage((int)(((double)(this.hostCount - this.hostsRemaining) * 100.0 + (double)n) / (double)this.hostCount));
        }
        this.dispatchProgressEvent(new InstallPatchEvent(this));
    }

    public void installPatchDone(InstallPatchEvent installPatchEvent) {
        if (--this.hostsRemaining == 0) {
            this.dispatchDoneEvent(new InstallPatchEvent(this));
        }
    }

    public void installPatchFailed(InstallPatchEvent installPatchEvent) {
        this.dispatchFailedEvent(installPatchEvent);
    }

    private void dispatchProgressEvent(InstallPatchEvent installPatchEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            InstallPatchListener installPatchListener = (InstallPatchListener)enumeration.nextElement();
            installPatchListener.installPatchProgress(installPatchEvent);
        }
    }

    private void dispatchDoneEvent(InstallPatchEvent installPatchEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            InstallPatchListener installPatchListener = (InstallPatchListener)enumeration.nextElement();
            installPatchListener.installPatchDone(installPatchEvent);
        }
    }

    private void dispatchFailedEvent(InstallPatchEvent installPatchEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            InstallPatchListener installPatchListener = (InstallPatchListener)enumeration.nextElement();
            installPatchListener.installPatchFailed(installPatchEvent);
        }
    }
}

