/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.BadHttpResponseException;
import com.sun.patchpro.model.DownloadPatchEvent;
import com.sun.patchpro.model.DownloadPatchListener;
import com.sun.patchpro.model.InvalidPatchDownloadDirectoryException;
import com.sun.patchpro.model.PatchDownloadDirectoryAccessException;
import com.sun.patchpro.model.PatchDownloadIOException;
import com.sun.patchpro.model.PatchDownloadResponseException;
import com.sun.patchpro.model.PatchNotAvailableException;
import com.sun.patchpro.model.PatchNotFoundException;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.PatchSignatureValidationException;
import com.sun.patchpro.model.ServerConnectionException;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchBundleInfo;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.security.ManifestFileNotFoundException;
import com.sun.patchpro.security.NoKeystorePresentException;
import com.sun.patchpro.security.NoSigningCertException;
import com.sun.patchpro.security.NotSignedByKnownCertificateException;
import com.sun.patchpro.security.SignatureCheckFailedException;
import com.sun.patchpro.security.SignatureValidationException;
import com.sun.patchpro.security.SignatureValidationUtil;
import com.sun.patchpro.server.DownloadPatchDBException;
import com.sun.patchpro.server.DownloadPatchException;
import com.sun.patchpro.server.DownloadRealizationException;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServiceProvider;
import com.sun.patchpro.server.PatchServiceUtil;
import com.sun.patchpro.server.ServerPatchServiceProviderException;
import com.sun.patchpro.util.Downloader;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.NoResultException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class ServerPatchServiceProvider
implements PatchServiceProvider {
    private LocalizedMessages msgcat;
    PatchInfoImpl genPatchInfo = null;
    boolean downloadAuthenticate = true;
    PatchProProperties properties = PatchProProperties.getInstance();
    PatchProLog log = PatchProLog.getInstance();
    SignatureValidationUtil validationUtil;
    String keystoreLocation;
    String patchBundlePrefix = "";
    String serverURLString;
    String[] signingCertAliasArray;
    String signingCertAlias;
    String sunSolvePasswd = "";
    String sunSolveUser = "";
    String targetLocation;
    URL serverURL;
    Vector listeners = new Vector();
    boolean smpatch = false;
    boolean updateSessionData = true;
    static final int SEGMENTED_PATCHLIST_SIZE = 10;
    static final String AUTHENTICATION_FAILED = "ServicePatchServiceProvider.AUTHENTICATION_FAILED";
    static final String DOWNLOAD_DIR_NOT_EXIST = "Patch download directory does not exist.";
    static final String DOWNLOAD_DIR_NOT_WRITABLE = "Patch download directory is not writable.";
    static final String FAILED_TO_CREATE_DOWNLOADER = "Failed to create a downloader to download patches.";
    static final String FAILED_TO_CREATE_VALIDATION_UTIL = "Failed to create the signature valiation utility.";
    public static final String FAILED_TO_VALIDATE_SIGNATURE = "Failed to validate the digital signature(s).";
    static final String HTTP_PARTIAL_CONTENT = "Status code 206 returned.  The client's request was only partially fulfilled.";
    static final String HTTP_BAD_REQUEST = "Status code 400 returned. The server could not understand the request, probably due to a syntax error in the HTTP request.";
    static final String HTTP_UNAUTHORIZED = "Status code 401 returned. The request lacked proper authorization.";
    static final String HTTP_FORBIDDEN = "Status code 403 returned. The request was understood, but the server is not willing to fulfill it.";
    static final String HTTP_NOT_FOUND = "Status code 404 returned. The requested resource was not found or is not available.";
    static final String HTTP_INTERNAL_SERVER_ERROR = "Status code 500 returned. An unexpected error occurred inside the server that prevented it from fulfilling the request.";
    static final String HTTP_NOT_IMPLEMENTED = "Status code 501 returned. The server does not support the functionality needed to fulfill the request.";
    static final String HTTP_UNKNOWN_ERROR = "Unknown HTTP status code returned.";
    static final String PATCH_NOT_FOUND = "Patch cannot be found by server.";
    static final String PATCH_NOT_ON_DISK = "Patch could not be found locally.";
    static final String INCORRECT_URL = "Incorrect downloading URL specified.";
    static final String INVALID_DESTINATION_TYPE = "Download destination is not a String object that indicates  the download location.";
    static final String INVALID_FILE_PERMISSION = "The write permission is not set.";
    static final String INVALID_PATCH_BUNDLE_FILE_NAME = "Invalid patch bundle file name.";
    static final String KEYSTORE_LOCATION_NOT_SPECIFIED = "patchpro.security.kslocation is not specified.";
    static final String NOT_ABLE_TO_DETERMINE_SIGNING_CERT_SN = "Cannot determine signing certificate serial number.";
    static final String PATCH_DOWNLOAD_DONE = "Patch download is done.";
    static final String SERVER_NOT_SSL_ENABLED = "This server is not SSL-enabled. ";
    static final String SERVER_SSL_ENABLED = "This server is SSL-enabled. ";
    static final String SERVER_NOT_SPECIFIED = "patchpro.patch.server.url is not specified.";
    static final String SIGNING_CERT_REVOKED = "Signing certificate has been revoked.";
    static final String UNKNOWN_CONTENT_TYPE = "Unknown content-type returned from the server.";
    static final String EMPTY_PATCH_LIST = "Empty Patch List.";

    public ServerPatchServiceProvider() throws ServerPatchServiceProviderException {
        this.configure(this.properties);
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        this.downloadAuthenticate = this.properties.downloadAuthenticationRequired();
        if (this.downloadAuthenticate) {
            try {
                this.validationUtil = SignatureValidationUtil.getValidationUtility(this.properties, this.validationUtil);
                this.keystoreLocation = this.validationUtil.getKeystoreLocation();
                this.signingCertAliasArray = this.validationUtil.getCertificateAliases();
            }
            catch (NoKeystorePresentException noKeystorePresentException) {
                String string = "Failed to create the signature valiation utility. " + noKeystorePresentException.getMessage();
                this.log.printStackTrace(this, 2, noKeystorePresentException);
                this.log.println(this, 3, string);
                this.dispatchFailedEvent(PatchProLog.createMessage(2, FAILED_TO_CREATE_VALIDATION_UTIL));
                throw new ServerPatchServiceProviderException(2);
            }
            catch (NoSigningCertException noSigningCertException) {
                String string = "Failed to create the signature valiation utility. " + noSigningCertException.getMessage();
                this.log.printStackTrace(this, 2, noSigningCertException);
                this.log.println(this, 3, string);
                this.dispatchFailedEvent(PatchProLog.createMessage(2, FAILED_TO_CREATE_VALIDATION_UTIL));
                throw new ServerPatchServiceProviderException(2);
            }
        }
        this.serverURLString = this.properties.getProperty("patchpro.patch.server.url");
        this.log.println(this, 7, "serverURLString: " + this.serverURLString);
        if (this.serverURLString == null) {
            this.log.println(this, 2, SERVER_NOT_SPECIFIED);
            throw new ServerPatchServiceProviderException(3);
        }
        this.serverURL = null;
        if (!this.downloadAuthenticate) {
            try {
                this.serverURL = new URL("file:" + File.separator);
            }
            catch (MalformedURLException malformedURLException) {
                this.log.printStackTrace(this, 2, malformedURLException);
            }
        } else {
            if (this.serverURLString.indexOf("https") == 0) {
                this.log.println(this, 7, "This server is SSL-enabled.  " + this.serverURLString);
            } else if (this.serverURLString.indexOf("http") == 0) {
                this.log.println(this, 7, "This server is not SSL-enabled.  " + this.serverURLString);
            }
            try {
                this.serverURL = new URL(this.serverURLString);
            }
            catch (MalformedURLException malformedURLException) {
                this.log.printStackTrace(this, 2, malformedURLException);
                throw new ServerPatchServiceProviderException(8);
            }
        }
        this.genPatchInfo = new PatchInfoImpl();
        this.genPatchInfo.setProperties(new PatchProperties(""));
    }

    public String getPatchBundlePrefix() {
        return this.patchBundlePrefix;
    }

    public void addDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(downloadPatchListener);
        }
    }

    public void removeDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(downloadPatchListener);
        }
    }

    public void configure(PatchProProperties patchProProperties) {
        this.sunSolveUser = patchProProperties.getProperty("patchpro.sunsolve.identity", "");
        this.sunSolvePasswd = patchProProperties.getProperty("patchpro.sunsolve.passwd", "");
        this.log.println(this, 7, "SunSolve user: " + this.sunSolveUser + "\tpasswd: " + this.sunSolvePasswd);
    }

    public void downloadPatchDB() throws DownloadPatchDBException, NotSupportedException {
    }

    public void downloadRealizationDetectors() throws DownloadRealizationException, NotSupportedException {
    }

    public PatchBundleInfo[] getDownloadedPatchBundlesInfo(PatchList patchList) {
        PatchBundleInfo[] patchBundleInfoArray = new PatchBundleInfo[patchList.size()];
        int n = 0;
        while (n < patchList.size()) {
            block3: {
                Patch patch;
                try {
                    patch = patchList.getPatchAt(n);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                    break block3;
                }
                String string = patch.getPatchID().getPatchID();
                patchBundleInfoArray[n] = new PatchBundleInfo(string, string + ".jar", 0L);
            }
            ++n;
        }
        return patchBundleInfoArray;
    }

    public Object getDownloadDestination() {
        return this.getPatchBundlePrefix();
    }

    public boolean isCertificateRevoked(String string) throws NotSupportedException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("action=isCertificateRevoked");
        stringBuffer2.append("&serialNumber=").append(URLEncoder.encode(string));
        this.log.println(this, 7, "CRL checking post string: " + stringBuffer2);
        URLConnection uRLConnection = null;
        try {
            uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoOutput(true);
            PrintWriter printWriter = new PrintWriter(uRLConnection.getOutputStream());
            printWriter.print(stringBuffer2);
            printWriter.close();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
            return true;
        }
        int n = -1;
        try {
            n = ((HttpURLConnection)uRLConnection).getResponseCode();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
        }
        if (n != 200) {
            String string2 = this.httpResponseCode2Str(n);
            this.log.println(this, 2, string2);
            return true;
        }
        int n2 = uRLConnection.getHeaderFieldInt("patchproServiceCompletionCode", 200);
        return n2 == 200;
    }

    public void downloadPatches(PatchList patchList, Object object) throws DownloadPatchException, NotSupportedException {
        this.updateSessionData = false;
        this.downloadPatches(patchList, object, null);
    }

    public void downloadPatches(PatchList patchList, Object object, SessionData sessionData) throws DownloadPatchException, NotSupportedException {
        Object object2;
        if (patchList == null || patchList.size() <= 0) {
            this.dispatchDoneEvent(PatchProLog.createMessage(5, EMPTY_PATCH_LIST));
            this.log.println(this, 3, EMPTY_PATCH_LIST);
            return;
        }
        this.properties = sessionData != null ? sessionData.getProperties() : PatchProProperties.getInstance();
        boolean bl = false;
        if (this.connectingServer()) {
            this.log.println(this, 7, "Network connected.");
            int n = 0;
            while (n < this.signingCertAliasArray.length) {
                this.signingCertAlias = this.signingCertAliasArray[n];
                object2 = this.getCertSerialNumber(this.keystoreLocation, this.signingCertAlias);
                if (object2 == null) {
                    throw new DownloadPatchException(5);
                }
                try {
                    if (this.isCertificateRevoked((String)object2)) {
                        this.log.println(this, 2, "Signing certificate has been revoked.: " + (String)object2);
                        throw new DownloadPatchException(6);
                    }
                }
                catch (NotSupportedException notSupportedException) {
                    this.log.printStackTrace(this, 2, notSupportedException);
                    throw notSupportedException;
                }
                ++n;
            }
            bl = true;
        } else {
            this.log.println(this, 7, "Network not connected.");
            System.out.println("... " + this.msgcat.getMessage("using_local_data", "Trying to use local data to service request.") + "\n");
        }
        String string = null;
        if (!(object instanceof String)) {
            this.dispatchFailedEvent(PatchProLog.createMessage(2, INVALID_DESTINATION_TYPE));
            this.log.println(this, 2, INVALID_DESTINATION_TYPE);
            if (this.updateSessionData) {
                object2 = new InvalidPatchDownloadDirectoryException("InvalidPatchDownloadDirectoryException", "InvalidPatchDownloadDirectoryException.MESSAGE", "InvalidPatchDownloadDirectoryException.REMEDY", 2);
                sessionData.addPatchProException((PatchProException)object2);
            }
            throw new DownloadPatchException(INVALID_DESTINATION_TYPE);
        }
        string = (String)object;
        if (string.indexOf("%") != -1) {
            this.setPatchBundlePrefix(PatchServiceUtil.generateTimeStampedString(string) + File.separator);
        } else {
            this.setPatchBundlePrefix(string + File.separator);
        }
        if (bl) {
            this.log.println(this, 7, "Invoking performDownloadPatches.");
            this.performDownloadPatches(patchList, sessionData);
        } else {
            this.log.println(this, 7, "Invoking performValidationOnDownloadedPatches.");
            this.performValidationOnDownloadedPatches(patchList, sessionData);
        }
    }

    private void setPatchBundlePrefix(String string) {
        this.patchBundlePrefix = string;
    }

    private String httpResponseCode2Str(int n) {
        String string = "";
        switch (n) {
            case 206: {
                string = HTTP_PARTIAL_CONTENT;
                break;
            }
            case 400: {
                string = HTTP_BAD_REQUEST;
                break;
            }
            case 401: {
                string = HTTP_UNAUTHORIZED;
                break;
            }
            case 403: {
                string = HTTP_FORBIDDEN;
                break;
            }
            case 404: {
                string = HTTP_NOT_FOUND;
                break;
            }
            case 500: {
                string = HTTP_INTERNAL_SERVER_ERROR;
                break;
            }
            case 501: {
                string = HTTP_NOT_IMPLEMENTED;
                break;
            }
            default: {
                string = HTTP_UNKNOWN_ERROR;
            }
        }
        return string;
    }

    private void performDownloadPatches(PatchList patchList, SessionData sessionData) throws DownloadPatchException, NotSupportedException {
        File file = new File(this.getPatchBundlePrefix());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.canWrite()) {
            this.dispatchFailedEvent(PatchProLog.createMessage(2, DOWNLOAD_DIR_NOT_WRITABLE));
            this.log.println(this, 2, DOWNLOAD_DIR_NOT_WRITABLE);
            if (this.updateSessionData) {
                PatchDownloadDirectoryAccessException patchDownloadDirectoryAccessException = new PatchDownloadDirectoryAccessException("PatchDownloadDirectoryAccessException", "PatchDownloadDirectoryAccessException.MESSAGE", "PatchDownloadDirectoryAccessException.REMEDY", 2);
                sessionData.addPatchProException(patchDownloadDirectoryAccessException);
            }
            throw new DownloadPatchException(DOWNLOAD_DIR_NOT_WRITABLE);
        }
        int n = patchList.size();
        Vector<PatchListImpl> vector = new Vector<PatchListImpl>();
        PatchListImpl patchListImpl = new PatchListImpl();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            try {
                IPatch iPatch = new IPatch(patchList.getPatchAt(n3));
                if (new File(file, iPatch.getPatchID().getPatchID() + ".jar").exists()) {
                    if (this.updateSessionData) {
                        sessionData.addPatchAlreadyPresent(iPatch);
                    }
                } else {
                    patchListImpl.addIPatch(iPatch);
                    patchListImpl.setSelectionStatus(n2, patchList.getSelectionStatus(n3));
                    ++n2;
                }
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 3, noSuchPatchException);
            }
            if ((n3 + 1) % 10 == 0 && patchListImpl.size() != 0) {
                vector.addElement(patchListImpl);
                patchListImpl = new PatchListImpl();
                n2 = 0;
            }
            ++n3;
        }
        if (n % 10 != 0 && patchListImpl.size() != 0) {
            vector.addElement(patchListImpl);
        }
        int n4 = 0;
        while (n4 < vector.size()) {
            try {
                this.requestDownload((PatchList)vector.elementAt(n4), sessionData);
            }
            catch (DownloadPatchException downloadPatchException) {
                this.log.printStackTrace(this, 4, downloadPatchException);
            }
            ++n4;
        }
        this.dispatchDoneEvent(PatchProLog.createMessage(7, PATCH_DOWNLOAD_DONE));
        if (this.updateSessionData) {
            this.createDownloadSummaryFile(sessionData, patchList, this.getPatchBundlePrefix());
        }
    }

    private void performValidationOnDownloadedPatches(PatchList patchList, SessionData sessionData) throws DownloadPatchException, NotSupportedException {
        this.smpatch = this.properties.getProperty("smpatch.request", "false").equals("true");
        File file = new File(this.getPatchBundlePrefix());
        if (!file.exists()) {
            this.log.println(this, 2, DOWNLOAD_DIR_NOT_EXIST);
            if (this.updateSessionData) {
                PatchDownloadDirectoryAccessException patchDownloadDirectoryAccessException = new PatchDownloadDirectoryAccessException("PatchDownloadDirectoryAccessException", "PatchDownloadDirectoryAccessException.MESSAGE", "PatchDownloadDirectoryAccessException.REMEDY", 2);
                sessionData.addPatchProException(patchDownloadDirectoryAccessException);
            }
            throw new DownloadPatchException(DOWNLOAD_DIR_NOT_EXIST);
        }
        int n = patchList.size();
        boolean bl = false;
        String string = "";
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            block24: {
                Serializable serializable;
                IPatch iPatch;
                Patch patch;
                try {
                    Patch patch2 = patchList.getPatchAt(n2);
                    string = patch2.getPatchID().getPatchID();
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 3, noSuchPatchException);
                    break block24;
                }
                string2 = this.getPatchBundlePrefix() + File.separator + string + ".jar";
                if (!new File(string2).exists()) {
                    try {
                        patch = patchList.getPatchByPatchID(new PatchID(string));
                        iPatch = new IPatch(patch);
                        iPatch.setError(PATCH_NOT_ON_DISK);
                        if (this.updateSessionData) {
                            sessionData.addPatchUnavailable(iPatch);
                        }
                        this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the problem list. ErrString: " + PATCH_NOT_ON_DISK);
                        if (this.updateSessionData) {
                            serializable = this.smpatch ? new PatchNotAvailableException("PatchNotAvailableException", "PatchNotAvailableException.SMPATCH_MESSAGE", "PatchNotAvailableException.SMPATCH_REMEDY", 3) : new PatchNotAvailableException("PatchNotAvailableException", "PatchNotAvailableException.MESSAGE", "PatchNotAvailableException.REMEDY", 3);
                            sessionData.addPatchProException((PatchProException)serializable);
                        }
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        this.log.println(this, 2, "There exists no patch failing signaturevalidation");
                        this.log.printStackTrace(this, 3, noSuchPatchException);
                    }
                    catch (MalformedPatchException malformedPatchException) {
                        this.log.println(this, 4, "PatchProModel.evaluatePatchListExpression(): Malformed patch ID on applied Patch. " + malformedPatchException.getMessage());
                        this.log.printStackTrace(this, 3, malformedPatchException);
                    }
                } else {
                    bl = false;
                    if (this.downloadAuthenticate) {
                        bl = this.validatePatchBundle(string2);
                        this.log.println(this, 7, "Validation of local patch " + string2 + " is done");
                    }
                    if (bl) {
                        if (this.updateSessionData) {
                            try {
                                serializable = new PatchID(string);
                                PatchImpl patchImpl = new PatchImpl(this.genPatchInfo, (PatchID)serializable);
                                sessionData.addPatchAlreadyPresent(patchImpl);
                            }
                            catch (Exception exception) {
                                this.log.printStackTrace(this, 3, exception);
                            }
                        }
                        this.log.println(this, 7, "The patch " + string2 + " has been validated");
                    } else {
                        try {
                            patch = patchList.getPatchByPatchID(new PatchID(string));
                            iPatch = new IPatch(patch);
                            iPatch.setError(FAILED_TO_VALIDATE_SIGNATURE);
                            if (this.updateSessionData) {
                                sessionData.addPatchCorruptOnDownload(iPatch);
                            }
                            this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the list. ErrString: " + FAILED_TO_VALIDATE_SIGNATURE);
                            if (this.updateSessionData) {
                                serializable = this.smpatch ? new PatchSignatureValidationException("PatchSignatureValidationException", "PatchSignatureValidationException.SMPATCH_MESSAGE", "PatchSignatureValidationException.SMPATCH_REMEDY", 2) : new PatchSignatureValidationException("PatchSignatureValidationException", "PatchSignatureValidationException.MESSAGE", "PatchSignatureValidationException.REMEDY", 2);
                                sessionData.addPatchProException((PatchProException)serializable);
                            }
                        }
                        catch (NoSuchPatchException noSuchPatchException) {
                            this.log.println(this, 2, "There exists no patch failing signaturevalidation");
                            this.log.printStackTrace(this, 3, noSuchPatchException);
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println(this, 4, "PatchProModel.evaluatePatchListExpression(): Malformed patch ID on applied Patch. " + malformedPatchException.getMessage());
                            this.log.printStackTrace(this, 3, malformedPatchException);
                        }
                    }
                }
            }
            ++n2;
        }
        this.dispatchDoneEvent(PatchProLog.createMessage(7, PATCH_DOWNLOAD_DONE));
        if (this.updateSessionData) {
            this.createDownloadSummaryFile(sessionData, patchList, file.getPath());
        }
    }

    private void requestDownload(PatchList patchList, SessionData sessionData) throws DownloadPatchException, NotSupportedException {
        Object object;
        Serializable serializable;
        Object object2;
        int n;
        Object object3;
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("action=patchDownload&version=2.1");
        Patch patch = null;
        int n2 = patchList.size();
        int n3 = 0;
        while (n3 < n2) {
            try {
                if (patchList.getSelectionStatus(n3)) {
                    patch = patchList.getPatchAt(n3);
                    String string3 = patch.getPatchID().getPatchID();
                    this.log.println(this, 7, "Adding " + string3 + " to the POST list...");
                    stringBuffer.append(string3).append(" ");
                    stringBuffer2.append('&');
                    stringBuffer2.append("patchId=").append(URLEncoder.encode(string3));
                }
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
            }
            ++n3;
        }
        this.log.println(this, 7, "Post String: " + stringBuffer2);
        int n4 = -1;
        Downloader downloader = null;
        try {
            downloader = this.sendPatchDownloadPostRequest(this.serverURL, stringBuffer2.toString(), this.sunSolveUser, this.sunSolvePasswd, sessionData);
            n4 = downloader.getResponseCode();
        }
        catch (DownloadPatchException downloadPatchException) {
            if (downloadPatchException.getReasonCode() == 4) {
                n4 = 500;
            }
            if (this.updateSessionData) {
                sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
            }
            throw downloadPatchException;
        }
        if (n4 == 401) {
            this.dispatchFailedEvent(PatchProLog.createMessage(4, this.msgcat.getMessage(AUTHENTICATION_FAILED, "The patch server failed to authenticate the request based on the current SunSolve user/password setting. Only public (non-contract) patches will be downloaded.")));
            this.log.println(this, 4, "Current SunSolve credential setting caused 401 response.");
            n4 = -1;
            try {
                downloader = this.sendPatchDownloadPostRequest(this.serverURL, stringBuffer2.toString(), "", "", sessionData);
                n4 = downloader.getResponseCode();
            }
            catch (DownloadPatchException downloadPatchException) {
                if (downloadPatchException.getReasonCode() == 4) {
                    n4 = 500;
                }
                if (this.updateSessionData) {
                    sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
                }
                throw downloadPatchException;
            }
        }
        this.log.println(this, 7, "HTTP response code: " + n4);
        if (n4 != 200 && n4 != 206) {
            string2 = this.httpResponseCode2Str(n4);
            this.log.println(this, 4, string2);
            if (this.updateSessionData) {
                BadHttpResponseException badHttpResponseException = new BadHttpResponseException("BadHttpResponseException", BadHttpResponseException.getBadHttpResponseExceptionMessage(n4), BadHttpResponseException.getBadHttpResponseExceptionRemedy(n4), 2);
                sessionData.addPatchProException(badHttpResponseException);
                sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
            }
            throw new DownloadPatchException(string2);
        }
        string2 = downloader.getHeaderField("patchFiles");
        String string4 = downloader.getHeaderField("rejects");
        String string5 = downloader.getHeaderField("requiredSize");
        this.log.println(this, 7, "Patches returned: " + string2);
        this.log.println(this, 7, "Patches rejected: " + string4);
        this.log.println(this, 7, "Patches required sizes: " + string5);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(downloader);
        if (string2 == null) {
            this.log.println(this, 4, "patchFiles is null.");
            string2 = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        int n5 = stringTokenizer.countTokens();
        String[] stringArray = new String[n5];
        String[] stringArray2 = new String[n5];
        String[] stringArray3 = new String[n5];
        int[] nArray = new int[n5];
        String string6 = null;
        StringTokenizer stringTokenizer2 = null;
        int n6 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            stringTokenizer2 = new StringTokenizer(string6, "&");
            string = stringTokenizer2.nextToken();
            stringArray[n6] = string.substring(0, string.indexOf(".jar"));
            stringArray2[n6] = this.patchBundlePrefix + string;
            stringArray3[n6] = string;
            nArray[n6] = Integer.parseInt(stringTokenizer2.nextToken());
            ++n6;
        }
        stringTokenizer2 = null;
        stringTokenizer = null;
        string = null;
        string6 = null;
        this.log.println(this, 7, "Number of patches returned: " + n5);
        n6 = 0;
        while (n6 < n5) {
            this.log.println(this, 7, "PatchID: " + stringArray2[n6] + "\tSize: " + nArray[n6]);
            this.log.println(this, 7, "The patch returned by server is PatchID: " + stringArray2[n6] + "\tSize: " + nArray[n6]);
            ++n6;
        }
        if (n5 == 0) {
            Patch patch2 = null;
            IPatch iPatch = null;
            int n7 = 0;
            while (n7 < n2) {
                try {
                    patch2 = patchList.getPatchAt(n7);
                    iPatch = new IPatch(patch2);
                    iPatch.setError(PATCH_NOT_FOUND);
                    if (this.updateSessionData) {
                        sessionData.addPatchUnavailable(iPatch);
                    }
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                }
                ++n7;
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
            }
            return;
        }
        Patch patch3 = null;
        int n8 = 0;
        while (n8 < n2) {
            block68: {
                try {
                    patch3 = patchList.getPatchAt(n8);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                    break block68;
                }
                object3 = patch3.getPatchID().getPatchID();
                String string7 = (String)object3 + ".jar";
                n = 0;
                while (n < n5) {
                    if (string7.equals(stringArray3[n])) {
                        if (!this.updateSessionData) break;
                        try {
                            sessionData.addPatchDownloaded((String)object3);
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println(this, 3, "Malformed patch string " + (String)object3);
                        }
                        break;
                    }
                    if (n + 1 == n5) {
                        object2 = null;
                        try {
                            object2 = patchList.getPatchByPatchID(new PatchID((String)object3));
                            serializable = new IPatch((Patch)object2);
                            ((IPatch)serializable).setError(PATCH_NOT_FOUND);
                            if (this.updateSessionData) {
                                sessionData.addPatchUnavailable((IPatch)serializable);
                                object = new PatchNotFoundException("PatchNotFoundException", "PatchNotFoundException.MESSAGE", "PatchNotFoundException.REMEDY", 2);
                                sessionData.addPatchProException((PatchProException)object);
                            }
                            this.log.println(this, 3, PATCH_NOT_FOUND);
                        }
                        catch (NoSuchPatchException noSuchPatchException) {
                            this.log.println(this, 3, "There exists no patch in the patch listto be downloaded.");
                            this.log.println(this, 3, noSuchPatchException.getMessage());
                            this.log.printStackTrace(this, 3, noSuchPatchException);
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println(this, 4, "ServerPatchServiceProvider.requestDownload(): Malformed patch ID on appliedPatch. " + malformedPatchException.getMessage());
                            this.log.printStackTrace(this, 4, malformedPatchException);
                        }
                    }
                    ++n;
                }
            }
            ++n8;
        }
        if (downloader.getContentType().compareTo("application/octet-stream") == 0) {
            int n9 = 0;
            int n10 = 0;
            n = downloader.getBufferLength();
            if (n <= 0) {
                n = 8192;
            }
            object2 = new byte[n];
            serializable = new File(this.patchBundlePrefix);
            if (!((File)serializable).exists()) {
                ((File)serializable).mkdirs();
            }
            serializable = null;
            object = null;
            this.smpatch = this.properties.getProperty("smpatch.request", "false").equals("true");
            int n11 = 0;
            while (n11 < n5) {
                Serializable serializable2;
                Serializable serializable3;
                object = stringArray2[n11];
                this.log.println(this, 7, (String)object);
                try {
                    serializable = new File((String)object);
                    if (!((File)serializable).exists()) {
                        ((File)serializable).createNewFile();
                        this.log.println(this, 7, "Created " + (String)object);
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream((String)object);
                    n10 = 0;
                    n9 = 0;
                    int n12 = nArray[n11] - n10;
                    while (n12 >= n) {
                        n9 = bufferedInputStream.read((byte[])object2, 0, n);
                        if (n9 == -1) break;
                        n12 = nArray[n11] - (n10 += n9);
                        fileOutputStream.write((byte[])object2, 0, n9);
                    }
                    if (n12 > 0) {
                        n9 = bufferedInputStream.read((byte[])object2, 0, n12);
                        fileOutputStream.write((byte[])object2, 0, n9);
                    }
                    fileOutputStream.close();
                    boolean bl = true;
                    if (this.downloadAuthenticate) {
                        bl = this.validatePatchBundle(stringArray2[n11]);
                        this.log.println(this, 7, "The downloader validation is done");
                    }
                    serializable3 = null;
                    if (bl) {
                        this.log.println(this, 7, "The patch bundle is validated");
                    } else {
                        try {
                            serializable3 = patchList.getPatchByPatchID(new PatchID(stringArray[n11]));
                            serializable2 = new IPatch((Patch)serializable3);
                            ((IPatch)serializable2).setError(FAILED_TO_VALIDATE_SIGNATURE);
                            if (this.updateSessionData) {
                                sessionData.addPatchCorruptOnDownload((IPatch)serializable2);
                            }
                            this.log.println(this, 7, "Added patch " + serializable3.getPatchID().getPatchID() + " to the list. ErrString: " + FAILED_TO_VALIDATE_SIGNATURE);
                            File file = new File(stringArray2[n11]);
                            file.delete();
                            file = null;
                            this.log.println(this, 3, FAILED_TO_VALIDATE_SIGNATURE);
                            if (this.updateSessionData) {
                                PatchSignatureValidationException patchSignatureValidationException = this.smpatch ? new PatchSignatureValidationException("PatchSignatureValidationException", "PatchSignatureValidationException.SMPATCH_MESSAGE", "PatchSignatureValidationException.SMPATCH_REMEDY", 2) : new PatchSignatureValidationException("PatchSignatureValidationException", "PatchSignatureValidationException.MESSAGE", "PatchSignatureValidationException.REMEDY", 2);
                                sessionData.addPatchProException(patchSignatureValidationException);
                            }
                        }
                        catch (NoSuchPatchException noSuchPatchException) {
                            this.log.println(this, 2, "There exists no patch failing signaturevalidation");
                            this.log.printStackTrace(this, 3, noSuchPatchException);
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println(this, 4, "PatchProModel.evaluatePatchListExpression(): Malformed patch ID on applied Patch. " + malformedPatchException.getMessage());
                            this.log.printStackTrace(this, 3, malformedPatchException);
                        }
                    }
                    if (!downloader.isCancelEnabled()) {
                        this.log.println(this, 6, "Downloading done.");
                    } else {
                        this.log.println(this, 6, "Downloading canceled.");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string8 = "Invalid patch bundle file name.: " + (String)object;
                    this.log.printStackTrace(this, 3, fileNotFoundException);
                    this.log.println(this, 3, string8);
                    this.dispatchFailedEvent(PatchProLog.createMessage(3, INVALID_PATCH_BUNDLE_FILE_NAME));
                }
                catch (SecurityException securityException) {
                    String string9 = "The write permission is not set.: " + (String)object;
                    this.log.printStackTrace(this, 3, securityException);
                    this.log.println(this, 3, string9);
                    this.dispatchFailedEvent(PatchProLog.createMessage(3, INVALID_FILE_PERMISSION));
                    securityException.printStackTrace();
                }
                catch (IOException iOException) {
                    this.log.printStackTrace(this, 3, iOException);
                    if (this.updateSessionData) {
                        serializable3 = new PatchDownloadIOException("PatchDownloadIOException", "PatchDownloadIOException.MESSAGE", "PatchDownloadIOException.REMEDY", 2);
                        sessionData.addPatchProException((PatchProException)serializable3);
                    }
                }
                catch (Exception exception) {
                    this.log.printStackTrace(this, 3, exception);
                    if (this.updateSessionData) {
                        serializable2 = new PatchDownloadIOException("PatchDownloadIOException", "PatchDownloadIOException.MESSAGE", "PatchDownloadIOException.REMEDY", 2);
                        sessionData.addPatchProException((PatchProException)serializable2);
                    }
                    this.dispatchFailedEvent(PatchProLog.createMessage(3, "PatchDownloadIOException.MESSAGE\nPatchDownloadIOException.REMEDY"));
                }
                ++n11;
            }
        } else {
            this.log.println(this, 4, UNKNOWN_CONTENT_TYPE);
            this.dispatchFailedEvent(PatchProLog.createMessage(4, UNKNOWN_CONTENT_TYPE));
            if (this.updateSessionData) {
                object3 = new PatchDownloadResponseException("PatchDownloadResponseException", "PatchDownloadResponseException.MESSAGE", "PatchDownloadResponseException.REMEDY", 2);
                sessionData.addPatchProException((PatchProException)object3);
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
            }
            if (this.updateSessionData) {
                sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
            }
        }
        try {
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
        }
    }

    private void createDownloadSummaryFile(SessionData sessionData, PatchList patchList, String string) {
        boolean bl = false;
        File file = null;
        File file2 = null;
        try {
            PatchList patchList2;
            PatchList patchList3;
            PatchList patchList4;
            PatchList patchList5;
            try {
                patchList5 = sessionData.getPatchesDownloaded();
            }
            catch (NoResultException noResultException) {
                patchList5 = new PatchListImpl();
            }
            try {
                patchList4 = sessionData.getPatchesAlreadyPresent();
            }
            catch (NoResultException noResultException) {
                patchList4 = new PatchListImpl();
            }
            try {
                patchList3 = sessionData.getPatchesUnavailable();
            }
            catch (NoResultException noResultException) {
                patchList3 = new PatchListImpl();
            }
            try {
                patchList2 = sessionData.getPatchesCorruptOnDownload();
            }
            catch (NoResultException noResultException) {
                patchList2 = new PatchListImpl();
            }
            int n = patchList5.size() + patchList4.size();
            int n2 = patchList3.size() + patchList2.size();
            file2 = new File(string);
            String string2 = !file2.canWrite() ? "/var/tmp/" : string;
            file = new File(string2 + File.separator + PatchServiceUtil.generateTimeStampedString("patchpro_dnld_'%Y.%m.%d@%T:%Z'") + "." + "txt");
            this.log.println(this, 7, "Dnld summary file: " + file.getPath());
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintStream printStream = new PrintStream(fileOutputStream);
            PatchListImpl patchListImpl = new PatchListImpl();
            if (n2 == 0) {
                printStream.println(this.msgcat.getMessage("readmeHeader", "This patch bundle was generated by PatchPro.\n\nPlease refer to the README file for each patch for installation\ninstructions.  To properly patch your system, the following patches\nshould be installed in the listed order:\n\n"));
                this.printDownloadedPatches(printStream, patchList);
            } else {
                printStream.println(this.msgcat.getMessage("readmeFailedHeader", "This collection of patches is incomplete due to problems in downloading.\nIt is advisable to retry the download later and see if the\nremaining patches can be downloaded. If they can, then the new download\nsummary file will show the patches required and the order in which to\ninstall them. The patches failing to install are listed here:\n\n"));
                try {
                    patchListImpl.merge(sessionData.getPatchesUnavailable());
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
                try {
                    patchListImpl.merge(sessionData.getPatchesCorruptOnDownload());
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
                this.printProblemPatches(printStream, patchListImpl);
            }
            fileOutputStream.close();
            printStream.close();
        }
        catch (Exception exception) {
            System.out.println("Problems creating download summary file. " + exception.getMessage());
            this.log.println(this, 7, "Unable to create the download summary file. " + exception.getMessage());
            this.log.printStackTrace(this, 4, exception);
            exception.printStackTrace();
        }
    }

    private boolean validatePatchBundle(String string) {
        boolean bl = true;
        this.log.println(this, 7, "Entered downloader validatePatchBundle()");
        if (this.validationUtil == null) {
            String string2 = FAILED_TO_CREATE_VALIDATION_UTIL;
            this.log.println(this, 3, string2);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_CREATE_VALIDATION_UTIL));
            return false;
        }
        try {
            this.validationUtil.validateJarFile(string);
        }
        catch (ManifestFileNotFoundException manifestFileNotFoundException) {
            bl = false;
            String string3 = "Failed to validate the digital signature(s). for: " + string + ": " + manifestFileNotFoundException.getMessage();
            this.log.printStackTrace(this, 3, manifestFileNotFoundException);
            this.log.println(this, 3, string3);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        catch (SignatureCheckFailedException signatureCheckFailedException) {
            bl = false;
            String string4 = "Failed to validate the digital signature(s). for: " + string + ": " + signatureCheckFailedException.getMessage();
            this.log.printStackTrace(this, 3, signatureCheckFailedException);
            this.log.println(this, 3, string4);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        catch (NotSignedByKnownCertificateException notSignedByKnownCertificateException) {
            bl = false;
            String string5 = "Failed to validate the digital signature(s). for: " + string + ": " + notSignedByKnownCertificateException.getMessage();
            this.log.printStackTrace(this, 3, notSignedByKnownCertificateException);
            this.log.println(this, 3, string5);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        catch (SignatureValidationException signatureValidationException) {
            bl = false;
            String string6 = "Failed to validate the digital signature(s). for: " + string + ": " + signatureValidationException.getMessage();
            this.log.printStackTrace(this, 3, signatureValidationException);
            this.log.println(this, 3, string6);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        System.out.println("");
        if (bl) {
            System.out.println(string + " has been validated.");
        } else {
            System.out.println(string + " cannot be validated.");
            System.out.print("\n\n");
        }
        return bl;
    }

    private void printDownloadedPatches(PrintStream printStream, PatchList patchList) {
        int n = 0;
        int n2 = patchList.size();
        int n3 = 0;
        while (n3 < n2) {
            try {
                if (patchList.getSelectionStatus(n3)) {
                    Patch patch = patchList.getPatchAt(n3);
                    String string = patch.getPatchID().getPatchID();
                    this.log.println(this, 7, "Checking if " + string + " is available...");
                    PatchProperties patchProperties = patch.getPatchInfo().getProperties();
                    ++n;
                    if (patchProperties.isNonstandard() || patchProperties.isInteractive()) {
                        printStream.println(n + ") " + string + " " + this.msgcat.getMessage("seeReadmeWarning", "!!! SEE README !!!"));
                    } else if (patchProperties.isRebootimmediate() || patchProperties.isReconfigimmediate()) {
                        printStream.println(n + ") " + string + " " + this.msgcat.getMessage("immediateRebootWarning", "!!! IMMEDIATE REBOOT !!!"));
                    } else if (patchProperties.isRebootafter() || patchProperties.isReconfigafter()) {
                        printStream.println(n + ") " + string + " " + this.msgcat.getMessage("rebootWarning", "!!! REBOOT !!!"));
                    } else if (patchProperties.isSingleuser()) {
                        printStream.println(n + ") " + string + " " + this.msgcat.getMessage("singleUserWarning", "!!! SINGLE USER !!!"));
                    } else {
                        printStream.println(n + ") " + string);
                    }
                }
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
            }
            ++n3;
        }
    }

    private void printProblemPatches(PrintStream printStream, PatchList patchList) {
        int n = patchList.size();
        String string = "";
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            block3: {
                IPatch iPatch;
                try {
                    iPatch = patchList.getIPatchAt(n2);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                    break block3;
                }
                string = iPatch.getPatchID().getPatchID();
                string2 = iPatch.hasError() ? iPatch.getError() : "";
                this.log.println(this, 7, "Listing " + string + " w/ " + string2);
                printStream.println(string + " " + string2);
            }
            ++n2;
        }
    }

    private String getCertSerialNumber(String string, String string2) {
        String string3 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            KeyStore keyStore = KeyStore.getInstance("JKS", "SUN");
            keyStore.load(fileInputStream, null);
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
            PublicKey publicKey = x509Certificate.getPublicKey();
            string3 = String.valueOf(x509Certificate.getSerialNumber());
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 3, exception);
        }
        return string3;
    }

    private boolean connectingServer() {
        URLConnection uRLConnection = null;
        try {
            uRLConnection = this.serverURL.openConnection();
            uRLConnection.connect();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
            System.out.println(this.msgcat.getMessage("not_connected", "Cannot establish a network connection with the patch server."));
            this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage("not_connected", "Cannot establish a network connection with the patch server.")));
            return false;
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            System.out.println(this.msgcat.getMessage("not_connected", "Cannot establish a network connection with the patch server."));
            return false;
        }
        return true;
    }

    private Downloader sendPatchDownloadPostRequest(URL uRL, String string, String string2, String string3, SessionData sessionData) throws DownloadPatchException {
        Downloader downloader;
        block5: {
            downloader = null;
            boolean bl = false;
            if (string2 != null && string2.compareTo("") != 0 && string3 != null && string3.compareTo("") != 0) {
                bl = true;
            }
            String string4 = "";
            String string5 = "";
            if (bl) {
                string4 = string2;
                string5 = string3;
            }
            this.log.println(this, 7, "Password authentication: " + bl);
            try {
                downloader = new Downloader(uRL, string, bl, string4, string5);
                downloader.connectToURL();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.log.println(this, 2, "It's possible that " + this.serverURLString + " does not have \"/\" at the end.");
                this.log.println(this, 2, "Returning HTTP response code is > 400. Assume 500.");
                this.log.printStackTrace(this, 2, fileNotFoundException);
                throw new DownloadPatchException(4);
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
                if (downloader != null) break block5;
                this.dispatchFailedEvent(PatchProLog.createMessage(2, FAILED_TO_CREATE_DOWNLOADER));
                ServerConnectionException serverConnectionException = new ServerConnectionException("ServerConnectionException", "ServerConnectionException.MESSAGE", "ServerConnectionException.REMEDY", 2);
                sessionData.addPatchProException(serverConnectionException);
                throw new DownloadPatchException(FAILED_TO_CREATE_DOWNLOADER);
            }
        }
        return downloader;
    }

    private void dispatchProgressEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchProgress(new DownloadPatchEvent(this, string));
        }
    }

    private void dispatchDoneEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchDone(new DownloadPatchEvent(this, string));
        }
    }

    private void dispatchFailedEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchFailed(new DownloadPatchEvent(this, string));
        }
    }
}

