/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.patchpro.model.PatchProProperties;
import java.util.Enumeration;
import javax.servlet.ServletConfig;

public class PatchServerServletProperties
extends PatchProProperties {
    public PatchServerServletProperties(ServletConfig servletConfig) {
        if (!this.getInitArgs(servletConfig)) {
            throw new Error("A required property was not defined in the PatchPro Server's zone.properties file.");
        }
    }

    public PatchServerServletProperties(PatchProProperties patchProProperties) {
        this.setPatchProProperties(patchProProperties);
    }

    private boolean getInitArgs(ServletConfig servletConfig) {
        this.setPATCH_DOWNLOAD_URL(servletConfig.getInitParameter("patchpro.patch.server.url"));
        this.setDETECTOR_DOWNLOAD_URL(servletConfig.getInitParameter("patchpro.detectors.source.url"));
        this.setCRL_SOURCE_URL(servletConfig.getInitParameter("patchpro.security.crl.source.url"));
        this.setDEBUG_STATUS(servletConfig.getInitParameter("patchpro.debug"));
        if (this.getPATCH_DOWNLOAD_URL() == null || this.getDETECTOR_DOWNLOAD_URL() == null || this.getCRL_SOURCE_URL() == null) {
            PatchProProperties.log.println(this, 3, "A required property was not defined in the PatchPro Server's zone.properties file.");
            PatchProProperties.log.println(this, 3, "There should be a property defined for \"patchpro.patch.server.url\" and \"patchpro.security.crl.source.url\" and \"patchpro.detectors.source.url\"");
            this.dump();
            return false;
        }
        return true;
    }

    private void setPatchProProperties(PatchProProperties patchProProperties) {
        Enumeration enumeration = patchProProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setProperty(string, patchProProperties.getProperty(string));
        }
    }

    public void setPATCH_DOWNLOAD_URL(String string) {
        this.setProperty("patchpro.patch.server.url", string);
    }

    public void setCRL_SOURCE_URL(String string) {
        this.setProperty("patchpro.security.crl.source.url", string);
    }

    public void setDETECTOR_DOWNLOAD_URL(String string) {
        this.setProperty("patchpro.detectors.source.url", string);
    }

    public void setDEBUG_STATUS(String string) {
        this.setProperty("patchpro.debug", string);
    }

    public String getPATCH_DOWNLOAD_URL() {
        return this.getProperty("patchpro.patch.server.url");
    }

    public String getDETECTOR_DOWNLOAD_URL() {
        return this.getProperty("patchpro.detectors.source.url");
    }

    public String getCRL_SOURCE_URL() {
        return this.getProperty("patchpro.security.crl.source.url");
    }

    public String getDEBUG_STATUS() {
        return this.getProperty("patchpro.debug");
    }
}

