/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.DownloadPatchListener;
import com.sun.patchpro.model.Messagable;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchBundleInfo;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.server.DownloadPatchDBException;
import com.sun.patchpro.server.DownloadPatchException;
import com.sun.patchpro.server.DownloadRealizationException;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServerProxyException;
import com.sun.patchpro.server.PatchServiceProvider;
import java.util.Collection;

public class PatchServerProxy
implements Messagable {
    PatchServiceProvider provider;
    PatchProLog log = PatchProLog.getInstance();

    public PatchServerProxy(PatchProProperties patchProProperties) throws PatchServerProxyException {
        String string = patchProProperties.getProperty("patchpro.patch.server.url");
        if (string == null || string.length() == 0) {
            String string2 = "patchpro.patch.server.url not specified.";
            this.log.println(this, 2, string2);
            throw new PatchServerProxyException(string2);
        }
        String string3 = null;
        if (string.indexOf("file:") == 0) {
            string3 = "com.sun.patchpro.server.FileSystemPatchServiceProvider";
        } else if (string.indexOf("https:") == 0 || string.indexOf("http:") == 0) {
            string3 = "com.sun.patchpro.server.ServerPatchServiceProvider";
        } else {
            String string4 = "Unknown protocol: " + string;
            this.log.println(this, 2, string4);
            throw new PatchServerProxyException(string4);
        }
        this.log.println(this, 7, "Adaptor is: " + string3);
        try {
            Class<?> clazz = Class.forName(string3);
            this.provider = (PatchServiceProvider)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.printStackTrace(this, 2, classNotFoundException);
            throw new PatchServerProxyException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            this.log.printStackTrace(this, 2, instantiationException);
            throw new PatchServerProxyException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.printStackTrace(this, 2, illegalAccessException);
            throw new PatchServerProxyException(illegalAccessException);
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            throw new PatchServerProxyException(exception);
        }
        if (string3.compareTo("com.sun.patchpro.server.FileSystemPatchServiceProvider") == 0) {
            this.configureServiceProvider(patchProProperties);
        }
    }

    public void configureServiceProvider(PatchProProperties patchProProperties) {
        this.provider.configure(patchProProperties);
    }

    public void downloadPatchDB() throws DownloadPatchDBException, NotSupportedException {
        this.provider.downloadPatchDB();
    }

    public void downloadRealizationDetectors() throws DownloadRealizationException, NotSupportedException {
        this.provider.downloadRealizationDetectors();
    }

    public void downloadPatches(PatchList patchList, Object object) throws DownloadPatchException, NotSupportedException {
        this.provider.downloadPatches(patchList, object);
    }

    public void downloadPatches(PatchList patchList, Object object, SessionData sessionData) throws DownloadPatchException, NotSupportedException {
        this.provider.downloadPatches(patchList, object, sessionData);
    }

    public PatchBundleInfo[] getDownloadedPatchBundlesInfo(PatchList patchList) {
        return this.provider.getDownloadedPatchBundlesInfo(patchList);
    }

    public Object getDownloadDestination() {
        return this.provider.getDownloadDestination();
    }

    public void addDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        this.provider.addDownloadPatchListener(downloadPatchListener);
    }

    public void removeDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        this.provider.removeDownloadPatchListener(downloadPatchListener);
    }

    public boolean isCertificateRevoked(String string) throws NotSupportedException {
        return this.provider.isCertificateRevoked(string);
    }

    public Collection getPatchProExceptions() {
        if (this.provider instanceof Messagable) {
            return ((Messagable)((Object)this.provider)).getPatchProExceptions();
        }
        return null;
    }
}

