/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.PatchBundleInfo;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.patch.SecurePatchListImpl;
import com.sun.patchpro.server.DownloadPatchDBException;
import com.sun.patchpro.server.DownloadPatchException;
import com.sun.patchpro.server.DownloadRealizationException;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServerProxy;
import com.sun.patchpro.server.PatchServerProxyException;
import com.sun.patchpro.server.PatchServerServletProperties;
import com.sun.patchpro.server.ServletLog;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PatchProServerServlet
extends HttpServlet {
    static final String VERSION_2_0 = "2.0";
    static final String VERSION_2_1 = "2.1";
    String protocolVersion = "";
    PatchServerServletProperties properties;
    PatchServerProxy patchServerProxy;
    private PatchProLog log;
    public static final int SUCCESS = 0;
    public static final int DUPLICATE_PARAMETER = 4;
    public static final int INVALID_PARAMETER = 8;
    public static final int INVALID_REQUEST = 16;
    public static final int MISSING_PARAMETER = 32;
    public static final int MISSING_VALUE = 36;
    public static final int IO_EXCEPTION = 48;
    public static final int EXCEPTION = 64;
    public static final int MALFORMED_PATCH_EXCEPTION = 100;
    public static final int DOWNLOADPATCH_EXCEPTION = 110;
    public static final int NOT_SUPPORTED_EXCEPTION = 120;
    public static final int PATCHBUNDLE_INFO_UNAVAILABLE = 130;
    public static final int EXPIRED_CERTIFICATE = 200;
    public static final int GOOD_CERTIFICATE = 201;
    public static final int DOWNLOADPATCHDB_EXCEPTION = 300;
    public static final int DOWNLOAD_REALIZATION_EXCEPTION = 400;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        block54: {
            try {
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 0);
                httpServletResponse.setStatus(200);
                String[] stringArray = httpServletRequest.getParameterValues("version");
                if (stringArray == null || stringArray.length == 0) {
                    this.protocolVersion = VERSION_2_0;
                } else if (stringArray[0].compareTo(VERSION_2_0) == 0) {
                    this.protocolVersion = VERSION_2_0;
                } else if (stringArray[0].compareTo(VERSION_2_1) == 0) {
                    this.protocolVersion = VERSION_2_1;
                } else {
                    this.log.println((Object)this, 3, "Invalid request: Invalid version specified.");
                    httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                    httpServletResponse.sendError(400);
                    return;
                }
                this.log.println((Object)this, 6, "Protocol version: " + this.protocolVersion);
                String[] stringArray2 = httpServletRequest.getParameterValues("action");
                if (stringArray2 == null || stringArray2.length > 1) {
                    this.log.println((Object)this, 3, "Invalid request: Either the \"action\" parameter was not specified or multiple \"action\" parameters were detected.");
                    httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                    httpServletResponse.sendError(400);
                    return;
                }
                if (stringArray2[0].compareTo("patchDownload") == 0) {
                    String[] stringArray3;
                    String[] stringArray4;
                    String string;
                    Enumeration enumeration = httpServletRequest.getParameterNames();
                    while (enumeration.hasMoreElements()) {
                        string = (String)enumeration.nextElement();
                        if (string.equals("action") || string.equals("patchId") || string.equals("user") || string.equals("passwd") || string.equals("text") || string.equals("maxSize") || string.equals("version")) continue;
                        this.log.println((Object)this, 3, "Invalid \"patchDownload\" request: Unknown parameter \"" + string + "\" was detected.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    string = null;
                    String string2 = null;
                    String string3 = "";
                    if (this.protocolVersion.compareTo(VERSION_2_0) == 0) {
                        stringArray4 = httpServletRequest.getParameterValues("user");
                        stringArray3 = httpServletRequest.getParameterValues("passwd");
                        if (stringArray4 != null) {
                            if (stringArray4.length > 1) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Multiple \"user\" parameters were  detected.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 4);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            if (stringArray4[0].equals("")) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Value was not specified for the specified \"user\" parameter.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            string = stringArray4[0];
                        }
                        if (stringArray3 != null) {
                            if (stringArray3.length > 1) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Multiple \"passwd\" parameters were  detected.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 4);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            if (stringArray3[0].equals("")) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Value was not specified for the specified \"passwd\"  parameter.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            string2 = stringArray3[0];
                        }
                    }
                    if (this.protocolVersion.compareTo(VERSION_2_0) != 0 && (stringArray3 = httpServletRequest.getParameterValues("maxSize")) != null && stringArray3.length > 0) {
                        this.log.println((Object)this, 7, "maxSize specified: " + stringArray3[0]);
                    }
                    if ((stringArray4 = httpServletRequest.getParameterValues("text")) != null) {
                        if (stringArray4.length > 1) {
                            this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Multiple \"text\" parameters were detected.");
                            httpServletResponse.sendError(400);
                            return;
                        }
                        if (stringArray4[0].equals("")) {
                            this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Value was not specified for the specified \"text\" parameter.");
                            httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                            httpServletResponse.sendError(400);
                            return;
                        }
                        string3 = stringArray4[0];
                    }
                    if ((stringArray3 = httpServletRequest.getParameterValues("patchId")) == null || string != null && string2 == null || string == null && string2 != null) {
                        this.log.println((Object)this, 3, "Invalid \"patchDownload\" request: A required \"patchID\", \"user\" and/or \"passwd\" parameter was not specified");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 32);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    PatchListImpl patchListImpl = null;
                    patchListImpl = string != null ? new SecurePatchListImpl(string, string2, string3) : new PatchListImpl(string3);
                    PatchInfoImpl patchInfoImpl = new PatchInfoImpl();
                    patchInfoImpl.setObsolesces("");
                    patchInfoImpl.setRequires("");
                    patchInfoImpl.setOS("");
                    patchInfoImpl.setProperties(new PatchProperties(""));
                    int n = 0;
                    while (n < stringArray3.length) {
                        try {
                            patchListImpl.addIPatch(new IPatch(new PatchImpl(patchInfoImpl, new PatchID(stringArray3[n]))));
                            patchListImpl.setSelectionStatus(n, true);
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. Exception: " + malformedPatchException);
                            httpServletResponse.setIntHeader("PatchProServletCompletionCode", 100);
                            httpServletResponse.sendError(500);
                            return;
                        }
                        ++n;
                    }
                    ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                    httpServletResponse.setContentType("application/octet-stream");
                    PatchBundleInfo[] patchBundleInfoArray = this.patchServerProxy.getDownloadedPatchBundlesInfo(patchListImpl);
                    this.log.println((Object)this, 7, "patchList.size: " + patchListImpl.size());
                    this.log.println((Object)this, 7, "pbinfo: " + patchBundleInfoArray.length);
                    if (patchBundleInfoArray == null) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. Cannot access patch bundle information.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 130);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    int n2 = 200;
                    boolean bl = true;
                    boolean bl2 = true;
                    String string4 = "";
                    String string5 = "";
                    int n3 = 0;
                    while (n3 < patchBundleInfoArray.length) {
                        if (patchBundleInfoArray[n3].getPatchBundleSize() < 0L) {
                            if (!bl2) {
                                string5 = string5 + "|";
                            }
                            string5 = string5 + patchBundleInfoArray[n3].getPatchBundleName() + "&" + "2";
                            bl2 = false;
                            n2 = 206;
                        } else {
                            if (!bl) {
                                string4 = string4 + "|";
                            }
                            string4 = string4 + patchBundleInfoArray[n3].getPatchBundleName() + "&" + Long.toString(patchBundleInfoArray[n3].getPatchBundleSize());
                            bl = false;
                        }
                        ++n3;
                    }
                    this.log.println((Object)this, 7, "patchFiles: " + string4);
                    this.log.println((Object)this, 7, "rejects: " + string5);
                    httpServletResponse.setHeader("patchFiles", string4);
                    if (this.protocolVersion.compareTo(VERSION_2_1) == 0 && string5.compareTo("") != 0) {
                        httpServletResponse.setHeader("rejects", string5);
                    }
                    httpServletResponse.setStatus(n2);
                    try {
                        this.patchServerProxy.downloadPatches(patchListImpl, servletOutputStream);
                    }
                    catch (DownloadPatchException downloadPatchException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. Cannot download patch bundle.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 110);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    catch (NotSupportedException notSupportedException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. \"patchDownload\" request is not supported.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 120);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    servletOutputStream.close();
                    this.log.println((Object)this, 7, "PatchProServerServlet.patchDownload done. Status: " + n2);
                    break block54;
                }
                if (stringArray2[0].compareTo("isCertificateRevoked") == 0) {
                    String string;
                    this.log.println((Object)this, 7, "Received a isCertificateRevoked request.");
                    Enumeration enumeration = httpServletRequest.getParameterNames();
                    while (enumeration.hasMoreElements()) {
                        string = (String)enumeration.nextElement();
                        if (string.equals("action") || string.equals("serialNumber") || string.equals("version")) continue;
                        this.log.println((Object)this, 3, "Invalid \"isCertificateRevoked\" request: Unknown parameter \"" + string + "\" detected.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    string = null;
                    String[] stringArray5 = httpServletRequest.getParameterValues("serialNumber");
                    if (stringArray5 == null) {
                        this.log.println((Object)this, 3, "Invalid \"isCertificateRevoked\" request: The required \"serialNumber\" parameter was not specified.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 32);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    if (stringArray5[0].equals("")) {
                        this.log.println((Object)this, 3, "Invalid  \"isCertificateRevoked\" request: Value was not specified for thespecified \"serialNumber\" parameter.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    if (stringArray5.length > 1) {
                        this.log.println((Object)this, 3, "Invalid \"isCertificateRevoked\" request: Multiple \"serialNumber\" parameters are not allowed.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 4);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    string = stringArray5[0];
                    if (this.patchServerProxy.isCertificateRevoked(string)) {
                        this.log.println((Object)this, 6, "Certificate has been revoked for " + string);
                        httpServletResponse.setIntHeader("patchproServiceCompletionCode", 200);
                    } else {
                        this.log.println((Object)this, 6, "This certificate is good: " + string);
                        httpServletResponse.setIntHeader("patchproServiceCompletionCode", 201);
                    }
                    return;
                }
                if (stringArray2[0].compareTo("downloadPatchDB") == 0) {
                    this.log.println((Object)this, 7, "Received a downloadPatchDB request.");
                    Enumeration enumeration = httpServletRequest.getParameterNames();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (string.equals("action") || string.equals("version")) continue;
                        this.log.println((Object)this, 3, "Invalid \"downloadPatchDB\" request: Unknown parameter \"" + string + "\" detected.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    try {
                        this.patchServerProxy.downloadPatchDB();
                        break block54;
                    }
                    catch (DownloadPatchDBException downloadPatchDBException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"downloadPatchDB\" request. Cannot download the patch database.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 300);
                        httpServletResponse.sendError(500);
                        return;
                    }
                }
                if (stringArray2[0].compareTo("downloadRealizationDetectors") == 0) {
                    this.log.println((Object)this, 7, "Received a downloadRealizationDetectors request.");
                    Enumeration enumeration = httpServletRequest.getParameterNames();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (string.equals("action") || string.equals("version")) continue;
                        this.log.println((Object)this, 3, "Invalid \"downloadRealizationDetectors\" request: Unknown parameter \"" + string + "\" detected");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    try {
                        this.patchServerProxy.downloadRealizationDetectors();
                        break block54;
                    }
                    catch (DownloadRealizationException downloadRealizationException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"downloadRealizationDetectors\" request. Cannot download realization detectors.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 400);
                        httpServletResponse.sendError(500);
                        return;
                    }
                }
                if (stringArray2[0].compareTo("getDocumentation") == 0) {
                    this.log.println((Object)this, 7, "Received a getDocumentation request.");
                    Enumeration enumeration = httpServletRequest.getParameterNames();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (string.equals("action") || string.equals("version") || string.equals("patchId")) continue;
                        this.log.println((Object)this, 3, "Invalid \"getDocumentation\" request: Unknown parameter \"" + string + "\" detected");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    break block54;
                }
                this.log.println((Object)this, 3, "Unknown \"action\" request was specified.");
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                httpServletResponse.sendError(400);
                return;
            }
            catch (IOException iOException) {
                this.log.printStackTrace((Object)this, 3, iOException);
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 48);
                httpServletResponse.setStatus(500);
                throw new ServletException(iOException.toString());
            }
            catch (Exception exception) {
                this.log.printStackTrace((Object)this, 3, exception);
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 64);
                httpServletResponse.setStatus(500);
                throw new ServletException(exception.toString());
            }
        }
    }

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.log = PatchProLog.getInstance();
        this.log.setLogger(new ServletLog(servletConfig.getServletContext()));
        this.properties = new PatchServerServletProperties(servletConfig);
        try {
            this.patchServerProxy = new PatchServerProxy(this.properties);
        }
        catch (PatchServerProxyException patchServerProxyException) {
            // empty catch block
        }
        if (this.properties.getDEBUG_STATUS().equals("true")) {
            this.log.println((Object)this, 7, "PatchProServerServlet: Patch Download URL is " + this.properties.getPATCH_DOWNLOAD_URL());
            this.log.println((Object)this, 7, "PatchProServerServlet: Detector Download URL is " + this.properties.getDETECTOR_DOWNLOAD_URL());
        }
    }

    public void destroy() {
        this.log.println((Object)this, 7, "PatchProServerServlet: destroy...");
        this.log = null;
        this.properties = null;
    }
}

