/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.log.ApplicationLog;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.DownloadPatchListener;
import com.sun.patchpro.model.PatchNotAvailableException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchBundleInfo;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.server.DownloadPatchDBException;
import com.sun.patchpro.server.DownloadPatchException;
import com.sun.patchpro.server.DownloadRealizationException;
import com.sun.patchpro.server.FileSystemPatchServiceProviderException;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServiceProvider;
import com.sun.patchpro.server.PatchServiceUtil;
import com.sun.patchpro.util.LocalizedMessages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class FileSystemPatchServiceProvider
implements PatchServiceProvider {
    private LocalizedMessages msgcat;
    boolean debug;
    boolean crlLoaded;
    Hashtable certificateRevokeList;
    Object downloadDestination;
    PatchProLog log = PatchProLog.getInstance();
    String detectorSourceLocation;
    String patchBundlePrefix = "/tmp/";
    String patchSourceLocation;
    String patchDBSourceLocation;
    String crlSourceLocation;
    Vector listeners;
    PatchProProperties properties = null;
    boolean updateSessionData = true;
    static final int BUFFER_SIZE = 102400;
    static final String CRL_TEXT_FILE_NAME = "crl.txt";
    static final String DEFAULT_DETECTOR_SOURCE_LOCATION = "/tmp";
    static final String DEFAULT_PATCH_SOURCE_LOCATION = "/tmp";
    static final String DEFAULT_PATCH_DB_SOURCE_LOCATION = "/tmp";
    static final String DEFAULT_CRL_SOURCE_LOCATION = "/opt/SUNWppro/lib/crl.jar";
    static final String DEFAULT_PATCH_BUNDLE_PREFIX = "/tmp/";
    static final String FAIL_TO_DOWNLOAD = "Failed to download patch. ";
    static final String PATCH_NOT_FOUND = "Patch cannot be found. ";
    static final String UNKNOWN_DESTINATION_TYPE = "Unknown download destination type. ";
    static final String DOWN_REV_PATCH = "Only downrev patches of the requested patch are available.";

    public FileSystemPatchServiceProvider() throws FileSystemPatchServiceProviderException {
        PatchProProperties patchProProperties = null;
        patchProProperties = PatchProProperties.getInstance();
        this.msgcat = new LocalizedMessages(patchProProperties.getLocale());
        boolean bl = this.debug = patchProProperties.getProperty("patchpro.debug", "false").equals("true");
        if (this.debug) {
            String string = patchProProperties.getProperty("patchpro.log.file", "system");
            try {
                this.log.setLogger(new ApplicationLog(string));
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 3, exception);
            }
        }
        this.detectorSourceLocation = "/tmp";
        this.patchSourceLocation = "/tmp";
        this.patchDBSourceLocation = "/tmp";
        this.crlSourceLocation = DEFAULT_CRL_SOURCE_LOCATION;
        this.certificateRevokeList = new Hashtable();
        this.crlLoaded = false;
        this.listeners = new Vector();
    }

    public String getPatchBundlePrefix() {
        return this.patchBundlePrefix;
    }

    public void addDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(downloadPatchListener);
        }
    }

    public void removeDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(downloadPatchListener);
        }
    }

    public void configure(PatchProProperties patchProProperties) {
        Object object;
        String string;
        Object object2;
        String string2 = patchProProperties.getProperty("patchpro.detectors.source.url");
        if (string2 == null) {
            this.detectorSourceLocation = "/tmp";
        } else {
            object2 = null;
            try {
                object2 = new URL(string2);
                string = ((URL)object2).getProtocol();
                this.detectorSourceLocation = string.compareTo("file") == 0 ? ((URL)object2).getPath() : "/tmp";
            }
            catch (MalformedURLException malformedURLException) {
                this.log.printStackTrace(this, 4, malformedURLException);
                this.detectorSourceLocation = "/tmp";
            }
        }
        object2 = patchProProperties.getProperty("patchpro.patch.server.url");
        if (object2 == null) {
            this.patchSourceLocation = "/tmp";
        } else {
            object = null;
            try {
                object = new URL((String)object2);
                string = ((URL)object).getProtocol();
                this.patchSourceLocation = string.compareTo("file") == 0 ? ((URL)object).getPath() : "/tmp";
            }
            catch (MalformedURLException malformedURLException) {
                this.log.printStackTrace(this, 4, malformedURLException);
                this.patchSourceLocation = "/tmp";
            }
        }
        object = patchProProperties.getProperty("patchpro.database.source.url");
        if (object == null) {
            this.patchDBSourceLocation = "/tmp";
        } else {
            URL uRL = null;
            try {
                uRL = new URL((String)object);
                string = uRL.getProtocol();
                this.patchDBSourceLocation = string.compareTo("file") == 0 ? uRL.getPath() : "/tmp";
            }
            catch (MalformedURLException malformedURLException) {
                this.log.printStackTrace(this, 4, malformedURLException);
                this.patchDBSourceLocation = "/tmp";
            }
        }
        this.loadCRL(patchProProperties);
        this.log.println(this, 6, "");
        this.log.println(this, 6, "FileSystemPatchServiceProvider.configure is done:");
        this.log.println(this, 6, "detectorSourceLocation: " + this.detectorSourceLocation);
        this.log.println(this, 6, "patchSourceLocation: " + this.patchSourceLocation);
        this.log.println(this, 6, "patchDBSourceLocation: " + this.patchDBSourceLocation);
        this.log.println(this, 6, "");
    }

    public void downloadPatchDB() throws DownloadPatchDBException, NotSupportedException {
    }

    public void downloadRealizationDetectors() throws DownloadRealizationException, NotSupportedException {
    }

    public PatchBundleInfo[] getDownloadedPatchBundlesInfo(PatchList patchList) {
        Vector<PatchBundleInfo> vector = new Vector<PatchBundleInfo>(patchList.size());
        this.log.println(this, 7, "Entering getDownloadedPatchBundlesInfo...");
        this.log.println(this, 7, "getDownloadedPatchBundlesInfo.patchListSize: " + patchList.size());
        long l = 0L;
        Object var5_4 = null;
        Object var7_5 = null;
        String string = null;
        Object var9_7 = null;
        int n = 0;
        while (n < patchList.size()) {
            block6: {
                Patch patch;
                try {
                    patch = patchList.getPatchAt(n);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                    break block6;
                }
                try {
                    string = this.findLatestPatch(patch.getPatchID().getPatchID());
                    this.log.println(this, 7, "getDownloadedPatchBundleInfo: latest patch found: " + string);
                    l = this.patchExists(string);
                    vector.addElement(new PatchBundleInfo(string, string + ".jar", l));
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.println(this, 4, noSuchPatchException.getMessage() + " " + string);
                    string = patch.getPatchID().getPatchID();
                    vector.addElement(new PatchBundleInfo(string, string + ".jar", -1L));
                    this.log.println(this, 4, string + " couldn't be found.");
                }
            }
            ++n;
        }
        Object[] objectArray = vector.toArray();
        PatchBundleInfo[] patchBundleInfoArray = new PatchBundleInfo[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            patchBundleInfoArray[n2] = (PatchBundleInfo)objectArray[n2];
            ++n2;
        }
        return patchBundleInfoArray;
    }

    public Object getDownloadDestination() {
        return this.downloadDestination;
    }

    public boolean isCertificateRevoked(String string) throws NotSupportedException {
        this.log.println(this, 7, "Requested serial number: " + string);
        if (!this.crlLoaded) {
            this.log.println(this, 7, "CRL has not been loaded yet.");
            return true;
        }
        if (this.certificateRevokeList.containsKey(string)) {
            this.log.println(this, 7, string + " has been revoked.");
            return true;
        }
        return false;
    }

    public void downloadPatches(PatchList patchList, Object object) throws DownloadPatchException, NotSupportedException {
        this.updateSessionData = false;
        this.downloadPatches(patchList, object, null);
    }

    public void downloadPatches(PatchList patchList, Object object, SessionData sessionData) throws DownloadPatchException, NotSupportedException {
        this.log.println(this, 7, "Entered FileSystemPatchServiceProvider: downloadPatches");
        this.properties = sessionData != null ? sessionData.getProperties() : PatchProProperties.getInstance();
        if (object instanceof OutputStream) {
            this.downloadDestination = object;
            byte[] byArray = new byte[102400];
            int n = 0;
            FileInputStream fileInputStream = null;
            String string = null;
            String string2 = null;
            int n2 = 0;
            while (n2 < patchList.size()) {
                block37: {
                    PatchNotAvailableException patchNotAvailableException;
                    Patch patch;
                    try {
                        patch = patchList.getPatchAt(n2);
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        this.log.printStackTrace(this, 2, noSuchPatchException);
                        break block37;
                    }
                    try {
                        string = this.findLatestPatch(patch.getPatchID().getPatchID());
                        string2 = this.patchSourceLocation + File.separator + string + ".jar";
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        this.log.println(this, 4, noSuchPatchException.getMessage() + " " + string);
                        if (this.updateSessionData) {
                            sessionData.addPatchUnavailable(new IPatch(patch));
                            patchNotAvailableException = new PatchNotAvailableException("PatchNotAvailableException", "PatchNotAvailableException.MESSAGE", "PatchNotAvailableException.REMEDY", 3);
                            sessionData.addPatchProException(patchNotAvailableException);
                        }
                        break block37;
                    }
                    try {
                        fileInputStream = new FileInputStream(string2);
                        while ((n = fileInputStream.read(byArray)) != -1) {
                            ((OutputStream)this.downloadDestination).write(byArray, 0, n);
                        }
                        try {
                            if (this.updateSessionData) {
                                sessionData.addPatchDownloaded(new IPatch(new PatchImpl(new PatchID(string))));
                            }
                            this.log.println(this, 7, "FileSystemPatchServiceProvider: downloadPatches: The patch added to returning resultantPatchList." + string);
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println(this, 4, "ServerPatchServiceProvider: A patch was found to be incorrectly formed " + malformedPatchException.getMessage());
                            this.log.printStackTrace(this, 3, malformedPatchException);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (this.updateSessionData) {
                            sessionData.addPatchUnavailable(new IPatch(patch));
                            patchNotAvailableException = new PatchNotAvailableException("PatchNotAvailableException", "PatchNotAvailableException.MESSAGE", "PatchNotAvailableException.REMEDY", 3);
                            sessionData.addPatchProException(patchNotAvailableException);
                        }
                        this.log.println(this, 4, "Patch cannot be found.  " + string);
                        this.log.println(this, 4, string2);
                        this.log.printStackTrace(this, 4, fileNotFoundException);
                    }
                    catch (IOException iOException) {
                        this.log.println(this, 4, FAIL_TO_DOWNLOAD);
                        this.log.printStackTrace(this, 4, iOException);
                    }
                }
                ++n2;
            }
        } else if (object instanceof String) {
            String string = (String)object;
            this.patchBundlePrefix = string.indexOf("%") != -1 ? PatchServiceUtil.generateTimeStampedString(string) : string + System.getProperty("file.separator");
            this.downloadDestination = this.getPatchBundlePrefix();
            File file = new File(this.patchBundlePrefix);
            if (!file.exists()) {
                file.mkdirs();
            }
            byte[] byArray = new byte[102400];
            int n = 0;
            File file2 = new File(this.patchBundlePrefix);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n3 = 0;
            while (n3 < patchList.size()) {
                block38: {
                    PatchNotAvailableException patchNotAvailableException;
                    Patch patch;
                    try {
                        patch = patchList.getPatchAt(n3);
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        this.log.printStackTrace(this, 2, noSuchPatchException);
                        break block38;
                    }
                    try {
                        string3 = this.findLatestPatch(patch.getPatchID().getPatchID());
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        this.log.println(this, 4, noSuchPatchException.getMessage() + " " + string3);
                        if (this.updateSessionData) {
                            sessionData.addPatchUnavailable(new IPatch(patch));
                            patchNotAvailableException = new PatchNotAvailableException("PatchNotAvailableException", "PatchNotAvailableException.MESSAGE", "PatchNotAvailableException.REMEDY", 3);
                            sessionData.addPatchProException(patchNotAvailableException);
                        }
                        break block38;
                    }
                    string5 = this.patchSourceLocation + string3 + ".jar";
                    string4 = this.patchBundlePrefix + string3 + ".jar";
                    try {
                        file2 = new File(string4);
                        if (!file2.exists()) {
                            file2.createNewFile();
                            fileInputStream = new FileInputStream(string5);
                            fileOutputStream = new FileOutputStream(string4);
                            while ((n = fileInputStream.read(byArray)) != -1) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                            fileOutputStream.close();
                            fileInputStream.close();
                            this.log.println(this, 7, "FileSystemPatchServiceProvider: Transferred patch from " + string5 + " to " + string4);
                            if (this.updateSessionData) {
                                sessionData.addPatchDownloaded(new IPatch(patch));
                            }
                            this.log.println(this, 7, "FileSystemPatchServiceProvider: downloadPatches: The patch added to returning resultantPatchList." + string3);
                        } else if (this.updateSessionData) {
                            sessionData.addPatchAlreadyPresent(new IPatch(patch));
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (this.updateSessionData) {
                            sessionData.addPatchUnavailable(new IPatch(patch));
                            patchNotAvailableException = new PatchNotAvailableException("PatchNotAvailableException", "PatchNotAvailableException.MESSAGE", "PatchNotAvailableException.REMEDY", 3);
                            sessionData.addPatchProException(patchNotAvailableException);
                        }
                        this.log.println(this, 4, "Patch cannot be found.  " + string3);
                        this.log.println(this, 4, string5);
                        this.log.printStackTrace(this, 4, fileNotFoundException);
                    }
                    catch (IOException iOException) {
                        if (this.updateSessionData) {
                            sessionData.addPatchUnavailable(new IPatch(patch));
                            PatchNotAvailableException patchNotAvailableException2 = new PatchNotAvailableException("PatchNotAvailableException", "PatchNotAvailableException.MESSAGE", "PatchNotAvailableException.REMEDY", 3);
                            sessionData.addPatchProException(patchNotAvailableException2);
                        }
                        this.log.println(this, 4, FAIL_TO_DOWNLOAD);
                        this.log.printStackTrace(this, 4, iOException);
                    }
                }
                ++n3;
            }
        } else {
            if (this.updateSessionData) {
                sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage("PsUnavailablePatch", "This patch could not be found"));
                PatchNotAvailableException patchNotAvailableException = new PatchNotAvailableException("PatchNotAvailableException", "PatchNotAvailableException.MESSAGE", "PatchNotAvailableException.REMEDY", 3);
                sessionData.addPatchProException(patchNotAvailableException);
            }
            throw new DownloadPatchException(UNKNOWN_DESTINATION_TYPE);
        }
        this.log.println(this, 7, "FileSystemPatchServiceProvider: downloadPatches: returning resultantPatchList.");
    }

    private void loadCRL(PatchProProperties patchProProperties) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = patchProProperties.getProperty("patchpro.security.crl.source.url");
        this.log.println(this, 7, "crlSourceURLStr: " + string);
        if (string == null) {
            this.crlSourceLocation = DEFAULT_CRL_SOURCE_LOCATION;
        } else {
            object4 = null;
            try {
                object4 = new URL(string);
                object3 = ((URL)object4).getProtocol();
                this.crlSourceLocation = ((String)object3).compareTo("file") == 0 ? (((File)(object2 = new File((String)(object = ((URL)object4).getPath())))).isAbsolute() ? object : patchProProperties.getProperty("patchpro.installdir.ppro") + File.separator + (String)object) : DEFAULT_CRL_SOURCE_LOCATION;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                this.log.printStackTrace(this, 4, malformedURLException);
                this.crlSourceLocation = DEFAULT_CRL_SOURCE_LOCATION;
            }
        }
        this.log.println(this, 7, "crlSourceLocation: " + this.crlSourceLocation);
        object4 = patchProProperties.getProperty("patchpro.security.kslocation");
        this.log.println(this, 7, "keystoreLocation: " + (String)object4);
        if (object4 == null) {
            this.crlLoaded = false;
            this.log.println(this, 2, "patchpro.security.kslocation is not defined.");
            return;
        }
        object3 = new File((String)object4);
        if (!((File)object3).exists()) {
            this.crlLoaded = false;
            this.log.println(this, 2, (String)object4 + " does not exist.");
            return;
        }
        object = null;
        try {
            object2 = new FileInputStream((String)object4);
            object = KeyStore.getInstance("JKS", "SUN");
            ((KeyStore)object).load((InputStream)object2, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.log.println(this, 2, "Having problem loading the keystore: " + (String)object4);
            this.log.printStackTrace(this, 2, noSuchAlgorithmException);
            this.crlLoaded = false;
            return;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            this.log.println(this, 2, "Having problem loading the keystore: " + (String)object4);
            this.log.printStackTrace(this, 2, noSuchProviderException);
            this.crlLoaded = false;
            return;
        }
        catch (CertificateException certificateException) {
            this.log.println(this, 2, "Having problem loading the keystore: " + (String)object4);
            this.log.printStackTrace(this, 2, certificateException);
            this.crlLoaded = false;
            return;
        }
        catch (IOException iOException) {
            this.log.println(this, 2, "Having problem loading the keystore: " + (String)object4);
            this.log.printStackTrace(this, 2, iOException);
            this.crlLoaded = false;
            return;
        }
        catch (KeyStoreException keyStoreException) {
            this.log.println(this, 2, "Having problem loading the keystore: " + (String)object4);
            this.log.printStackTrace(this, 2, keyStoreException);
            this.crlLoaded = false;
            return;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(this.crlSourceLocation, true);
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
            this.crlLoaded = false;
            return;
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        InputStream inputStream = null;
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            if (((ZipEntry)object2).getName().compareTo(CRL_TEXT_FILE_NAME) != 0) continue;
            try {
                inputStream = jarFile.getInputStream((ZipEntry)object2);
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
                this.crlLoaded = false;
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = "";
            try {
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.indexOf("#") == 0) {
                        this.log.println(this, 7, "Read comment: " + string2);
                        continue;
                    }
                    if (this.debug) {
                        System.out.println("Read revoked certificate: " + string2);
                    }
                    this.log.println(this, 7, "Read revoked certificate: " + string2);
                    this.certificateRevokeList.put(string2, string2);
                }
                bufferedReader.close();
            }
            catch (SecurityException securityException) {
                this.crlLoaded = false;
                if (this.debug) {
                    System.out.println("Signature/digest check failed.");
                }
                this.log.println(this, 2, "Signature/digest check failed.");
                this.log.printStackTrace(this, 2, securityException);
                return;
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
                this.crlLoaded = false;
                return;
            }
            Certificate[] certificateArray = ((JarEntry)object2).getCertificates();
            if (certificateArray != null) {
                String string3 = null;
                boolean bl = false;
                int n = 0;
                while (n < certificateArray.length) {
                    try {
                        string3 = ((KeyStore)object).getCertificateAlias(certificateArray[n]);
                    }
                    catch (KeyStoreException keyStoreException) {
                        this.log.printStackTrace(this, 2, keyStoreException);
                        this.crlLoaded = false;
                        return;
                    }
                    if (string3 != null) {
                        bl = true;
                    }
                    this.log.println(this, 7, "Signing certificate alias is: " + string3);
                    this.log.println(this, 7, "Cert match found in the keystore? " + bl);
                    ++n;
                }
                if (bl) {
                    this.crlLoaded = true;
                } else {
                    this.crlLoaded = false;
                    if (this.debug) {
                        System.out.println("The CRL's not signed by trusted party. Stopped loading CRL.");
                    }
                    this.log.println(this, 2, "The CRL's not signed by trusted party. Stopped loading CRL.");
                }
            } else {
                this.crlLoaded = false;
                if (this.debug) {
                    System.out.println("The CRL's not signed. Stopped loading CRL.");
                }
                this.log.println(this, 2, "The CRL's not signed. Stopped loading CRL.");
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
                return;
            }
        }
    }

    public String findExactPatch(String string) {
        return string;
    }

    public String findLatestPatch(String string) throws NoSuchPatchException {
        this.log.println(this, 7, "Entered FileSystemPatchServiceProvider.findLatestPatch()");
        boolean bl = false;
        String string2 = "";
        String string3 = string;
        string2 = this.getNextRevPatch(string, 0);
        bl = false;
        while (!bl && string2.compareTo(string) != 0) {
            if (this.patchExists(string2) != 0L) {
                this.log.println(this, 7, " FileSystemPatchServiceProvider.findLatestPatch(): newer revision of the patch exists.");
                bl = true;
                string = string2;
                continue;
            }
            this.log.println(this, 7, " Entered FileSystemPatchServiceProvider.findLatestPatch(): newer revision of the patch does not exist.");
            string2 = this.getNextRevPatch(string2, -1);
        }
        if (string2.compareTo(string3) == 0 && this.patchExists(string2) == 0L) {
            throw new NoSuchPatchException(PATCH_NOT_FOUND);
        }
        this.log.println(this, 7, "FileSystemPatchServiceProvider.findLatestPatch(): Latest patch is: " + string2);
        return string2;
    }

    private long patchExists(String string) {
        String string2 = this.patchSourceLocation + File.separator + string + ".jar";
        File file = new File(string2);
        return file.length();
    }

    private String getNextRevPatch(String string, int n) {
        int n2 = this.parseRev(string);
        int n3 = (n2 + n) % 100;
        return string.substring(0, string.length() - 2) + (n3 < 10 ? "0" + String.valueOf(n3) : String.valueOf(n3));
    }

    private int parseRev(String string) {
        int n = string.length();
        String string2 = string.substring(n - 2, n);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        return n2;
    }
}

