/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.security;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.security.ManifestFileNotFoundException;
import com.sun.patchpro.security.NoKeystorePresentException;
import com.sun.patchpro.security.NoSigningCertException;
import com.sun.patchpro.security.NotSignedByKnownCertificateException;
import com.sun.patchpro.security.SignatureCheckFailedException;
import com.sun.patchpro.security.SignatureValidationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class SignatureValidationUtil {
    private static final int BUFFER_SIZE = 8192;
    private static final String NO_X509_CERT_FOUND = "The specified certificate cannot be found.";
    private static final String NOT_X509_CERT = "The specified certificate is not in X.509 format.";
    private static final String JARFILE_NOT_READABLE = "The specific Jar file is not readable.";
    private PatchProLog log;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private X509Certificate knownCertificate;
    private X509Certificate[] knownCertificates;
    private String keystoreLocation = null;
    private String certificateAlias = null;
    private String[] certificateAliases;
    private X509Certificate knownCert;

    public SignatureValidationUtil(String string, String string2) throws SignatureValidationException {
        this(string, new String[]{string2});
    }

    public SignatureValidationUtil(String string, String[] stringArray) throws SignatureValidationException {
        this.log = PatchProLog.getInstance();
        this.keystoreLocation = string;
        int n = stringArray.length;
        this.certificateAliases = new String[n];
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            KeyStore keyStore = KeyStore.getInstance("JKS", "SUN");
            keyStore.load(fileInputStream, null);
            int n2 = 0;
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            Vector<String> vector2 = new Vector<String>();
            int n3 = 0;
            while (n3 < n) {
                String string2 = stringArray[n3];
                Certificate certificate = keyStore.getCertificate(string2);
                if (certificate == null && n3 < n - 1) {
                    ++n2;
                } else if (certificate == null && n3 == n - 1) {
                    if (n2 == n3) {
                        throw new SignatureValidationException(NO_X509_CERT_FOUND);
                    }
                } else {
                    if (!(certificate instanceof X509Certificate)) {
                        throw new SignatureValidationException(NOT_X509_CERT);
                    }
                    this.knownCertificate = (X509Certificate)certificate;
                    vector.add(this.knownCertificate);
                    vector2.add(string2);
                    Object[] objectArray = vector.toArray();
                    this.knownCertificates = new X509Certificate[objectArray.length];
                    int n4 = 0;
                    while (n4 < objectArray.length) {
                        this.knownCertificates[n4] = (X509Certificate)objectArray[n4];
                        ++n4;
                    }
                    Object[] objectArray2 = vector2.toArray();
                    this.certificateAliases = new String[objectArray2.length];
                    int n5 = 0;
                    while (n5 < objectArray2.length) {
                        this.certificateAliases[n5] = (String)objectArray2[n5];
                        ++n5;
                    }
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            throw new SignatureValidationException(exception.toString());
        }
    }

    public String getKeystoreLocation() {
        return this.keystoreLocation;
    }

    public String[] getCertificateAliases() {
        return this.certificateAliases;
    }

    public void validateJarFile(String string) throws ManifestFileNotFoundException, SignatureCheckFailedException, NotSignedByKnownCertificateException, SignatureValidationException {
        boolean bl = true;
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            throw new SignatureValidationException(JARFILE_NOT_READABLE);
        }
        try {
            JarFile jarFile = new JarFile(string, true);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                jarFile.close();
                throw new ManifestFileNotFoundException();
            }
            byte[] byArray = new byte[8192];
            boolean bl2 = true;
            Enumeration<JarEntry> enumeration = jarFile.entries();
            InputStream inputStream = null;
            JarEntry jarEntry = null;
            while (enumeration.hasMoreElements()) {
                bl2 = true;
                jarEntry = enumeration.nextElement();
                if (jarEntry.getSize() == 0L) {
                    this.log.println(this, 7, "Skipping " + jarEntry.getName() + " because its length is: 0 byte.");
                    continue;
                }
                try {
                    inputStream = jarFile.getInputStream(jarEntry);
                    int n = 0;
                    while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    }
                }
                catch (SecurityException securityException) {
                    bl2 = false;
                    bl = false;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    throw new SignatureCheckFailedException();
                }
                inputStream.close();
                if (!bl2 || jarEntry.getName().indexOf("META-INF") != -1 || this.matchCerts(this.knownCertificates, jarEntry.getCertificates())) continue;
                bl = false;
                jarFile.close();
                throw new NotSignedByKnownCertificateException(jarEntry.getName() + " " + this.knownCert.getSubjectDN().getName());
            }
            jarFile.close();
        }
        catch (IOException iOException) {
            bl = false;
            this.log.printStackTrace(this, 4, iOException);
            throw new SignatureValidationException(iOException.getMessage());
        }
    }

    private boolean matchCerts(X509Certificate[] x509CertificateArray, Certificate[] certificateArray) {
        int n = 0;
        while (n < x509CertificateArray.length) {
            this.knownCert = x509CertificateArray[n];
            if (!(this.knownCert instanceof X509Certificate)) {
                this.log.println(this, 4, "The known certificate: " + this.knownCert + "  is not a X.509 certificate.");
                return false;
            }
            Principal principal = this.knownCert.getIssuerDN();
            BigInteger bigInteger = this.knownCert.getSerialNumber();
            if (certificateArray == null || certificateArray.length == 0) {
                this.log.println(this, 4, "The signing certificates (signingCerts) is null.");
                return false;
            }
            int n2 = 0;
            while (n2 < certificateArray.length) {
                if (!(certificateArray[n2] instanceof X509Certificate)) {
                    return false;
                }
                X509Certificate x509Certificate = (X509Certificate)certificateArray[n2];
                if (principal.getName().compareTo(x509Certificate.getIssuerDN().getName()) == 0 && bigInteger.compareTo(x509Certificate.getSerialNumber()) == 0) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public static SignatureValidationUtil getValidationUtility(PatchProProperties patchProProperties, SignatureValidationUtil signatureValidationUtil) throws NoKeystorePresentException, NoSigningCertException {
        SignatureValidationUtil signatureValidationUtil2 = null;
        if (signatureValidationUtil != null) {
            signatureValidationUtil2 = signatureValidationUtil;
        } else {
            if (!patchProProperties.keystoreIsPresent()) {
                throw new NoKeystorePresentException("PatchBundleInstaller.KEYSTORE_LOCATION_NOT_DEFINED");
            }
            String string = patchProProperties.getProperty("patchpro.security.kslocation");
            String string2 = patchProProperties.getProperty("patchpro.security.patch.signingcert.alias", "patchsigning");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            int n = stringTokenizer.countTokens();
            boolean bl = false;
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (vector.contains(string3)) continue;
                vector.add(string3);
            }
            Object[] objectArray = vector.toArray();
            String[] stringArray = new String[objectArray.length];
            int n2 = 0;
            while (n2 < objectArray.length) {
                stringArray[n2] = (String)objectArray[n2];
                ++n2;
            }
            try {
                signatureValidationUtil2 = new SignatureValidationUtil(string, stringArray);
            }
            catch (SignatureValidationException signatureValidationException) {
                signatureValidationException.getMessage();
                throw new NoSigningCertException("PatchBundleInstaller.FAILED_TO_CREATE_VALIDATION_UTIL", string2);
            }
        }
        return signatureValidationUtil2;
    }
}

