/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.patch;

import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.interpreter.HostSpecificInterpreter;
import com.sun.patchpro.interpreter.ParseError;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.SequencerEvent;
import com.sun.patchpro.model.SequencerListener;
import com.sun.patchpro.patch.IPair;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.IPatchList;
import com.sun.patchpro.patch.IncompatList;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.MissingPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class PatchSequencer {
    private IPatchList initialPatchList;
    private PatchListImpl finalList;
    private PatchListImpl workingList;
    private PatchListImpl existingPatches;
    private IncompatList incompatlist;
    private PatchProLog log;
    private Locale locale;
    private LocalizedMessages catalog;
    private Vector oblist;
    private HostSpecificInterpreter interpreter;
    private PatchDB patchdb;
    private float complete;
    private Vector listeners;
    private boolean shutdown;
    private boolean sequencerRunning;
    private boolean obsolescingPatchInstalled;
    static final int OBSO_PROC_ERR = 0;
    static final int OBSO_LOOP_ERR = 1;
    static final int REQ_PARSE_ERR = 2;
    static final int REQ_INVALID_ID = 3;
    static final int REQ_LOOP_ERR = 4;
    static final int NO_REQ_ERR = 5;
    static final int NO_PREF_ERR = 6;
    static final int PREF_PARSE_ERR = 7;
    static final int INCOMPAT_PARSE_ERR = 8;
    static final int INCOMPAT_INVALID_ID = 9;
    static final int INCOMPAT_PATCH = 10;
    static final int COUNT = 10;
    static final int SLEEP = 1000;
    String[][] errStrings = new String[][]{{"PsObsoProcErr", "-Could not find obsolescing patch"}, {"PsObsoLoopErr", "-The obsolesced field loops back to this patch"}, {"PsReqParseErr", "-Error when parsing the required field"}, {"PsReqInvalidId", "-Invalid PatchID in the required field"}, {"PsReqLoopErr", "-The required field loops back to this patch"}, {"PsNoReqErr", "-Requires a patch that could not be found"}, {"PsNoPrefErr", "-Prefers a patch that could not be found"}, {"PsPrefParseErr", "-Error when parsing the preferred field"}, {"PsIncompatParseErr", "-Error when parsing the incompatible field"}, {"PsIncompatInvalidId", "-Invalid PatchID in the incompatible field"}, {"PsIncompatPatch", "-This patch is incompatible with patch(s)"}};

    public PatchSequencer(HostSpecificInterpreter hostSpecificInterpreter, PatchDB patchDB, Locale locale) {
        this.interpreter = hostSpecificInterpreter;
        this.patchdb = patchDB;
        this.locale = locale;
        this.log = PatchProLog.getInstance();
        this.catalog = locale != null ? new LocalizedMessages(locale) : new LocalizedMessages(Locale.ENGLISH);
        this.listeners = new Vector();
    }

    /*
     * Unable to fully structure code
     */
    private IPatchList getPatchListFromRealizations(Enumeration var1_1) {
        var2_2 = this;
        synchronized (var2_2) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        var3_4 = new IPatchList();
        var4_5 = null;
        var5_6 = null;
        var6_7 = null;
        var10_8 = new Vector<E>();
        while (var1_1.hasMoreElements()) {
            var10_8.addElement(var1_1.nextElement());
        }
        var11_9 = 100.0f / (float)var10_8.size();
        this.complete = 0.0f;
        this.log.println(this, 7, "PatchSequencer.getPatchListFromRealizations(): Realization list is " + var1_1);
        var12_10 = 0;
        while (var12_10 < var10_8.size()) {
            block14: {
                this.progressUpdate();
                this.complete += var11_9;
                var8_12 = var10_8.elementAt(var12_10);
                if (!(var8_12 instanceof Realization)) break block14;
                var9_13 = (Realization)var8_12;
                try {
                    var7_11 = this.patchdb.getPatches(var9_13);
                    if (true) ** GOTO lbl57
                }
                catch (NoSuchPatchException var13_15) {
                    break block14;
                }
                do {
                    var14_16 = false;
                    var8_12 = var7_11.nextElement();
                    if (!(var8_12 instanceof PatchImpl)) continue;
                    var4_5 = (PatchImpl)var8_12;
                    this.log.println(this, 7, "PatchSequencer.getPatchListFromRealizations(): Realization is: " + var9_13.getRealizationString() + " Patch " + var4_5.getPatchID().getPatchID());
                    var13_14 = var4_5.getPatchInfo().getConstraint();
                    if (var13_14 != null && var13_14.compareTo("") != 0 && var13_14.indexOf("(") != -1) {
                        try {
                            if (this.interpreter.getExitCode(var13_14) != 0) {
                                var14_16 = true;
                            }
                        }
                        catch (ParseError var15_17) {
                            this.log.println(this, 4, "PatchSequencer.getPatchListFromRealizations(): Patch " + var4_5.getPatchID().getPatchID() + " contains a malformed constraint " + "expression.");
                            this.log.printStackTrace(this, 4, var15_17);
                        }
                    }
                    if (var14_16) continue;
                    this.log.println(this, 7, "PatchSequencer.getPatchListFromRealizations():  Adding Patch " + var4_5.getPatchID().getPatchID() + " to the patchlist to be returned.");
                    var6_7 = var3_4.getIPatchByIDString(var4_5.getPatchID().getPatchID());
                    if (var6_7 == null) {
                        var5_6 = new IPatch(var4_5, 2002);
                        var5_6.addRealization(var9_13);
                        var3_4.addIPatch(var5_6);
                        continue;
                    }
                    var5_6 = var6_7;
                    var5_6.addRealization(var9_13);
lbl57:
                    // 5 sources

                } while (var7_11.hasMoreElements());
            }
            ++var12_10;
        }
        return var3_4;
    }

    public PatchListImpl getPatchList(Enumeration enumeration) {
        return this.getPatchList(enumeration, new PatchListImpl());
    }

    public PatchListImpl getPatchList(Enumeration enumeration, PatchListImpl patchListImpl) {
        if (enumeration == null) {
            this.sendDoneEvent();
            PatchSequencer patchSequencer = this;
            synchronized (patchSequencer) {
                this.sequencerRunning = false;
            }
            return new PatchListImpl();
        }
        return this.getPatchList(this.getPatchListFromRealizations(enumeration), patchListImpl);
    }

    public PatchListImpl getPatchList(IPatchList iPatchList, PatchListImpl patchListImpl) {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            this.sequencerRunning = true;
        }
        if (this.interpreter == null || this.patchdb == null) {
            this.sendDoneEvent();
            PatchSequencer patchSequencer2 = this;
            synchronized (patchSequencer2) {
                this.sequencerRunning = false;
            }
        }
        try {
            this.finalList = this.evaluatePatchList(iPatchList, patchListImpl);
        }
        catch (Error error) {
            PatchSequencer patchSequencer3 = this;
            synchronized (patchSequencer3) {
                this.sequencerRunning = false;
                if (!this.shutdown) {
                    throw error;
                }
                this.shutdown = false;
                this.log.println(this, 6, "Sequencer shut down.");
            }
        }
        return this.finalList;
    }

    private PatchListImpl evaluatePatchList(IPatchList iPatchList, PatchListImpl patchListImpl) {
        this.finalList = new PatchListImpl();
        this.existingPatches = patchListImpl;
        this.initialPatchList = iPatchList;
        this.workingList = new PatchListImpl();
        this.incompatlist = new IncompatList();
        IPatch iPatch = null;
        PatchID patchID = null;
        Object var5_5 = null;
        boolean bl = true;
        this.obsolescingPatchInstalled = false;
        while (this.initialPatchList.size() != 0) {
            iPatch = this.initialPatchList.getIPatchAt(0);
            iPatch.setRequired();
            patchID = iPatch.getPatchID();
            this.log.println(this, 7, "PatchSequencer.evaluatePatchList(): The patch being processed in the initialPatchList is " + patchID.getPatchID());
            bl = this.removeExistingPatch(patchID);
            if (bl) {
                this.log.println(this, 7, "PatchSequencer.evaluatePatchList(): Patch is installed on the system.");
                this.initialPatchList.removeIPatch(iPatch);
                continue;
            }
            this.processPatch(iPatch);
        }
        this.markIncompats();
        return this.finalList;
    }

    public PatchListImpl augmentPatchList(PatchID[] patchIDArray, PatchListImpl patchListImpl) {
        Object object;
        Object object2;
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            this.sequencerRunning = true;
        }
        if (this.interpreter == null || this.patchdb == null || patchIDArray == null) {
            this.sendDoneEvent();
            object2 = this;
            synchronized (object2) {
                this.sequencerRunning = false;
            }
        }
        object2 = new PatchListImpl();
        try {
            object = null;
            int n = 0;
            while (n < patchIDArray.length) {
                try {
                    object = this.patchdb.getLatestPatch(patchIDArray[n]);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    object = new PatchImpl(patchIDArray[n]);
                }
                ((IPatchList)object2).addIPatch(new IPatch((PatchImpl)object));
                object2 = this.evaluatePatchList((IPatchList)object2, patchListImpl);
                ++n;
            }
        }
        catch (Error error) {
            PatchSequencer patchSequencer2 = this;
            synchronized (patchSequencer2) {
                this.sequencerRunning = false;
                if (!this.shutdown) {
                    throw error;
                }
                this.shutdown = false;
                this.log.println(this, 6, "Sequencer shut down.");
            }
        }
        this.sendDoneEvent();
        object = this;
        synchronized (object) {
            this.sequencerRunning = false;
        }
        return object2;
    }

    public void cancel() {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.sequencerRunning) {
                this.log.println(this, 6, "Shutting down sequencer.");
                this.shutdown = true;
                new InnerCancelThread().start();
            }
        }
    }

    private void removeExistingPatches(PatchListImpl patchListImpl) {
        PatchImpl patchImpl;
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        int n = 0;
        while ((patchImpl = patchListImpl.getPatchImplAt(n)) != null) {
            PatchImpl patchImpl2;
            int n2 = 0;
            while ((patchImpl2 = this.finalList.getPatchImplAt(n2)) != null) {
                if (patchImpl2.isEquivalentTo(patchImpl)) {
                    this.finalList.removeIPatch(new IPatch(patchImpl2));
                }
                ++n2;
            }
            ++n;
        }
    }

    public void markIncompats() {
        if (this.incompatlist.size() == 0) {
            return;
        }
        int n = 0;
        while (n < this.finalList.size()) {
            IPatch iPatch = this.finalList.getIPatchAt(n);
            Enumeration enumeration = this.incompatlist.getIncompatPatchIDs(iPatch.getPatchID());
            StringBuffer stringBuffer = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                PatchID patchID = (PatchID)enumeration.nextElement();
                if (this.finalList.getIPatchByID(patchID) == null) continue;
                stringBuffer.append(patchID.getPatchID() + " ");
            }
            if (new String(stringBuffer).compareTo("") != 0) {
                iPatch.setError(this.catalog.getMessage(this.errStrings[10][0], this.errStrings[10][1]) + " " + stringBuffer);
            }
            ++n;
        }
    }

    private void processPatch(IPatch iPatch) {
        IPatch iPatch2;
        PatchID patchID;
        int n;
        String[] stringArray;
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        Object var3_4 = null;
        boolean bl = true;
        this.obsolescingPatchInstalled = false;
        if (iPatch == null) {
            return;
        }
        bl = this.removeExistingPatch(iPatch.getPatchID());
        if (bl) {
            this.log.println(this, 7, "PatchSequencer.processPatch(): Patch is installed on the system.");
            this.initialPatchList.removeIPatch(iPatch);
            return;
        }
        this.log.println(this, 7, "PatchSequencer.processPatch(): Patch is not installed on the system.");
        int n2 = iPatch.getState();
        IPatch iPatch3 = null;
        IPatch iPatch4 = null;
        try {
            iPatch3 = this.getObsolescingIPatch(iPatch);
            this.clearCircularObsolescence();
        }
        catch (MissingPatchException missingPatchException) {
            this.log.println(this, 4, "PatchSequencer: Obsolesce processing failed for patch " + iPatch.getPatchID().getPatchID() + "Exception " + missingPatchException.getMessage());
            this.markSingleError(iPatch, this.getLocaleMessage(0));
            this.finalizePatch(iPatch);
            return;
        }
        catch (NoSuchPatchException noSuchPatchException) {
            iPatch3 = iPatch;
        }
        if (this.obsolescingPatchInstalled) {
            return;
        }
        iPatch3.setState(n2);
        iPatch4 = this.workingList.getIPatchByID(iPatch3.getPatchID());
        if (iPatch4 != null) {
            if (!iPatch4.hasError()) {
                this.markLoopError(iPatch3);
            }
            this.finalizePatch(iPatch3);
            return;
        }
        IPatch iPatch5 = this.finalList.getIPatchByID(iPatch3.getPatchID());
        if (iPatch5 != null) {
            iPatch5.setState(n2);
            return;
        }
        this.workingList.addIPatch(iPatch3);
        try {
            stringArray = this.getPatchStringsFromExpression(iPatch3.getPatchInfo().getRequires());
            try {
                n = 0;
                patchID = null;
                while (stringArray != null) {
                    try {
                        patchID = new PatchID(stringArray[n]);
                    }
                    catch (MalformedPatchException malformedPatchException) {
                        this.log.println(this, 4, "PatchSequencer: A required patch was found to be incorrectly formed " + malformedPatchException.getMessage());
                        this.markSingleError(iPatch3, this.getLocaleMessage(5));
                    }
                    bl = this.removeExistingPatch(patchID);
                    if (bl) {
                        ++n;
                        this.log.println(this, 7, "PatchSequencer.processPatch(): required patch is installed on the system.");
                        continue;
                    }
                    try {
                        iPatch2 = this.getIPatchFromDB(patchID);
                        iPatch2.setState(n2);
                        this.processPatch(iPatch2);
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        this.log.println(this, 4, "PatchSequencer: A required patch could not be found " + stringArray[n] + "Exception " + noSuchPatchException.getMessage());
                        this.markSingleError(iPatch3, this.getLocaleMessage(5));
                    }
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        catch (ParseError parseError) {
            this.markSingleError(iPatch3, this.getLocaleMessage(2));
            this.finalizePatch(iPatch3);
            return;
        }
        try {
            stringArray = this.getPatchStringsFromExpression(iPatch3.getPatchInfo().getPrefers());
            try {
                n = 0;
                patchID = null;
                while (stringArray != null) {
                    try {
                        patchID = new PatchID(stringArray[n]);
                    }
                    catch (MalformedPatchException malformedPatchException) {
                        this.log.println(this, 4, "PatchSequencer: A required patch was found to be incorrectly formed " + malformedPatchException.getMessage());
                        this.markSingleError(iPatch3, this.getLocaleMessage(6));
                    }
                    bl = this.removeExistingPatch(patchID);
                    if (bl) {
                        ++n;
                        this.log.println(this, 7, "PatchSequencer.processPatch(): preferred patch is installed on the system.");
                        continue;
                    }
                    try {
                        iPatch2 = this.getIPatchFromDB(patchID);
                        iPatch2.setState(2001);
                        this.processPatch(iPatch2);
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        this.log.println(this, 4, "PatchSequencer: A preferred patch could not be found " + stringArray[n] + "Exception " + noSuchPatchException.getMessage());
                        this.markSingleError(iPatch3, this.getLocaleMessage(6));
                    }
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        catch (ParseError parseError) {
            this.markSingleError(iPatch3, this.getLocaleMessage(2));
            this.finalizePatch(iPatch3);
            return;
        }
        this.processIncompat(iPatch3);
        this.finalizePatch(iPatch3);
    }

    public Enumeration getIPatchesFromString(String string) throws ParseError, NoSuchPatchException, MalformedPatchException {
        Vector<IPatch> vector = new Vector<IPatch>();
        String[] stringArray = this.getPatchStringsFromExpression(string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(this.getIPatchFromDB(new PatchID(stringArray[n])));
                ++n;
            }
        }
        return vector.elements();
    }

    private IPatch getObsolescingIPatch(IPatch iPatch) throws MissingPatchException, NoSuchPatchException {
        IPatch iPatch2;
        boolean bl = true;
        this.log.println(this, 7, "PatchSequencer.getObsolescingIPatch(): Entered getObsolescingIPatch().");
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        if (!iPatch.getPatchInfo().getProperties().isObsolete()) {
            return iPatch;
        }
        this.log.println(this, 7, "PatchSequencer.getObsolescingIPatch(): The patch " + iPatch.getPatchID().getPatchID() + " is obsolete.");
        PatchID patchID = iPatch.getPatchInfo().getObsolescedBy();
        this.log.println(this, 7, "PatchSequencer.getObsolescingIPatch(): The patch " + iPatch.getPatchID().getPatchID() + "is obsolesced by " + patchID.getPatchID());
        bl = this.removeExistingPatch(patchID);
        if (bl) {
            this.log.println(this, 7, "PatchSequencer.getObsolescingIPatch(): Obsolecing patch is installed on the system.");
            this.obsolescingPatchInstalled = true;
            this.initialPatchList.removeIPatch(iPatch);
            return iPatch;
        }
        try {
            iPatch2 = this.getIPatchFromDB(patchID);
        }
        catch (NoSuchPatchException noSuchPatchException) {
            throw new MissingPatchException("PatchSequencer.getObsolescingIPatch(): Missing obsolescing patch.");
        }
        this.finalizeObsoletePatch(iPatch);
        if (this.checkForCircularObsolescence(iPatch2)) {
            this.markObsolescenceLoopError(iPatch);
            return iPatch;
        }
        try {
            return this.getObsolescingIPatch(iPatch2);
        }
        catch (NoSuchPatchException noSuchPatchException) {
            return iPatch2;
        }
    }

    private void clearCircularObsolescence() {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        this.oblist = null;
    }

    private boolean checkForCircularObsolescence(IPatch iPatch) {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        if (this.oblist == null) {
            this.oblist = new Vector();
            if (this.oblist != null) {
                this.oblist.addElement(iPatch);
            }
            return false;
        }
        Enumeration enumeration = this.oblist.elements();
        String string = iPatch.getPatchID().getPatchID();
        while (enumeration.hasMoreElements()) {
            IPatch iPatch2 = (IPatch)enumeration.nextElement();
            if (string.compareTo(iPatch2.getPatchID().getPatchID()) != 0) continue;
            return true;
        }
        this.oblist.addElement(iPatch);
        return false;
    }

    private void markObsolescenceLoopError(IPatch iPatch) {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        this.markSingleError(iPatch, this.getLocaleMessage(1) + " " + iPatch.getPatchID().getPatchID());
        boolean bl = false;
        String string = iPatch.getPatchID().getPatchID();
        Enumeration enumeration = this.oblist.elements();
        while (enumeration.hasMoreElements()) {
            IPatch iPatch2 = (IPatch)enumeration.nextElement();
            this.markSingleError(iPatch2, this.getLocaleMessage(1) + " " + string);
            this.log.println(this, 4, "PatchSequencer: Oboslesce loop includes patch " + iPatch2.getPatchID().getPatchID());
        }
    }

    private IPatch getIPatchFromDB(PatchID patchID) throws NoSuchPatchException {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        if (patchID == null) {
            return null;
        }
        PatchImpl patchImpl = this.patchdb.getLatestPatch(patchID);
        if (patchImpl == null) {
            this.log.println(this, 4, "PatchSequencer: Database returned null patch and no exception");
            throw new NoSuchPatchException("got null patch from database");
        }
        return new IPatch(patchImpl);
    }

    public void processIncompat(IPatch iPatch) {
        String[] stringArray = null;
        try {
            stringArray = this.getPatchStringsFromExpression(iPatch.getPatchInfo().getIncompat());
            if (stringArray == null) {
                return;
            }
            int n = 0;
            while (n < stringArray.length) {
                block6: {
                    PatchID patchID;
                    try {
                        patchID = new PatchID(stringArray[n]);
                    }
                    catch (MalformedPatchException malformedPatchException) {
                        this.markSingleError(iPatch, this.getLocaleMessage(9));
                        break block6;
                    }
                    this.incompatlist.add(new IPair(iPatch.getPatchID(), patchID));
                }
                ++n;
            }
        }
        catch (ParseError parseError) {
            this.markSingleError(iPatch, this.getLocaleMessage(8));
        }
    }

    public void processPreferred(IPatch iPatch) {
        String[] stringArray = null;
        try {
            stringArray = this.getPatchStringsFromExpression(iPatch.getPatchInfo().getPrefers());
        }
        catch (ParseError parseError) {
            this.markSingleError(iPatch, this.getLocaleMessage(7));
            return;
        }
        if (stringArray == null) {
            this.finalizePatch(iPatch);
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            block8: {
                IPatch iPatch2;
                PatchID patchID;
                try {
                    patchID = new PatchID(stringArray[n]);
                }
                catch (MalformedPatchException malformedPatchException) {
                    this.markSingleError(iPatch, this.getLocaleMessage(3));
                    break block8;
                }
                try {
                    iPatch2 = this.getIPatchFromDB(patchID);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.markSingleError(iPatch, this.getLocaleMessage(5));
                    break block8;
                }
                iPatch2.setState(2001);
                this.processPatch(iPatch2);
            }
            ++n;
        }
    }

    private String[] getPatchStringsFromExpression(String string) throws ParseError {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        if (string == null || string.compareTo("") == 0) {
            return null;
        }
        String[] stringArray = null;
        if (string.indexOf("(") != -1) {
            stringArray = this.interpreter.getPatchList(string);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    private void finalizeObsoletePatch(IPatch iPatch) {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        if (this.initialPatchList != null && iPatch != null) {
            this.initialPatchList.removeIPatch(iPatch);
        }
    }

    void finalizePatch(IPatch iPatch) {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        if (this.finalList == null || this.initialPatchList == null || iPatch == null) {
            return;
        }
        this.initialPatchList.removeIPatch(iPatch);
        this.workingList.removeIPatch(iPatch);
        this.log.println(this, 7, "PatchSequencer.finalizePatch(): The patch added to the finalList to be returned is " + iPatch.getPatchID().getPatchID());
        this.finalList.addIPatch(iPatch);
    }

    public String getLocaleMessage(int n) {
        if (n >= 0 && n < this.errStrings.length) {
            return this.catalog.getMessage(this.errStrings[n][0], this.errStrings[n][1]);
        }
        this.log.println(this, 4, "PatchSequencer: Invalid error identifier used in call to getLocaleMessage " + n);
        return null;
    }

    private void markSingleError(IPatch iPatch, String string) {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        iPatch.setError(string);
    }

    private void markLoopError(IPatch iPatch) {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        this.markSingleError(iPatch, this.getLocaleMessage(4) + " " + iPatch.getPatchID().getPatchID());
        boolean bl = false;
        String string = iPatch.getPatchID().getPatchID();
        int n = 0;
        while (n < this.workingList.size()) {
            IPatch iPatch2 = this.workingList.getIPatchAt(n);
            if (!bl) {
                if (string.compareTo(iPatch2.getPatchID().getPatchID()) == 0) {
                    bl = true;
                }
            } else {
                this.markSingleError(iPatch2, this.getLocaleMessage(4) + " " + iPatch.getPatchID().getPatchID());
            }
            ++n;
        }
    }

    private boolean removeExistingPatch(PatchID patchID) {
        PatchImpl patchImpl;
        boolean bl = true;
        this.log.println(this, 7, "PatchSequencer.removeExistingPatch(): existingPatches size = " + this.existingPatches.size());
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        String string = patchID.getPatchID();
        this.log.println(this, 7, "PatchSequencer.removeExistingPatch(): The current patch is " + string);
        String string2 = patchID.getBasecode().trim();
        int n = 0;
        while ((patchImpl = this.existingPatches.getPatchImplAt(n)) != null) {
            String string3 = patchImpl.getPatchID().getPatchID();
            String string4 = patchImpl.getPatchID().getBasecode().trim();
            if (string4.equals(string2) && string3.compareTo(string) >= 0) {
                this.log.println(this, 7, "Installed patch is >= to current patch.");
                return bl;
            }
            ++n;
        }
        bl = false;
        return bl;
    }

    public void setInterpreter(HostSpecificInterpreter hostSpecificInterpreter) {
        this.interpreter = hostSpecificInterpreter;
    }

    public void setPatchDB(PatchDB patchDB) {
        this.patchdb = patchDB;
    }

    public void addSequencerListener(SequencerListener sequencerListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(sequencerListener);
        }
    }

    public void removeSequencerListener(SequencerListener sequencerListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(sequencerListener);
        }
    }

    protected void progressUpdate() {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.listeners.size()) {
                SequencerListener sequencerListener = (SequencerListener)this.listeners.elementAt(n);
                sequencerListener.sequencerProgress(new SequencerEvent(this));
                ++n;
            }
        }
    }

    protected void sendDoneEvent() {
        PatchSequencer patchSequencer = this;
        synchronized (patchSequencer) {
            if (this.shutdown) {
                throw new Error("shutting down sequencer");
            }
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.listeners.size()) {
                SequencerListener sequencerListener = (SequencerListener)this.listeners.elementAt(n);
                sequencerListener.sequencerDone(new SequencerEvent(this));
                ++n;
            }
        }
    }

    public Percentage getStatus() {
        try {
            return new Percentage((int)this.complete);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "Sequencer progress out of range.  " + this.complete);
            if (this.complete > 100.0f) {
                return new Percentage(100);
            }
            return new Percentage(0);
        }
    }

    private class InnerCancelThread
    extends Thread {
        private InnerCancelThread() {
        }

        public void run() {
            PatchSequencer patchSequencer;
            int n = 0;
            while (n < 10) {
                patchSequencer = PatchSequencer.this;
                synchronized (patchSequencer) {
                    if (!PatchSequencer.this.sequencerRunning) {
                        break;
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    PatchSequencer.this.log.println(this, 4, "Sequencer cancel thread interrupted.");
                }
                ++n;
            }
            patchSequencer = PatchSequencer.this;
            synchronized (patchSequencer) {
                if (PatchSequencer.this.sequencerRunning) {
                    PatchSequencer.this.log.println(this, 2, "Sequencer doesn't want to exit.");
                } else {
                    PatchSequencer.this.log.println(this, 6, "Sequencer has been shut down.");
                }
            }
        }
    }
}

