/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.model;

import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.LocalizedMessages;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class PatchProException
extends Exception
implements Serializable {
    int severity;
    transient LocalizedMessages msgcat;
    String key;
    String remedy;
    Throwable targetException;
    public static final int EMERGENCY = 0;
    public static final int ALERT = 1;
    public static final int CRITICAL = 2;
    public static final int ERROR = 3;
    public static final int WARNING = 4;
    public static final int NOTICE = 5;
    public static final int INFO = 6;
    public static final int DEBUG = 7;

    public PatchProException(String string) {
        this("", string, "", 7);
    }

    public PatchProException(Throwable throwable) {
        this("", "", "", 7, throwable);
    }

    public PatchProException(String string, String string2, String string3, int n, Throwable throwable) {
        this(string, string2, string3, n);
        this.targetException = throwable;
    }

    public PatchProException(String string, String string2, String string3, int n) {
        super(string2);
        this.key = string;
        this.remedy = string3;
        this.severity = n;
        PatchProProperties patchProProperties = PatchProProperties.getInstance();
        this.msgcat = new LocalizedMessages(patchProProperties.getLocale());
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public String getLocalizedMessage() {
        return this.msgcat.getMessage(this.getMessage(), this.getMessage());
    }

    public String getRemedy() {
        return this.remedy;
    }

    public String getLocalizedRemedy() {
        return this.msgcat.getMessage(this.remedy, this.remedy);
    }

    public int getSeverity() {
        return this.severity;
    }

    public Throwable getTargetException() {
        return this.targetException;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PatchProException)) {
            return false;
        }
        return this.getKey().compareTo(((PatchProException)object).getKey()) == 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            this.msgcat = new LocalizedMessages(PatchProProperties.getInstance().getLocale());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

