/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.manipulators.CannotDeferException;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Installable;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.NoSuchImageException;
import com.sun.patchpro.manipulators.Removable;
import com.sun.patchpro.manipulators.RemoveFailedException;
import com.sun.patchpro.manipulators.SunOSSunPatchInstaller;
import com.sun.patchpro.manipulators.Verifiable;
import com.sun.patchpro.manipulators.VerifyFailedException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.security.NoKeystorePresentException;
import com.sun.patchpro.security.NoSigningCertException;
import com.sun.patchpro.security.SignatureValidationUtil;
import java.io.File;
import java.io.IOException;

public class SunOSSunPatchManipulator
extends Manipulator {
    public SunOSSunPatchManipulator() throws NoSuchImageException, NoKeystorePresentException, NoSigningCertException {
    }

    public SunOSSunPatchManipulator(Patch patch, Host host, SignatureValidationUtil signatureValidationUtil) throws NoSuchImageException, NoKeystorePresentException, NoSigningCertException {
        super(patch, host, null, signatureValidationUtil);
    }

    public Installable getInstaller() throws InstallFailedException {
        return new SunOSSunPatchInstaller(this, this.properties);
    }

    public Verifiable getVerifier() throws VerifyFailedException {
        throw new VerifyFailedException("This Manipulator can't verify.");
    }

    public void defer() throws CannotDeferException {
        String string = null;
        File file = null;
        if (string == null) {
            string = this.properties.getProperty("patchpro.patch.sequester.directory", "/var/spool/pkg/patchproSequester");
        }
        file = new File(string);
        if (!this.smpatch) {
            System.out.println(this.msgcat.getMessage("PatchBundleInstaller.defering", "Defering") + " " + this.currentImage.getPath());
        }
        try {
            this.move(new File(file, this.currentImage.getName()));
        }
        catch (IOException iOException) {
            throw new CannotDeferException(iOException.getMessage());
        }
    }

    public Removable getRemover() throws RemoveFailedException {
        throw new RemoveFailedException("This Manipulator can't remove.");
    }

    public int getStrategy(boolean bl) {
        PatchProperties patchProperties = this.activePatch.getPatchInfo().getProperties();
        int n = bl ? 4 : 3;
        if (this.properties.installIsAllowed(bl)) {
            n = 1;
            if (!this.mustFail(bl, patchProperties)) {
                if (bl) {
                    if (patchProperties.isDiscontinued() && !this.properties.mayDiscontinued(bl)) {
                        n = 4;
                    } else if (patchProperties.isPointpatch() && !this.properties.mayPointpatch(bl)) {
                        n = 4;
                    } else if (patchProperties.isObsolete() && !this.properties.mayObsolete(bl)) {
                        n = 4;
                    } else if (patchProperties.isInteractive() && !this.properties.mayInteractive(bl)) {
                        n = 4;
                    } else if (patchProperties.isSingleuser() && !this.properties.maySingleuser(bl)) {
                        n = 4;
                    } else if (patchProperties.isRebootimmediate() && !this.properties.mayRebootimmediate(bl)) {
                        n = 4;
                    } else if (patchProperties.isReconfigimmediate() && !this.properties.mayReconfigimmediate(bl)) {
                        n = 4;
                    } else if (patchProperties.isRebootafter() && !this.properties.mayRebootafter(bl)) {
                        n = 4;
                    } else if (patchProperties.isReconfigafter() && !this.properties.mayReconfigafter(bl)) {
                        n = 4;
                    } else if (patchProperties.isNonstandard()) {
                        n = 4;
                    }
                } else if (!this.rebootIsPossible()) {
                    if (patchProperties.isSingleuser() && !this.properties.maySingleuser(bl)) {
                        n = 3;
                    } else if (patchProperties.isRebootafter() && !this.properties.mayRebootafter(bl)) {
                        n = 3;
                    } else if (patchProperties.isReconfigafter() && !this.properties.mayReconfigafter(bl)) {
                        n = 3;
                    } else if (patchProperties.isRebootimmediate() || patchProperties.isReconfigimmediate() || patchProperties.isNonstandard() || patchProperties.isInteractive()) {
                        n = 3;
                    }
                } else if (patchProperties.isInteractive()) {
                    n = this.properties.mayInteractive(bl) ? 2 : 3;
                } else if (patchProperties.isSingleuser()) {
                    n = this.properties.maySingleuser(bl) ? 2 : 3;
                } else if (patchProperties.isRebootafter()) {
                    n = this.properties.mayRebootafter(bl) ? 2 : 3;
                } else if (patchProperties.isReconfigafter()) {
                    n = this.properties.mayReconfigafter(bl) ? 2 : 3;
                } else if (patchProperties.isRebootimmediate()) {
                    n = this.properties.mayRebootimmediate(bl) ? 2 : 3;
                } else if (patchProperties.isReconfigimmediate()) {
                    n = this.properties.mayReconfigimmediate(bl) ? 2 : 3;
                } else if (patchProperties.isNonstandard()) {
                    n = 3;
                }
            } else {
                n = 4;
            }
        }
        this.log.println(this, 7, "getStrategy() returns " + n);
        return n;
    }

    private boolean rebootIsPossible() {
        boolean bl = false;
        boolean bl2 = this.properties.getProperty("patchpro.control.reboot.allowed").compareTo("true") == 0;
        int n = 0;
        String string = this.properties.getProperty("patchpro.control.reboot.at.time");
        if (string != null && string.compareTo("0:00-0:00") != 0) {
            n = 2;
        }
        if (bl2 && n > 0) {
            bl = true;
        }
        return bl;
    }

    private boolean mustFail(boolean bl, PatchProperties patchProperties) {
        boolean bl2 = false;
        if (!bl && (patchProperties.isDiscontinued() || patchProperties.isPointpatch() || patchProperties.isObsolete())) {
            bl2 = true;
        }
        return bl2;
    }
}

