/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.manipulators.ManipulatorEvent;
import com.sun.patchpro.manipulators.ManipulatorListener;
import com.sun.patchpro.util.Percentage;
import java.util.Enumeration;
import java.util.Vector;

public class ManipulableEventManager {
    private int progress;
    private int percentIncrement = 5;
    private double startProgress = 0.0;
    private double endProgress;
    private double incrementValue;
    private double currentProgress;
    private double currentStep;
    protected Exception finalException = null;
    private Vector listeners = new Vector();

    public Percentage getProgress() {
        return new Percentage(this.progress);
    }

    public synchronized void addListener(ManipulatorListener manipulatorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(manipulatorListener);
        }
    }

    public synchronized void removeListener(ManipulatorListener manipulatorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(this.listeners);
        }
    }

    protected void initializeProgress(double d, double d2, int n) {
        try {
            this.startProgress = d;
            this.endProgress = d2;
            this.percentIncrement = n;
            this.currentStep = this.incrementValue = (d2 - d) * ((double)n * 0.01);
        }
        catch (Exception exception) {
            this.progress = 20;
        }
        this.currentProgress = 0.0;
    }

    protected void initializeProgress(double d, double d2) {
        this.initializeProgress(d, d2, 5);
    }

    protected void incrementProgress(double d) {
        this.currentProgress += d;
        boolean bl = false;
        while (this.currentProgress >= this.currentStep) {
            bl = true;
            this.progress += this.percentIncrement;
            this.currentStep += this.incrementValue;
            if (this.progress <= 100) continue;
            this.progress = 100;
        }
        if (bl) {
            this.dispatchProgressEvent(new ManipulatorEvent(this));
        }
    }

    protected void issueDone() {
        this.dispatchDoneEvent(new ManipulatorEvent(this));
    }

    protected void issueFail(Exception exception) {
        this.finalException = exception;
        this.dispatchErrorEvent(new ManipulatorEvent(this));
    }

    public Exception getFailure() {
        return this.finalException;
    }

    private void dispatchProgressEvent(ManipulatorEvent manipulatorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ManipulatorListener manipulatorListener = (ManipulatorListener)enumeration.nextElement();
            manipulatorListener.manipulatorProgress(manipulatorEvent);
        }
    }

    private void dispatchDoneEvent(ManipulatorEvent manipulatorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ManipulatorListener manipulatorListener = (ManipulatorListener)enumeration.nextElement();
            manipulatorListener.manipulatorDone(manipulatorEvent);
        }
    }

    private void dispatchErrorEvent(ManipulatorEvent manipulatorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ManipulatorListener manipulatorListener = (ManipulatorListener)enumeration.nextElement();
            manipulatorListener.manipulatorFailed(manipulatorEvent);
        }
    }
}

