/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.log;

import com.sun.patchpro.log.Log;
import com.sun.patchpro.log.LogEverything;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.LocalizedMessages;
import java.io.IOException;
import java.util.Date;

public class SunOSSystemLogger
implements Log {
    private static LocalizedMessages msgcat;
    private static final String TRACEOFF = "0";
    private static final String TRACEON = "1";
    private static final String DEFAULT_SYSLOG_FACILITY = "user";
    private static final String SYSLOG_SEVERITY_LEVEL_0 = "emerg";
    private static final String SYSLOG_SEVERITY_LEVEL_1 = "alert";
    private static final String SYSLOG_SEVERITY_LEVEL_2 = "crit";
    private static final String SYSLOG_SEVERITY_LEVEL_3 = "err";
    private static final String SYSLOG_SEVERITY_LEVEL_4 = "warning";
    private static final String SYSLOG_SEVERITY_LEVEL_5 = "notice";
    private static final String SYSLOG_SEVERITY_LEVEL_6 = "info";
    private static final String SYSLOG_SEVERITY_LEVEL_7 = "debug";
    private String syslog_facility = "";
    private int logLevel = 0;
    private Process process = null;
    private Runtime runTime = null;
    private PatchProProperties properties = PatchProProperties.getInstance();

    public SunOSSystemLogger() {
        msgcat = new LocalizedMessages(this.properties.getLocale());
        this.logLevel = new Integer(this.properties.getProperty("patchpro.log.level", TRACEOFF));
        this.syslog_facility = this.properties.getProperty("patchpro.syslog.facility");
        if (this.syslog_facility == null || this.syslog_facility.length() == 0) {
            this.syslog_facility = DEFAULT_SYSLOG_FACILITY;
        }
        this.runTime = Runtime.getRuntime();
    }

    public synchronized void print(Object object, int n, String string) {
        String string2 = "<unknown>";
        String string3 = "";
        switch (n) {
            case 0: {
                string2 = "EMERGENCY";
                string3 = SYSLOG_SEVERITY_LEVEL_0;
                break;
            }
            case 1: {
                string2 = "ALERT";
                string3 = SYSLOG_SEVERITY_LEVEL_1;
                break;
            }
            case 2: {
                string2 = "CRITICAL";
                string3 = SYSLOG_SEVERITY_LEVEL_2;
                break;
            }
            case 3: {
                string2 = "ERROR";
                string3 = SYSLOG_SEVERITY_LEVEL_3;
                break;
            }
            case 4: {
                string2 = "WARNING";
                string3 = SYSLOG_SEVERITY_LEVEL_4;
                break;
            }
            case 5: {
                string2 = "NOTICE";
                string3 = SYSLOG_SEVERITY_LEVEL_5;
                break;
            }
            case 6: {
                string2 = "INFO";
                string3 = SYSLOG_SEVERITY_LEVEL_6;
                break;
            }
            case 7: {
                string2 = "DEBUG";
                string3 = SYSLOG_SEVERITY_LEVEL_7;
            }
        }
        if (n <= this.logLevel) {
            try {
                String string4 = new Date().toString() + "(" + string2 + ") => " + object.toString() + " <=" + string;
                String string5 = "/usr/bin/logger -p " + this.syslog_facility + "." + string3 + " " + "\"" + string4 + "\"";
                String[] stringArray = new String[]{"/usr/bin/sh", "-c", string5};
                this.process = this.runTime.exec(stringArray);
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Warning: Process to log a SYSLOG message was interrupted.");
                }
                if (this.process.exitValue() != 0) {
                    System.err.println(msgcat.getMessage("syslogWriteError", "An error was detected writing to the SYSLOG file -") + " " + this.process.exitValue());
                }
            }
            catch (IOException iOException) {
                try {
                    PatchProLog patchProLog = PatchProLog.getInstance();
                    patchProLog.setLogger(new LogEverything(System.out));
                    patchProLog.println(this, 3, "Error: Unable to write to syslog file");
                    patchProLog.printStackTrace(this, 3, iOException);
                }
                catch (Exception exception) {
                    System.err.println("ERROR: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
    }
}

