/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.interpreter;

import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.interpreter.ASTStart;
import com.sun.patchpro.interpreter.EnvState;
import com.sun.patchpro.interpreter.Evaluation;
import com.sun.patchpro.interpreter.ExitCondition;
import com.sun.patchpro.interpreter.InterpretError;
import com.sun.patchpro.interpreter.InterpretPatchListExpression;
import com.sun.patchpro.interpreter.ParseError;
import com.sun.patchpro.interpreter.ParseException;
import com.sun.patchpro.interpreter.PatchListExpressionTree;
import com.sun.patchpro.log.PatchProLog;
import java.io.StringReader;

public class Interpreter {
    public static Evaluation interpret(String string, ReadOnlyHost readOnlyHost) throws ParseError {
        PatchProLog patchProLog = PatchProLog.getInstance();
        PatchListExpressionTree patchListExpressionTree = new PatchListExpressionTree(new StringReader(string));
        try {
            ASTStart aSTStart = patchListExpressionTree.Start();
            EnvState envState = new EnvState(readOnlyHost);
            InterpretPatchListExpression interpretPatchListExpression = new InterpretPatchListExpression();
            try {
                aSTStart.jjtAccept(interpretPatchListExpression, envState);
            }
            catch (ExitCondition exitCondition) {
                envState.exitCode(exitCondition.getExitCode());
            }
            return new Evaluation(envState.getOutput().trim(), envState.getExitCode());
        }
        catch (InterpretError interpretError) {
            patchProLog.printStackTrace(patchListExpressionTree, 7, interpretError);
            throw new ParseError(interpretError.toString());
        }
        catch (Exception exception) {
            patchProLog.println(patchListExpressionTree, 2, "Internal error within exression Interpreter... ");
            patchProLog.printStackTrace(patchListExpressionTree, 2, exception);
            throw new ParseError(exception.getMessage());
        }
    }

    public static void validate(String string) throws ParseException {
        try {
            PatchListExpressionTree patchListExpressionTree = new PatchListExpressionTree(new StringReader(string));
            ASTStart aSTStart = patchListExpressionTree.Start();
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            throw new ParseException("Parse failure: " + exception.getMessage());
        }
    }
}

