/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.database;

import com.sun.database.simpleadapter.common.PracticalTokenizer;
import com.sun.database.simpleadapter.memory.MemoryAdapter;
import com.sun.database.simpledatabase.DatabaseError;
import com.sun.database.simpledatabase.DuplicateEntryException;
import com.sun.database.simpledatabase.SimpleDatabase;
import com.sun.patchpro.database.DBBuilderFailedException;
import com.sun.patchpro.database.MemoryPatchDB;
import com.sun.patchpro.database.PatchBaseRecord;
import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.database.PatchDBBuilder;
import com.sun.patchpro.database.RealizationRecord;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.DownloadPatchDBEvent;
import com.sun.patchpro.model.DownloadPatchDBListener;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.CachingDownloader;
import com.sun.patchpro.util.IncompatibleVersionException;
import com.sun.patchpro.util.InvalidVersionException;
import com.sun.patchpro.util.Percentage;
import com.sun.patchpro.util.Version;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MemoryPatchDBBuilder
implements PatchDBBuilder {
    private final String LISTPROPERTIESNAME = "patchlist.properties";
    private int progress = 0;
    private float loadedPatchCount;
    private float totalPatchCount;
    private float onePercent;
    private float currentThreshold;
    private Vector listeners;
    private PatchProLog log;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private Reader sourceReader;
    private Properties patchlistProperties;
    private URL sourceDBURL = null;
    private SimpleDatabase patchBaseDB = null;
    private SimpleDatabase realizationDB = null;
    private PatchDB patchDB = null;
    private CachingDownloader downloader;
    static final String LISTVERSIONMINIMUM = "1.0";
    static final String LISTVERSION = "list.version";
    static final String PATCHCOUNT = "patch.count";
    static final String PATCHDELIMITER = "patch.delimiter";
    static final String PATCHLISTNAME = "patchlist.name";

    public MemoryPatchDBBuilder() {
        this.log = PatchProLog.getInstance();
        this.listeners = new Vector();
    }

    private void setSourceURL(String string) throws IOException, MalformedURLException, IncompatibleVersionException {
        this.sourceDBURL = new URL(string);
        this.setSourceReader(this.sourceDBURL);
        this.verifyListVersion();
    }

    public synchronized PatchDB buildDB(String string, String string2, String string3, String string4) throws DBBuilderFailedException {
        block7: {
            if (this.patchDB == null) {
                try {
                    try {
                        this.setSourceURL(string);
                        this.transferFile();
                        this.patchDB = new MemoryPatchDB(string2, string3, string4, this.patchBaseDB, this.realizationDB);
                    }
                    catch (IOException iOException) {
                        this.log.println(this, 7, "MemoryPatchDBBuilder: IOException during transferFile()");
                        this.log.printStackTrace(this, 7, iOException);
                        throw new DBBuilderFailedException(iOException.getMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.log.println(this, 7, "MemoryPatchDBBuilder: IllegalAccessException during transferFile()");
                        throw new DBBuilderFailedException(illegalAccessException.getMessage());
                    }
                    catch (Exception exception) {
                        this.log.println(this, 7, "MemoryPatchDBBuilder: Error in database build - " + exception.getMessage());
                        this.log.printStackTrace(this, 7, exception);
                        throw new DBBuilderFailedException(exception.getMessage());
                    }
                    Object var9_5 = null;
                    this.dispatchDoneEvent(new DownloadPatchDBEvent(this));
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var9_6 = null;
                    this.dispatchDoneEvent(new DownloadPatchDBEvent(this));
                    throw throwable;
                }
            }
            this.dispatchDoneEvent(new DownloadPatchDBEvent(this));
        }
        return this.patchDB;
    }

    public synchronized void buildDB(ReadOnlyHost readOnlyHost) throws DBBuilderFailedException {
        this.properties = readOnlyHost.getSessionData().getProperties();
        PatchDB patchDB = this.buildDB(this.properties.getProperty("patchpro.database.source.url"), readOnlyHost.getOperatingSystem(), readOnlyHost.getOSRelease(), readOnlyHost.getArchitecture());
        readOnlyHost.getSessionData().setPatchDB(patchDB);
    }

    public synchronized PatchDB buildDB(String string) throws DBBuilderFailedException {
        try {
            try {
                this.setSourceURL(string);
                this.transferFile();
                PatchDB patchDB = this.patchDB = new MemoryPatchDB(this.patchBaseDB, this.realizationDB);
                Object var6_4 = null;
                this.dispatchDoneEvent(new DownloadPatchDBEvent(this));
                return patchDB;
            }
            catch (IOException iOException) {
                this.log.println(this, 7, "MemoryPatchDBBuilder: IOException during transferFile()");
                throw new DBBuilderFailedException(iOException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                this.log.println(this, 7, "MemoryPatchDBBuilder: IllegalAccessException during transferFile()");
                throw new DBBuilderFailedException(illegalAccessException.getMessage());
            }
            catch (Exception exception) {
                this.log.println(this, 7, "MemoryPatchDBBuilder: Error in database build - " + exception.getMessage());
                throw new DBBuilderFailedException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.dispatchDoneEvent(new DownloadPatchDBEvent(this));
            throw throwable;
        }
    }

    public Percentage percentComplete() {
        return new Percentage(this.progress);
    }

    public void addListener(DownloadPatchDBListener downloadPatchDBListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(downloadPatchDBListener);
        }
    }

    public void removeListener(DownloadPatchDBListener downloadPatchDBListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(this.listeners);
        }
    }

    private void setSourceReader(URL uRL) throws IOException, MalformedURLException {
        ZipInputStream zipInputStream;
        String string = uRL.getProtocol();
        boolean bl = true;
        if (string.compareTo("file") == 0) {
            zipInputStream = new ZipInputStream(new FileInputStream(new File(this.sourceDBURL.getFile())));
        } else if (string.compareTo("http") == 0 || string.compareTo("https") == 0) {
            this.log.println(this, 7, "MemoryPatchDBBuilder.setSourceReader(): new CachingDownloader(" + uRL + ")");
            String string2 = this.properties.getProperty("patchpro.cache.file.database");
            File file = new File(string2);
            String string3 = file.isAbsolute() ? string2 : this.properties.getProperty("patchpro.installdir.ppro") + System.getProperty("file.separator") + string2;
            File file2 = new File(string3);
            long l = new Long(this.properties.getProperty("patchpro.cache.old.age.days.database"));
            long l2 = new Long(this.properties.getProperty("patchpro.cache.dead.age.days.database"));
            this.downloader = new CachingDownloader(uRL, file2, CachingDownloader.days(l), CachingDownloader.days(l2));
            try {
                zipInputStream = new ZipInputStream(this.downloader);
            }
            catch (Exception exception) {
                throw new MalformedURLException("MemoryPatchDBBuilder: Could not acquire connection to JAR file. Received exception message " + exception.getMessage());
            }
        } else {
            throw new MalformedURLException("MemoryPatchDBBuilder: Only file and http protocols are usable.");
        }
        this.log.println(this, 7, "zipInputStream = " + zipInputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        this.patchlistProperties = new Properties();
        this.patchlistProperties.load(zipInputStream);
        zipEntry = zipInputStream.getNextEntry();
        this.sourceReader = new InputStreamReader(zipInputStream);
    }

    private void verifyListVersion() throws IOException, IncompatibleVersionException {
        try {
            Version version = new Version(this.patchlistProperties.getProperty(LISTVERSION));
            Version version2 = new Version(LISTVERSIONMINIMUM);
            if (version2.compareTo(version) > 0) {
                this.downloader.close();
                throw new IncompatibleVersionException("MemoryPatchDBBuilder: Patch list version of " + version.getVersion() + " is lower than the required " + LISTVERSIONMINIMUM + ".");
            }
        }
        catch (InvalidVersionException invalidVersionException) {
            this.downloader.close();
            throw new IncompatibleVersionException("MemoryPatchDBBuilder: Patch list version of " + this.patchlistProperties.getProperty(LISTVERSION) + " is malformed.");
        }
    }

    private void initializeProgress(int n) {
        this.totalPatchCount = n;
        this.currentThreshold = this.onePercent = (float)n / 100.0f;
        this.loadedPatchCount = 0.0f;
        this.progress = 0;
    }

    private void incrementProgress() {
        this.loadedPatchCount += 1.0f;
        if (this.loadedPatchCount > this.currentThreshold) {
            this.currentThreshold += this.onePercent;
            this.progress = (int)((double)(this.loadedPatchCount / this.totalPatchCount) * 100.0);
            this.dispatchProgressEvent(new DownloadPatchDBEvent(this));
        }
    }

    public Percentage getPatchDBProgress() {
        Percentage percentage;
        try {
            percentage = new Percentage(this.progress);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "MemoryPatchDBBuilder.getPatchDBProgress(): Unable to create a Percentage from " + this.progress + ".");
            percentage = new Percentage(100);
        }
        return percentage;
    }

    private void transferFile() throws SecurityException, IllegalAccessException, IOException {
        block19: {
            String string = this.patchlistProperties.getProperty(PATCHCOUNT);
            this.initializeProgress(new Integer(string.trim()));
            PracticalTokenizer practicalTokenizer = new PracticalTokenizer(this.patchlistProperties.getProperty(PATCHDELIMITER), this.sourceReader);
            practicalTokenizer.eolIsSignificant(true);
            String[] stringArray = new String[]{"patchBaseCode"};
            String[] stringArray2 = new String[]{"realization"};
            try {
                try {
                    this.patchBaseDB = new MemoryAdapter(Class.forName("com.sun.patchpro.database.PatchBaseRecord"), stringArray);
                    this.patchBaseDB.allowDuplicates("patchBaseCode", true);
                    this.realizationDB = new MemoryAdapter(Class.forName("com.sun.patchpro.database.RealizationRecord"), stringArray2);
                    try {
                        while (true) {
                            PatchBaseRecord patchBaseRecord = new PatchBaseRecord();
                            this.loadObjects(practicalTokenizer, patchBaseRecord, this.realizationDB);
                            this.storePatchBase(this.patchBaseDB, patchBaseRecord);
                            this.incrementProgress();
                        }
                    }
                    catch (EOFException eOFException) {
                        this.log.println(this, 7, "MemoryPatchDBBuilder.transferFile(): Reached end of patchlist stream.");
                        Object var8_8 = null;
                        try {
                            if (this.downloader != null) {
                                while (this.downloader.skip(10L) != -1L) {
                                }
                                this.downloader.close();
                            }
                            if (this.patchBaseDB != null) {
                                this.patchBaseDB.closeDatabase();
                            }
                            if (this.patchBaseDB != null) {
                                this.realizationDB.closeDatabase();
                            }
                            break block19;
                        }
                        catch (Throwable throwable) {
                            this.log.println(this, 2, "MemoryPatchDBBuilder.transferFile: Unexpected throwable " + throwable.toString() + " thrown with message " + throwable.getMessage() + ".");
                            throw new DatabaseError("odd throwable");
                        }
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    this.log.println(this, 2, "MemoryPatchDBBuilder.transferFile: Class in the database does not include a field that was there when it was created!!!");
                    throw new DatabaseError("no such field.");
                }
                catch (Exception exception) {
                    this.log.printStackTrace(this, 2, exception);
                    this.log.println(this, 2, "MemoryPatchDBBuilder.transferFile: Unexpected exception " + exception.toString() + " thrown with message " + exception.getMessage() + ".");
                    throw new DatabaseError("odd exception");
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (this.downloader != null) {
                        while (this.downloader.skip(10L) != -1L) {
                        }
                        this.downloader.close();
                    }
                    if (this.patchBaseDB != null) {
                        this.patchBaseDB.closeDatabase();
                    }
                    if (this.patchBaseDB != null) {
                        this.realizationDB.closeDatabase();
                    }
                }
                catch (Throwable throwable2) {
                    this.log.println(this, 2, "MemoryPatchDBBuilder.transferFile: Unexpected throwable " + throwable2.toString() + " thrown with message " + throwable2.getMessage() + ".");
                    throw new DatabaseError("odd throwable");
                }
            }
            throw throwable;
        }
    }

    private void loadObjects(PracticalTokenizer practicalTokenizer, PatchBaseRecord patchBaseRecord, SimpleDatabase simpleDatabase) throws IOException, EOFException {
        Object var4_4 = null;
        Object var5_5 = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (practicalTokenizer.nextToken() != -2) {
            if (practicalTokenizer.ttype == -3) {
                if (bl2) {
                    bl2 = false;
                    n = 0;
                    continue;
                }
                if (n == 0) {
                    bl3 = true;
                } else if (n != 16) {
                    bl2 = true;
                } else {
                    bl = true;
                    break;
                }
            }
            if (bl2) {
                ++n;
                continue;
            }
            switch (n) {
                case 0: {
                    patchBaseRecord.patchBaseCode = practicalTokenizer.sval;
                    break;
                }
                case 1: {
                    patchBaseRecord.patchVersion = practicalTokenizer.sval;
                    break;
                }
                case 2: {
                    patchBaseRecord.synopsis = practicalTokenizer.sval;
                    break;
                }
                case 3: {
                    patchBaseRecord.targetArchitecture = practicalTokenizer.sval;
                    break;
                }
                case 4: {
                    patchBaseRecord.targetOS = practicalTokenizer.sval;
                    break;
                }
                case 5: {
                    patchBaseRecord.targetRelease = practicalTokenizer.sval;
                    break;
                }
                case 6: {
                    patchBaseRecord.requires = practicalTokenizer.sval;
                    break;
                }
                case 7: {
                    patchBaseRecord.obsolesces = practicalTokenizer.sval;
                    break;
                }
                case 8: {
                    patchBaseRecord.incompatibleWith = practicalTokenizer.sval;
                    break;
                }
                case 9: {
                    patchBaseRecord.prefers = practicalTokenizer.sval;
                    break;
                }
                case 10: {
                    patchBaseRecord.obsolescedBy = practicalTokenizer.sval;
                    break;
                }
                case 11: {
                    patchBaseRecord.corrects = practicalTokenizer.sval;
                    if (patchBaseRecord.corrects.length() <= 0) break;
                    StringTokenizer stringTokenizer = new StringTokenizer(patchBaseRecord.corrects);
                    while (stringTokenizer.hasMoreElements()) {
                        RealizationRecord realizationRecord = new RealizationRecord();
                        realizationRecord.realization = (String)stringTokenizer.nextElement();
                        realizationRecord.patchIDs = patchBaseRecord.patchBaseCode + "-" + patchBaseRecord.patchVersion;
                        try {
                            this.storeRealization(simpleDatabase, realizationRecord);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            this.log.println(this, 2, "MemoryPatchDBBuilder.loadObjects: Unexpectedly denied access to the database.");
                            throw new DatabaseError((Exception)illegalAccessException, "MemoryPatchDBBuilder.loadObjects: Denied access to the database.");
                        }
                    }
                    break;
                }
                case 12: {
                    patchBaseRecord.constraint = practicalTokenizer.sval;
                    break;
                }
                case 13: {
                    patchBaseRecord.properties = practicalTokenizer.sval;
                    break;
                }
                case 14: {
                    patchBaseRecord.type = practicalTokenizer.sval;
                }
            }
            if (bl3) {
                bl3 = false;
                continue;
            }
            ++n;
        }
        if (bl) {
            return;
        }
        throw new EOFException();
    }

    private void storeRealization(SimpleDatabase simpleDatabase, RealizationRecord realizationRecord) throws IllegalAccessException {
        if (realizationRecord.realization != null && realizationRecord.realization.compareTo("") != 0) {
            try {
                simpleDatabase.addObject((Object)realizationRecord);
            }
            catch (DuplicateEntryException duplicateEntryException) {
                try {
                    String string;
                    int n = simpleDatabase.findObjectHandle(0, (Object)realizationRecord.realization);
                    RealizationRecord realizationRecord2 = (RealizationRecord)simpleDatabase.getObject(n);
                    realizationRecord2.patchIDs = string = new String(realizationRecord2.patchIDs + " " + realizationRecord.patchIDs);
                }
                catch (Exception exception) {
                    throw new IllegalAccessException("MemoryPatchDBBuilder.storeRealization: Unable to clear old database entry");
                }
            }
            catch (Exception exception) {
                this.log.println(this, 2, "MemoryPatchDBBuilder.storeRealization: Unable to store the realization " + realizationRecord.realization + ".");
                throw new DatabaseError(exception, "MemoryPatchDBBuilder.storeRealization: Could not store a new realization.");
            }
        }
    }

    private void storePatchBase(SimpleDatabase simpleDatabase, PatchBaseRecord patchBaseRecord) throws IllegalAccessException {
        try {
            simpleDatabase.addObject((Object)patchBaseRecord);
        }
        catch (Exception exception) {
            this.log.println(this, 2, "MemoryPatchDBBuilder.storePatchBase: Unexpectedly denied access to the database.");
            throw new DatabaseError(exception, "MemoryPatchDBBuilder.storePatchBase: Denied access to the database.");
        }
    }

    private void dispatchProgressEvent(DownloadPatchDBEvent downloadPatchDBEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchDBListener downloadPatchDBListener = (DownloadPatchDBListener)enumeration.nextElement();
            downloadPatchDBListener.downloadPatchDBProgress(downloadPatchDBEvent);
        }
    }

    private void dispatchDoneEvent(DownloadPatchDBEvent downloadPatchDBEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchDBListener downloadPatchDBListener = (DownloadPatchDBListener)enumeration.nextElement();
            downloadPatchDBListener.downloadPatchDBDone(downloadPatchDBEvent);
        }
    }
}

