/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.database;

import com.sun.patchpro.database.DBBuilderFailedException;
import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.database.PatchDBBuilder;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.DownloadPatchDBEvent;
import com.sun.patchpro.model.DownloadPatchDBListener;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.Percentage;
import java.util.Enumeration;
import java.util.Vector;

public class GroupPatchDBBuilder
implements PatchDBBuilder,
DownloadPatchDBListener {
    private int hostCount = 1;
    private int hostsRemaining = 1;
    private Percentage progress = new Percentage(0);
    private Vector listeners;
    private PatchProLog log;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private ReadOnlyHost targetHost;

    public GroupPatchDBBuilder(ReadOnlyHost readOnlyHost) {
        this.log = PatchProLog.getInstance();
        this.listeners = new Vector();
        this.targetHost = readOnlyHost;
    }

    public synchronized PatchDB buildDB(String string, String string2, String string3, String string4) throws DBBuilderFailedException {
        throw new DBBuilderFailedException("GroupPatchDBBuilder: Cannot process a group without a Host.");
    }

    public synchronized void buildDB(ReadOnlyHost readOnlyHost) throws DBBuilderFailedException {
        PatchDBBuilder patchDBBuilder = null;
        this.hostCount = this.hostsRemaining = readOnlyHost.getAssociateCount() + 1;
        try {
            try {
                patchDBBuilder = readOnlyHost.getSessionData().getPatchDBBuilder();
                patchDBBuilder.addListener(this);
                patchDBBuilder.buildDB(readOnlyHost);
                patchDBBuilder.removeListener(this);
                Enumeration enumeration = readOnlyHost.getAssociates();
                while (enumeration.hasMoreElements()) {
                    ReadOnlyHost readOnlyHost2 = (ReadOnlyHost)enumeration.nextElement();
                    patchDBBuilder = readOnlyHost2.getSessionData().getPatchDBBuilder();
                    patchDBBuilder.addListener(this);
                    patchDBBuilder.buildDB(readOnlyHost2);
                    patchDBBuilder.removeListener(this);
                }
            }
            catch (DBBuilderFailedException dBBuilderFailedException) {
                this.log.println(this, 2, "GroupPatchDBBuilder: Internal error. Build failed.");
                this.log.printStackTrace(this, 2, dBBuilderFailedException);
                throw new DBBuilderFailedException(dBBuilderFailedException.getMessage());
            }
            catch (Exception exception) {
                this.log.println(this, 2, "GroupPatchDBBuilder: Internal error. Unknown Error");
                this.log.printStackTrace(this, 2, exception);
                throw new DBBuilderFailedException(exception.getMessage());
            }
            Object var6_7 = null;
            if (patchDBBuilder != null) {
                patchDBBuilder.removeListener(this);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (patchDBBuilder != null) {
                patchDBBuilder.removeListener(this);
            }
            throw throwable;
        }
    }

    public synchronized PatchDB buildDB(String string) throws DBBuilderFailedException {
        throw new DBBuilderFailedException("GroupPatchDBBuilder: Cannot process a group without a Host.");
    }

    public Percentage percentComplete() {
        return this.progress;
    }

    public void addListener(DownloadPatchDBListener downloadPatchDBListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(downloadPatchDBListener);
        }
    }

    public void removeListener(DownloadPatchDBListener downloadPatchDBListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(this.listeners);
        }
    }

    public void downloadPatchDBProgress(DownloadPatchDBEvent downloadPatchDBEvent) {
        int n = downloadPatchDBEvent == null ? 100 : ((PatchDBBuilder)downloadPatchDBEvent.getSource()).percentComplete().getPercentage();
        Percentage percentage = this.progress;
        synchronized (percentage) {
            this.progress = new Percentage((int)(((double)(this.hostCount - this.hostsRemaining) * 100.0 + (double)n) / (double)this.hostCount));
        }
        this.dispatchProgressEvent(new DownloadPatchDBEvent(this));
    }

    public void downloadPatchDBDone(DownloadPatchDBEvent downloadPatchDBEvent) {
        if (--this.hostsRemaining == 0) {
            this.dispatchDoneEvent(new DownloadPatchDBEvent(this));
        }
    }

    public void downloadPatchDBFailed(DownloadPatchDBEvent downloadPatchDBEvent) {
        this.dispatchFailedEvent(new DownloadPatchDBEvent(this));
    }

    private void dispatchProgressEvent(DownloadPatchDBEvent downloadPatchDBEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchDBListener downloadPatchDBListener = (DownloadPatchDBListener)enumeration.nextElement();
            downloadPatchDBListener.downloadPatchDBProgress(downloadPatchDBEvent);
        }
    }

    private void dispatchDoneEvent(DownloadPatchDBEvent downloadPatchDBEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchDBListener downloadPatchDBListener = (DownloadPatchDBListener)enumeration.nextElement();
            downloadPatchDBListener.downloadPatchDBDone(downloadPatchDBEvent);
        }
    }

    private void dispatchFailedEvent(DownloadPatchDBEvent downloadPatchDBEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchDBListener downloadPatchDBListener = (DownloadPatchDBListener)enumeration.nextElement();
            downloadPatchDBListener.downloadPatchDBFailed(downloadPatchDBEvent);
        }
    }
}

