/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.cli;

import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProAccessor;
import com.sun.patchpro.model.PatchProEvent;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchAccumulator;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.util.GetOpt;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.NoResultException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;

public final class SMPatchServices
implements PatchProListener {
    private static final String add_validArgs = "d:hi:x:";
    private static final String analyze_validArgs = "h";
    private static final String download_validArgs = "d:hi:x:";
    private static final String remove_validArgs = "hi:";
    private static final String update_validArgs = "d:h";
    private static final String DEFAULT_PATCH_DIRECTORY = "/var/sadm/spool";
    private static final String DEFAULT_SEQUESTER_DIRECTORY = "/var/sadm/spool/patchproSequester";
    private static final int LINELENGTH = 200;
    private static boolean outData;
    private static Vector exceptionRepository;
    private static LocalizedMessages msgcat;
    private static String hostMachine;
    private static String sequesterDirectory;
    private static boolean debug;
    private PatchPro model;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private PatchList unavailablePatches = null;
    boolean done = false;
    boolean failed = false;

    public SMPatchServices() {
        debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
        msgcat = new LocalizedMessages(this.properties.getLocale());
    }

    /*
     * Loose catch block
     */
    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = -1;
        GetOpt getOpt = null;
        InetAddress inetAddress = null;
        PatchList patchList = null;
        Object var7_6 = null;
        Runtime runtime = null;
        SMPatchServices sMPatchServices = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String[] stringArray2 = null;
        String[] stringArray3 = new String[3];
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        try {
            sMPatchServices = new SMPatchServices();
            sMPatchServices.instantiateModel();
        }
        catch (PatchProException patchProException) {
            System.err.println(patchProException.getLocalizedMessage());
            System.exit(1);
        }
        if (stringArray.length < 1) {
            SMPatchServices.usageTool(msgcat);
            System.exit(1);
        }
        if (stringArray.length == 1 && stringArray[0].equals("-h")) {
            SMPatchServices.usageTool(msgcat);
            System.exit(0);
        }
        string5 = stringArray[0];
        stringArray2 = new String[stringArray.length - 1];
        int n3 = 0;
        while (n3 < stringArray.length - 1) {
            if (stringArray[n3 + 1].substring(0, 1).equals("-") && stringArray[n3 + 1].length() > 2) {
                vector3.addElement(stringArray[n3 + 1].substring(0, 2));
                vector3.addElement(stringArray[n3 + 1].substring(2));
            } else {
                vector3.addElement(stringArray[n3 + 1]);
            }
            ++n3;
        }
        stringArray2 = new String[vector3.size()];
        int n4 = 0;
        while (n4 < vector3.size()) {
            stringArray2[n4] = (String)vector3.elementAt(n4);
            if (debug) {
                System.out.println("Option " + n4 + " : " + stringArray2[n4]);
            }
            ++n4;
        }
        try {
            inetAddress = InetAddress.getLocalHost();
            hostMachine = "\"" + InetAddress.getLocalHost() + "\"";
        }
        catch (UnknownHostException unknownHostException) {
            hostMachine = "\"local host\"";
        }
        catch (SecurityException securityException) {
            hostMachine = "\"local host\"";
        }
        if (string5.equals("add")) {
            try {
                if (stringArray2.length == 0) {
                    System.out.println(msgcat.getMessage("missing_patch_id", "At least one patch must be specified for this request."));
                    System.exit(1);
                }
                getOpt = new GetOpt(stringArray2, "d:hi:x:");
                try {
                    int n5;
                    while ((n5 = getOpt.getNextOption()) != -1) {
                        ++n;
                        switch ((char)n5) {
                            case 'd': {
                                if (bl2) {
                                    bl = true;
                                    break;
                                }
                                bl2 = true;
                                string = getOpt.getOptionArg();
                                ++n;
                                break;
                            }
                            case 'i': {
                                if (bl3) {
                                    String string6 = getOpt.getOptionArg();
                                    if (vector2.contains(string6)) {
                                        System.out.println(msgcat.getMessage("dup_patchids", "Ignoring duplicate patch ID") + " " + string6);
                                    } else {
                                        vector2.addElement(string6);
                                    }
                                    ++n;
                                    break;
                                }
                                bl3 = true;
                                vector2.addElement(getOpt.getOptionArg());
                                ++n;
                                break;
                            }
                            case 'x': {
                                if (bl4) {
                                    bl = true;
                                    break;
                                }
                                bl4 = true;
                                string2 = getOpt.getOptionArg();
                                if (string2.length() < 8 || !string2.substring(0, 7).equals("idlist=")) {
                                    throw new IllegalArgumentException(string2);
                                }
                                string3 = string2.substring(7);
                                ++n;
                                break;
                            }
                            case 'h': {
                                if (bl5) {
                                    bl = true;
                                    break;
                                }
                                bl5 = true;
                                break;
                            }
                            default: {
                                System.err.println(msgcat.getMessage("uncovered_GetOpt_error", "Invalid option or invalid syntax specification detected."));
                                System.exit(1);
                            }
                        }
                    }
                    if (bl) {
                        System.err.println(msgcat.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                        SMPatchServices.usageAdd(msgcat);
                        System.exit(1);
                    }
                    if (bl5) {
                        SMPatchServices.usageAdd(msgcat);
                        System.exit(0);
                    }
                    if (n != stringArray2.length) {
                        System.err.println(msgcat.getMessage("invalid_option_detected", "Unexpected option or option value detected."));
                        SMPatchServices.usageAdd(msgcat);
                        System.exit(1);
                    }
                    if (bl3 && bl4) {
                        System.err.println(msgcat.getMessage("smpatch_mutex_optix", "Options i and x are mutually exclusive"));
                        SMPatchServices.usageAdd(msgcat);
                        System.exit(1);
                    }
                    if (debug && bl3) {
                        int n6 = 0;
                        while (n6 < vector2.size()) {
                            System.out.println("Patch to add via the -i options is " + vector2.elementAt(n6));
                            ++n6;
                        }
                    }
                    vector = bl4 ? sMPatchServices.createPatchList(string3) : sMPatchServices.createPatchList(vector2);
                    if (!bl2) {
                        string = DEFAULT_PATCH_DIRECTORY;
                        sequesterDirectory = DEFAULT_SEQUESTER_DIRECTORY;
                    } else {
                        sequesterDirectory = string + System.getProperty("file.separator") + "patchproSequester";
                    }
                    if (debug) {
                        System.out.println("Effective patch directory is " + string);
                    }
                    sMPatchServices.addPatches(vector, new File(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(msgcat.getMessage("illegal_argument_detected", "Illegal Argument detected") + ": " + illegalArgumentException.getMessage());
                    SMPatchServices.usageAdd(msgcat);
                    System.exit(1);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(msgcat.getMessage("patchlist_file_not_found", "Specified patch list file was not found."));
                    System.exit(2);
                }
                catch (IOException iOException) {
                    System.err.println(msgcat.getMessage("err_processing_patch_file", "Error detected while processing patch list file") + ": " + iOException.getMessage());
                    System.exit(2);
                }
                catch (MalformedPatchException malformedPatchException) {
                    System.exit(2);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
            catch (Exception exception) {
                System.exit(2);
            }
        } else if (string5.equals("download")) {
            try {
                getOpt = new GetOpt(stringArray2, "d:hi:x:");
                try {
                    int n7;
                    while ((n7 = getOpt.getNextOption()) != -1) {
                        ++n;
                        switch ((char)n7) {
                            case 'd': {
                                if (bl2) {
                                    bl = true;
                                    break;
                                }
                                bl2 = true;
                                string = getOpt.getOptionArg();
                                ++n;
                                break;
                            }
                            case 'i': {
                                if (bl3) {
                                    String string7 = getOpt.getOptionArg();
                                    if (vector2.contains(string7)) {
                                        System.out.println(msgcat.getMessage("dup_patchids", "Ignoring duplicate patchID") + " " + string7);
                                    } else {
                                        vector2.addElement(string7);
                                    }
                                    ++n;
                                    break;
                                }
                                bl3 = true;
                                vector2.addElement(getOpt.getOptionArg());
                                ++n;
                                break;
                            }
                            case 'x': {
                                if (bl4) {
                                    bl = true;
                                    break;
                                }
                                bl4 = true;
                                string2 = getOpt.getOptionArg();
                                if (string2.length() < 8 || !string2.substring(0, 7).equals("idlist=")) {
                                    throw new IllegalArgumentException(string2);
                                }
                                string3 = string2.substring(7);
                                ++n;
                                break;
                            }
                            case 'h': {
                                if (bl5) {
                                    bl = true;
                                    break;
                                }
                                bl5 = true;
                                break;
                            }
                            default: {
                                System.err.println(msgcat.getMessage("uncovered_GetOpt_error", "Invalid option or invalid syntax specification detected."));
                                System.exit(1);
                            }
                        }
                    }
                    if (bl) {
                        System.err.println(msgcat.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                        SMPatchServices.usageDownload(msgcat);
                        System.exit(1);
                    }
                    if (bl5) {
                        SMPatchServices.usageDownload(msgcat);
                        System.exit(0);
                    }
                    if (n != stringArray2.length) {
                        System.err.println(msgcat.getMessage("invalid_option_detected", "Unexpected option or option value detected."));
                        SMPatchServices.usageDownload(msgcat);
                        System.exit(1);
                    }
                    if (bl3 && bl4) {
                        System.err.println(msgcat.getMessage("smpatch_mutex_optix", "Options i and x are mutually exclusive"));
                        SMPatchServices.usageDownload(msgcat);
                        System.exit(1);
                    }
                    if (debug && bl3) {
                        int n8 = 0;
                        while (n8 < vector2.size()) {
                            System.out.println("Patch to download via the -i options is " + vector2.elementAt(n8));
                            ++n8;
                        }
                    }
                    vector = bl4 ? sMPatchServices.createPatchList(string3) : sMPatchServices.createPatchList(vector2);
                    if (!bl2) {
                        string = DEFAULT_PATCH_DIRECTORY;
                    }
                    if (!bl4 && !bl3) {
                        sMPatchServices.downloadAllPatches(new File(string));
                        System.exit(0);
                    }
                    System.out.println(msgcat.getMessage("requested_patches", "Requested patches:"));
                    System.out.println("");
                    int n9 = 0;
                    while (n9 < vector.size()) {
                        System.out.println("    " + vector.elementAt(n9));
                        ++n9;
                    }
                    System.out.println("");
                    sMPatchServices.downloadPatches(vector, new File(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(msgcat.getMessage("illegal_argument_detected", "Illegal Argument detected") + ": " + illegalArgumentException.getMessage());
                    SMPatchServices.usageDownload(msgcat);
                    System.exit(1);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(msgcat.getMessage("patchlist_file_not_found", "Specified patch list file was not found."));
                    System.exit(2);
                }
                catch (IOException iOException) {
                    System.err.println(msgcat.getMessage("err_processing_patch_file", "Error detected while processing patch list file") + ": " + iOException.getMessage());
                    System.exit(2);
                }
                catch (MalformedPatchException malformedPatchException) {
                    System.exit(2);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    System.exit(2);
                }
            }
            catch (Exception exception) {
                System.exit(1);
            }
        } else if (string5.equals("analyze")) {
            try {
                if (stringArray2.length == 0) {
                    patchList = sMPatchServices.displayPatchList();
                    System.exit(0);
                }
                getOpt = new GetOpt(stringArray2, "d:hi:x:");
                try {
                    int n10;
                    while ((n10 = getOpt.getNextOption()) != -1) {
                        ++n;
                        switch ((char)n10) {
                            case 'h': {
                                ++n;
                                if (bl5) {
                                    bl = true;
                                    break;
                                }
                                bl5 = true;
                                break;
                            }
                            default: {
                                System.err.println(msgcat.getMessage("uncovered_GetOpt_error", "Invalid option or invalid syntax specification detected."));
                                System.exit(1);
                            }
                        }
                    }
                    if (bl) {
                        System.err.println(msgcat.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                        SMPatchServices.usageAnalyze(msgcat);
                        System.exit(1);
                    }
                    if (bl5) {
                        SMPatchServices.usageAnalyze(msgcat);
                        System.exit(0);
                    }
                    if (n != stringArray2.length) {
                        System.err.println(msgcat.getMessage("invalid_option_detected", "Unexpected option or option value detected."));
                        SMPatchServices.usageAnalyze(msgcat);
                        System.exit(1);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(msgcat.getMessage("illegal_argument_detected", "Illegal Argument detected") + ": " + illegalArgumentException.getMessage());
                    SMPatchServices.usageAnalyze(msgcat);
                    System.exit(1);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    System.exit(2);
                }
            }
            catch (Exception exception) {
                System.exit(2);
            }
        } else if (string5.equals("remove")) {
            try {
                char[] cArray = new char[200];
                if (stringArray2.length == 0) {
                    System.out.println(msgcat.getMessage("missing_patch_id", "At least one patch must be specified for this request."));
                    System.exit(1);
                }
                getOpt = new GetOpt(stringArray2, remove_validArgs);
                try {
                    block148: {
                        int n11;
                        while ((n11 = getOpt.getNextOption()) != -1) {
                            ++n;
                            switch ((char)n11) {
                                case 'h': {
                                    ++n;
                                    if (bl5) {
                                        bl = true;
                                        break;
                                    }
                                    bl5 = true;
                                    break;
                                }
                                case 'i': {
                                    if (bl3) {
                                        bl = true;
                                        break;
                                    }
                                    bl3 = true;
                                    string4 = getOpt.getOptionArg();
                                    ++n;
                                    break;
                                }
                                default: {
                                    System.err.println(msgcat.getMessage("uncovered_GetOpt_error", "Invalid option or invalid syntax specification detected."));
                                    System.exit(1);
                                }
                            }
                        }
                        if (bl) {
                            System.err.println(msgcat.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                            SMPatchServices.usageRemove(msgcat);
                            System.exit(1);
                        }
                        if (bl5) {
                            SMPatchServices.usageRemove(msgcat);
                            System.exit(0);
                        }
                        if (n != stringArray2.length) {
                            System.err.println(msgcat.getMessage("invalid_option_detected", "Unexpected option or option value detected."));
                            SMPatchServices.usageRemove(msgcat);
                            System.exit(1);
                        }
                        if (!sMPatchServices.isValidPatch(string4)) {
                            System.err.println(string4 + " " + msgcat.getMessage("err_patchid", "is an invalid patch. Please specify patch in XXXXXX-YY format where X and Y are numbers."));
                            System.exit(1);
                        }
                        System.out.println(msgcat.getMessage("machine_name", "On machine") + " " + hostMachine + " ...\n");
                        System.out.println(msgcat.getMessage("remove_patch", "Removing patch") + " " + string4);
                        runtime = Runtime.getRuntime();
                        stringArray3[0] = "/bin/sh";
                        stringArray3[1] = "-c";
                        stringArray3[2] = "/usr/sbin/patchrm " + string4;
                        Process process = runtime.exec(stringArray3);
                        n2 = process.waitFor();
                        InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                        InputStreamReader inputStreamReader2 = new InputStreamReader(process.getErrorStream());
                        try {
                            outData = false;
                            do {
                                try {
                                    int n12;
                                    sMPatchServices.clearArray(cArray, 200);
                                    if (inputStreamReader.ready()) {
                                        int n13 = 0;
                                        while ((n13 = inputStreamReader.read(cArray, 0, 200)) != -1) {
                                            outData = true;
                                            n12 = 0;
                                            while (n12 < n13) {
                                                System.out.print(cArray[n12]);
                                                ++n12;
                                            }
                                            sMPatchServices.clearArray(cArray, 200);
                                        }
                                    }
                                    if (!inputStreamReader2.ready()) continue;
                                    int n14 = 0;
                                    while ((n14 = inputStreamReader2.read(cArray, 0, 200)) != -1) {
                                        outData = true;
                                        n12 = 0;
                                        while (n12 < n14) {
                                            System.err.print(cArray[n12]);
                                            ++n12;
                                        }
                                        sMPatchServices.clearArray(cArray, 200);
                                    }
                                }
                                catch (IOException iOException) {
                                    outData = true;
                                    System.out.println("smpatch: IOException " + iOException + " thrown by out/err read.");
                                }
                            } while (!outData);
                            Object var34_69 = null;
                        }
                        catch (Throwable throwable) {
                            Object var34_71 = null;
                            inputStreamReader.close();
                            inputStreamReader2.close();
                            inputStreamReader = null;
                            inputStreamReader2 = null;
                            throw throwable;
                        }
                        inputStreamReader.close();
                        inputStreamReader2.close();
                        inputStreamReader = null;
                        inputStreamReader2 = null;
                        {
                            break block148;
                            catch (Exception exception) {
                                System.err.println("smpatch: Failed to read output in reader thread.");
                                exception.printStackTrace();
                                Object var34_70 = null;
                                inputStreamReader.close();
                                inputStreamReader2.close();
                                inputStreamReader = null;
                                inputStreamReader2 = null;
                            }
                        }
                    }
                    if (n2 > 0) {
                        if (debug) {
                            System.out.println(stringArray3[0] + stringArray3[1] + stringArray3[2] + " completed with cc=" + n2);
                        }
                        System.exit(2);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(msgcat.getMessage("illegal_argument_detected", "Illegal Argument detected") + ": " + illegalArgumentException.getMessage());
                    SMPatchServices.usageRemove(msgcat);
                    System.exit(1);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    System.exit(2);
                }
            }
            catch (Exception exception) {
                System.exit(2);
            }
        } else if (string5.equals("update")) {
            try {
                getOpt = new GetOpt(stringArray2, update_validArgs);
                try {
                    int n15;
                    while ((n15 = getOpt.getNextOption()) != -1) {
                        ++n;
                        switch ((char)n15) {
                            case 'd': {
                                if (bl2) {
                                    bl = true;
                                    break;
                                }
                                bl2 = true;
                                string = getOpt.getOptionArg();
                                ++n;
                                break;
                            }
                            case 'h': {
                                ++n;
                                if (bl5) {
                                    bl = true;
                                    break;
                                }
                                bl5 = true;
                                break;
                            }
                            default: {
                                System.err.println(msgcat.getMessage("uncovered_GetOpt_error", "Invalid option or invalid syntax specification detected."));
                                System.exit(1);
                            }
                        }
                    }
                    if (bl) {
                        System.err.println(msgcat.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                        SMPatchServices.usageUpdate(msgcat);
                        System.exit(1);
                    }
                    if (bl5) {
                        SMPatchServices.usageUpdate(msgcat);
                        System.exit(0);
                    }
                    if (!bl2) {
                        string = DEFAULT_PATCH_DIRECTORY;
                        sequesterDirectory = DEFAULT_SEQUESTER_DIRECTORY;
                    } else {
                        sequesterDirectory = string + System.getProperty("file.separator") + "patchproSequester";
                    }
                    if (n != stringArray2.length) {
                        System.err.println(msgcat.getMessage("invalid_option_detected", "Unexpected option or option value detected."));
                        SMPatchServices.usageUpdate(msgcat);
                        System.exit(1);
                    }
                    System.out.println(msgcat.getMessage("machine_name", "On machine") + " " + hostMachine + " ...\n");
                    sMPatchServices.installAllPatches(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(msgcat.getMessage("illegal_argument_detected", "Illegal Argument detected") + ": " + illegalArgumentException.getMessage());
                    SMPatchServices.usageUpdate(msgcat);
                    System.exit(1);
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    System.exit(2);
                }
            }
            catch (Exception exception) {
                System.exit(2);
            }
        } else {
            System.err.println(msgcat.getMessage("unknown_subcommand", "Unknown subcommand was specified."));
            SMPatchServices.usageTool(msgcat);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void usageTool(LocalizedMessages localizedMessages) {
        SMPatchServices.usageAdd(localizedMessages);
        SMPatchServices.usageAnalyze(localizedMessages);
        SMPatchServices.usageDownload(localizedMessages);
        SMPatchServices.usageRemove(localizedMessages);
        SMPatchServices.usageUpdate(localizedMessages);
    }

    private static void usageAdd(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("usage_header", "Usage:"));
        System.err.println(localizedMessages.getMessage("smpatch_add_usage_1", "\tsmpatch add [-h] -i <patchid> [-i <patchid> ...] |<patchlist_file>  [-d <patchdir>] where:\n"));
        System.err.println(localizedMessages.getMessage("smpatch_add_usage_2", "\tadd\tSubcommand used to install the patches."));
        System.err.println(localizedMessages.getMessage("smpatch_add_usage_3", "\t-d <patchdir>\n\t\tUsed to specify the directory where patches are\n\t\texpected to be installed from.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_add_usage_4", "\t-h\tUsed to display help info for the add subcommand.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_add_usage_5", "\t-i <patchid>\n\t\tUsed to specify the id of the patch to install.\n\t\tOne or more patches can be specified using this\n\t\toption.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_add_usage_6", "\t-x idlist=<patchlist_file>\n\t\tUsed to specify the path of the file that contains\n\t\ta list of patches to install."));
        System.err.println();
    }

    private static void usageAnalyze(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("usage_header", "Usage:"));
        System.err.println(localizedMessages.getMessage("smpatch_analyze_usage_1", "\tsmpatch analyze [-h] where:"));
        System.err.println(localizedMessages.getMessage("smpatch_analyze_usage_2", "\tanalyze\tSubcommand used to analyze a host and list\n\t\tneeded patches.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_analyze_usage_3", "\t-h\tUsed to display help info for the analyze subcommand.\n"));
        System.err.println();
    }

    private static void usageDownload(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("usage_header", "Usage:"));
        System.err.println(localizedMessages.getMessage("smpatch_download_usage_1", "\tsmpatch download [-h] -i <patchid> [-i <patchid> ...] |\n\t\t-x idlist=<patchlist_file>  [-d <patchdir>] where:\n"));
        System.err.println(localizedMessages.getMessage("smpatch_download_usage_2", "\tdownload\tSubcommand used to download patches from SunSolve.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_download_usage_3", "\t-d <patchdir>\n\t\tUsed to specify the directory where the patches\n\t\tfrom SunSolve are to be downloaded.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_download_usage_4", "\t-h\tUsed to display help info for the download subcommand.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_download_usage_5", "\t-i <patchid>\n\t\tUsed to specify the id of the patch to download.\n\t\tOne or more patches can be specified using this\n\t\toption.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_download_usage_6", "\t-x idlist=<patchlist_file>\n\t\tUsed to specify the path of the file that contains\n\t\ta list of patches to download."));
        System.err.println();
    }

    private static void usageRemove(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("usage_header", "Usage:"));
        System.err.println(localizedMessages.getMessage("smpatch_remove_usage_1", "\tsmpatch remove -i patchid [-h] where:\n"));
        System.err.println(localizedMessages.getMessage("smpatch_remove_usage_2", "\tremove\tSubcommand used to remove a patch.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_remove_usage_3", "\t-h\tUsed to display help info for the remove subcommand.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_remove_usage_4", "\t-i <patchid>\n\t\tUsed to specify the id of the patch to remove."));
        System.err.println();
    }

    private static void usageUpdate(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("usage_header", "Usage:"));
        System.err.println(localizedMessages.getMessage("smpatch_update_usage_1", "\tsmpatch update [-d patchdir] [-h] where:\n"));
        System.err.println(localizedMessages.getMessage("smpatch_update_usage_2", "\tupdate\tSubcommand used to download and install required\n\t\tpatches for the local host.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_update_usage_3", "\t-d <patchdir>\n\t\tUsed to specify the directory  where the patches\n\t\tfrom SunSolve which are required by the local host\n\t\tare to be downloaded and installed from.\n"));
        System.err.println(localizedMessages.getMessage("smpatch_update_usage_4", "\t-h\tUsed to display help info for the update subcommand.\n"));
        System.err.println();
    }

    private void instantiateModel() throws PatchProException {
        new PatchProAccessor();
        this.model = PatchProAccessor.getPatchPro();
    }

    public boolean areAccessible(PatchList patchList, File file) {
        boolean bl = true;
        File file2 = null;
        String string = null;
        IPatch iPatch = null;
        try {
            int n = 0;
            while (n < patchList.size()) {
                iPatch = (IPatch)patchList.getPatchAt(n);
                string = file + System.getProperty("file.separator") + iPatch.getPatchID().getPatchID() + ".jar";
                file2 = new File(string);
                if (!file2.exists()) {
                    System.err.println("(" + (n + 1) + ") " + msgcat.getMessage("err_patch_missing", "Patch not found:") + " " + iPatch.getPatchID().getPatchID());
                    bl = false;
                }
                file2 = null;
                string = null;
                iPatch = null;
                ++n;
            }
        }
        catch (NoSuchPatchException noSuchPatchException) {
            System.err.println("Error: Invalid patch list detected");
            bl = false;
        }
        return bl;
    }

    public void addPatches(Vector vector, File file) {
        try {
            int n;
            Serializable serializable;
            System.out.println(msgcat.getMessage("machine_name", "On machine") + " " + hostMachine + " ...\n");
            this.model.addListener(this);
            this.model.initializeDatabase();
            this.done = false;
            while (!this.done) {
                Thread.sleep(2000L);
            }
            this.done = false;
            this.model.generateAbbreviatedHost();
            while (!this.done) {
                Thread.sleep(2000L);
            }
            ReadOnlyHost readOnlyHost = this.model.getAbbreviatedHost();
            this.model.setHost(readOnlyHost);
            PatchAccumulator patchAccumulator = this.model.getPatchAccumulator();
            PatchList patchList = new PatchListImpl();
            int n2 = 0;
            while (n2 < vector.size()) {
                if (debug) {
                    System.out.println("Accumulating patches for " + vector.elementAt(n2));
                }
                serializable = new PatchID((String)vector.elementAt(n2));
                patchList = patchAccumulator.getPatchClosure((PatchID)serializable);
                if (debug) {
                    System.out.println("The Total number of patches that were acculmulated so far is " + patchList.size());
                    int n3 = 0;
                    while (n3 < patchList.size()) {
                        System.out.println(((IPatch)patchList.getPatchAt(n3)).getPatchID().getPatchID());
                        ++n3;
                    }
                    System.out.println(" -- ");
                }
                ++n2;
            }
            System.out.println("");
            serializable = new Vector();
            String string = null;
            String string2 = null;
            boolean bl = false;
            int n4 = 0;
            while (n4 < vector.size()) {
                bl = false;
                string = (String)vector.elementAt(n4);
                n = 0;
                while (n < patchList.size()) {
                    string2 = patchList.getPatchAt(n).getPatchID().getPatchID();
                    if (string.equals(string2)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    ((Vector)serializable).addElement(string);
                }
                ++n4;
            }
            if (((Vector)serializable).size() > 0) {
                System.out.println("\n" + msgcat.getMessage("download_excluded", "The following patch(es) are already installed or replaced by another patch:"));
                n = 0;
                while (n < ((Vector)serializable).size()) {
                    System.out.println("    " + ((Vector)serializable).elementAt(n));
                    ++n;
                }
                System.out.println("");
            }
            if (patchList.size() == 0) {
                System.exit(2);
            }
            Vector<String> vector2 = new Vector<String>();
            int n5 = 0;
            while (n5 < patchList.size()) {
                string2 = patchList.getPatchAt(n5).getPatchID().getPatchID();
                if (!vector.contains(string2)) {
                    vector2.addElement(string2);
                }
                ++n5;
            }
            if (vector2.size() > 0) {
                System.out.println("\n" + msgcat.getMessage("download_added", "The following patches were added due to patch dependencies:"));
                int n6 = 0;
                while (n6 < vector2.size()) {
                    System.out.println("    " + vector2.elementAt(n6));
                    ++n6;
                }
                System.out.println("");
            }
            this.defineValidPatchTypes(patchList);
            if (!this.areAccessible(patchList, file)) {
                System.err.println(msgcat.getMessage("patches_not_found", "One or more patches could not be found."));
                System.exit(2);
            }
            this.properties.setProperty("smpatch.request", "true");
            this.properties.setProperty("patchpro.patch.sequester.directory", sequesterDirectory);
            this.model.installPatches(patchList, file);
            this.done = false;
            while (!this.done) {
                Thread.sleep(2000L);
                if (!debug) continue;
                System.out.print(".");
            }
            this.problemSummary();
        }
        catch (NoSuchPatchException noSuchPatchException) {
            System.err.println(noSuchPatchException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void downloadPatches(Vector vector, File file) {
        try {
            int n;
            int n2;
            Serializable serializable;
            System.out.println(msgcat.getMessage("download_patches", "Downloading the requested patches"));
            this.model.addListener(this);
            this.model.initializeDatabase();
            this.done = false;
            while (!this.done) {
                Thread.sleep(2000L);
            }
            this.done = false;
            this.model.generateAbbreviatedHost();
            while (!this.done) {
                Thread.sleep(2000L);
            }
            ReadOnlyHost readOnlyHost = this.model.getAbbreviatedHost();
            this.model.setHost(readOnlyHost);
            PatchAccumulator patchAccumulator = this.model.getPatchAccumulator();
            PatchList patchList = new PatchListImpl();
            int n3 = 0;
            while (n3 < vector.size()) {
                if (debug) {
                    System.out.println("Accumulating patches for " + vector.elementAt(n3));
                }
                serializable = new PatchID((String)vector.elementAt(n3));
                patchList = patchAccumulator.getPatchClosure((PatchID)serializable);
                if (debug) {
                    System.out.println("The Total number of patches that were acculmulated so far is " + patchList.size());
                    int n4 = 0;
                    while (n4 < patchList.size()) {
                        System.out.println(((IPatch)patchList.getPatchAt(n4)).getPatchID().getPatchID());
                        ++n4;
                    }
                    System.out.println(" -- ");
                }
                ++n3;
            }
            System.out.println("");
            serializable = new Vector();
            String string = null;
            String string2 = null;
            boolean bl = false;
            int n5 = 0;
            while (n5 < vector.size()) {
                bl = false;
                string = (String)vector.elementAt(n5);
                n2 = 0;
                while (n2 < patchList.size()) {
                    string2 = patchList.getPatchAt(n2).getPatchID().getPatchID();
                    if (string.equals(string2)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    ((Vector)serializable).addElement(string);
                }
                ++n5;
            }
            if (((Vector)serializable).size() > 0) {
                System.out.println("\n" + msgcat.getMessage("download_excluded", "The following patch(es) are already installed or replaced by another patch:"));
                n2 = 0;
                while (n2 < ((Vector)serializable).size()) {
                    System.out.println("    " + ((Vector)serializable).elementAt(n2));
                    ++n2;
                }
            }
            Vector<String> vector2 = new Vector<String>();
            int n6 = 0;
            while (n6 < patchList.size()) {
                string2 = patchList.getPatchAt(n6).getPatchID().getPatchID();
                if (!vector.contains(string2)) {
                    vector2.addElement(string2);
                }
                ++n6;
            }
            if (vector2.size() > 0) {
                System.out.println("\n" + msgcat.getMessage("download_added", "The following patches were added due to patch dependencies:"));
                n = 0;
                while (n < vector2.size()) {
                    System.out.println("    " + vector2.elementAt(n));
                    ++n;
                }
            }
            if (patchList.size() == 0) {
                System.exit(2);
            }
            n = 0;
            while (n < patchList.size()) {
                patchList.setSelectionStatus(n, true);
                ++n;
            }
            this.properties.setProperty("smpatch.request", "true");
            this.model.downloadPatches(patchList, file);
            if (debug) {
                System.out.println(msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + file.getPath() + "...");
            }
            this.done = false;
            while (!this.done) {
                Thread.sleep(2000L);
                if (!debug) continue;
                System.out.print(".");
            }
            if (this.checkForUnavailablePatches() != patchList.size()) {
                System.out.println("\n" + msgcat.getMessage("download_done", "For downloaded patch(es) see") + " " + file.getPath());
            }
            this.problemSummary();
        }
        catch (NoSuchPatchException noSuchPatchException) {
            System.err.println(noSuchPatchException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public PatchList displayPatchList() {
        PatchList patchList = null;
        try {
            System.out.println(msgcat.getMessage("host_needed_patches", "Assessing required patches for machine") + " " + hostMachine + " . " + msgcat.getMessage("please_wait", "Please wait ...") + "\n");
            this.model.addListener(this);
            this.done = false;
            this.model.assessNeededPatches();
            while (!this.done) {
                Thread.sleep(2000L);
                if (!debug) continue;
                System.out.print(".");
            }
            patchList = this.model.getNeededPatches();
            if (patchList.size() > 0) {
                this.printPatchList(patchList);
            } else {
                System.out.println(msgcat.getMessage("no_required_patches", "No patches needed."));
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException.getMessage());
        }
        catch (NoResultException noResultException) {
            System.err.println(noResultException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return patchList;
    }

    public void printPatchList(PatchList patchList) {
        if (patchList.hasAnyErrors()) {
            System.out.println(msgcat.getMessage("errorsFound", "Errors were found."));
        }
        int n = 0;
        while (n < patchList.size()) {
            try {
                Patch patch = patchList.getPatchAt(n);
                System.out.println(patch.getPatchID().getPatchID() + " " + patch.getPatchInfo().getSynopsis());
                boolean bl = patchList.hasErrorAt(n);
                if (bl) {
                    System.err.println("    Error: " + patchList.getErrorAt(n));
                }
            }
            catch (NoSuchPatchException noSuchPatchException) {
                System.err.println(msgcat.getMessage("patchlist_non_existing_patch", "Error: The patch list contains a non-existing patch."));
            }
            ++n;
        }
    }

    public void downloadAllPatches(File file) {
        try {
            System.out.println(msgcat.getMessage("host_needed_patches", "Assessing required patches for machine") + " " + hostMachine + " . " + msgcat.getMessage("please_wait", "Please wait ...") + "\n");
            String string = this.properties.getProperty("patchpro.patch.download.directory");
            this.model.addListener(this);
            this.done = false;
            this.model.assessNeededPatches();
            while (!this.done) {
                Thread.sleep(2000L);
                if (!debug) continue;
                System.out.print(".");
            }
            System.out.println("");
            PatchList patchList = this.model.getNeededPatches();
            if (patchList.size() <= 0) {
                System.out.println(msgcat.getMessage("no_required_patches", "No patches needed."));
                return;
            }
            this.printPatchList(patchList);
            System.out.println();
            System.out.println(msgcat.getMessage("download_host_patches", "Downloading the required patches for machine") + " " + hostMachine + ". " + msgcat.getMessage("please_wait", "Please wait ..."));
            if (patchList.size() > 0) {
                this.failed = false;
                this.done = false;
                this.properties.setProperty("smpatch.request", "true");
                this.model.downloadPatches(patchList, file);
                if (debug) {
                    System.out.println(msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + file.getPath() + "...");
                }
                while (!this.done) {
                    Thread.sleep(2000L);
                    if (!debug) continue;
                    System.out.print(".");
                }
                System.out.println("");
                if (this.checkForUnavailablePatches() != patchList.size()) {
                    System.out.println("\n" + msgcat.getMessage("download_done", "For downloaded patch(es) see") + " " + file.getPath());
                }
                this.problemSummary();
            } else {
                System.out.println(msgcat.getMessage("no_required_patches", "No patches needed."));
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException.getMessage());
        }
        catch (NoResultException noResultException) {
            System.err.println(noResultException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void installAllPatches(String string) {
        try {
            this.model.addListener(this);
            this.model.assessNeededPatches();
            System.out.println(msgcat.getMessage("host_needed_patches", "Assessing required patches for machine") + " " + hostMachine + " . " + msgcat.getMessage("please_wait", "Please wait ...") + "\n");
            this.failed = false;
            this.done = false;
            while (!this.done) {
                Thread.sleep(2000L);
                if (!debug) continue;
                System.out.print(".");
            }
            System.out.println("");
            PatchList patchList = this.model.getNeededPatches();
            if (patchList.size() > 0) {
                this.properties.setProperty("smpatch.request", "true");
                this.printPatchList(patchList);
                File file = new File(string);
                System.out.println("\n" + msgcat.getMessage("download_host_patches", "Downloading the required patches for machine") + " " + hostMachine + ". " + msgcat.getMessage("please_wait", "Please wait ..."));
                this.model.downloadPatches(patchList, file);
                if (debug) {
                    System.out.println("\n" + msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + string + "...");
                }
                this.done = false;
                while (!this.done) {
                    Thread.sleep(2000L);
                    if (!debug) continue;
                    System.out.print(".");
                }
                System.out.println("");
                if (this.checkForUnavailablePatches() > 0) {
                    System.out.println("\n" + msgcat.getMessage("update_retry", "Please try to update your host again after the Sun Microsystems support provider confirms that the patches are now available"));
                    System.exit(2);
                }
                this.defineValidPatchTypes(patchList);
                this.properties.setProperty("patchpro.patch.sequester.directory", sequesterDirectory);
                this.model.installPatches(patchList, file);
                if (debug) {
                    System.out.println(msgcat.getMessage("installingPatches", "Installing patches from") + " " + string + "...");
                }
                this.done = false;
                while (!this.done) {
                    Thread.sleep(2000L);
                    if (!debug) continue;
                    System.out.print(".");
                }
                this.problemSummary();
                System.out.println("");
            } else {
                System.out.println(msgcat.getMessage("no_required_patches", "No patches required."));
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException.getMessage());
        }
        catch (NoResultException noResultException) {
            System.err.println(noResultException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector createPatchList(String string) throws FileNotFoundException, IOException, MalformedPatchException {
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string2 = null;
        while (null != (string2 = bufferedReader.readLine())) {
            if (!this.isValidPatch(string2)) {
                System.err.println(string2 + " " + msgcat.getMessage("err_patchid", "is an invalid patch. Please specify patch in XXXXXX-YY format where X and Y are numbers."));
                bl = true;
                continue;
            }
            vector.addElement(string2);
        }
        if (bl) {
            throw new MalformedPatchException("");
        }
        return vector;
    }

    public Vector createPatchList(Vector vector) throws MalformedPatchException {
        boolean bl = false;
        Object var3_3 = null;
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            if (!this.isValidPatch((String)vector.elementAt(n))) {
                System.err.println((String)vector.elementAt(n) + " " + msgcat.getMessage("err_patchid", "is an invalid patch. Please specify patch in XXXXXX-YY format where X and Y are numbers."));
                bl = true;
            } else {
                vector2.addElement(vector.elementAt(n));
            }
            ++n;
        }
        if (bl) {
            throw new MalformedPatchException("");
        }
        return vector2;
    }

    public int checkForUnavailablePatches() {
        Patch patch = null;
        try {
            PatchList patchList = this.model.getUnavailablePatches();
            if (patchList != null) {
                if (debug) {
                    System.out.println("\nThe number of patches that are not available: " + patchList.size());
                }
                if (patchList.size() > 0) {
                    System.out.println("\n" + msgcat.getMessage("downloaded_not", "The following patches were not downloaded. Contact your Sun Microsystems support provider for more information."));
                    int n = 0;
                    while (n < patchList.size()) {
                        patch = patchList.getPatchAt(n);
                        System.out.println(patch.getPatchID().getPatchID());
                        patch = null;
                        ++n;
                    }
                }
            }
            return patchList.size();
        }
        catch (NoResultException noResultException) {
            return 0;
        }
        catch (NoSuchPatchException noSuchPatchException) {
            return 0;
        }
    }

    public void defineValidPatchTypes(PatchList patchList) throws NoSuchPatchException {
        boolean bl = false;
        String string = "";
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector vector4 = new Vector();
        int n = 0;
        while (n < patchList.size()) {
            PatchInfoImpl patchInfoImpl = (PatchInfoImpl)((IPatch)patchList.getPatchAt(n)).getPatchInfo();
            PatchProperties patchProperties = patchInfoImpl.getProperties();
            vector4 = patchProperties.getAllTypes();
            int n2 = 0;
            while (n2 < vector4.size()) {
                string = string + vector4.elementAt(n2) + " ";
                if (!vector.contains(vector4.elementAt(n2))) {
                    vector.addElement(vector4.elementAt(n2));
                }
                ++n2;
            }
            if (debug) {
                System.out.println(((IPatch)patchList.getPatchAt(n)).getPatchID().getPatchID() + ": " + string);
            }
            vector2.addElement(((IPatch)patchList.getPatchAt(n)).getPatchID().getPatchID());
            vector3.addElement(string);
            string = "";
            ++n;
        }
        String string2 = this.properties.getProperty("patchpro.patch.interactive.patchtype");
        Vector<String> vector5 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        if (stringTokenizer.hasMoreTokens()) {
            while (stringTokenizer.hasMoreTokens()) {
                vector5.addElement(stringTokenizer.nextToken());
            }
        } else {
            vector5.addElement("");
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            if (!vector5.contains((String)vector.elementAt(n3))) {
                bl = true;
                break;
            }
            ++n3;
        }
        if (bl) {
            System.out.println(msgcat.getMessage("unable_to_install", "At least one patch cannot be installed due to patch attributes."));
            System.out.println();
            int n4 = 0;
            while (n4 < vector2.size()) {
                System.out.println("    " + vector2.elementAt(n4) + "    " + vector3.elementAt(n4));
                ++n4;
            }
            System.out.println();
            if (string2.length() > 0) {
                System.out.println(msgcat.getMessage("display_patch_policy", "Policy permits the following patches to be installed:") + "\n    " + string2.replace(':', ','));
            } else {
                System.out.println(msgcat.getMessage("no_smpatch_policy", "Policy does not permit the installation of any patch."));
            }
            System.out.println("\n" + msgcat.getMessage("setup_policy_reference", "See \"pprosetup -i\" to change the patch installation policy.") + "\n\n");
        }
        this.properties.setProperty("patchpro.patch.install.patchtype", string2);
    }

    public boolean isValidPatch(String string) {
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                return false;
            }
        } else {
            return false;
        }
        string3 = stringTokenizer.nextToken();
        if (string2.length() != 6) {
            return false;
        }
        int n = 0;
        while (n < string2.length()) {
            if (!Character.isDigit(string2.charAt(n))) {
                return false;
            }
            ++n;
        }
        if (string3.length() != 2) {
            return false;
        }
        int n2 = 0;
        while (n2 < string3.length()) {
            if (!Character.isDigit(string3.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void patchproProgress(PatchProEvent patchProEvent) {
    }

    public void patchproDone(PatchProEvent patchProEvent) {
        this.done = true;
    }

    public void patchproFailed(PatchProEvent patchProEvent) {
        Object object = patchProEvent.getSource();
        Throwable throwable = null;
        if (object instanceof PatchProModel) {
            throwable = ((PatchProModel)object).getPatchProFailure();
            System.err.println(msgcat.getMessage("patchProFailed", "Error: PatchPro failed:\n") + throwable.getMessage());
        } else {
            System.err.println(msgcat.getMessage("err_event_not_model", "Error: Event source not PatchProModel"));
        }
        this.failed = true;
    }

    private void clearArray(char[] cArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            cArray[n2++] = '\u0000';
        }
    }

    private void problemSummary() {
        if (this.model.getPatchProExceptions() != null) {
            exceptionRepository.addAll(this.model.getPatchProExceptions());
            if (exceptionRepository.size() > 0) {
                System.err.println(msgcat.getMessage("diagnostic_info", "Problem Summary:"));
                String string = "";
                int n = 0;
                while (n < exceptionRepository.size()) {
                    string = string + "\n(" + (n + 1) + ") " + ((PatchProException)exceptionRepository.elementAt(n)).getLocalizedMessage() + "\n" + ((PatchProException)exceptionRepository.elementAt(n)).getLocalizedRemedy();
                    System.err.println(string);
                    ++n;
                }
                System.exit(2);
            }
        }
    }

    static {
        exceptionRepository = new Vector();
        hostMachine = null;
        sequesterDirectory = null;
        debug = false;
    }
}

