/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.cli;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProAccessor;
import com.sun.patchpro.model.PatchProEvent;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.util.GetOpt;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.NoResultException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class PatchServices
implements PatchProListener {
    private static final String validArgs = "o:c:z:hR:s:p:t:r:lnd;i;";
    private LocalizedMessages msgcat;
    private PatchPro model;
    private ReadOnlyHost primaryHost;
    private PatchProProperties properties = PatchProProperties.getInstance();
    boolean done = false;
    boolean failed = false;
    boolean hostIsAnalyzed = false;
    String hostsToInstall = null;
    private static final String LIST_RESULT_FILE = "required_patches.xml";
    private static final String DOWNLOAD_RESULT_FILE = "results.xml";
    private static final String INSTALL_RESULT_FILE = "results.xml";
    private static boolean option_p_Specified = false;
    private static boolean option_o_Specified = false;
    private static String targetHostStr = null;
    private static String patchIDStr = null;
    public static final String SIGNING_CERT_REVOKED = "The signing certificate has been revoked. All patch download activities have been disabled. ";
    public static final String INSTANTIATION_PROBLEM = "Problem detected during PatchPro initialization process. Please check the log file. Exiting";

    public PatchServices() {
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
    }

    public static void main(String[] stringArray) {
        boolean bl;
        block67: {
            String string = null;
            PatchProProperties patchProProperties = PatchProProperties.getInstance();
            GetOpt getOpt = new GetOpt(stringArray, validArgs);
            LocalizedMessages localizedMessages = new LocalizedMessages(patchProProperties.getLocale());
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            PatchServices patchServices = new PatchServices();
            bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            boolean bl11 = false;
            boolean bl12 = false;
            boolean bl13 = false;
            boolean bl14 = true;
            boolean bl15 = true;
            try {
                int n;
                while ((n = getOpt.getNextOption()) != -1) {
                    switch ((char)n) {
                        case 'd': {
                            if (bl4) {
                                bl2 = true;
                                break;
                            }
                            bl4 = true;
                            break;
                        }
                        case 'h': {
                            if (bl5) {
                                bl2 = true;
                                break;
                            }
                            bl5 = true;
                            break;
                        }
                        case 'i': {
                            if (bl6) {
                                bl2 = true;
                                break;
                            }
                            bl6 = true;
                            break;
                        }
                        case 'l': {
                            if (bl7) {
                                bl2 = true;
                                break;
                            }
                            bl7 = true;
                            break;
                        }
                        case 'o': {
                            if (option_o_Specified) {
                                bl2 = true;
                            } else {
                                targetHostStr = getOpt.getOptionArg();
                            }
                            option_o_Specified = true;
                            break;
                        }
                        case 'p': {
                            if (option_p_Specified) {
                                bl2 = true;
                            } else {
                                patchIDStr = getOpt.getOptionArg();
                            }
                            option_p_Specified = true;
                            break;
                        }
                        case 'r': {
                            if (bl9) {
                                bl2 = true;
                            } else {
                                string = getOpt.getOptionArg();
                            }
                            bl9 = true;
                            break;
                        }
                        case 's': {
                            if (bl10) {
                                bl2 = true;
                            } else {
                                string4 = getOpt.getOptionArg();
                            }
                            bl10 = true;
                            break;
                        }
                        case 'c': {
                            if (bl3) {
                                bl2 = true;
                                break;
                            }
                            string2 = getOpt.getOptionArg();
                            bl3 = true;
                            break;
                        }
                        case 'n': {
                            if (bl8) {
                                bl2 = true;
                                break;
                            }
                            bl8 = true;
                            break;
                        }
                        case 'R': {
                            if (bl13) {
                                bl2 = true;
                                break;
                            }
                            string3 = getOpt.getOptionArg();
                            bl13 = true;
                            break;
                        }
                        case 't': {
                            if (bl11) {
                                bl2 = true;
                            } else {
                                string5 = getOpt.getOptionArg();
                            }
                            bl11 = true;
                            break;
                        }
                        case 'z': {
                            if (bl12) {
                                bl2 = true;
                                break;
                            }
                            String string6 = getOpt.getOptionArg();
                            bl = string6.equals("true");
                            bl12 = true;
                            break;
                        }
                        default: {
                            System.out.println(patchServices.msgcat.getMessage("invalidOption", "Ignoring invalid option."));
                        }
                    }
                }
                if (bl2) {
                    System.err.println(localizedMessages.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                    System.exit(1);
                }
                if (bl5 || stringArray.length < 1) {
                    PatchServices.usage(localizedMessages);
                    System.exit(0);
                }
                if (bl7 && (bl4 || bl6) || bl4 && (bl7 || bl6) || bl6 && (bl7 || bl4)) {
                    System.err.println(localizedMessages.getMessage("pprosvcmutex", "Options l, d and i are mutually exclusive"));
                    PatchServices.usage(localizedMessages);
                    System.exit(1);
                }
                if (bl13) {
                    bl14 = patchServices.setRealizationsProvided(string3);
                }
                if (!bl14) {
                    System.exit(1);
                    break block67;
                }
                try {
                    patchServices.instantiateModel();
                }
                catch (PatchProException patchProException) {
                    System.err.println(patchProException.getLocalizedMessage());
                    System.exit(1);
                }
                if (option_o_Specified) {
                    bl15 = patchServices.setInstallHost(targetHostStr);
                    if (!bl15) {
                        System.exit(1);
                    }
                    if (option_p_Specified) {
                        patchProProperties.setProperty(targetHostStr, "patchpro.patches.provided", patchIDStr);
                    }
                    patchProProperties.setProperty("patchpro.target.hosts", targetHostStr);
                } else if (option_p_Specified) {
                    patchProProperties.setProperty("patchpro.patches.provided", patchIDStr);
                    bl15 = patchServices.setInstallHost(null);
                }
                if (bl8) {
                    patchServices.setNoninteractive();
                }
                if (bl7) {
                    if (string == null) {
                        string = LIST_RESULT_FILE;
                    }
                    PatchList patchList = patchServices.displayPatchList();
                }
                if (bl4) {
                    if (string == null) {
                        string = "results.xml";
                    }
                    patchServices.downloadAllPatches();
                }
                if (bl6) {
                    if (string == null) {
                        string = "results.xml";
                    }
                    patchServices.installPatches();
                }
                if (string2 != null) {
                    patchServices.changeConfigFile(string2);
                }
                if (bl10) {
                    int n2 = 1;
                    if (bl7 || bl4 || bl6) {
                        try {
                            patchServices.initializeHost();
                            if (bl7) {
                                n2 = 1;
                            } else if (bl4) {
                                n2 = 3;
                            } else if (bl6) {
                                n2 = 16;
                            }
                            patchServices.setSessionID(string4, string, n2);
                        }
                        catch (NoResultException noResultException) {
                            System.err.println(noResultException.getLocalizedMessage());
                        }
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println(illegalArgumentException.getMessage());
                PatchServices.usage(localizedMessages);
                if (bl) {
                    System.out.println("System.exit(1)");
                    return;
                }
                System.exit(1);
            }
        }
        if (bl) {
            System.out.println("System.exit(0)");
            return;
        }
        System.exit(0);
    }

    private static void usage(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("pprosvcUsage", "usage: pprosvc [ -i [-n] [-R realization_id] [-o target_ip] [-s session_id [ -r result_file ]]  [-p patch_ID[,patch_ID...]]] | [-d [-R realization_id] [-s session_id [ -r result_file ]] |  [ -l [-R realization_id] [-s session_id [ -r result_file ]]] [-p patch_ID[,patch_ID...]]] | [-h]  where:"));
        System.err.println("   d " + localizedMessages.getMessage("usageDownloadAll", "means download all patches."));
        System.err.println("   i " + localizedMessages.getMessage("usageInstallAll", "means install required patches."));
        System.err.println("   l " + localizedMessages.getMessage("usageListPatches", "means list required patches."));
        System.err.println("   n " + localizedMessages.getMessage("usageNonInteractive", "means operate in non interactive mode."));
        System.err.println("   o " + localizedMessages.getMessage("usageSetInstallHost", "means define the host for the current request."));
        System.err.println("   s " + localizedMessages.getMessage("usageSessionID", "means <session_id> is used as an identifier to create a patchlist file for the current session."));
        System.err.println("   h " + localizedMessages.getMessage("usageHelp", "display usage information."));
    }

    private void instantiateModel() throws PatchProException {
        this.model = PatchProAccessor.getPatchPro();
    }

    private void initializeHost() throws NoResultException {
        this.primaryHost = this.model.getHost();
    }

    public PatchList displayPatchList() {
        PatchList patchList = null;
        try {
            this.model.addListener(this);
            this.done = false;
            this.model.assessNeededPatches();
            System.out.println(this.msgcat.getMessage("assessNeededPatches", "Assessing patches needed for your system..."));
            while (!this.done) {
                Thread.sleep(2000L);
                System.out.print(".");
            }
            System.out.println("");
            patchList = this.model.getNeededPatches();
            System.out.println(this.msgcat.getMessage("getNeededPatches", "Retrieved patch list..."));
            if (patchList.size() > 0) {
                this.printPatchList(patchList);
            } else {
                System.out.println(this.msgcat.getMessage("noPatches", "No patches required."));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (NoResultException noResultException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return patchList;
    }

    public void printPatchList(PatchList patchList) {
        System.out.println(this.msgcat.getMessage("reqPatches", "Required patches."));
        if (patchList.hasAnyErrors()) {
            System.out.println(this.msgcat.getMessage("errorsFound", "Errors were found."));
        }
        int n = 0;
        while (n < patchList.size()) {
            try {
                Patch patch = patchList.getPatchAt(n);
                System.out.println(patch.getPatchID().getPatchID() + " " + patch.getPatchInfo().getSynopsis());
                boolean bl = patchList.hasErrorAt(n);
                if (bl) {
                    System.err.println("    Error: " + patchList.getErrorAt(n));
                }
            }
            catch (NoSuchPatchException noSuchPatchException) {
                System.err.println("Error: The patch list contains a non-existing patch.");
            }
            ++n;
        }
    }

    public void downloadAllPatches() {
        try {
            String string = this.properties.getProperty("patchpro.patch.download.directory");
            this.model.addListener(this);
            this.done = false;
            this.model.assessNeededPatches();
            System.out.println(this.msgcat.getMessage("assessNeededPatches", "Assessing patches needed for your system..."));
            while (!this.done) {
                Thread.sleep(2000L);
                System.out.print(".");
            }
            System.out.println("");
            PatchList patchList = this.model.getNeededPatches();
            System.out.println(this.msgcat.getMessage("getNeededPatches", "Retrieved patch list..."));
            if (patchList.size() > 0) {
                this.failed = false;
                this.done = false;
                this.model.downloadPatches();
                System.out.println(this.msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + string + "...");
                while (!this.done) {
                    Thread.sleep(2000L);
                    System.out.print(".");
                }
                System.out.println("");
            } else {
                System.out.println(this.msgcat.getMessage("noPatches", "No patches required."));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (NoResultException noResultException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean setInstallHost(String string) {
        boolean bl = true;
        try {
            ReadOnlyHost readOnlyHost;
            this.model.addListener(this);
            this.done = false;
            if (!this.hostIsAnalyzed) {
                this.model.analyzeHost();
                while (!this.done) {
                    Thread.sleep(2000L);
                    System.out.print(".");
                }
                this.hostIsAnalyzed = true;
                System.out.println("");
            }
            this.primaryHost = this.model.getHost();
            if (string == null) {
                string = targetHostStr = this.primaryHost.getAddress();
            }
            Enumeration enumeration = this.primaryHost.getAssociates();
            int n = this.primaryHost.getAssociateCount() + 1;
            Vector<ReadOnlyHost> vector = new Vector<ReadOnlyHost>(n);
            vector.add(this.primaryHost);
            while (enumeration.hasMoreElements()) {
                readOnlyHost = (ReadOnlyHost)enumeration.nextElement();
                vector.add(readOnlyHost);
            }
            boolean bl2 = this.validateIP(string);
            if (!bl2) {
                vector.clear();
                bl = false;
            } else {
                if (this.primaryHost.isAddress(string)) {
                    vector.remove(this.primaryHost);
                }
                enumeration = this.primaryHost.getAssociates();
                while (enumeration.hasMoreElements()) {
                    readOnlyHost = (ReadOnlyHost)enumeration.nextElement();
                    if (!readOnlyHost.isAddress(string)) continue;
                    vector.remove(readOnlyHost);
                }
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    ReadOnlyHost readOnlyHost2 = (ReadOnlyHost)enumeration2.nextElement();
                    readOnlyHost2.getSessionData().setIgnoreStatus(true);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException.getMessage());
        }
        catch (NoResultException noResultException) {
            System.err.println(noResultException.getMessage());
        }
        return bl;
    }

    private boolean validateIP(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        n2 = stringTokenizer.countTokens();
        if (n2 == 4) {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Integer n3 = new Integer(string2);
                int n4 = 0;
                int n5 = 255;
                if (n3.compareTo(new Integer(n4)) >= 0 && n3.compareTo(new Integer(n5)) <= 255) {
                    ++n;
                    continue;
                }
                System.out.println(this.msgcat.getMessage("invalidIPAddress", "An invalid IP address is specified."));
                break;
            }
            if (n == 4) {
                bl = true;
            }
        } else {
            System.out.println(this.msgcat.getMessage("invalidIPAddress", "An invalid IP address is specified."));
        }
        return bl;
    }

    public void setSessionID(String string, String string2, int n) {
        String string3;
        File file;
        File file2;
        String string4 = "patchpro.sessionid.directory.prefix";
        this.properties.setProperty(string4, "/var/tmp/pprosvc_");
        if (string2 == null || string2.length() == 0) {
            string2 = "results.xml";
        }
        if ((file2 = (file = new File(string3 = "/var/tmp/pprosvc_" + string + "/" + string2)).getParentFile()) != null && !file2.exists()) {
            file2.mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            this.primaryHost.printXMLPatchListSet(n, 0, printWriter);
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    private boolean patchesAreRequired(ReadOnlyHost readOnlyHost) {
        boolean bl = false;
        SessionData sessionData = readOnlyHost.getSessionData();
        if (!sessionData.getIgnoreStatus()) {
            try {
                sessionData.getPatchesRequired();
                bl = true;
            }
            catch (NoResultException noResultException) {
                bl = false;
            }
        }
        Enumeration enumeration = readOnlyHost.getAssociates();
        while (!bl && enumeration.hasMoreElements()) {
            Host host = (Host)enumeration.nextElement();
            sessionData = host.getSessionData();
            if (sessionData.getIgnoreStatus()) continue;
            try {
                sessionData.getPatchesRequired();
                bl = true;
            }
            catch (NoResultException noResultException) {
                bl = false;
            }
        }
        return bl;
    }

    public void installPatches() {
        try {
            this.model.addListener(this);
            this.model.assessNeededPatches();
            System.out.println(this.msgcat.getMessage("assessNeededPatches", "Assessing patches needed for your system..."));
            this.failed = false;
            this.done = false;
            try {
                while (!this.done) {
                    Thread.sleep(2000L);
                    System.out.print(".");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.model.removeListener(this);
            System.out.println("");
            System.out.println(this.msgcat.getMessage("getNeededPatches", "Retrieved patch list..."));
            if (this.patchesAreRequired(this.model.getHost())) {
                String string = this.properties.getProperty("patchpro.patch.download.directory");
                this.model.addListener(this);
                this.done = false;
                this.model.downloadPatches();
                System.out.println(this.msgcat.getMessage("downloadingPatches", "Downloading patches to") + " " + string + "...");
                while (!this.done) {
                    Thread.sleep(2000L);
                    System.out.print(".");
                }
                System.out.println("");
                String string2 = this.properties.getProperty("patchpro.patch.install.directory");
                this.model.installPatches();
                System.out.println(this.msgcat.getMessage("installingPatches", "Applying patches from") + " " + string2 + "...");
                this.done = false;
                while (!this.done) {
                    Thread.sleep(2000L);
                    System.out.print(".");
                }
                System.out.println("");
            } else {
                System.out.println(this.msgcat.getMessage("noPatches", "No patches required."));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (NoResultException noResultException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean setRealizationsProvided(String string) {
        String string2 = "patchpro.realization.provided";
        boolean bl = true;
        try {
            if (string == null || string.equals("none")) {
                string = "";
            }
            if (string != "") {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    try {
                        Realization realization = new Realization(string3);
                    }
                    catch (NoSuchRealizationException noSuchRealizationException) {
                        System.out.println(this.msgcat.getMessage("noSuchRealization", "Poorly formed realization."));
                        bl = false;
                        return bl;
                    }
                }
            }
            this.properties.setProperty(string2, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public void patchproProgress(PatchProEvent patchProEvent) {
    }

    public void patchproDone(PatchProEvent patchProEvent) {
        this.done = true;
    }

    public void patchproFailed(PatchProEvent patchProEvent) {
        Object object = patchProEvent.getSource();
        Throwable throwable = null;
        if (object instanceof PatchProModel) {
            throwable = ((PatchProModel)object).getPatchProFailure();
            System.err.println(throwable.getMessage());
        } else {
            System.err.println("Error: Event source not PatchProModel");
        }
        this.failed = true;
    }

    public void setNoninteractive() {
        this.model.setInteractive(false);
    }

    public void changeConfigFile(String string) {
        File file = new File(string);
        try {
            System.out.println(this.msgcat.getMessage("changeConfigFile", "Changing Configuration File."));
            this.properties.load(new FileInputStream(file));
            System.out.println(this.msgcat.getMessage("newConfigFile", "Using specified new config file") + string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }
}

