/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.cli;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.NoMoreDetectorsException;
import com.sun.patchpro.cli.RenderInteractionSetImpl;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProAccessor;
import com.sun.patchpro.model.PatchProEvent;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.GetOpt;
import com.sun.patchpro.util.InteractionSet;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.ScheduleService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public final class PatchProSetup
implements PatchProListener {
    private static final String validArgs = "o:DW:M:s:Cd:b:q:P:a;mp;Hx;c:z:u;hy:i:";
    private static final String[] validPatchTypes = new String[]{"", "none", "standard", "rebootafter", "reconfigafter", "singleuser"};
    private static final String[] validInteractivePatchTypes = new String[]{"none", "standard", "rebootafter", "reconfigafter", "singleuser", "rebootimmediate", "reconfigimmediate", "interactive"};
    private static File defaultConfFile;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private LocalizedMessages msgcat = new LocalizedMessages(this.properties.getLocale());
    boolean done = false;
    PatchPro patchPro = PatchProAccessor.getPatchPro();
    String associateStr = null;
    boolean hasAssociate = false;

    public PatchProSetup() throws PatchProException {
        String string = this.properties.getProperty("patchpro.default.conf.file", "etc/patchpro.conf");
        defaultConfFile = new File(string);
        if (!defaultConfFile.exists()) {
            System.err.println(this.msgcat.getMessage("noConfigurationFile", "Configuration file was not found -") + " " + string);
            System.exit(1);
        } else if (!defaultConfFile.canWrite()) {
            System.err.println(this.msgcat.getMessage("cantWriteConfigurationFile", "Configuration file is not writable -") + " " + string);
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        PatchProProperties patchProProperties = null;
        GetOpt getOpt = new GetOpt(stringArray, validArgs);
        LocalizedMessages localizedMessages = null;
        PatchProSetup patchProSetup = null;
        Vector<String> vector = new Vector<String>();
        String string = "00:00";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        boolean bl18 = false;
        boolean bl19 = false;
        boolean bl20 = false;
        boolean bl21 = false;
        boolean bl22 = false;
        boolean bl23 = false;
        boolean bl24 = false;
        try {
            String[] stringArray2;
            int n;
            while ((n = getOpt.getNextOption()) != -1) {
                stringArray2 = new Character((char)n);
                switch ((char)n) {
                    case 'D': {
                        if (bl9) {
                            bl2 = true;
                            break;
                        }
                        vector.addElement(stringArray2.toString());
                        bl9 = true;
                        break;
                    }
                    case 'W': {
                        if (bl10) {
                            bl2 = true;
                            break;
                        }
                        vector.addElement(stringArray2.toString());
                        vector.addElement(getOpt.getOptionArg());
                        bl10 = true;
                        break;
                    }
                    case 'M': {
                        if (bl11) {
                            bl2 = true;
                            break;
                        }
                        vector.addElement(stringArray2.toString());
                        vector.addElement(getOpt.getOptionArg());
                        bl11 = true;
                        break;
                    }
                    case 's': {
                        if (bl20) {
                            bl2 = true;
                            break;
                        }
                        if (string.compareTo("none") == 0) break;
                        string = getOpt.getOptionArg();
                        bl = true;
                        bl20 = true;
                        break;
                    }
                    case 'a': {
                        if (bl4) {
                            bl2 = true;
                            break;
                        }
                        string2 = getOpt.getOptionArg();
                        if (string2 == null) {
                            string2 = "";
                        }
                        bl4 = true;
                        break;
                    }
                    case 'C': {
                        if (bl8) {
                            bl2 = true;
                            break;
                        }
                        string = "none";
                        bl = true;
                        bl8 = true;
                        break;
                    }
                    case 'o': {
                        if (bl16) {
                            bl2 = true;
                            break;
                        }
                        string4 = getOpt.getOptionArg();
                        bl16 = true;
                        break;
                    }
                    case 'd': {
                        if (bl7) {
                            bl2 = true;
                            break;
                        }
                        string3 = getOpt.getOptionArg();
                        bl7 = true;
                        break;
                    }
                    case 'b': {
                        if (bl5) {
                            bl2 = true;
                            break;
                        }
                        string5 = getOpt.getOptionArg();
                        bl5 = true;
                        break;
                    }
                    case 'q': {
                        if (bl19) {
                            bl2 = true;
                            break;
                        }
                        string6 = getOpt.getOptionArg();
                        bl19 = true;
                        break;
                    }
                    case 'P': {
                        if (bl18) {
                            bl2 = true;
                            break;
                        }
                        string7 = getOpt.getOptionArg();
                        bl18 = true;
                        break;
                    }
                    case 'm': {
                        if (bl15) {
                            bl2 = true;
                            break;
                        }
                        bl15 = true;
                        break;
                    }
                    case 'p': {
                        if (bl17) {
                            bl2 = true;
                            break;
                        }
                        string8 = getOpt.getOptionArg();
                        bl17 = true;
                        break;
                    }
                    case 'i': {
                        if (bl14) {
                            bl2 = true;
                            break;
                        }
                        string9 = getOpt.getOptionArg();
                        bl14 = true;
                        break;
                    }
                    case 'H': {
                        if (bl12) {
                            bl2 = true;
                            break;
                        }
                        bl12 = true;
                        break;
                    }
                    case 'c': {
                        if (bl6) {
                            bl2 = true;
                            break;
                        }
                        string10 = getOpt.getOptionArg();
                        bl6 = true;
                        break;
                    }
                    case 'z': {
                        if (bl24) {
                            bl2 = true;
                            break;
                        }
                        String string14 = getOpt.getOptionArg();
                        bl3 = string14.equals("true");
                        bl24 = true;
                        break;
                    }
                    case 'x': {
                        if (bl22) {
                            bl2 = true;
                            break;
                        }
                        string11 = getOpt.getOptionArg();
                        bl22 = true;
                        break;
                    }
                    case 'u': {
                        if (bl21) {
                            bl2 = true;
                            break;
                        }
                        string12 = getOpt.getOptionArg();
                        if (string12 == null) {
                            string12 = "";
                        }
                        bl21 = true;
                        break;
                    }
                    case 'y': {
                        if (bl23) {
                            bl2 = true;
                            break;
                        }
                        string13 = getOpt.getOptionArg();
                        bl23 = true;
                        break;
                    }
                    case 'h': {
                        if (bl13) {
                            bl2 = true;
                            break;
                        }
                        bl13 = true;
                        break;
                    }
                }
            }
            if (string10 != null) {
                PatchProProperties.freeInstance();
                patchProProperties = PatchProProperties.getInstance(string10);
            } else {
                patchProProperties = PatchProProperties.getInstance();
            }
            try {
                patchProSetup = new PatchProSetup();
                localizedMessages = new LocalizedMessages(patchProProperties.getLocale());
            }
            catch (PatchProException patchProException) {
                System.err.println(patchProException.getLocalizedMessage());
                if (bl3) {
                    System.err.println("System.exit(1)");
                    return;
                }
                System.exit(1);
            }
            if (bl2) {
                System.err.println(localizedMessages.getMessage("errDuplicateDetected", "Error: One or more duplicate options were detected."));
                if (bl3) {
                    System.err.println("System.exit(1)");
                    return;
                }
                System.exit(1);
            }
            if (bl13 || stringArray.length < 2 && bl23) {
                PatchProSetup.usage(localizedMessages);
                System.exit(0);
            }
            if (bl9 && (bl10 || bl11) || bl10 && (bl9 || bl11) || bl11 && (bl9 || bl10)) {
                System.err.println(localizedMessages.getMessage("pprosetupmutexDWM", "Options D, W and M are mutually exclusive"));
                PatchProSetup.usage(localizedMessages);
                System.exit(1);
            }
            patchProProperties.lock(string13);
            if (bl15) {
                patchProSetup.changeMediaType();
            }
            if (bl16) {
                patchProSetup.associateStr = string4;
                patchProSetup.hasAssociate = true;
            }
            if (bl12) {
                patchProSetup.changeHardware();
            }
            if (bl17) {
                patchProSetup.changePatchType(string8);
            }
            if (bl14) {
                patchProSetup.changeInteractivePatchType(string9);
            }
            if (bl22) {
                patchProSetup.changeProxyServer(string11);
            }
            if (bl) {
                stringArray2 = new String[vector.size()];
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    stringArray2[n2] = (String)vector.elementAt(n2);
                    ++n2;
                }
                patchProSetup.changeSchedule(string, stringArray2);
            }
            if (string2 != null) {
                patchProSetup.changeAdminEmail(string2);
            }
            if (string3 != null) {
                patchProSetup.changeDirectoryLocation(string3);
            }
            if (string5 != null) {
                patchProSetup.changeBackoutLocation(string5);
            }
            if (string6 != null) {
                patchProSetup.changeSequesterLocation(string6);
            }
            if (string7 != null) {
                patchProSetup.changePatchServer(string7);
            }
            if (string12 != null) {
                patchProSetup.changeUserName(string12);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            PatchProSetup.usage(localizedMessages);
            if (bl3) {
                System.err.println("System.exit(1)");
                return;
            }
            System.exit(1);
        }
        catch (Exception exception) {
            if (exception.getMessage().indexOf("in use") != -1) {
                System.err.println(localizedMessages.getMessage("inuse", "Error - PatchPro is in use by another process. Please try again later ..."));
            } else {
                System.err.println("Error: " + exception.getMessage());
            }
            System.exit(1);
        }
        if (bl3) {
            System.out.println("System.exit(0)");
            return;
        }
        System.exit(0);
    }

    private static void usage(LocalizedMessages localizedMessages) {
        System.err.println(localizedMessages.getMessage("pprosetupUsage", "usage:  pprosetup -o <host_type or ip_address> [[[D | W <day_of_week> | M <day_of_month> ]-s <hh:mm>] | -C] -d <download_directory> -b <backout_directory>-q <sequester_directory> -P <patch_server_url> -a <admin_email_address> -p [none | standard] -i [none|<patch_type_list>]-H -x [host:port] -u <user_name> -h where:"));
        System.err.println("   o <host_type or ip_address> " + localizedMessages.getMessage("usageHostType", "Host or host type to which the property applies. Valid host types include:\nT3\tT3 Storage Array\nT3PP\tT3B partner pair\n6120\t6120 storage array\n6120PP\t6120 partner pair\n"));
        System.err.println("   [[[D | W <day_of_week> | M <day_of_month>] s <hh:mm>] | -C] " + localizedMessages.getMessage("usageSchedulePatchService", "create or clear an existing schedule for patch service."));
        System.err.println("   d <download_directory> " + localizedMessages.getMessage("usageDownloadDirectory", "directory where patches are downloaded."));
        System.err.println("   b <backout_directory> " + localizedMessages.getMessage("usageBackoutDirectory", "directory where patch backout data will be kept."));
        System.err.println("   q <sequester_directory> " + localizedMessages.getMessage("usageSequesterDirectory", "directory where uninstallable patches are stored."));
        System.err.println("   P <patch_server_url> " + localizedMessages.getMessage("usagePatchServer", "The URL of the server providing patches. For example: \"https://emea.patchmanager.sun.com/patchmanager\""));
        System.err.println("   a <admin_email_address> " + localizedMessages.getMessage("usageAdminEmail", "an administrator's e-mail address to use for event notification."));
        System.err.println("   p <patch_type> " + localizedMessages.getMessage("usagePatchType", "patch type allowed to be scheduled for automatic installation. Either \"none\" or one or more of the following\n patch types delimited by the colon ':' Character\n\t\"rebootafter\"\n\t\"reconfigafter\"\n\t\"rebootimmediate\"\n\t\"reconfigimmediate\"\n\t\"singleuser\"\n\t\"standard\""));
        System.err.println("   i [none|<patch_type_list>] " + localizedMessages.getMessage("usageInteractivePatchType", "Either \"none\" or one or more of the following\n patch types delimited by the colon ':' Character\n\t\"interactive\"\n\t\"rebootafter\"\n\t\"reconfigafter\"\n\t\"rebootimmediate\"\n\t\"reconfigimmediate\"\n\t\"singleuser\"\n\t\"standard\""));
        System.err.println("   H " + localizedMessages.getMessage("usageHardware", "establish interactive dialog to determine hardware attached to host."));
        System.err.println("   x " + localizedMessages.getMessage("usageProxyServer", "local proxy server [host:port]."));
        System.err.println("   u " + localizedMessages.getMessage("usageUserName", "Sunsolve account id (user name) to use for accessing contract patches."));
        System.err.println("   h " + localizedMessages.getMessage("usageHelp", "display usage information."));
    }

    public void changeSchedule(String string, String[] stringArray) throws IllegalArgumentException {
        block14: {
            String string2 = this.properties.getProperty("patchpro.installdir.ppro");
            String string3 = string2 == null || string2.equals("") ? "" : string2 + File.separator + "bin" + File.separator;
            String string4 = this.properties.getProperty("patchpro.patch.install.patchtype");
            String string5 = string3 + "pprosvc -n -i";
            int n = stringArray.length;
            String string6 = new String("com.sun.patchpro.util." + Host.getOSName() + "ScheduleService");
            try {
                Class<?> clazz = Class.forName(string6);
                ScheduleService scheduleService = (ScheduleService)clazz.newInstance();
                if (n != 0) {
                    if (string.compareTo("none") == 0) {
                        throw new IllegalArgumentException("\"-C\" is incompatible with other schedule arguments.");
                    }
                    char c = stringArray[0].charAt(0);
                    switch (c) {
                        case 'D': {
                            scheduleService.daily(string5, string);
                            break block14;
                        }
                        case 'W': {
                            scheduleService.weekly(string5, string, stringArray[1]);
                            break block14;
                        }
                        case 'M': {
                            scheduleService.monthly(string5, string, stringArray[1]);
                            break block14;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                if (string.compareTo("none") != 0) {
                    scheduleService.begin(string5, string);
                } else {
                    scheduleService.clear("pprosvc");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("ClassNotFoundException " + classNotFoundException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                System.err.println("InstantiationException " + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("IllegalAccessException " + illegalAccessException.getMessage());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
    }

    public void changeDirectoryLocation(String string) {
        String string2 = "patchpro.patch.download.directory";
        try {
            File file = new File(string);
            String string3 = this.properties.getProperty(string2);
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                    string2 = "patchpro.patch.install.directory";
                    this.setAppropriateProperty(string2, string);
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalDownloadDirectory", "Specified download directory is identical to the one in effect - No action necessary."));
            }
        }
        catch (Exception exception) {
            System.err.println(this.msgcat.getMessage("errChangeDownloadDirectory", "Error - failed to change download directory location"));
        }
    }

    public void changeBackoutLocation(String string) {
        String string2 = "patchpro.patch.backout.directory";
        try {
            File file = new File(string);
            String string3 = this.properties.getProperty(string2);
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalBackoutDirectory", "Specified backout directory is identical to the one in effect - No action necessary."));
            }
        }
        catch (Exception exception) {
            System.err.println(this.msgcat.getMessage("errChangeBackoutDirectory", "Error - failed to change backout directory location"));
        }
    }

    public void changeSequesterLocation(String string) {
        String string2 = "patchpro.patch.sequester.directory";
        try {
            File file = new File(string);
            String string3 = this.properties.getProperty(string2);
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalSequesterDirectory", "Specified sequester directory is identical to the one in effect - No action necessary."));
            }
        }
        catch (Exception exception) {
            System.err.println(this.msgcat.getMessage("errChangeSequesterDirectory", "Error - failed to change sequester directory location"));
        }
    }

    public void changePatchServer(String string) {
        String string2 = "patchpro.patch.server.url";
        try {
            int n;
            String string3 = this.properties.getProperty(string2);
            if (string3 == null) {
                string3 = "";
            }
            try {
                n = string.indexOf(58);
                if (n == -1) {
                    System.err.println(this.msgcat.getMessage("PatchProSetup.MALFORMED_URL", "Failed to change patch server URL - malformed URL.)"));
                    System.exit(1);
                } else {
                    String string4 = "";
                    string4 = string.substring(0, n);
                    if (string4.compareTo("https") == 0 || string4.compareTo("http") == 0) {
                        int n2 = n + 1;
                        int n3 = n + 3;
                        if (string.substring(n2, n3).compareTo("//") != 0) {
                            System.err.println(this.msgcat.getMessage("PatchProSetup.MALFORMED_URL", "Failed to change patch server URL - malformed URL.)"));
                            System.exit(1);
                        }
                    } else {
                        System.err.println(this.msgcat.getMessage("PatchProSetup.UNSUPPORTED_PROTOCOL", "Failed to change patch server URL - specified protocol not supported.)"));
                        System.exit(1);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(this.msgcat.getMessage("PatchProSetup.FAILED_CHANGING_PATCH_SERVER", "Failed to change patch server URL.)"));
                System.exit(1);
            }
            n = string.length();
            if (string.substring(n - 1, n).compareTo("/") != 0) {
                string = string + "/";
            }
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalPatchServer", "Specified patch server is identical to the one in effect - No action necessary."));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void changeAdminEmail(String string) {
        String string2 = "patchpro.error.email";
        try {
            String string3 = this.properties.getProperty(string2);
            if (string3 != null) {
                if (string3.compareTo(string) != 0) {
                    try {
                        this.setAppropriateProperty(string2, string);
                        this.properties.update(string2, string);
                        string2 = "patchpro.download.email";
                        this.setAppropriateProperty(string2, string);
                        this.properties.update(string2, string);
                        string2 = "patchpro.install.email";
                        this.setAppropriateProperty(string2, string);
                        this.properties.update(string2, string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println(fileNotFoundException.getMessage());
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getMessage());
                    }
                    catch (Exception exception) {
                        System.err.println(exception.getMessage());
                    }
                } else {
                    System.out.println(this.msgcat.getMessage("isIdenticalAdminEmail", "Specified admin email address is identical to the one in effect - No action necessary."));
                }
            } else {
                System.err.println(this.msgcat.getMessage("errChangeAdminEmail", "Error - failed to change admin E-Mail."));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void changeMediaType() {
        System.out.println(this.msgcat.getMessage("media", "TBD - Change media type"));
    }

    public void changePatchType(String string) {
        String string2 = "patchpro.patch.install.patchtype";
        String string3 = this.properties.getProperty(string2);
        if (this.isValidPatchType(string)) {
            if (string == null || string.equals("none")) {
                string = "";
            }
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalPatchType", "Specified patch type is identical to the one in effect - No action necessary."));
            }
        } else {
            System.err.println(this.msgcat.getMessage("errChangePatchType", "Error - failed to change patch type."));
            System.err.println(this.msgcat.getMessage("validPatchTypes", "Valid patch types : "));
            int n = 0;
            while (n < validPatchTypes.length) {
                System.err.println("\t\"" + validPatchTypes[n] + "\"");
                ++n;
            }
        }
    }

    public void changeInteractivePatchType(String string) {
        String string2 = "patchpro.patch.interactive.patchtype";
        String string3 = this.properties.getProperty(string2);
        if (this.isValidInteractivePatchType(string)) {
            if (string == null || string.equals("none")) {
                string = "";
            }
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalPatchType", "Specified patch type is identical to the one in effect - No action necessary."));
            }
        } else {
            System.err.println(this.msgcat.getMessage("errChangePatchType", "Error - failed to change patch type."));
            System.err.println(this.msgcat.getMessage("validPatchTypes", "Valid patch types : "));
            int n = 0;
            while (n < validInteractivePatchTypes.length) {
                System.err.println("\t\"" + validInteractivePatchTypes[n] + "\"");
                ++n;
            }
        }
    }

    private boolean isValidPatchType(String string) {
        boolean bl = false;
        if (string != null) {
            int n = 0;
            while (n < validPatchTypes.length) {
                if (string.equals(validPatchTypes[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isValidInteractivePatchType(String string) {
        boolean bl = true;
        Vector<String> vector = new Vector<String>();
        if (string.indexOf("none") != -1 && !string.equals("none")) {
            System.out.println(this.msgcat.getMessage("nonetypeusage", "\"none\" cannot be specified with other patch types."));
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (string != null) {
            int n = 0;
            while (n < validInteractivePatchTypes.length) {
                vector.addElement(validInteractivePatchTypes[n]);
                ++n;
            }
            stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || vector.contains(string2)) continue;
                bl = false;
                break;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void changeHardware() {
        System.out.println(this.msgcat.getMessage("changeHwConfiguration", "Change Hardware Configuration"));
        RenderInteractionSetImpl renderInteractionSetImpl = new RenderInteractionSetImpl();
        try {
            this.patchPro.addListener(this);
            this.done = false;
            this.patchPro.generateAbbreviatedHost();
            System.out.println(this.msgcat.getMessage("analyzingComputer", "Analyzing this computer."));
            while (!this.done) {
                Thread.sleep(2000L);
                System.out.print(".");
            }
            System.out.println("");
            this.patchPro.initializeInteractiveDetectors();
            while (true) {
                try {
                    while (true) {
                        InteractionSet interactionSet;
                        if ((interactionSet = this.patchPro.nextInteractiveDetector()) == null) {
                            System.out.println(this.msgcat.getMessage("nullXnSet", "Null Interaction Set."));
                            continue;
                        }
                        renderInteractionSetImpl.render(interactionSet);
                        this.patchPro.setInteractionSet(interactionSet);
                    }
                }
                catch (DetectorFailedException detectorFailedException) {
                    System.err.println(this.msgcat.getMessage("noHardware", "No hardware on your system."));
                    detectorFailedException.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (NoMoreDetectorsException noMoreDetectorsException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void changeProxyServer(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "patchpro.proxyserver.host";
        String string5 = "patchpro.proxyserver.port";
        boolean bl = false;
        boolean bl2 = false;
        if (string == null || string.equals("")) {
            bl = true;
            bl2 = true;
        } else {
            int n;
            int n2 = string.indexOf(58);
            if (n2 != -1 && n2 == (n = string.lastIndexOf(58))) {
                string2 = string.substring(0, n2);
                string3 = string.substring(n2 + 1);
                bl2 = true;
                try {
                    long l = Long.parseLong(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = false;
                }
            }
        }
        if (bl2) {
            String string6 = this.properties.getProperty(string4);
            String string7 = this.properties.getProperty(string5);
            this.setAppropriateProperty(string4, string2);
            this.setAppropriateProperty(string5, string3);
            try {
                this.properties.update(string4, string2);
                this.properties.update(string5, string3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        } else {
            System.err.println(this.msgcat.getMessage("wrongProxyServerFormat", "Proxy server format is incorrect."));
        }
    }

    public void patchproProgress(PatchProEvent patchProEvent) {
    }

    public void patchproDone(PatchProEvent patchProEvent) {
        this.done = true;
    }

    public void patchproFailed(PatchProEvent patchProEvent) {
        Object object = patchProEvent.getSource();
        Throwable throwable = null;
        if (object instanceof PatchProModel) {
            throwable = ((PatchProModel)object).getPatchProFailure();
            System.err.println(this.msgcat.getMessage("patchProFailed", "Error: PatchPro failed: ") + throwable.getMessage());
        } else {
            System.err.println("Error: Event source not PatchProModel");
        }
        this.done = true;
    }

    public void changeUserName(String string) {
        String string2 = "patchpro.sunsolve.identity";
        String string3 = this.properties.getProperty(string2);
        if (string3 != null) {
            if (string3.compareTo(string) != 0) {
                this.setAppropriateProperty(string2, string);
                try {
                    this.properties.update(string2, string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.out.println(this.msgcat.getMessage("isIdenticalUserName", "Specified user name is identical to the one in effect - No action necessary."));
            }
        } else {
            System.err.println(this.msgcat.getMessage("errChangeUserName", "Error - failed to change user name."));
        }
    }

    private void setAppropriateProperty(String string, String string2) {
        if (this.hasAssociate) {
            this.properties.setProperty(this.associateStr, string, string2);
        } else {
            this.properties.setProperty(string, string2);
        }
    }
}

