/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.BaseDataDetector;
import com.sun.patchpro.analysis.DetectorEvent;
import com.sun.patchpro.analysis.DetectorListener;
import com.sun.patchpro.analysis.SolarisIostatScanner;
import com.sun.patchpro.analysis.SolarisPackageScanner;
import com.sun.patchpro.analysis.SolarisPatchScanner;
import com.sun.patchpro.analysis.SolarisPrtconfScanner;
import com.sun.patchpro.analysis.SunOSHostScanner;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class SunOSBaseData
implements BaseDataDetector {
    private Host targetHost;
    private PatchProLog log;
    private PatchProProperties properties;
    private Vector listeners = new Vector();
    private Locale locale;
    private LocalizedMessages catalog;
    private int progress;
    private final int PKGSCANNER = 0;
    private final int PATCHSCANNER = 1;
    private final int PRTCONFSCANNER = 2;
    private final int IOSTATSCANNER = 3;
    private final int HOSTSCANNER = 4;
    private final int detectorCount = 5;
    private int detectorsDone = 0;
    private DetectorThread[] detectorArray = new DetectorThread[5];

    public SunOSBaseData() {
        this.log = PatchProLog.getInstance();
        this.properties = PatchProProperties.getInstance();
        this.catalog = this.locale != null ? new LocalizedMessages(this.locale) : new LocalizedMessages(Locale.ENGLISH);
    }

    public void setHost(Host host) {
        this.targetHost = host;
    }

    public String getMessage() {
        return this.catalog.getMessage("SunOSBaseDataMessage", "Looking for packages, patches, hosts & configuration ...");
    }

    public void run() {
        this.initializeProgress();
        this.detectorArray[0] = new DetectorThread(new SolarisPackageScanner(this.targetHost, this.locale), "pkgThread");
        this.detectorArray[1] = new DetectorThread(new SolarisPatchScanner(this.targetHost, this.locale), "patchThread");
        this.detectorArray[2] = new DetectorThread(new SolarisPrtconfScanner(this.targetHost, this.locale), "prtconfThread");
        this.detectorArray[3] = new DetectorThread(new SolarisIostatScanner(this.targetHost, this.locale), "iostatThread");
        this.detectorArray[4] = new DetectorThread(new SunOSHostScanner(this.targetHost, this.locale), "hostThread");
        try {
            int n = 0;
            while (n < 5) {
                this.detectorArray[n].setPriority();
                ++n;
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            this.log.println(this, 4, "SunOSBaseData.run(): Couldn't mark the scanners as daemons.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println(this, 4, "SunOSBaseData.run(): Couldn't set scanner thread priority.");
        }
        catch (SecurityException securityException) {
            this.log.println(this, 4, "SunOSBaseData.run(): Security error setting scanner thread priority.");
        }
        int n = 0;
        while (n < 5) {
            this.detectorArray[n].start();
            ++n;
        }
        try {
            while (this.detectorsDone < 5) {
                int n2 = 0;
                while (n2 < 5) {
                    if (this.detectorArray[n2].isAlive()) {
                        this.detectorArray[n2].join(1000);
                        this.detectorArray[n2].yield();
                    }
                    ++n2;
                }
                Thread.sleep(2000L);
            }
            int n3 = 0;
            while (n3 < 5) {
                this.detectorArray[n3].logTimeout();
                ++n3;
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.println(this, 4, "SunOSBaseData.analyze(): Operation was interrupted.");
        }
        this.dispatchDoneEvent(new DetectorEvent(this));
    }

    public Percentage percentComplete() {
        return new Percentage(this.progress);
    }

    public void addListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(detectorListener);
        }
    }

    public void removeListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(this.listeners);
        }
    }

    private void initializeProgress() {
        this.progress = 0;
        this.detectorsDone = 0;
    }

    private void evaluateProgress() {
        long l;
        long l2;
        long l3;
        long l4;
        try {
            l4 = this.detectorArray[3].percentComplete().getPercentage();
        }
        catch (Exception exception) {
            l4 = 0L;
        }
        try {
            l3 = this.detectorArray[2].percentComplete().getPercentage();
        }
        catch (Exception exception) {
            l3 = 0L;
        }
        try {
            l2 = this.detectorArray[1].percentComplete().getPercentage();
        }
        catch (Exception exception) {
            l2 = 0L;
        }
        try {
            l = this.detectorArray[4].percentComplete().getPercentage();
        }
        catch (Exception exception) {
            l = 0L;
        }
        long l5 = this.detectorArray[0].percentComplete().getPercentage();
        long l6 = (long)((float)(l2 + l5 + l3 + l4 + l) / 5.0f);
        this.progress = (int)l6;
        this.dispatchProgressEvent(new DetectorEvent(this));
    }

    private void dispatchProgressEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorProgress(detectorEvent);
        }
    }

    private void dispatchDoneEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorDone(detectorEvent);
        }
    }

    private void dispatchFailedEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            this.log.println(this, 7, "SunOSBaseData: Error Event.");
            detectorListener.detectorFailed(detectorEvent);
        }
    }

    private class DetectorThread
    implements DetectorListener {
        BaseDataDetector detector;
        Thread detectorThread;
        String name;

        public DetectorThread(BaseDataDetector baseDataDetector, String string) {
            this.detector = baseDataDetector;
            this.name = string;
            baseDataDetector.addListener(this);
            this.detectorThread = new Thread(baseDataDetector);
        }

        public void setPriority() throws IllegalThreadStateException, IllegalArgumentException, SecurityException {
            this.detectorThread.setDaemon(true);
            this.detectorThread.setPriority(1);
        }

        public void start() {
            this.detectorThread.start();
        }

        public boolean isAlive() {
            return this.detectorThread.isAlive();
        }

        public void join(int n) throws InterruptedException {
            this.detectorThread.join(n);
        }

        public void yield() {
            Thread.yield();
        }

        public void logTimeout() {
            if (this.detector.percentComplete().getPercentage() != 100) {
                SunOSBaseData.this.log.println(this, 4, "SunOSBaseData.analyze(): " + this.name + " timed out.");
            }
        }

        public Percentage percentComplete() {
            return this.detector.percentComplete();
        }

        public void detectorProgress(DetectorEvent detectorEvent) {
            SunOSBaseData.this.evaluateProgress();
        }

        public void detectorDone(DetectorEvent detectorEvent) {
            this.detector.removeListener(this);
            SunOSBaseData.this.log.println(this, 7, this.name + " is done...");
            SunOSBaseData.this.detectorsDone++;
            SunOSBaseData.this.evaluateProgress();
        }

        public void detectorFailed(DetectorEvent detectorEvent) {
            SunOSBaseData.this.dispatchFailedEvent(detectorEvent);
        }
    }
}

