/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.BaseDataDetector;
import com.sun.patchpro.analysis.DetectorEvent;
import com.sun.patchpro.analysis.DetectorListener;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.LineParser;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisPrtconfScanner
implements BaseDataDetector {
    final String[] validDrivers = new String[]{"ac", "central", "clock-board", "disk", "ebus", "ecpp", "environment", "fdthree", "fhc", "isp", "network", "options", "pci", "power", "pseudo", "QLGC,isp", "sbus", "sc", "scsi", "sd", "se", "ses", "sf", "simm-status", "sram", "ssd", "st", "su", "tape", "zs"};
    static final String MEMORYSIZEPREFIX = "Memory size: ";
    static final String DRIVERSUFFIX = ", instance #";
    final String OBPPREFIX = "OBP";
    private PatchProProperties properties;
    private PatchProLog log;
    private Vector listeners = new Vector();
    private Locale locale;
    private LocalizedMessages catalog;
    private Host targetHost;
    private int progress;
    private int fivePercent;
    private int totalPkgCount;
    private int loadedPkgCount;
    private boolean bestGuessProgress = true;
    private boolean memoryTokenFound = false;
    private boolean instanceTokenFound = false;
    private boolean driverFound = false;
    private boolean obpTokenFound = false;

    public SolarisPrtconfScanner() {
        this.log = PatchProLog.getInstance();
        this.properties = PatchProProperties.getInstance();
        this.catalog = new LocalizedMessages(Locale.ENGLISH);
        this.initializeProgress();
    }

    public SolarisPrtconfScanner(Host host, Locale locale) {
        this();
        this.setHost(host);
        this.setLocale(locale);
        this.initializeProgress();
    }

    public void setHost(Host host) {
        this.targetHost = host;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.catalog = new LocalizedMessages(locale);
        }
    }

    public String getMessage() {
        return this.catalog.getMessage("SolarisPrtconfScannerMessage", "Looking for memory and driver data ...");
    }

    public void run() {
        Runtime runtime = Runtime.getRuntime();
        try {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(this.properties.getProperty("SunOS.command.get.config.data", "/usr/sbin/prtconf"));
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = stringTokenizer.nextToken();
                    ++n;
                }
                Process process = runtime.exec(stringArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                this.interpretStream(bufferedReader);
                stringTokenizer = new StringTokenizer(this.properties.getProperty("SunOS.command.get.OBP.version", "/usr/sbin/prtconf -V"));
                String[] stringArray2 = new String[stringTokenizer.countTokens()];
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    stringArray2[n2] = stringTokenizer.nextToken();
                    ++n2;
                }
                process = runtime.exec(stringArray2);
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                this.interpretStream(bufferedReader);
                bufferedReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.dispatchErrorEvent(new DetectorEvent(this, "SolarisPrtconfScanner: Could not find utility."));
            }
        }
        catch (Exception exception) {
            this.log.println(this, 2, "SolarisPrtconfScanner: Threw " + exception.getMessage() + " while verifying privilege.");
            this.dispatchErrorEvent(new DetectorEvent(this, "SolarisPrtconfScanner: Threw " + exception.getMessage() + " while verifying privilege."));
        }
        this.finishProgress();
        this.dispatchDoneEvent(new DetectorEvent(this));
    }

    public Percentage percentComplete() {
        return new Percentage(this.progress);
    }

    public void addListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(detectorListener);
        }
    }

    public void removeListener(DetectorListener detectorListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(this.listeners);
        }
    }

    private void initializeProgress() {
        this.progress = 0;
        this.dispatchProgressEvent(new DetectorEvent(this));
    }

    private void finishProgress() {
        this.progress = 100;
        this.dispatchProgressEvent(new DetectorEvent(this));
    }

    private void interpretStream(BufferedReader bufferedReader) {
        try {
            try {
                String string;
                LineParser lineParser = new LineParser();
                while ((string = bufferedReader.readLine()) != null) {
                    lineParser.setLine(string);
                    if (!this.memoryTokenFound) {
                        try {
                            this.targetHost.setMemorySize(lineParser.getTokenSuffix(MEMORYSIZEPREFIX));
                            this.memoryTokenFound = true;
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    try {
                        this.addDriverSelectively(lineParser.getTokenPrefix(DRIVERSUFFIX), this.targetHost);
                        this.instanceTokenFound = true;
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        this.targetHost.setBootFirmware(lineParser.getTokenSuffix("OBP"));
                        this.obpTokenFound = true;
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                this.log.println(this, 4, "SolarisPrtconfScanner.interpretStream: " + exception + " thrown trying to interpret output.");
                Object var7_11 = null;
                if (!this.memoryTokenFound) {
                    this.log.println(this, 4, "SolarisPrtconfScanner.interpretStream: SunOS " + this.targetHost.getOSRelease() + " No memory token was found.");
                }
                if (!this.instanceTokenFound) {
                    this.log.println(this, 4, "SolarisPrtconfScanner.interpretStream: SunOS " + this.targetHost.getOSRelease() + " No instance token was found.");
                }
                if (!this.driverFound) {
                    this.log.println(this, 4, "SolarisPrtconfScanner.interpretStream: SunOS " + this.targetHost.getOSRelease() + " No driver was found.");
                }
            }
            Object var7_10 = null;
            if (!this.memoryTokenFound) {
                this.log.println(this, 4, "SolarisPrtconfScanner.interpretStream: SunOS " + this.targetHost.getOSRelease() + " No memory token was found.");
            }
            if (!this.instanceTokenFound) {
                this.log.println(this, 4, "SolarisPrtconfScanner.interpretStream: SunOS " + this.targetHost.getOSRelease() + " No instance token was found.");
            }
            if (!this.driverFound) {
                this.log.println(this, 4, "SolarisPrtconfScanner.interpretStream: SunOS " + this.targetHost.getOSRelease() + " No driver was found.");
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (!this.memoryTokenFound) {
                this.log.println(this, 4, "SolarisPrtconfScanner.interpretStream: SunOS " + this.targetHost.getOSRelease() + " No memory token was found.");
            }
            if (!this.instanceTokenFound) {
                this.log.println(this, 4, "SolarisPrtconfScanner.interpretStream: SunOS " + this.targetHost.getOSRelease() + " No instance token was found.");
            }
            if (!this.driverFound) {
                this.log.println(this, 4, "SolarisPrtconfScanner.interpretStream: SunOS " + this.targetHost.getOSRelease() + " No driver was found.");
            }
            throw throwable;
        }
    }

    private void addDriverSelectively(String string, Host host) {
        if (string.indexOf("SUNW,") == 0) {
            this.driverFound = true;
            host.addDriver(string);
        } else {
            int n = 0;
            while (n < this.validDrivers.length) {
                if (this.validDrivers[n].compareTo(string) == 0) {
                    this.driverFound = true;
                    host.addDriver(string);
                    break;
                }
                ++n;
            }
        }
    }

    private void dispatchProgressEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorProgress(detectorEvent);
        }
    }

    private void dispatchDoneEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorDone(detectorEvent);
        }
    }

    private void dispatchErrorEvent(DetectorEvent detectorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DetectorListener detectorListener = (DetectorListener)enumeration.nextElement();
            detectorListener.detectorFailed(detectorEvent);
        }
    }
}

