/* lib.h - SAM-FS API library functions.
 *
 * Definitions for SAM-FS API library functions.
 *
 */

/*    LSC_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *      Copyright (c) 2003 Sun Microsystems, Inc.
 *      All Rights Reserved.
 *      SUN PROPRIETARY/CONFIDENTIAL.
 *
 *      Government Rights Notice
 *      Use, duplication, or disclosure by the U.S. Government is
 *      subject to restrictions set forth in the Sun Microsystems,
 *      Inc. license agreements and as provided in DFARS 227.7202-1(a)
 *      and 227.7202-3(a) (1995), DRAS 252.227-7013(c)(ii) (OCT 1988),
 *      FAR 12.212(a)(1995), FAR 52.227-19, or FAR 52.227-14 (ALT III),
 *      as applicable.  Sun Microsystems, Inc.
 *
 *    LSC_notice_end
 */

/*
 * $Id: lib.h,v 1.3.2.2 2003/05/07 17:00:28 jdunn Exp $
 */

#pragma ident "$Id: lib.h,v 1.3.2.2 2003/05/07 17:00:28 jdunn Exp $"


#ifndef	SAMLIB_H
#define SAMLIB_H

#ifdef  __cplusplus
extern "C" {
#endif

int sam_archive(const char *name, const char *opns);
char *sam_attrtoa(int attr, char *string);
int sam_cancelstage(const char *name);
char *sam_devstr(uint_t p);
int sam_release(const char *name, const char *opns);
int sam_ssum(const char *name, const char *opns);
int sam_stage(const char *name, const char *opns);
int sam_setfa(const char *name, const char *opns);
int sam_segment(const char *name, const char *opns);
int sam_advise(const int fildes, const char *opns);

#ifdef  __cplusplus
}
#endif

#endif /* SAMLIB_H */
