/*
 * Decompiled with CFR 0.152.
 */
package sam.model;

import java.util.Observable;
import sam.model.Media;
import sam.model.SamManager;

public class SamDevice
extends Observable {
    public static final int STATE_ON = 0;
    public static final int STATE_READ_ONLY = 1;
    public static final int STATE_IDLE = 2;
    public static final int STATE_UNAVAILABLE = 3;
    public static final int STATE_OFF = 4;
    public static final int STATE_DOWN = 5;
    public static final short RAW_DISK = 256;
    public static final short TAPE = 512;
    public static final short TAPE_VIDEO = 513;
    public static final short TAPE_3480 = 514;
    public static final short TAPE_8MM = 515;
    public static final short TAPE_DLT = 516;
    public static final short TAPE_4MM = 517;
    public static final short TAPE_9490 = 518;
    public static final short TAPE_D3 = 519;
    public static final short TAPE_D2 = 520;
    public static final short TAPE_3590 = 521;
    public static final short TAPE_3570 = 522;
    public static final short TAPE_DTF = 523;
    public static final short TAPE_AIT = 524;
    public static final short TAPE_9840 = 525;
    public static final short TAPE_DIANA4 = 526;
    public static final short TAPE_LTO = 529;
    public static final short DISK_OPTICAL = 1280;
    public static final short DISK_12_WORM = 1281;
    public static final short DISK_525_WORM = 1282;
    public static final short DISK_525 = 1283;
    public static final short DISK_MULTI_FUNC = 1284;
    public static final short SET_DISK = 2049;
    public static final short ROBOT_LMS4500 = 6273;
    public static final short ROBOT_CYGNET = 6274;
    public static final short ROBOT_DOCSTOR = 6275;
    public static final short ROBOT_HP_LIB = 6276;
    public static final short ROBOT_DLT2700 = 6341;
    public static final short ROBOT_METRUM_LIB = 6342;
    public static final short ROBOT_METRUM_D28 = 6343;
    public static final short ROBOT_METRUM_D360 = 6344;
    public static final short ROBOT_ACL_LIB = 6345;
    public static final short ROBOT_ACL_452 = 6346;
    public static final short ROBOT_ACL_2640 = 6347;
    public static final short ROBOT_EXB_210 = 6349;
    public static final short ROBOT_ADIC_448 = 6351;
    public static final short ROBOT_SPECLOG = 6352;
    public static final short ROBOT_STK_97XX = 6354;
    public static final short ROBOT_AMPX_410 = 6355;
    public static final short ROBOT_IBM_3570 = 6356;
    public static final short ROBOT_SONY_DMS = 6357;
    public static final short ROBOT_AMPX_810 = 6358;
    public static final short ROBOT_ACI_GRAU = 6220;
    public static final short ROBOT_API_STK = 6222;
    public static final short ROBOT_API_IBM = 6225;
    public static final short ROBOT_API_LMF = 6231;
    public static final short ROBOT_ATL_P3000 = 6360;
    public static final short ROBOT_ADIC1000 = 6363;
    public static final short ROBOT_EXBX80 = 6364;
    public static final short ROBOT_STKLXX = 6365;
    public static final short ROBOT_IBM3584 = 6366;
    public static final short ROBOT_ADIC100 = 6367;
    public static final short ROBOT_AMPX914 = 6368;
    public static final short ROBOT_SUN_L20 = 6369;
    public static final short ROBOT_QUAL_LIB = 6370;
    public static final short ROBOT_L25_LIB = 6371;
    public static final short ROBOT_ODI_NEO = 6372;
    public static final short PSEUDO_SSI = 8193;
    public static final short ROBOT_HISTORIAN = 8197;
    private static final String[] deviceStringCodes = new String[]{"fs", "ms", "rb", "rc", "ml", "ds", "hp", "cy", "me", "me", "me", "ac", "ac", "ac", "dm", "gr", "eb", "sk", "s9", "a1", "a2", "ic", "im", "ad", "sl", "fj", "ac", "as", "e8", "sn", "il", "ae", "a3", "hc", "q8", "al", "ov", "md", "tp", "vt", "st", "se", "xt", "lt", "dt", "d2", "d3", "ib", "i7", "so", "at", "sg", "fd", "li", "ai", "od", "wo", "mo", "o2", "mf", "ra", "rs", "rd", "hy"};
    private static final short[] deviceNumberCodes = new short[]{-1, -1, -1, 6273, 6341, 6275, 6276, 6274, 6342, 6343, 6344, 6345, 6346, 6347, 6357, 6220, 6349, 6222, 6354, 6355, 6358, 6356, 6225, 6351, 6352, 6231, 6360, 6363, 6364, 6365, 6366, 6367, 6368, 6369, 6370, 6371, 6372, -1, -1, 513, 514, 518, 515, 516, 517, 520, 519, 521, 522, 523, 524, 525, 526, 529, 1280, 1282, 1283, 1281, 1284, -1, -1, -1, 8197};
    private static final short[] defaultMediaCodes = new short[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 513, 514, 518, 515, 516, 517, 520, 519, 521, 522, 523, 524, 525, 526, 529, 1280, 1282, 1283, 1281, 1283, -1, -1, -1, -1};
    protected String name;
    protected String setName;
    protected int eqId;
    protected int familySetEqId;
    protected int type;
    protected int ordinal;
    protected int sectorSize;
    protected String vendorId;
    protected String productId;
    protected boolean maintenance;
    protected boolean scanError;
    protected boolean auditing;
    protected boolean attention;
    protected boolean scanning;
    protected boolean mounted;
    protected boolean scanned;
    protected boolean writeLockout;
    protected boolean unload;
    protected boolean requested;
    protected boolean opened;
    protected boolean ready;
    protected boolean present;
    protected boolean storageFull;
    protected boolean ioPortWait;
    protected boolean stageActive;
    protected boolean cleaning;
    protected boolean positioning;
    protected boolean forward;
    protected boolean waitIdle;
    protected boolean fsActive;
    protected int state;
    protected long space;
    protected long capacity;
    protected int activeCount;
    protected int openCount;
    protected String messageText = new String();
    protected String priorityMessageText = new String();
    protected SamDevice parent;
    protected Media media;

    public static String getDeviceString(int n) {
        int n2 = 0;
        while (n2 < deviceNumberCodes.length) {
            if (deviceNumberCodes[n2] == n) {
                return deviceStringCodes[n2];
            }
            ++n2;
        }
        return null;
    }

    public short getDefaultMediaType() {
        int n = 0;
        while (n < deviceNumberCodes.length) {
            if (deviceNumberCodes[n] == this.type) {
                return defaultMediaCodes[n];
            }
            ++n;
        }
        return -1;
    }

    public boolean inMaintenanceMode() {
        return this.maintenance;
    }

    public boolean isScanning() {
        return this.scanning;
    }

    public boolean scanError() {
        return this.scanError;
    }

    public boolean inAuditMode() {
        return this.auditing;
    }

    public boolean isIdleWaiting() {
        return this.waitIdle;
    }

    public boolean needsOperatorAttention() {
        return this.attention;
    }

    public boolean needsCleaning() {
        return this.cleaning;
    }

    public boolean isUnloading() {
        return this.unload;
    }

    public boolean isReserved() {
        return this.requested;
    }

    public boolean isWriting() {
        return this.writeLockout;
    }

    public boolean isOpen() {
        return this.opened;
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isPresent() {
        return this.present;
    }

    public boolean isOn() {
        return this.state == 0;
    }

    public String getName() {
        return this.name;
    }

    public String getSetName() {
        return this.setName;
    }

    public String getCurrentMessageText() {
        if (this.priorityMessageText != null && this.priorityMessageText.length() > 0) {
            return this.priorityMessageText;
        }
        return this.messageText;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public String getPriorityMessageText() {
        return this.priorityMessageText;
    }

    public String getVendorId() {
        return this.vendorId;
    }

    public String getProductId() {
        return this.productId;
    }

    public int getEqId() {
        return this.eqId;
    }

    public int getFamilySetEqId() {
        return this.familySetEqId;
    }

    public int getState() {
        return this.state;
    }

    public Media getMedia() {
        return this.media;
    }

    public SamDevice getParent() {
        return this.parent;
    }

    public void setParent(SamDevice samDevice) {
        this.parent = samDevice;
    }

    public long getSpace() {
        return this.space;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public short getPercentageFull() {
        if (this.capacity > 0L) {
            return (short)((this.capacity - this.space) * 100L / this.capacity);
        }
        return -1;
    }

    public boolean isParent() {
        return this.familySetEqId == this.eqId;
    }

    public boolean isChild(SamDevice samDevice) {
        return this.familySetEqId == samDevice.getEqId() && !this.isParent();
    }

    public String getTypeString() {
        return SamDevice.getDeviceString(this.type);
    }

    public int getType() {
        return this.type;
    }

    public void update(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, boolean bl21, int n, long l, long l2, int n2, int n3, String string, String string2) {
        string = string.trim();
        string2 = string2.trim();
        if (this.maintenance != bl) {
            this.setChanged();
            this.maintenance = bl;
        }
        if (this.scanError != bl2) {
            this.setChanged();
            this.scanError = bl2;
        }
        if (this.auditing != bl3) {
            this.setChanged();
            this.auditing = bl3;
        }
        if (this.attention != bl4) {
            this.setChanged();
            this.attention = bl4;
        }
        if (this.scanning != bl5) {
            this.setChanged();
            this.scanning = bl5;
        }
        if (this.mounted != bl6) {
            this.setChanged();
            this.mounted = bl6;
        }
        if (this.scanned != bl7) {
            this.setChanged();
            this.scanned = bl7;
        }
        if (this.writeLockout != bl8) {
            this.setChanged();
            this.writeLockout = bl8;
        }
        if (this.unload != bl9) {
            this.setChanged();
            this.unload = bl9;
        }
        if (this.requested != bl10) {
            this.setChanged();
            this.requested = bl10;
        }
        if (this.opened != bl11) {
            this.setChanged();
            this.opened = bl11;
        }
        if (this.ready != bl12) {
            this.setChanged();
            this.ready = bl12;
        }
        if (this.present != bl13) {
            this.setChanged();
            this.present = bl13;
        }
        if (this.storageFull != bl14) {
            this.setChanged();
            this.storageFull = bl14;
        }
        if (this.ioPortWait != bl15) {
            this.setChanged();
            this.ioPortWait = bl15;
        }
        if (this.stageActive != bl16) {
            this.setChanged();
            this.stageActive = bl16;
        }
        if (this.cleaning != bl17) {
            this.setChanged();
            this.cleaning = bl17;
        }
        if (this.positioning != bl18) {
            this.setChanged();
            this.positioning = bl18;
        }
        if (this.forward != bl19) {
            this.setChanged();
            this.forward = bl19;
        }
        if (this.waitIdle != bl20) {
            this.setChanged();
            this.waitIdle = bl20;
        }
        if (this.fsActive != bl21) {
            this.setChanged();
            this.fsActive = bl21;
        }
        if (this.state != n) {
            this.setChanged();
            this.state = n;
        }
        if (this.space != l) {
            this.setChanged();
            this.space = l;
        }
        if (this.capacity != l2) {
            this.setChanged();
            this.capacity = l2;
        }
        if (this.activeCount != n2) {
            this.setChanged();
            this.activeCount = n2;
        }
        if (this.openCount != n3) {
            this.setChanged();
            this.openCount = n3;
        }
        if (!this.messageText.equals(string)) {
            this.setChanged();
            this.messageText = string;
        }
        if (!this.priorityMessageText.equals(string2)) {
            this.setChanged();
            this.priorityMessageText = string2;
        }
    }

    public int hashCode() {
        return this.getEqId();
    }

    public boolean equals(Object object) {
        try {
            if (((SamDevice)object).getEqId() == this.getEqId()) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public void unload() {
        SamManager.dataSource.unloadDevice(this);
    }

    public void setState(int n) {
        SamManager.dataSource.setDeviceState(this, n);
    }

    public SamDevice(String string, String string2, int n, int n2, int n3, int n4, int n5, String string3, String string4) {
        this.name = string.trim();
        this.setName = string2.trim();
        this.eqId = n;
        this.familySetEqId = n2;
        this.type = n3;
        this.ordinal = n4;
        this.sectorSize = n5;
        this.vendorId = string3.trim();
        this.productId = string4.trim();
    }
}

