/*
 * Decompiled with CFR 0.152.
 */
package sam.model;

import java.util.Date;
import java.util.Observable;
import sam.model.Robot;
import sam.model.SamDevice;
import sam.model.SamManager;

public class Media
extends Observable {
    public static final short TAPE = 512;
    public static final short TAPE_VIDEO = 513;
    public static final short TAPE_3480 = 514;
    public static final short TAPE_8MM = 515;
    public static final short TAPE_DLT = 516;
    public static final short TAPE_4MM = 517;
    public static final short TAPE_9490 = 518;
    public static final short TAPE_D3 = 519;
    public static final short TAPE_D2 = 520;
    public static final short TAPE_3590 = 521;
    public static final short TAPE_3570 = 522;
    public static final short TAPE_DTF = 523;
    public static final short TAPE_AIT = 524;
    public static final short TAPE_9840 = 525;
    public static final short TAPE_DIANA4 = 526;
    public static final short TAPE_LTO = 529;
    public static final short TAPE_MASK = 512;
    public static final short DISK_OPTICAL = 1280;
    public static final short DISK_12_WORM = 1281;
    public static final short DISK_525_WORM = 1282;
    public static final short DISK_525 = 1283;
    public static final short OPTICAL_MASK = 1280;
    private static String[] mediaStringCodes = new String[]{"tp", "vt", "st", "xt", "lt", "dt", "se", "d3", "d2", "ib", "i7", "so", "at", "sg", "fd", "li", "od", "o2", "wo", "mo"};
    private static short[] mediaNumberCodes = new short[]{512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 529, 1280, 1281, 1282, 1283};
    protected String barcode;
    protected short type;
    private String idString;
    protected String vsn;
    protected boolean labeled;
    protected boolean badMedia;
    protected boolean cleaning;
    protected boolean barcoded;
    protected boolean writeProtected;
    protected boolean readOnly;
    protected boolean recycle;
    protected boolean unformatted;
    protected boolean unavailable;
    protected int accessCount;
    protected long capacity;
    protected long space;
    protected int sectorSize;
    protected Date labelTime = new Date(0L);
    protected Date modificationTime = new Date(0L);
    protected Date lastMountTime = new Date(0L);

    public static short getMediaStringType(String string) {
        int n = 0;
        while (n < mediaStringCodes.length) {
            if (mediaStringCodes[n].equals(string)) {
                return mediaNumberCodes[n];
            }
            ++n;
        }
        return -1;
    }

    public static String getMediaString(short s) {
        int n = 0;
        while (n < mediaNumberCodes.length) {
            if (mediaNumberCodes[n] == s) {
                return mediaStringCodes[n];
            }
            ++n;
        }
        return null;
    }

    public static String[] getTypeStrings() {
        return mediaStringCodes;
    }

    public int getLabelLength() {
        return 0;
    }

    public int getMaxBlocksize() {
        return 0;
    }

    public String getName() {
        return this.vsn;
    }

    public String getBarcode() {
        if (this.barcoded) {
            return this.barcode;
        }
        return null;
    }

    public int getAccessCount() {
        return this.accessCount;
    }

    public int getSectorSize() {
        return this.sectorSize;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getSpace() {
        return this.space;
    }

    public Date getLabelDate() {
        return this.labelTime;
    }

    public Date getMountDate() {
        return this.lastMountTime;
    }

    public Date getModificationDate() {
        return this.modificationTime;
    }

    public boolean isLabeled() {
        return this.labeled;
    }

    public boolean isMarkedDamaged() {
        return this.badMedia;
    }

    public boolean isCleaning() {
        return this.cleaning;
    }

    public boolean isBarcoded() {
        return this.barcoded;
    }

    public boolean isWriteProtected() {
        return this.writeProtected;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isMarkedRecycle() {
        return this.recycle;
    }

    public boolean isUnformatted() {
        return this.unformatted;
    }

    public boolean isUnavailable() {
        return this.unavailable;
    }

    public short getType() {
        return this.type;
    }

    public String getTypeString() {
        return Media.getMediaString(this.type);
    }

    public void setMountDate(Date date) {
        this.lastMountTime = date;
    }

    public short getPercentageFull() {
        if (this.capacity > 0L) {
            return (short)((this.capacity - this.space) * 100L / this.capacity);
        }
        return -1;
    }

    public void setUnavailable(boolean bl) {
        SamManager.dataSource.setUnavailable(this, bl);
    }

    public void setDamaged(boolean bl) {
        SamManager.dataSource.setDamaged(this, bl);
    }

    public void setReadOnly(boolean bl) {
        SamManager.dataSource.setReadOnly(this, bl);
    }

    public void setRecycle(boolean bl) {
        SamManager.dataSource.setRecycle(this, bl);
    }

    public void update(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, int n, long l, long l2, int n2, long l3, long l4, long l5) {
        if (this.vsn == null && string != null || !this.vsn.equals(string)) {
            this.setChanged();
            this.vsn = string;
        }
        if (this.labeled != bl) {
            this.setChanged();
            this.labeled = bl;
        }
        if (this.badMedia != bl2) {
            this.setChanged();
            this.badMedia = bl2;
        }
        if (this.cleaning != bl3) {
            this.setChanged();
            this.cleaning = bl3;
        }
        if (this.barcoded != bl4) {
            this.setChanged();
            this.barcoded = bl4;
        }
        if (this.writeProtected != bl5) {
            this.setChanged();
            this.writeProtected = bl5;
        }
        if (this.readOnly != bl6) {
            this.setChanged();
            this.readOnly = bl6;
        }
        if (this.recycle != bl7) {
            this.setChanged();
            this.recycle = bl7;
        }
        if (this.unavailable != bl9) {
            this.setChanged();
            this.unavailable = bl9;
        }
        if (this.accessCount != n) {
            this.setChanged();
            this.accessCount = n;
        }
        if (this.capacity != l) {
            this.setChanged();
            this.capacity = l;
        }
        if (this.space != l2) {
            this.setChanged();
            this.space = l2;
        }
        if (this.sectorSize != n2) {
            this.setChanged();
            this.sectorSize = n2;
        }
        if (this.labelTime.getTime() != l3) {
            this.setChanged();
            this.labelTime = new Date(l3);
        }
        if (this.modificationTime.getTime() != l4) {
            this.setChanged();
            this.modificationTime = new Date(l4);
        }
        if (this.lastMountTime.getTime() != l5) {
            this.setChanged();
            this.lastMountTime = new Date(l5);
        }
        this.notifyObservers();
    }

    public void update(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l, long l2, int n, long l3) {
        if (this.vsn == null && string != null || !this.vsn.equals(string)) {
            this.setChanged();
            this.vsn = string;
        }
        if (this.labeled != bl) {
            this.setChanged();
            this.labeled = bl;
        }
        if (this.badMedia != bl2) {
            this.setChanged();
            this.badMedia = bl2;
        }
        if (this.writeProtected != bl3) {
            this.setChanged();
            this.writeProtected = bl3;
        }
        if (this.readOnly != bl4) {
            this.setChanged();
            this.readOnly = bl4;
        }
        if (this.capacity != l) {
            this.setChanged();
            this.capacity = l;
        }
        if (this.space != l2) {
            this.setChanged();
            this.space = l2;
        }
        if (this.sectorSize != n) {
            this.setChanged();
            this.sectorSize = n;
        }
        if (this.labelTime.getTime() != l3) {
            this.setChanged();
            this.labelTime = new Date(l3);
        }
        this.notifyObservers();
    }

    public void update(String string) {
        if (this.vsn == null && string != null || !this.vsn.equals(string)) {
            this.setChanged();
            this.vsn = string;
        }
        this.notifyObservers();
    }

    public int hashCode() {
        return this.idString.hashCode();
    }

    public boolean equals(Object object) {
        try {
            Media media = (Media)object;
            if (media.idString.equals(this.idString)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public String toString() {
        return "[media - name:" + this.vsn + " barcode:" + this.barcode + " type:" + this.type + " labeled:" + this.labeled + " badmedia:" + this.badMedia + " cleaning:" + this.cleaning + " barcoded:" + this.barcoded + " writeprotect:" + this.writeProtected + " readonly:" + this.readOnly + " recycle:" + this.recycle + " unformatted:" + this.unformatted + "  access:" + this.accessCount + " capacity:" + this.capacity + " space:" + this.space + " sector:" + this.sectorSize + "]";
    }

    public boolean isFuzzy() {
        return this.cleaning || this.vsn == null || this.type == 0 || this.vsn.length() == 0;
    }

    public Media(String string, String string2, short s) {
        if (string != null) {
            this.vsn = string.trim();
            if (this.vsn.length() > 0) {
                this.labeled = true;
            }
        } else {
            this.vsn = new String();
        }
        if (string2 != null) {
            this.barcode = string2.trim();
            if (this.barcode.length() > 0) {
                this.barcoded = true;
            }
        } else {
            this.barcode = new String();
        }
        this.type = s;
        this.idString = new String("T:" + this.getTypeString() + " V:" + string);
    }

    public Media(String string, String string2, short s, boolean bl, SamDevice samDevice, int n) {
        this(string, string2, s);
        this.cleaning = bl;
        this.idString = new String("T:" + this.getType() + " E:" + samDevice.getEqId());
        if (samDevice instanceof Robot) {
            this.idString = String.valueOf(this.idString) + " S:" + n;
        }
    }
}

