/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import sam.resource.ResourceManager;

public class GUIManager {
    private static Object mainObject;
    private static Component mainComponent;
    private static Dimension screenDim;
    private static int screenType;
    private static final int HEIGHT = 0;
    public static final int MIN_FONT = 1;
    public static final int NORM_FONT = 2;
    public static final int MAX_FONT = 3;
    public static final int MIN_ICON = 4;
    public static final int NORM_ICON = 5;
    public static final int MAX_ICON = 6;
    private static int[][] screenSettings;

    public static Object parentObject() {
        return mainObject;
    }

    public static void setParentObject(Object object) {
        mainObject = object;
    }

    public static Component parentComponent() {
        return mainComponent;
    }

    private static void setParentComponent(Component component) {
        mainComponent = component;
    }

    public static Dimension getScreenSize() {
        return screenDim;
    }

    public static void setScreenType(Dimension dimension) {
        screenType = screenSettings.length - 1;
        int n = 0;
        while (n < screenSettings.length) {
            if (dimension.height <= screenSettings[n][0]) {
                screenType = n;
                return;
            }
            ++n;
        }
    }

    public static void setScreenType(int n) {
        if (n >= 0 && n < screenSettings.length) {
            screenType = n;
        }
    }

    public static int getScreenType() {
        return screenType;
    }

    public static void setParentPosition(Point point) {
        if (point.x >= 0 && point.y >= 0) {
            mainComponent.setLocation(point);
            return;
        }
        int n = point.x;
        int n2 = point.y;
        if (n < 0) {
            n += GUIManager.screenDim.width;
        }
        if (n2 < 0) {
            n2 += GUIManager.screenDim.height;
        }
        mainComponent.setLocation(n, n2);
    }

    public static void setParentSize(Dimension dimension) {
        mainComponent.setSize(dimension);
    }

    public static void initialize(Component component) {
        GUIManager.setParentComponent(component);
        screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 0;
        while (n < screenSettings.length) {
            try {
                Integer[] integerArray = ResourceManager.getScreenSizings(n);
                int n2 = 0;
                while (n2 < integerArray.length) {
                    GUIManager.screenSettings[n][n2] = integerArray[n2];
                    ++n2;
                }
                System.out.println("Overrode screen settings for display type: " + n);
            }
            catch (Exception exception) {}
            ++n;
        }
        if (screenType < 0) {
            GUIManager.setScreenType(screenDim);
        }
    }

    public static int getFontPointSize(int n) {
        return screenSettings[screenType][n];
    }

    public static int getIconHeight(int n) {
        return screenSettings[screenType][n];
    }

    private GUIManager() {
    }

    static {
        screenType = -1;
        screenSettings = new int[][]{{480, 9, 10, 14, 20, 50, 80}, {600, 9, 11, 16, 30, 70, 95}, {768, 10, 12, 18, 35, 75, 100}};
    }
}

