/*
 * Decompiled with CFR 0.152.
 */
package sam.model.datasource;

import sam.model.DataSource;
import sam.model.Ea;
import sam.model.MassStorage;
import sam.model.Media;
import sam.model.OpticalDrive;
import sam.model.Robot;
import sam.model.SamDevice;
import sam.model.TapeDrive;
import sam.resource.ResourceManager;

public class LiveData
extends DataSource {
    private static final int NO_SLOT = -1;

    public boolean setup() {
        try {
            System.loadLibrary("liveData");
            if (!this.liveSetup()) {
                System.err.println(ResourceManager.getString("Native live initialization failed"));
                return false;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(String.valueOf(ResourceManager.getString("Could not find native live interface library")) + ": " + unsatisfiedLinkError);
            return false;
        }
        return true;
    }

    public void update() {
        this.liveUpdate();
    }

    private native boolean liveSetup();

    private native void liveUpdate();

    private native int liveExport(int var1, String var2, int var3);

    private native int liveImport(int var1, String var2, String var3, boolean var4);

    private native int liveMove(int var1, int var2, int var3);

    private native int liveOpticalLabel(int var1, String var2, String var3, int var4, int var5, String var6, boolean var7);

    private native int liveTapeLabel(int var1, String var2, String var3, int var4, int var5, int var6, boolean var7);

    private native int liveSetState(int var1, int var2);

    private native int liveUnloadDevice(int var1);

    private native int liveLoadDevice(int var1, String var2, int var3, int var4);

    private native int liveClearRequest(int var1);

    private native int liveAudit(int var1, int var2);

    private native int liveSetFSThreshold(int var1, int var2, int var3);

    private native int liveSetFSReadahead(int var1, int var2);

    private native int liveSetFSWritebehind(int var1, int var2);

    private native int liveSetMediaDamage(String var1, String var2, boolean var3);

    private native int liveSetMediaReadOnly(String var1, String var2, boolean var3);

    private native int liveSetMediaRecycle(String var1, String var2, boolean var3);

    private native int liveSetMediaUnavailable(String var1, String var2, boolean var3);

    private String getTrueString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    public int exportMedia(SamDevice samDevice, Media media) {
        return this.liveExport(samDevice.getEqId(), this.getTrueString(media.getName()), -1);
    }

    public int exportSlot(Robot robot, Ea ea) {
        return this.liveExport(robot.getEqId(), null, ea.getElementAddress());
    }

    public int importMedia(Robot robot, boolean bl) {
        return this.liveImport(robot.getEqId(), null, null, bl);
    }

    public int importMedia(Robot robot, Media media, boolean bl) {
        return this.liveImport(robot.getEqId(), this.getTrueString(media.getName()), this.getTrueString(media.getTypeString()), bl);
    }

    public int moveMedia(Robot robot, Ea ea, Ea ea2) {
        return this.liveMove(robot.getEqId(), ea.getElementAddress(), ea2.getElementAddress());
    }

    public int labelMedia(Robot robot, Media media, Ea ea, String string, String string2, boolean bl) {
        return this.liveOpticalLabel(robot.getEqId(), string, this.getTrueString(media.getName()), ea.getElementAddress(), ea.getModifier(), string2, bl);
    }

    public int labelMedia(OpticalDrive opticalDrive, Media media, String string, String string2, boolean bl) {
        return this.liveOpticalLabel(opticalDrive.getEqId(), string, this.getTrueString(media.getName()), -1, 0, string2, bl);
    }

    public int labelMedia(Robot robot, Media media, Ea ea, String string, int n, boolean bl) {
        return this.liveTapeLabel(robot.getEqId(), string, this.getTrueString(media.getName()), ea.getElementAddress(), ea.getModifier(), n, bl);
    }

    public int labelMedia(TapeDrive tapeDrive, Media media, String string, int n, boolean bl) {
        return this.liveTapeLabel(tapeDrive.getEqId(), string, this.getTrueString(media.getName()), -1, 0, n, bl);
    }

    public int setDeviceState(SamDevice samDevice, int n) {
        return this.liveSetState(samDevice.getEqId(), n);
    }

    public int unloadDevice(SamDevice samDevice) {
        return this.liveUnloadDevice(samDevice.getEqId());
    }

    public int loadSlot(Robot robot, Ea ea) {
        return this.liveLoadDevice(robot.getEqId(), null, ea.getElementAddress(), ea.getModifier());
    }

    public int loadDevice(SamDevice samDevice, Media media) {
        return this.liveLoadDevice(samDevice.getEqId(), this.getTrueString(media.getName()), -1, 0);
    }

    public int clearRequest(int n) {
        return this.liveClearRequest(n);
    }

    public int auditRobot(Robot robot) {
        return this.liveAudit(robot.getEqId(), -1);
    }

    public int auditSlot(Robot robot, Ea ea) {
        return this.liveAudit(robot.getEqId(), ea.getElementAddress());
    }

    public int setFSThreshold(MassStorage massStorage, int n, int n2) {
        return this.liveSetFSThreshold(massStorage.getEqId(), n, n2);
    }

    public int setReadahead(MassStorage massStorage, int n) {
        return this.liveSetFSReadahead(massStorage.getEqId(), n);
    }

    public int setWritebehind(MassStorage massStorage, int n) {
        return this.liveSetFSWritebehind(massStorage.getEqId(), n);
    }

    public int setUnavailable(Media media, boolean bl) {
        return this.liveSetMediaUnavailable(media.getName(), media.getTypeString(), bl);
    }

    public int setDamaged(Media media, boolean bl) {
        return this.liveSetMediaDamage(media.getName(), media.getTypeString(), bl);
    }

    public int setReadOnly(Media media, boolean bl) {
        return this.liveSetMediaReadOnly(media.getName(), media.getTypeString(), bl);
    }

    public int setRecycle(Media media, boolean bl) {
        return this.liveSetMediaRecycle(media.getName(), media.getTypeString(), bl);
    }

    public LiveData() {
        this.updateInterval = 1;
        this.garbageCollectionInterval = this.updateInterval * 60;
    }
}

