/*
 * Decompiled with CFR 0.152.
 */
package sam.gui.popup;

import sam.authority.AuthorityManager;
import sam.gui.DeviceDisplay;
import sam.gui.PopUp;
import sam.model.SamDevice;
import sam.resource.ResourceManager;

public class DevicePopUp
extends PopUp {
    private SamDevice device;

    public void handleCommand(String string) {
        if (string.equals(ResourceManager.getString("Unload"))) {
            this.device.unload();
            return;
        }
        if (string.equals(ResourceManager.getString("On"))) {
            this.device.setState(0);
            return;
        }
        if (string.equals(ResourceManager.getString("Off"))) {
            this.device.setState(4);
            return;
        }
        if (string.equals(ResourceManager.getString("Unavailable"))) {
            this.device.setState(3);
            return;
        }
        if (string.equals(ResourceManager.getString("Down"))) {
            this.device.setState(5);
        }
    }

    public void setupMenu() {
        this.addMenuItem(ResourceManager.getString("Unload"), this.device.getMedia() != null);
        this.addSeparator();
        this.addMenuItem(ResourceManager.getString("On"), true);
        boolean bl = AuthorityManager.canChangeState(this.device);
        this.addMenuItem(ResourceManager.getString("Off"), bl);
        this.addMenuItem(ResourceManager.getString("Unavailable"), bl);
        this.addMenuItem(ResourceManager.getString("Down"), bl);
        switch (this.device.getState()) {
            case 0: {
                this.setHighlighted(ResourceManager.getString("On"));
                return;
            }
            case 4: {
                this.setHighlighted(ResourceManager.getString("Off"));
                return;
            }
            case 3: {
                this.setHighlighted(ResourceManager.getString("Unavailable"));
                return;
            }
            case 5: {
                this.setEnabled(ResourceManager.getString("On"), false);
                this.setEnabled(ResourceManager.getString("Unavailable"), false);
                this.setHighlighted(ResourceManager.getString("Down"));
                return;
            }
        }
    }

    public DevicePopUp(DeviceDisplay deviceDisplay) {
        super(ResourceManager.getString("Device"), deviceDisplay);
        this.device = deviceDisplay.getDevice();
        this.setupMenu();
    }
}

