/*
 * Decompiled with CFR 0.152.
 */
package sam.gui.popup;

import sam.authority.AuthorityManager;
import sam.gui.CatalogDisplay;
import sam.gui.dialog.LabelDialog;
import sam.gui.dialog.MoveDialog;
import sam.gui.popup.TableEntryPopUp;
import sam.model.Catalog;
import sam.model.CatalogEntry;
import sam.model.Robot;
import sam.model.TableEntry;
import sam.resource.ResourceManager;

public class CatEntryPopUp
extends TableEntryPopUp {
    private CatalogDisplay displayParent;
    private CatalogEntry entry;
    private Catalog catalog;

    public void handleCommand(String string) {
        if (string.equals(ResourceManager.getString("Label"))) {
            LabelDialog labelDialog = new LabelDialog((CatalogDisplay)this.parentComponent);
            labelDialog.show(this.entry);
            return;
        }
        if (string.equals(ResourceManager.getString("Move"))) {
            MoveDialog moveDialog = new MoveDialog((CatalogDisplay)this.parentComponent);
            moveDialog.show(this.entry);
            return;
        }
        if (string.equals(ResourceManager.getString("Export"))) {
            this.catalog.getParent().export(this.entry.getEa());
            return;
        }
        if (string.equals(ResourceManager.getString("Mount"))) {
            this.catalog.getParent().mount(this.entry.getEa());
            return;
        }
        if (string.equals(ResourceManager.getString("Audit"))) {
            this.catalog.getParent().audit(this.entry.getEa());
        }
    }

    protected void setupMenu(TableEntry tableEntry) {
        this.entry = (CatalogEntry)tableEntry;
        Robot robot = this.catalog.getParent();
        if (!this.entry.isOccupied() || !this.entry.isInUse()) {
            return;
        }
        if (!this.entry.getMedia().isCleaning()) {
            this.addMenuItem(ResourceManager.getString("Label"), AuthorityManager.canLabel(robot));
            if (robot.isAuditable()) {
                this.addMenuItem(ResourceManager.getString("Audit"), true);
            }
            this.addMenuItem(ResourceManager.getString("Mount"), true);
        }
        if (robot.canPerformSlotMovement()) {
            this.addMenuItem(ResourceManager.getString("Move"), AuthorityManager.canMove(robot));
        }
        if (robot.hasMailbox()) {
            this.addMenuItem(ResourceManager.getString("Export"), AuthorityManager.canExport(robot));
        }
    }

    public CatEntryPopUp(CatalogDisplay catalogDisplay) {
        super(ResourceManager.getString("Catalog Entry"), catalogDisplay);
        this.catalog = (Catalog)catalogDisplay.getDataTable();
    }
}

