/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import sam.gui.GUIManager;
import sam.resource.ResourceManager;

public class Icon
extends Canvas {
    private static final String NULL_IMAGE = "null.gif";
    private static boolean cacheImages = true;
    private static Hashtable images = new Hashtable();
    private Image image;
    private String filename;
    private boolean scaling;
    private int scaledHeight;
    private int scaledWidth;
    public static Component baseComponent;

    public static Image findPaintedImage(String string, int n, int n2, int n3) {
        if (cacheImages) {
            return (Image)images.get(String.valueOf(string) + " w:" + n + " h:" + n2 + " a:" + n3);
        }
        return null;
    }

    public static synchronized void addPaintedImage(String string, int n, int n2, int n3, Image image) {
        if (cacheImages) {
            images.put(String.valueOf(string) + " w:" + n + " h:" + n2 + " a:" + n3, image);
        }
    }

    public static Image findImage(String string, int n, int n2) {
        if (cacheImages) {
            return (Image)images.get(String.valueOf(string) + " w:" + n + " h:" + n2);
        }
        return null;
    }

    public static synchronized void addImage(String string, int n, int n2, Image image) {
        if (cacheImages) {
            images.put(String.valueOf(string) + " w:" + n + " h:" + n2, image);
        }
    }

    public int getPaintedAttributes() {
        return 0;
    }

    public void setScaling(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.setNoScaling();
            return;
        }
        this.scaledHeight = n2;
        this.scaledWidth = n;
        this.scaling = true;
    }

    public void setNoScaling() {
        this.scaledWidth = 0;
        this.scaledHeight = 0;
        this.scaling = false;
    }

    private Image loadUnscaledImage() {
        Serializable serializable;
        Image image = Icon.findImage(this.filename, 0, 0);
        if (image != null) {
            return image;
        }
        try {
            serializable = GUIManager.parentObject().getClass().getResource(this.filename);
            image = Toolkit.getDefaultToolkit().createImage((ImageProducer)((URL)serializable).getContent());
        }
        catch (Exception exception) {
            image = Toolkit.getDefaultToolkit().getImage(this.filename);
        }
        serializable = new MediaTracker(this);
        ((MediaTracker)serializable).addImage(image, 0);
        try {
            ((MediaTracker)serializable).waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        if (((MediaTracker)serializable).isErrorAny()) {
            System.err.println(String.valueOf(ResourceManager.getString("Unable to load")) + ": " + this.filename);
            return null;
        }
        Icon.addImage(this.filename, 0, 0, image);
        return image;
    }

    private Image loadScaledImage() {
        Image image = this.loadUnscaledImage();
        if (image == null) {
            return null;
        }
        if (this.scaledHeight < 0) {
            this.scaledHeight = (int)((float)image.getHeight(this) * ((float)this.scaledWidth / (float)image.getWidth(this)));
        } else if (this.scaledWidth < 0) {
            this.scaledWidth = (int)((float)image.getWidth(this) * ((float)this.scaledHeight / (float)image.getHeight(this)));
        }
        if (this.scaledHeight == image.getHeight(this) && this.scaledWidth == image.getWidth(this)) {
            return image;
        }
        Image image2 = Icon.findImage(this.filename, this.scaledWidth, this.scaledHeight);
        if (image2 != null) {
            return image2;
        }
        image2 = image.getScaledInstance(this.scaledWidth, this.scaledHeight, 4);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image2, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        if (mediaTracker.isErrorAny()) {
            System.err.println(String.valueOf(ResourceManager.getString("Unable to load")) + ": " + this.filename);
            return null;
        }
        Icon.addImage(this.filename, this.scaledWidth, this.scaledHeight, image2);
        return image2;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.getImageSize();
    }

    public Dimension getImageSize() {
        if (this.scaling) {
            return new Dimension(this.scaledWidth, this.scaledHeight);
        }
        if (this.image != null) {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }
        return new Dimension(-1, -1);
    }

    public String getIconFilename() {
        return this.filename;
    }

    public void paint(Graphics graphics) {
        this.drawImage(graphics);
    }

    public void drawImage(Graphics graphics) {
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, this);
        }
    }

    public Image getPaintedImage(Component component) {
        int n;
        if (this.image == null) {
            return null;
        }
        int n2 = this.image.getWidth(this);
        Image image = Icon.findPaintedImage(this.filename, n2, n = this.image.getHeight(this), this.getPaintedAttributes());
        if (image != null) {
            return image;
        }
        try {
            image = GUIManager.parentComponent().createImage(n2, n);
            Graphics graphics = image.getGraphics();
            Color color = this.getBackground();
            graphics.setColor(component.getBackground());
            this.setBackground(component.getBackground());
            graphics.fillRect(0, 0, n2, n);
            this.paint(graphics);
            this.setBackground(color);
            Icon.addPaintedImage(this.filename, n2, n, this.getPaintedAttributes(), image);
        }
        catch (Exception exception) {}
        return image;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(String string) {
        this.filename = string == null ? NULL_IMAGE : string;
        this.image = this.scaling ? this.loadScaledImage() : this.loadUnscaledImage();
        this.repaint();
    }

    public void clearImage() {
        this.filename = null;
        this.image = null;
        this.repaint();
    }

    public boolean isLoaded() {
        return this.image != null;
    }

    public Icon(String string) {
        this.setImage(string);
    }

    public Icon(String string, int n, int n2) {
        this.setScaling(n, n2);
        this.setImage(string);
    }

    public Icon() {
    }
}

