/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;
import sam.gui.MediaIcon;
import sam.model.CatalogEntry;

public class CatalogMediaIcon
extends MediaIcon
implements Observer {
    private CatalogEntry entry;

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.entry.isUnavailable()) {
            this.drawUnavailable(graphics);
        }
    }

    public int getPaintedAttributes() {
        int n = super.getPaintedAttributes();
        n <<= 1;
        if (this.entry.isUnavailable()) {
            ++n;
        }
        return n;
    }

    public void update(Observable observable, Object object) {
        this.repaint();
    }

    public void drawUnavailable(Graphics graphics) {
        graphics.setXORMode(Color.gray);
        this.drawImage(graphics);
        graphics.setPaintMode();
    }

    CatalogMediaIcon(CatalogEntry catalogEntry) {
        super(catalogEntry.getMedia());
        this.entry = catalogEntry;
        catalogEntry.addObserver(this);
    }

    CatalogMediaIcon(CatalogEntry catalogEntry, int n, int n2) {
        super(catalogEntry.getMedia(), n, n2);
        this.entry = catalogEntry;
        catalogEntry.addObserver(this);
    }
}

