/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCAdjustable;
import jclass.bwt.JCAdjustmentEvent;
import jclass.bwt.JCAdjustmentListener;
import jclass.bwt.JCContainer;
import jclass.bwt.JCLabel;
import jclass.bwt.ScrollbarConverter;
import jclass.bwt.ScrollbarThumb;
import jclass.bwt.SliderConverter;
import jclass.bwt.SliderThumb;
import jclass.util.JCVector;

public class JCSlider
extends JCContainer
implements JCAdjustable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected ScrollbarThumb thumb;
    int value;
    int min;
    int max = 100;
    int dir = -999;
    int trough_offset;
    protected JCVector adjustmentListeners = new JCVector(0);
    int line_incr = 10;
    int page_incr = 10;
    long filter_time;
    long last_time;
    int trough_size;
    int slider_size;
    int visible;
    int major;
    int minor;
    private int dragStart = -999;
    private int dragValueStart = -999;
    int thumb_major = 21;
    int thumb_minor = 11;
    int THUMB_SIZE = Math.min(this.thumb_major, this.thumb_minor);
    int HALF_THUMB_SIZE = (int)Math.ceil((double)this.THUMB_SIZE / 2.0);
    static final int TICK_SIZE = 3;
    int num_ticks;
    boolean auto_tick = true;
    JCLabel min_label;
    JCLabel max_label;
    private static final String base = "slider";
    private static int nameCounter;

    public JCSlider() {
        this(0, null, null);
    }

    public JCSlider(int n) {
        this(n, null, null);
    }

    public JCSlider(int n, int n2, int n3, int n4) {
        this(n, null, null);
        this.setValues(n2, n3, n4);
    }

    public JCSlider(int n, Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.setLayout(null);
        this.setOrientation(n);
        this.double_buffer = true;
        this.thumb = new SliderThumb(this);
        this.add(this.thumb);
        if (this.getClass().getName().equals("jclass.bwt.JCSlider")) {
            this.getParameters(applet);
        }
        this.enable11Events(32L);
    }

    protected void getParameters() {
        super.getParameters();
        SliderConverter.getParams(this);
    }

    public void setValues(int n, int n2, int n3) {
        int n4 = 0;
        JCSlider jCSlider = this;
        synchronized (jCSlider) {
            n4 = this.page_incr;
            this.min = n2;
            this.max = n3;
            this.visible = 0;
            if (n3 < n2) {
                n3 = n2;
            }
            this.visible = Math.min(n3 - n2, this.visible);
            this.value = n = Math.min(Math.max(n2, n), n3 - this.visible);
            this.page_incr = this.visible = this.visible;
        }
        this.layout();
        jCSlider = this;
        synchronized (jCSlider) {
            this.page_incr = n4;
            return;
        }
    }

    public int getOrientation() {
        return this.dir;
    }

    public synchronized void setOrientation(int n) {
        ScrollbarConverter.checkOrientation(n);
        if (this.dir == n) {
            return;
        }
        this.dir = n;
    }

    public int getValue() {
        return this.value;
    }

    protected int check(int n) {
        return Math.min(Math.max(this.min, n), this.max - this.visible);
    }

    public void setValue(int n) {
        boolean bl = false;
        JCSlider jCSlider = this;
        synchronized (jCSlider) {
            n = this.check(n);
            if (n != this.value) {
                this.value = n;
                bl = true;
            }
        }
        if (bl) {
            this.moveThumb();
        }
    }

    public void setValue(int n, boolean bl) {
        this.setValue(n, 605, bl);
    }

    void setValue(int n, int n2, boolean bl) {
        switch (n2) {
            case 601: {
                n2 = 2;
                break;
            }
            case 602: {
                n2 = 1;
                break;
            }
            case 603: {
                n2 = 3;
                break;
            }
            case 604: {
                n2 = 4;
                break;
            }
            case 605: {
                n2 = 5;
                break;
            }
        }
        JCVector jCVector = null;
        Serializable serializable = this;
        synchronized (serializable) {
            n = this.check(n);
            if (n == this.value) {
                Object var6_6 = null;
                return;
            }
            this.value = n;
            jCVector = (JCVector)this.adjustmentListeners.clone();
        }
        this.moveThumb();
        if (!bl || jCVector.size() == 0) {
            return;
        }
        serializable = new JCAdjustmentEvent(this, 601, n2, n);
        int n3 = 0;
        while (n3 < jCVector.size()) {
            ((JCAdjustmentListener)jCVector.elementAt(n3)).adjustmentValueChanged((JCAdjustmentEvent)serializable);
            ++n3;
        }
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int n) {
        this.setValues(this.value, n, this.max);
    }

    public void setMaximum(int n) {
        this.setValues(this.value, this.min, n);
    }

    public int getBlockIncrement() {
        return this.page_incr;
    }

    public void addAdjustmentListener(JCAdjustmentListener jCAdjustmentListener) {
        this.adjustmentListeners.add(jCAdjustmentListener);
    }

    public void removeAdjustmentListener(JCAdjustmentListener jCAdjustmentListener) {
        this.adjustmentListeners.removeElement(jCAdjustmentListener);
    }

    public boolean dragging() {
        return this.dragStart != -999;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.dragging()) {
            int n3 = this.value;
            this.value = -999;
            this.setValue(n3, 605, true);
        }
        this.dragValueStart = -999;
        this.dragStart = -999;
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        int n3;
        if (this.slider_size == this.trough_size || event.target != this) {
            return true;
        }
        if (event.when - this.last_time < 20L) {
            return true;
        }
        this.last_time = event.when;
        int n4 = this.dir == 0 ? n : n2;
        int n5 = n3 = this.dir == 0 ? this.thumb.location().x : this.thumb.location().y;
        if (n4 >= n3 && n4 <= n3 + this.slider_size) {
            this.dragStart = n4;
            this.dragValueStart = this.value;
            return true;
        }
        if (event.controlDown()) {
            if (n4 < n3) {
                this.setValue(this.min, 605, true);
            } else {
                this.setValue(this.max - this.visible, 605, true);
            }
            return true;
        }
        if (n4 < n3) {
            this.setValue(this.value - this.page_incr, 603, true);
        } else {
            this.setValue(this.value + this.page_incr, 604, true);
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        boolean bl;
        if (!this.dragging()) {
            return true;
        }
        if (this.slider_size == this.trough_size) {
            return true;
        }
        int n3 = this.dir == 0 ? event.x : event.y;
        boolean bl2 = bl = event.when - this.last_time > this.filter_time;
        if (bl) {
            this.last_time = event.when;
        }
        this.setValue(this.dragValueStart + this.toValue(n3 - this.dragStart), bl);
        this.last_time = event.when;
        return true;
    }

    public boolean keyDown(Event event, int n) {
        if (this.slider_size == this.trough_size) {
            return true;
        }
        if (n == 1002) {
            this.setValue(this.value - this.page_incr, 603, true);
            return true;
        }
        if (n == 1003) {
            this.setValue(this.value + this.page_incr, 604, true);
            return true;
        }
        if (n == 1000) {
            this.setValue(this.min, 605, true);
            return true;
        }
        if (n == 1001) {
            this.setValue(this.max - this.slider_size, 605, true);
            return true;
        }
        if (n == 1004 || n == 1006) {
            this.setValue(this.value - this.line_incr, 601, true);
            return true;
        }
        if (n == 1005 || n == 1007) {
            this.setValue(this.value + this.line_incr, 602, true);
            return true;
        }
        return super.keyDown(event, n);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        JCSlider jCSlider = this;
        synchronized (jCSlider) {
            this.major = this.dir == 0 ? n3 : n4;
            this.minor = this.dir == 0 ? n4 : n3;
        }
        super.reshape(n, n2, n3, n4);
    }

    protected void moveThumb() {
        int n = 0;
        int n2 = 0;
        JCSlider jCSlider = this;
        synchronized (jCSlider) {
            if (this.getPeer() == null) {
                Object var5_4 = null;
                return;
            }
            int n3 = Math.max(0, Math.min(this.toPixels(this.value - this.min), this.trough_size - this.slider_size));
            if (this.dir == 0) {
                n = n3;
            } else {
                n2 = n3;
            }
        }
        this.thumb.move(n, n2);
    }

    protected void paintThumb(Graphics graphics) {
        if (!this.thumb.isVisible()) {
            return;
        }
        Point point = BWTUtil.translateToParent(this, this.thumb, 0, 0);
        Dimension dimension = this.thumb.size();
        if (!this.getPaintRect().intersects(new Rectangle(point, dimension))) {
            return;
        }
        this.thumb.setDoubleBuffer(false);
        Point point2 = this.thumb.location();
        graphics.setColor(this.getBackground());
        Graphics graphics2 = graphics.create(point2.x, point2.y, dimension.width, dimension.height);
        this.thumb.paint(graphics2);
        graphics2.dispose();
        this.thumb.setDoubleBuffer(true);
    }

    protected int toPixels(int n) {
        if (this.max == this.min) {
            return 0;
        }
        if (n >= this.max - this.min - this.visible) {
            return this.trough_size;
        }
        int n2 = this.trough_size * n / (this.max - this.min);
        if (n2 > 0) {
            return n2;
        }
        return 0;
    }

    protected int toValue(int n) {
        if (this.trough_size == 0) {
            return 0;
        }
        return n * (this.max - this.min) / this.trough_size;
    }

    public synchronized void setBackground(Color color) {
        this.thumb.setBackground(color);
        super.setBackground(color);
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public int getMaximum() {
        return this.max - this.visible;
    }

    public Dimension getThumbSize() {
        if (this.dir == 0) {
            return new Dimension(this.thumb_minor, this.thumb_major);
        }
        return new Dimension(this.thumb_major, this.thumb_minor);
    }

    public void setThumbSize(Dimension dimension) {
        this.thumb_minor = this.dir == 0 ? dimension.width : dimension.height;
        this.thumb_major = this.dir == 0 ? dimension.height : dimension.width;
        this.layout();
    }

    public void setUnitIncrement(int n) {
        this.line_incr = n;
    }

    public int getUnitIncrement() {
        return this.line_incr;
    }

    public int getVisibleAmount() {
        return this.visible;
    }

    public void setVisibleAmount(int n) {
        this.setValues(this.value, this.min, this.max);
    }

    public void setBlockIncrement(int n) {
        this.page_incr = this.line_incr = n;
    }

    public boolean getAutoTick() {
        return this.auto_tick;
    }

    public void setAutoTick(boolean bl) {
        this.auto_tick = bl;
        this.repaint();
    }

    public int getNumTicks() {
        return this.num_ticks;
    }

    public void setNumTicks(int n) {
        this.num_ticks = n;
        this.repaint();
    }

    public JCLabel getMinimumLabel() {
        return this.min_label;
    }

    public void setMinimumLabel(JCLabel jCLabel) {
        if (this.min_label != null && jCLabel == null) {
            this.remove(this.min_label);
        }
        this.min_label = jCLabel;
        this.layout();
        this.repaint();
    }

    public String getMinimumLabelString() {
        if (this.min_label != null) {
            return this.min_label.getText();
        }
        return null;
    }

    public void setMinimumLabelString(String string) {
        this.setMinimumLabel(new JCLabel(string));
    }

    public String getMaximumLabelString() {
        if (this.max_label != null) {
            return this.max_label.getText();
        }
        return null;
    }

    public void setMaximumLabelString(String string) {
        this.setMaximumLabel(new JCLabel(string));
    }

    public JCLabel getMaximumLabel() {
        return this.max_label;
    }

    public void setMaximumLabel(JCLabel jCLabel) {
        if (this.max_label != null && jCLabel == null) {
            this.remove(this.max_label);
        }
        this.max_label = jCLabel;
        this.layout();
        this.repaint();
    }

    protected int preferredWidth() {
        int n = 0;
        int n2 = 0;
        if (this.min_label != null) {
            n = this.min_label.preferredSize().width;
        }
        if (this.max_label != null) {
            n2 = this.max_label.preferredSize().width;
        }
        if (this.dir == 0) {
            return n + n2 + 200;
        }
        return Math.max(Math.max(n, n2), this.thumb_major + (this.num_ticks > 0 || this.auto_tick ? 4 : 0));
    }

    protected int preferredHeight() {
        int n = 0;
        int n2 = 0;
        if (this.min_label != null) {
            n = this.min_label.preferredSize().height;
        }
        if (this.max_label != null) {
            n2 = this.max_label.preferredSize().height;
        }
        if (this.dir == 1) {
            return n + n2 + 200;
        }
        return Math.max(Math.max(n, n2), this.thumb_major + (this.num_ticks > 0 || this.auto_tick ? 4 : 0));
    }

    protected void resizeThumb(int n, int n2) {
        if (this.dir == 0) {
            this.thumb.resize(this.thumb_minor, this.thumb_major);
            return;
        }
        this.thumb.resize(this.thumb_major, this.thumb_minor);
    }

    public void layout() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.getPeer() == null) {
            return;
        }
        JCSlider jCSlider = this;
        synchronized (jCSlider) {
            n4 = this.insets().left;
            n3 = this.insets().top;
            n2 = 0;
            this.trough_offset = this.dir == 0 ? n4 : n3;
        }
        if (this.min_label != null) {
            this.add(this.min_label);
            int n5 = this.min_label.preferredSize().width;
            n = this.min_label.preferredSize().height;
            this.min_label.reshape(n4, n3, n5, n);
            JCSlider jCSlider2 = this;
            synchronized (jCSlider2) {
                if (this.dir == 0) {
                    this.trough_offset = n4 + n5;
                    n2 += n5;
                } else {
                    this.trough_offset = n3 + n;
                    n2 += n;
                }
            }
        }
        if (this.max_label != null) {
            int n6;
            int n7;
            this.add(this.max_label);
            int n8 = this.max_label.preferredSize().width;
            n = this.max_label.preferredSize().height;
            JCSlider jCSlider3 = this;
            synchronized (jCSlider3) {
                if (this.dir == 0) {
                    n7 = this.major - this.insets().right - n8;
                    n6 = n3;
                    n2 += n8;
                } else {
                    n7 = n4;
                    n6 = this.major - this.insets().bottom - n;
                    n2 += n;
                }
            }
            this.max_label.reshape(n7, n6, n8, n);
        }
        JCSlider jCSlider4 = this;
        synchronized (jCSlider4) {
            Math.max(this.minor, 16);
            this.trough_size = this.major;
            this.slider_size = this.thumb_minor;
        }
        if (this.dir == 0) {
            this.resizeThumb(this.slider_size, this.minor);
        } else {
            this.resizeThumb(this.minor, this.slider_size);
        }
        this.moveThumb();
        jCSlider4 = this;
        synchronized (jCSlider4) {
            this.trough_size = Math.max(5, this.major - n2);
            this.max -= this.visible;
            this.visible = this.toValue(this.THUMB_SIZE);
            this.max += this.visible;
        }
        this.moveThumb();
    }

    protected void drawTicks(Graphics graphics, int n) {
        graphics.setColor(this.getForeground());
        double d = n > 1 ? (double)(this.trough_size - this.THUMB_SIZE) / ((double)n - 1.0) : 0.0;
        int n2 = this.trough_offset + this.trough_size - this.HALF_THUMB_SIZE;
        if (this.dir == 0) {
            double d2 = (double)this.trough_offset + (double)this.THUMB_SIZE / 2.0;
            int n3 = this.thumb.bounds().y + this.thumb_major + 1;
            int n4 = 0;
            while (n4 < n - 1) {
                graphics.drawLine((int)d2, n3, (int)d2, n3 + 3);
                ++n4;
                d2 += d;
            }
            if (n > 1) {
                graphics.drawLine(n2, n3, n2, n3 + 3);
                return;
            }
        } else {
            int n5 = this.thumb.bounds().x + this.thumb_major + 1;
            double d3 = (double)this.trough_offset + (double)this.THUMB_SIZE / 2.0;
            int n6 = 0;
            while (n6 < n - 1) {
                graphics.drawLine(n5, (int)d3, n5 + 3, (int)d3);
                ++n6;
                d3 += d;
            }
            if (n > 1) {
                graphics.drawLine(n5, n2, n5 + 3, n2);
            }
        }
    }

    public void paintInterior(Graphics graphics) {
        int n;
        if (this.dir == 0) {
            n = this.trough_offset;
            int n2 = this.thumb_major / 2 - 2;
            graphics.setColor(BWTUtil.darker(this.getBackground()));
            graphics.drawLine(n, n2, n + this.trough_size - 1, n2);
            graphics.drawLine(n, n2, n, n2 + 3);
            graphics.setColor(Color.black);
            graphics.drawLine(n + 1, ++n2, n + this.trough_size - 2, n2);
            graphics.setColor(this.getBackground().brighter().darker());
            graphics.drawLine(n + 1, ++n2, n + this.trough_size - 1, n2);
            graphics.drawLine(n + this.trough_size - 1, n2 - 1, n + this.trough_size - 1, n2);
            graphics.setColor(BWTUtil.brighter(graphics.getColor()));
            graphics.drawLine(n, ++n2, n + this.trough_size, n2);
            graphics.drawLine(n + this.trough_size - 1, n2 - 3, n + this.trough_size - 1, n2);
        } else {
            n = this.trough_offset;
            int n3 = this.thumb_major / 2 - 2;
            graphics.setColor(BWTUtil.darker(this.getBackground()));
            graphics.drawLine(n3, n, n3, n + this.trough_size - 1);
            graphics.drawLine(n3, n, n3 + 3, n);
            graphics.setColor(Color.black);
            graphics.drawLine(++n3, n + 1, n3, n + this.trough_size - 2);
            graphics.setColor(this.getBackground().brighter().darker());
            graphics.drawLine(++n3, n + 1, n3, n + this.trough_size - 1);
            graphics.drawLine(n3 - 1, n + this.trough_size - 1, n3, n + this.trough_size - 1);
            graphics.setColor(BWTUtil.brighter(graphics.getColor()));
            graphics.drawLine(++n3, n, n3, n + this.trough_size);
            graphics.drawLine(n3 - 3, n + this.trough_size - 1, n3, n + this.trough_size - 1);
        }
        int n4 = this.num_ticks > 0 ? this.num_ticks : (n = this.auto_tick && this.page_incr > 0 ? (this.max - this.visible - this.min) / this.page_incr + 1 : 0);
        if (n > 0) {
            this.drawTicks(graphics, n);
        }
        this.paintThumb(graphics);
    }
}

