#!/bin/sh

#
#  upfrom331.sh  - convert files and paths from SAM-FS 3.3.1 style
#

ETCDIR=/etc/opt/SUNWsamfs
VARDIR=/var/opt/SUNWsamfs
LAST_DIR=/etc/opt/SUNWsamfs/samfs.old.last
OLD_ETC_DIR=/etc/fs/samfs
CAT_DIR=$VARDIR/catalog
NEW_EXE=/opt/SUNWsamfs/sbin
DUMP_DIR=$LASTDIR/cat.dump

#  Function definitions.

#  copy catalogs to their new locations.

copy_cat()
{
	cat_file=`/bin/basename $cat`
	echo $cat | grep /etc/fs/samfs > /dev/null
	if [ $? -eq 0 ] ; then
		# this catalog must live in /etc/fs/samfs
		if [ -f $LAST_DIR/$cat_file ] ; then
			if [ -f ${OLD_ETC_DIR}/$cat_file ] ; then
				/bin/cp $LAST_DIR/$cat_file $OLD_ETC_DIR/${cat_file}.33x
			else
				/bin/cp $LAST_DIR/$cat_file $OLD_ETC_DIR
			fi
		fi
	else
		# quick check if it is some non-expected place
		echo $cat | grep '/' > /dev/null
		if [ $? -ne 0 ] ; then
			# this catalog should be moved to the (new) catalog dir
			if [ -f $LAST_DIR/$cat_file ] ; then
				if [ -f ${CAT_DIR}/$cat_file ] ; then
					/bin/cp $LAST_DIR/$cat_file $CAT_DIR/${cat_file}.33x
				else
					/bin/cp $LAST_DIR/$cat_file $CAT_DIR
				fi
			fi
		fi
	fi
}

#  main script.

# copy files that work without conversion unless already there

SAVELIST="archiver.cmd defaults.conf inquiry.conf mcf \
recycler.cmd releaser.cmd samfs.cmd"

	for object in $SAVELIST
	do
		if [ -f ${LAST_DIR}/${object} ] ; then
			if [ -f ${ETCDIR}/${object} ] ; then
				/usr/bin/cp ${LAST_DIR}/${object} $ETCDIR/${object}.33x
			else
				/usr/bin/cp ${LAST_DIR}/${object} $ETCDIR
			fi
		fi
	done

	if [ -f ${LAST_DIR}/.archive/ReservedVSNs ] ; then
		if [ -f ${VARDIR}/archiver/ReservedVSNs ] ; then
			/usr/bin/cp ${LAST_DIR}/.archive/ReservedVSNs $VARDIR/archiver/ReservedVSNs.33x
		else
			/usr/bin/cp ${LAST_DIR}/.archive/ReservedVSNs $VARDIR/archiver/ReservedVSNs
		fi
	fi
	
	# copy files that need conversion

CHGLIST="ar_notify.sh recycler.sh ssi.sh" 

	for object in $CHGLIST
	do
		if [ -f ${LAST_DIR}/${object} ] ; then
			/usr/bin/cp ${LAST_DIR}/${object} $ETCDIR/${object}.33x
			echo "WARNING: old "${object}" saved as "$ETCDIR/${object}.33x
			echo "WARNING: Make any local changes in the new version."
		fi
	done

	found_hist=0
	exec <$LAST_DIR/mcf
	while read eqid eqord eqtype famset state cat
	do
		case $eqid in
		\#*)
			continue
			;;
		esac

		if [ X = X$cat ]; then
			cat=$famset
		fi

		# copy the catalogs to their new locations.
	
		case $eqtype in
		'rb'|'hp'|'ml'|'cy'|'dm'|'ds'|'me'|'ac'|'eb'|'ad'|'a1'|'a2'|'sl'|'s9'|'ic')
			copy_cat
			;;

		'fj'|'gr'|'im'|'sk'|'sc')
			copy_cat

			# copy the network robot and remote sam configuration files.
			nrcon=`/usr/bin/basename $eqid`
			if [ -f ${LAST_DIR}/${nrcon} ] ; then
				/usr/bin/cp ${LAST_DIR}/${nrcon} $OLD_ETC_DIR/${nrcon}
			echo "Network or remote "$famset" configuration file "${nrcon}" saved."
			fi
			;;

		'ss')
			# copy the remote sam configuration files.
			nrcon=`/usr/bin/basename $eqid`
			if [ -f ${LAST_DIR}/${nrcon} ] ; then
				/usr/bin/cp ${LAST_DIR}/${nrcon} $OLD_ETC_DIR/${nrcon}
			echo "Remote "$famset" configuration file "${nrcon}" saved."
			fi
			;;

		'hy')
			copy_cat
			found_hist=1
			;;

		default)
			;;
		esac
	done

	if [ $found_hist -eq 0 ] ; then
		if [ -f $LAST_DIR/sam_historian ] ; then
			if [ -f ${CAT_DIR}/historian ] ; then
				/bin/mv $CAT_DIR/historian $CAT_DIR/historian.35x
			fi
			/bin/cp $LAST_DIR/sam_historian $CAT_DIR/historian
		fi
	fi
