/*
 * Decompiled with CFR 0.152.
 */
package sam.gui.popup;

import sam.authority.AuthorityManager;
import sam.gui.DeviceDisplay;
import sam.gui.PopUp;
import sam.gui.RobotDisplay;
import sam.gui.dialog.ConfirmDialog;
import sam.gui.dialog.ManualImportDialog;
import sam.model.Robot;
import sam.model.robot.NonSCSIRobot;
import sam.resource.ResourceManager;

public class RobotPopUp
extends PopUp {
    protected Robot robot;

    public void handleCommand(String string) {
        if (string.equals(ResourceManager.getString("Unload"))) {
            this.robot.unload();
            return;
        }
        if (string.equals(ResourceManager.getString("Import"))) {
            if (this.robot instanceof NonSCSIRobot) {
                ManualImportDialog manualImportDialog = new ManualImportDialog((RobotDisplay)this.parentComponent);
                manualImportDialog.show();
                return;
            }
            this.robot.importMedia();
            return;
        }
        if (string.equals(ResourceManager.getString("Full Audit"))) {
            ConfirmDialog confirmDialog;
            if (AuthorityManager.requiresConfirmation() && !(confirmDialog = new ConfirmDialog(ResourceManager.getString("A full audit could take a long time to complete, during which no archiving or staging may occur.  Please confirm you want to proceed."), (RobotDisplay)this.parentComponent)).getConfirmation()) {
                return;
            }
            this.robot.audit();
            return;
        }
        if (string.equals(ResourceManager.getString("On"))) {
            this.robot.setState(0);
            return;
        }
        if (string.equals(ResourceManager.getString("Off"))) {
            this.robot.setState(4);
            return;
        }
        if (string.equals(ResourceManager.getString("Unavailable"))) {
            this.robot.setState(3);
            return;
        }
        if (string.equals(ResourceManager.getString("Down"))) {
            this.robot.setState(5);
        }
    }

    public void setupMenu() {
        if (this.robot.isAuditable()) {
            this.addMenuItem(ResourceManager.getString("Full Audit"), AuthorityManager.canAudit(this.robot));
        }
        if (this.robot.isUnloadable()) {
            this.addMenuItem(ResourceManager.getString("Unload"), AuthorityManager.canUnload(this.robot));
        }
        if (this.robot.hasMailbox()) {
            this.addMenuItem(ResourceManager.getString("Import"), true);
        }
        this.addSeparator();
        this.addMenuItem(ResourceManager.getString("On"), true);
        boolean bl = AuthorityManager.canChangeState(this.robot);
        this.addMenuItem(ResourceManager.getString("Off"), bl);
        this.addMenuItem(ResourceManager.getString("Unavailable"), bl);
        this.addMenuItem(ResourceManager.getString("Down"), bl);
        switch (this.robot.getState()) {
            case 0: {
                this.setHighlighted(ResourceManager.getString("On"));
                return;
            }
            case 4: {
                this.setHighlighted(ResourceManager.getString("Off"));
                return;
            }
            case 3: {
                this.setHighlighted(ResourceManager.getString("Unavailable"));
                return;
            }
            case 5: {
                this.setEnabled(ResourceManager.getString("On"), false);
                this.setEnabled(ResourceManager.getString("Unavailable"), false);
                this.setHighlighted(ResourceManager.getString("Down"));
                return;
            }
        }
    }

    public RobotPopUp(DeviceDisplay deviceDisplay) {
        super(ResourceManager.getString("Robot"), deviceDisplay);
        this.robot = (Robot)deviceDisplay.getDevice();
        this.setupMenu();
    }
}

