/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import sam.gui.ClickPanel;
import sam.gui.event.MouseClicksListener;

public class TextTicker
extends ClickPanel
implements MouseClicksListener {
    private final int INS_PIXELS = 2;
    private Scroller scroller;
    private String text;
    private int textLength;
    private int cols;
    private int position;
    int screenX;
    int screenY;
    int width;
    int height;
    int charWidth;

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void paint(Graphics graphics) {
        if (this.textLength == 0) {
            return;
        }
        if (this.textLength <= this.cols) {
            int n = (this.cols - this.textLength) / 2 * this.charWidth + this.screenX;
            graphics.drawString(this.text, n, this.screenY);
            return;
        }
        int n = this.position + this.cols;
        if (n > this.textLength) {
            n = this.textLength;
        }
        graphics.drawString(this.text.substring(this.position, n), this.screenX, this.screenY);
    }

    public void mouseLeftClicked(MouseEvent mouseEvent) {
        this.mouseClicked(false);
    }

    public void mouseRightClicked(MouseEvent mouseEvent) {
        this.mouseClicked(true);
    }

    public void mouseDoubleClicked(MouseEvent mouseEvent) {
    }

    public void mouseClicked(boolean bl) {
        if (this.textLength <= this.cols) {
            return;
        }
        if (this.scroller.isScrolling()) {
            this.scroller.setScrolling(false);
            this.repaint();
            return;
        }
        if (bl) {
            this.position = this.position < this.cols ? (this.position == 0 ? this.textLength - this.textLength % this.cols : 0) : (this.position -= this.cols);
        } else {
            this.position += this.cols;
            if (this.position > this.textLength) {
                this.position = 0;
            }
        }
        this.repaint();
    }

    public void setText(String string) {
        this.scroller.setScrolling(false);
        this.text = string;
        this.textLength = string.length();
        if (this.textLength > this.cols) {
            this.scroller.setScrolling(true);
        }
        this.repaint();
    }

    public void calculateCanvasSize() {
        Font font = this.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.screenY = fontMetrics.getHeight() - fontMetrics.getMaxDescent() + 2;
        this.screenX = 2;
        this.charWidth = fontMetrics.charWidth('X');
        this.width = this.charWidth * this.cols + 4;
        this.height = fontMetrics.getHeight() + 4;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.calculateCanvasSize();
    }

    public TextTicker(int n, Font font) {
        this.cols = n;
        this.setFont(font);
        this.add(new Canvas());
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.addMouseClicksListener(this);
        this.scroller = new Scroller();
        this.scroller.start();
    }

    private class Scroller
    extends Thread {
        private final int delay = 300;
        private final int pauseMax = 6;
        private int countDown;
        private int wrapCol;
        private boolean scrolling = false;

        Scroller() {
            TextTicker.this = TextTicker.this;
        }

        public boolean isScrolling() {
            return this.scrolling;
        }

        public void setScrolling(boolean bl) {
            this.scrolling = bl;
            this.wrapCol = TextTicker.this.cols / 2;
            TextTicker.this.position = 0;
            if (this.scrolling) {
                this.countDown = 6;
            }
        }

        private void pause() {
            this.countDown = TextTicker.this.position == 0 && this.scrolling ? 6 : 1;
            try {
                while (this.countDown != 0) {
                    --this.countDown;
                    Thread.sleep(300L);
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }

        public void run() {
            while (this.isAlive()) {
                this.pause();
                if (!this.scrolling) continue;
                if (TextTicker.this.textLength - TextTicker.this.position > this.wrapCol) {
                    TextTicker textTicker = TextTicker.this;
                    textTicker.position = textTicker.position + 1;
                } else {
                    TextTicker.this.position = 0;
                }
                TextTicker.this.repaint();
            }
        }
    }
}

