/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import jclass.bwt.JCMultiColumnList;
import jclass.bwt.JCMultiColumnListComponent;
import jclass.util.JCSortInterface;
import sam.gui.GUIManager;
import sam.gui.Icon;
import sam.gui.dialog.TableEntryDialog;
import sam.gui.event.RowListener;
import sam.gui.popup.TableEntryPopUp;
import sam.model.CatalogSort;
import sam.model.Table;
import sam.model.TableEntry;
import sam.resource.ResourceManager;

public abstract class TableDisplay
extends Panel
implements MouseListener,
RowListener,
Observer {
    protected static int ALIGN_LEFT = 3;
    protected static int ALIGN_MIDDLE = 4;
    protected static int ALIGN_RIGHT = 5;
    private JCMultiColumnList table;
    private Vector rowHandlers = new Vector();
    private TableEntryPopUp entryPopup;
    private int counter;
    private Hashtable entryList = new Hashtable();
    protected String[] headers;
    private Table dataTable;

    public void setHeaderRow(String[] stringArray, String[] stringArray2, int[] nArray) {
        this.headers = stringArray;
        String[] stringArray3 = new String[this.headers.length];
        int[] nArray2 = new int[this.headers.length];
        int n = 0;
        while (n < this.headers.length) {
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray2[n2].equals(this.headers[n])) {
                    nArray2[n] = nArray[n2];
                    break;
                }
                ++n2;
            }
            if (n2 == stringArray2.length) {
                System.err.println(String.valueOf(ResourceManager.getString("Unknown column header")) + ": " + this.headers[n]);
            }
            stringArray3[n] = ResourceManager.getString(this.headers[n]);
            ++n;
        }
        this.table.setColumnButtons(stringArray3);
        this.table.setColumnAlignments(nArray2);
    }

    private Vector buildDisplayRow(Vector vector) {
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            try {
                if (e == null) {
                    throw new NullPointerException();
                }
                if (e instanceof Icon) {
                    Image image = ((Icon)e).getPaintedImage((Component)this.table.getList());
                    if (image == null) {
                        throw new NullPointerException();
                    }
                    vector2.addElement(image);
                } else {
                    vector2.addElement(e);
                }
            }
            catch (NullPointerException nullPointerException) {
                vector2.addElement(" ");
            }
            ++n;
        }
        return vector2;
    }

    public synchronized int findRow(Object object) {
        Vector vector = (Vector)this.entryList.get(object);
        int n = 0;
        while (n < this.table.countItems()) {
            if (vector == this.table.getItem(n)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public synchronized Object findEntry(Vector vector) {
        if (vector == null) {
            return null;
        }
        Enumeration<Object> enumeration = this.entryList.elements();
        int n = 0;
        try {
            while (enumeration.hasMoreElements()) {
                ++n;
                if (vector == (Vector)enumeration.nextElement()) break;
            }
            enumeration = this.entryList.keys();
            Object object = null;
            int n2 = 0;
            while (n2 < n) {
                object = enumeration.nextElement();
                ++n2;
            }
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Vector getRow(MouseEvent mouseEvent) {
        return (Vector)((JCMultiColumnListComponent)mouseEvent.getComponent()).getSelectedItem();
    }

    public synchronized void addDisplayRow(Object object, Vector vector) {
        Vector vector2 = this.buildDisplayRow(vector);
        this.table.setBatched(true);
        this.table.addItem((Object)vector2);
        this.entryList.put(object, vector2);
    }

    public synchronized boolean updateDisplayRow(Object object, Vector vector) {
        int n = this.findRow(object);
        if (n < 0) {
            return false;
        }
        Vector vector2 = this.buildDisplayRow(vector);
        this.table.setBatched(true);
        this.table.replaceItem((Object)vector2, n);
        this.entryList.put(object, vector2);
        return true;
    }

    public synchronized void removeDisplayRow(Object object) {
        int n = this.findRow(object);
        if (n < 0) {
            return;
        }
        this.table.setBatched(true);
        this.table.deleteItem(n);
        this.entryList.remove(object);
    }

    public void addRowListener(RowListener rowListener) {
        this.rowHandlers.addElement(rowListener);
    }

    public void removeRowListener(RowListener rowListener) {
        this.rowHandlers.removeElement(rowListener);
    }

    public void rowClicked(MouseEvent mouseEvent) {
    }

    public void rowRightClicked(MouseEvent mouseEvent) {
        if (this.entryPopup == null) {
            return;
        }
        TableEntry tableEntry = (TableEntry)this.findEntry((Vector)((JCMultiColumnListComponent)mouseEvent.getSource()).getSelectedItem());
        if (tableEntry != null) {
            this.entryPopup.show(tableEntry, (Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void rowDoubleClicked(MouseEvent mouseEvent) {
        TableEntryDialog tableEntryDialog = this.getDialogBox();
        if (tableEntryDialog == null) {
            return;
        }
        TableEntry tableEntry = (TableEntry)this.findEntry((Vector)((JCMultiColumnListComponent)mouseEvent.getSource()).getSelectedItem());
        if (tableEntry != null) {
            tableEntryDialog.show(tableEntry);
        }
    }

    private void notifyRowListeners(MouseEvent mouseEvent, boolean bl, boolean bl2) {
        if (this.rowHandlers.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.rowHandlers.elements();
        while (enumeration.hasMoreElements()) {
            if (bl) {
                ((RowListener)enumeration.nextElement()).rowRightClicked(mouseEvent);
                continue;
            }
            if (bl2) {
                ((RowListener)enumeration.nextElement()).rowDoubleClicked(mouseEvent);
                continue;
            }
            ((RowListener)enumeration.nextElement()).rowClicked(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl = mouseEvent.getClickCount() > 1;
        boolean bl2 = mouseEvent.getModifiers() == 4 || mouseEvent.getModifiers() == 8;
        this.notifyRowListeners(mouseEvent, bl2, bl);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void refresh() {
        if (!this.table.getBatched()) {
            return;
        }
        this.table.setBatched(false);
    }

    public int getRowHeight() {
        return this.table.getRowHeight();
    }

    public void setPopupMenu(TableEntryPopUp tableEntryPopUp) {
        this.entryPopup = tableEntryPopUp;
        this.add(this.entryPopup);
    }

    private Vector buildRow(TableEntry tableEntry) {
        Vector<Object> vector = new Vector<Object>();
        Hashtable hashtable = this.buildSlotData(tableEntry);
        int n = 0;
        while (n < this.headers.length) {
            try {
                vector.addElement(hashtable.get(this.headers[n]));
            }
            catch (Exception exception) {
                vector.addElement(" ");
            }
            ++n;
        }
        return vector;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof TableEntry) {
            this.updateRow((TableEntry)observable);
            return;
        }
        if (observable instanceof Table) {
            if (object instanceof Integer) {
                this.addRow((TableEntry)this.dataTable.getEntry((Integer)object));
                return;
            }
            if (object instanceof TableEntry) {
                this.removeRow((TableEntry)object);
                return;
            }
            if (object == null && !this.dataTable.isUpdating()) {
                this.refresh();
            }
        }
    }

    private void addRow(TableEntry tableEntry) {
        Vector vector = this.buildRow(tableEntry);
        this.addDisplayRow(tableEntry, vector);
        tableEntry.addObserver(this);
        if (!this.dataTable.isUpdating()) {
            this.refresh();
        }
    }

    private void updateRow(TableEntry tableEntry) {
        Vector vector = this.buildRow(tableEntry);
        this.updateDisplayRow(tableEntry, vector);
        if (!this.dataTable.isUpdating()) {
            this.refresh();
        }
    }

    private void removeRow(TableEntry tableEntry) {
        tableEntry.deleteObserver(this);
        this.removeDisplayRow(tableEntry);
        if (!this.dataTable.isUpdating()) {
            this.refresh();
        }
    }

    public Table getDataTable() {
        return this.dataTable;
    }

    protected abstract Hashtable buildSlotData(TableEntry var1);

    protected abstract void defineHeaders(Table var1);

    protected abstract TableEntryDialog getDialogBox();

    TableDisplay(Table table) {
        CatalogSort catalogSort = new CatalogSort();
        this.dataTable = table;
        this.setLayout(new GridLayout(1, 1));
        this.setBackground(Color.lightGray);
        int n = table.getSize();
        if (n == 0) {
            n = 1;
        }
        this.table = new JCMultiColumnList(n, false);
        this.table.getList().addMouseListener(this);
        this.table.getList().setBackground(Color.white);
        this.table.setSpacing(5);
        this.table.setRowHeight(GUIManager.getIconHeight(4));
        this.table.setBackground(Color.lightGray);
        this.table.setFont(new Font("Monospaced", 0, GUIManager.getFontPointSize(2)));
        this.table.setColumnLabelSortMethod((JCSortInterface)catalogSort);
        this.add((Component)this.table);
        this.defineHeaders(table);
        try {
            TableEntry[] tableEntryArray = table.getEntries();
            if (tableEntryArray != null) {
                int n2 = 0;
                while (n2 < tableEntryArray.length) {
                    this.addRow(tableEntryArray[n2]);
                    ++n2;
                }
                this.invalidate();
            }
        }
        catch (Exception exception) {}
        table.addObserver(this);
        this.addRowListener(this);
        this.table.sortByColumn(0, (JCSortInterface)catalogSort, 0);
    }
}

