/*
 * Decompiled with CFR 0.152.
 */
package sam.model;

import java.util.Date;
import sam.model.Media;
import sam.model.Robot;
import sam.model.SamManager;
import sam.model.TableEntry;
import sam.resource.ResourceManager;

public class MountRequestEntry
extends TableEntry {
    private Media media;
    private String user;
    private int processId;
    private Date requestTime;
    private boolean busy;
    private boolean inUse;
    private boolean error;
    private boolean write;
    private boolean fsRequest;
    private boolean blockIO;
    private boolean stage;
    private boolean flipSide;
    private int count;
    private Robot assignedRobot;
    private float priority;

    public boolean isBusy() {
        return this.busy;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public boolean isClearing() {
        return this.error;
    }

    public boolean isWriteRequest() {
        return this.write;
    }

    public boolean isFileSystemRequest() {
        return this.fsRequest;
    }

    public boolean usingBlockIO() {
        return this.blockIO;
    }

    public boolean usingFlipSide() {
        return this.flipSide;
    }

    public boolean isStageRequest() {
        return this.stage;
    }

    public int getRequestCount() {
        return this.count;
    }

    public Date getRequestTime() {
        return this.requestTime;
    }

    public String getElapsedTimeString() {
        int n = this.getElapsedSeconds() / 60;
        int n2 = n % 60;
        if (n >= 1440) {
            return String.valueOf(Integer.toString(n / 1440)) + " " + ResourceManager.getString("days");
        }
        if (n2 < 10) {
            return String.valueOf(Integer.toString(n / 60)) + ":0" + Integer.toString(n2);
        }
        return String.valueOf(Integer.toString(n / 60)) + ":" + Integer.toString(n2);
    }

    public int getElapsedSeconds() {
        return (int)(new Date().getTime() - this.requestTime.getTime()) / 1000;
    }

    public String getUser() {
        return this.user;
    }

    public Robot getRobot() {
        return this.assignedRobot;
    }

    public int getPID() {
        return this.processId;
    }

    public Media getMedia() {
        return this.media;
    }

    public float getPriority() {
        return this.priority;
    }

    void update(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, int n2, float f) {
        if (this.busy != bl) {
            this.setChanged();
            this.busy = bl;
        }
        if (this.inUse != bl2) {
            this.setChanged();
            this.inUse = bl2;
        }
        if (this.error != bl3) {
            this.setChanged();
            this.error = bl3;
        }
        if (this.write != bl4) {
            this.setChanged();
            this.write = bl4;
        }
        if (this.fsRequest != bl5) {
            this.setChanged();
            this.fsRequest = bl5;
        }
        if (this.blockIO != bl6) {
            this.setChanged();
            this.blockIO = bl6;
        }
        if (this.stage != bl7) {
            this.setChanged();
            this.stage = bl7;
        }
        if (this.flipSide != bl8) {
            this.setChanged();
            this.flipSide = bl8;
        }
        if (this.count != n) {
            this.setChanged();
            this.count = n;
        }
        if (this.priority != f) {
            this.setChanged();
            this.priority = f;
        }
        if (this.assignedRobot == null || this.assignedRobot.getEqId() != n2) {
            if (n2 > 0) {
                this.setChanged();
                this.assignedRobot = (Robot)SamManager.getDevice(n2);
            } else if (this.assignedRobot != null) {
                this.setChanged();
                this.assignedRobot = null;
            }
        }
        this.notifyObservers();
    }

    public MountRequestEntry(Media media, int n, String string, int n2, long l, float f) {
        super(n);
        this.media = media;
        this.user = string;
        this.processId = n2;
        this.requestTime = new Date(l);
        this.priority = f;
    }
}

