/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.ScrollPane;
import sam.gui.CatalogDisplay;
import sam.gui.DevicesPanel;
import sam.gui.GUIManager;
import sam.gui.HistorianCatDisplay;
import sam.gui.RobotDisplay;
import sam.model.Catalog;
import sam.model.Robot;
import sam.model.SamManager;
import sam.model.robot.Historian;
import sam.resource.ResourceManager;

class DeviceTabPanel
extends Panel {
    private static final int INS_PIXELS = 5;
    private GridBagLayout gridbag = new GridBagLayout();
    private DevicesPanel[] devicesPanel;
    private CatalogDisplay catalogPanel;
    private String panelLabel;

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        try {
            int n = 0;
            while (n < this.devicesPanel.length) {
                Dimension dimension2 = this.devicesPanel[n].getPreferredSize();
                int n2 = dimension2.height / this.devicesPanel[n].getRowCount() + 10;
                if (n2 > dimension.height) {
                    dimension.height = n2;
                }
                dimension.width += dimension2.width + 10;
                ++n;
            }
            if (this.catalogPanel != null) {
                dimension.width += this.catalogPanel.getPreferredSize().width + 10;
            }
            return dimension;
        }
        catch (Exception exception) {
            return new Dimension(-1, -1);
        }
    }

    public String getPanelName() {
        return this.panelLabel;
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    DeviceTabPanel(Robot[] robotArray) {
        DevicesPanel devicesPanel = null;
        this.setLayout(new GridLayout(1, 1));
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 11;
        this.panelLabel = ResourceManager.getString("All drives");
        this.devicesPanel = new DevicesPanel[robotArray.length + SamManager.getManualMountCount()];
        int n = 0;
        while (n < robotArray.length) {
            if (robotArray[n].getDevices() != null) {
                this.devicesPanel[n] = new DevicesPanel(robotArray[n]);
                this.devicesPanel[n].setTopAlignment();
                devicesPanel = this.devicesPanel[n];
                gridBagConstraints.insets = new Insets(1, 1, 1, 1);
                gridBagLayout.setConstraints(devicesPanel, gridBagConstraints);
                panel.add(devicesPanel);
            }
            ++n;
        }
        if (SamManager.getManualMountCount() > 0) {
            this.devicesPanel[n] = new DevicesPanel();
            this.devicesPanel[n].setTopAlignment();
            devicesPanel = this.devicesPanel[n];
            gridBagConstraints.insets = new Insets(1, 1, 1, 1);
            gridBagLayout.setConstraints(devicesPanel, gridBagConstraints);
            panel.add(devicesPanel);
        }
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(devicesPanel, gridBagConstraints);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.getVAdjustable().setUnitIncrement(GUIManager.getIconHeight(5) / 10);
        scrollPane.getHAdjustable().setUnitIncrement(GUIManager.getIconHeight(5) / 10);
        scrollPane.add(panel);
        this.add(scrollPane);
    }

    DeviceTabPanel(Robot robot) {
        Panel panel;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridheight = 1;
        this.panelLabel = RobotDisplay.getNameResource(robot);
        if (robot.getDevices() == null) {
            panel = new Panel();
        } else {
            this.devicesPanel = new DevicesPanel[1];
            this.devicesPanel[0] = new DevicesPanel(robot);
            panel = this.devicesPanel[0];
        }
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        Catalog catalog = robot.getCatalog();
        if (catalog == null) {
            panel = new Panel();
        } else {
            this.catalogPanel = robot instanceof Historian ? new HistorianCatDisplay(catalog) : new CatalogDisplay(catalog);
            panel = this.catalogPanel;
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
    }

    DeviceTabPanel() {
        this.panelLabel = new String(ResourceManager.getString("Manual mount devices"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridheight = 1;
        this.devicesPanel = new DevicesPanel[1];
        this.devicesPanel[0] = new DevicesPanel();
        Panel panel = this.devicesPanel[0];
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        panel = new Panel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
    }
}

