/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCSeparator;
import jclass.bwt.JCSplitterWindow;
import jclass.bwt.Shadow;
import jclass.util.JCEnvironment;

class SplitterWindowSeparator
extends JCSeparator {
    boolean dragging = false;
    JCSplitterWindow window;
    Component child1;
    Component child2;
    int dx;
    int dy;
    int pos;
    static long last_time;
    private static int x_save;
    private static int y_save;
    private static boolean version102;

    SplitterWindowSeparator(JCSplitterWindow jCSplitterWindow) {
        super(jCSplitterWindow.dir == 0 ? 1 : 0, jCSplitterWindow.applet, jCSplitterWindow.getName());
        this.window = jCSplitterWindow;
        this.traversable = JCEnvironment.getJavaVersion() < 110;
        this.shadow_type = 4;
        this.shadow = 3;
        this.enable11Events(32L);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getDrawingArea();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.size().width - 1, this.size().height - 1);
        Shadow.draw(graphics, this.shadow_type, 1, 1, 1, this.size().width - 2, this.size().height - 2, this.getBackground(), this.getForeground());
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        if (!this.dragging) {
            this.setCursor(this.dir == 1 ? 10 : 8);
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (!this.dragging) {
            this.setCursor(0);
        }
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.pos = this.window.getComponent(this);
        if (this.pos <= 0 || this.pos == this.window.countComponents() - 1) {
            return false;
        }
        this.child1 = this.window.getComponents()[this.pos - 1];
        this.child2 = this.window.getComponents()[this.pos + 1];
        this.dragging = true;
        this.dy = 0;
        this.dx = 0;
        this.drawLine(false, event);
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        int n3;
        boolean bl;
        if (!this.dragging) {
            return false;
        }
        boolean bl2 = bl = JCEnvironment.getBrowser(this) != 1;
        if (bl && event.when - last_time < 50L) {
            return true;
        }
        last_time = event.when;
        int n4 = this.dir == 1 ? event.x : 0;
        int n5 = n3 = this.dir == 1 ? 0 : event.y;
        if (n4 < 0 && this.child1.size().width + n4 < this.window.min_child_size || n4 > 0 && this.child2.size().width - n4 < this.window.min_child_size || n3 < 0 && this.child1.size().height + n3 < this.window.min_child_size || n3 > 0 && this.child2.size().height - n3 < this.window.min_child_size) {
            return true;
        }
        this.dx = n4;
        this.dy = n3;
        this.drawLine(true, null);
        this.drawLine(false, event);
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (!this.dragging) {
            return false;
        }
        this.drawLine(true, null);
        if (this.dx != 0 || this.dy != 0) {
            this.child1.resize(this.child1.size().width + this.dx, this.child1.size().height + this.dy);
            this.move(this.location().x + this.dx, this.location().y + this.dy);
            n = this.dx == 0 ? this.child2.location().x : this.location().x + this.size().width + 1;
            n2 = this.dy == 0 ? this.child2.location().y : this.location().y + this.size().height + 1;
            this.child2.reshape(n, n2, this.child2.size().width - this.dx, this.child2.size().height - this.dy);
            this.window.resized = true;
        }
        this.dragging = false;
        this.setCursor(0);
        return true;
    }

    void drawLine(boolean bl, Event event) {
        this.drawLine(bl, event, this.window);
    }

    void drawLine(boolean bl, Event event, Container container) {
        if (!bl && container == this.window) {
            x_save = event.x + this.location().x;
            y_save = event.y + this.location().y;
        } else if (x_save == -999) {
            return;
        }
        int n = 0;
        while (n < container.countComponents()) {
            Component component = container.getComponents()[n];
            if (!BWTUtil.instanceOf(component, "Scrollbar")) {
                if (component instanceof Container) {
                    this.drawLine(bl, event, (Container)component);
                }
                if (!version102 || component instanceof Canvas) {
                    Point point = BWTUtil.translateToParent(this.window, component, 0, 0);
                    Graphics graphics = component.getGraphics();
                    if (graphics != null) {
                        int n2;
                        int n3;
                        graphics.setXORMode(component.getBackground());
                        if (this.dir == 0) {
                            n3 = y_save - point.y;
                            n2 = component.size().width;
                            graphics.drawLine(0, n3, n2, n3);
                        } else {
                            n3 = x_save - point.x;
                            n2 = component.size().height;
                            graphics.drawLine(n3, 0, n3, n2);
                        }
                        graphics.dispose();
                    }
                }
            }
            ++n;
        }
    }

    static {
        x_save = -999;
        y_save = -999;
        version102 = JCEnvironment.getJavaVersion() == 102;
    }
}

